 /*
  * Khoros: $Id: getarg_line.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: getarg_line.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: getarg_line.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 

/******************************************************************

	Get an 'argument' Line from the Answer File

	source filename:		

	revision	  date			programmer
	--------	  ----			----------
	   0.0		mmm-dd-yy		don hush

******************************************************************

	usage
	-----

	stat = get_arg_line(fd,line)

	int stat,fd;
	char *line;

	description
	-----------

	  This routine reads one line from the answer file.
	If the line begins with a '-' this routine returns the
	length of the line. If the line does not begin with '-'
	this routine returns a -1, and on an EOF a 0 is returned.
	This routine parses the following special character
	sequences,

		\n - newline
		\x skip the x character


******************************************************************/

get_arg_line(fd,line)

int fd;
char *line;

{
	int i=1;

	if ( read(fd,line,1) < 1 )
		return(0);
	
	if (line[0]!='-') {
		while (line[0]!='\n')
			if (read(fd,line,1)<1) break;
		return(-1);
	    }

	while ( read(fd,&line[i],1) > 0 )
	{ 
		if (line[i]=='\\')
		{
			read(fd,&line[i+1],1);
			if (line[i+1]=='\n')
				continue;
			else 
				i += 1;
		}
		else if (line[i]=='\n'){
			i++;
			break;
		}
		i++;
	}
	line[i] = '\0';


	return(i);
}
