.J1 1 "Getting Started"
.K1 1 "GETTING STARTED" "Introduction to the User's Manual"  "John Rasure & Danielle Argiro"
.K0 "GETTING STARTED"
.NH 1 "INTRODUCTION"
.XS
\s12\*(SN  INTRODUCTION\s0
.XE
.sp
.PP
Khoros is a software environment for research in the use of
visual programming as a tool for software development for scientific 
visualization.
The Khoros infrastructure consists of several layers of interacting
subsystems.  A user interface development system (UIDS) combines a 
high-level user interface specification with methods of software development 
and maintenance that are embedded in a code generation tool set.  
An interoperable data exchange format (VIFF) and algorithm library contain 
the application specific layer.  The UIDS can be
used to create three user interface styles: (1) a command line user interface,
(2) a graphical, form/menu based user interface, and (3) the basic 
operations of a visual programming language.  The result is an extensible 
visual programming environment.
.sp
.PP
The current library of over 260 routines has been developed to facilitate 
research in image processing, signal processing, pattern recognition,
remote sensing, machine vision, and geographic information systems.
Khoros is also a valuable teaching tool for signal and image processing.
.sp 3
.NH 1 "SETTING UP YOUR ENVIRONMENT"
.XS
\s12\*(SN  SETTING UP YOUR ENVIRONMENT\s0
.XE
.sp
.PP
In order for you to access the Khoros software from your login
environment, the following issues must be addressed:
.IP "(1)"
Khoros environment variables must be defined.
.IP "(2)"
Your path must be set to include the Khoros binaries.
.IP "(3)"
Xdefaults for the Khoros system must be set by using the ".Xdefaults" file.
.PP
These are discussed in the following sections.  Examples of the files 
described are included in the directory \f(CW$KHOROS_HOME/dotfiles\fP.
.sp 2
.NH 2 "ENVIRONMENT VARIABLES"
.XS
      \*(SN  ENVIRONMENT VARIABLES
.XE
.sp
.PP
Environment variables for Khoros are typically put in a file 
called \f(CW.khoros_env\fP which should be created in the user's home
directory and sourced at login.
The most important environment variable, "KHOROS_HOME", indicates the 
directory where Khoros has been installed:
.br
\f(CW% setenv KHOROS_HOME\fP \fIdirectory\fP
.br
.PP
Another very important environment variable that is used by UNIX and Khoros
is the "TMPDIR" variable.  Khoros uses this directory as the location of all 
temporary files and images.  It should be set to a large directory, as in:
.br
\f(CW% setenv TMPDIR /usr/tmp\fP
.br
.PP
Several of the maintenance and installation procedures (\fBkinstall\fP and 
\fBksrcconf\fP) send mail to indicate their status.  If you want this mail 
sent to a specific account, then include the following line:
.br
\f(CW% setenv KHOROS_MAIL\fP \fIuser_name\fP
.br
.PP
Programs will log their execution occurrence into a command log file if
the "KHOROS_LOG" environment variable is set to a valid filename:
.br
\f(CW% setenv KHOROS_LOG\fP \fIfilename\fP
.br
.PP
Programs will print out a warning message and a default value for each option 
that is not used if the "KHOROS_VERBOSE" flag is set.  You will
probably want to set the flag to 'no':
.br
\f(CW% setenv KHOROS_VERBOSE no\fP
.br
.PP
The file browser used by Khoros xvroutines has a Keywords capability, that
provides a shorthand for entering input files.  The use of the Keywords 
capability is explained in detail in the last section of this chapter; 
on-line help can be accessed 
from the "Help" button that appears on the file browser.  If desired, you 
may create your own Keywords file defining your own preferred shorthand to
frequently-used input files, and set the "KHOROS_KEYWORDS" file to it;  
otherwise, the Keywords shorthand is defined in the Keywords file:
.br
\f(CW% setenv KHOROS_KEYWORDS $KHOROS_HOME/repos/Keywords\fP
.br
.PP
There are three environment variables used by Khoros that deal with the shared
memory file system cache.  These are "KHOROS_CACHE_SIZE", "KHOROS_CACHE", and 
"KHOROS_CACHE_WDISABLE".  Once you feel comfortable with the Khoros system,
and would like to take advantage of the increased speed made possible by the 
caching mechanism, please see the section on \fIcache\fP in the Khoros User's
Manual under \fBcantata\fP, or reference the man pages on cache by executing
\f(CW% vman cache\fP.
.PP
Here is an example of the \f(CW.khoros_env\fP file.  Create this file 
in your home directory, or copy the example file 
given in \f(CW$KHOROS_HOME/dotfiles/khoros_env\fP.
.DS

\f(CW
#   ----------------------------------------------
#   This file must be sourced (source .khoros_env) 
#   or included in your .login or .cshrc
#   ----------------------------------------------
#
#   This file contains default values for ALL 
#   environmental variables used by KHOROS.

setenv KHOROS_HOME 		\fIdirectory_name\fP
setenv KHOROS_CONTRIB 		\fIdirectory_name\fP
setenv KHOROS_MAIL 		$USER
setenv KHOROS_LOG		$HOME/khoros.cmdlog
setenv KHOROS_VERBOSE		no
setenv KHOROS_CACHE_SIZE	4194304
setenv KHOROS_CACHE		no
setenv KHOROS_CACHE_WDISABLE	off
setenv KHOROS_KEYWORDS		$KHOROS_HOME/repos/Keywords
setenv TMPDIR			/usr/tmp
\fP
.DE
.sp 2
.NH 2 "MODIFICATIONS TO THE .cshrc FILE"
.XS
      \*(SN  MODIFICATIONS TO THE .cshrc FILE
.XE
.sp
.PP
For the Khoros system to work correctly, the Khoros environment file
(describe above) must be sourced at login.  This can be done by
adding a source statement at the \fItop\fP of the ".cshrc" file.
The Khoros binary directory must also be added to your search path.
To indicate where Khoros X applications will be displayed, the 
DISPLAY environment variable must be set to your workstation.
One way to accomplish these actions is to modify your \f(CW.cshrc\fP 
file with the following changes.
.DS

\f(CW
# Source the .khoros_env file to set environment variables:
# (This must be included before the "set path" command!)
source $HOME/.khoros_env

# Modify your path to include $KHOROS_HOME/bin:
set path=(. ~{$USER}/bin $KHOROS_HOME/bin ...)

# Set the X Window environment variable DISPLAY:
# (this is optional)
setenv DISPLAY \fIworkstation\fP:0
\fP
.DE
.sp 2
.NH 2 "XDEFAULTS"
.XS
      \*(SN  XDEFAULTS
.XE
.sp
.PP
The ".Xdefaults" file is read by X Windows-based applications
during startup to customize the appearance or characteristics of their
windows.
See the example in \f(CW$KHOROS_HOME/dotfiles/Xdefaults\fP.  This is a
very long .Xdefaults file;  however, the majority of it is devoted to 
controlling the colors that appear on the various Khoros applications.
You need not be concerned with this unless you would like to customize the
colors for Khoros applications for your own use.  If you would like to 
customize the colors, it is easiest to edit this file and do a global
change.  For example, if you use the \fIvi\fP visual editor, and want
all subform buttons to appear in orange instead of royal blue, you can do:
.br
\f(CW
:1,$ s/royal blue/orange/g
\fP
.br
.PP
If you use the \fIemacs\fP visual editor, the global change can be made with:
.br
\f(CW
<esc> x replace-string
\fP
.br
Remember, any time you change your .Xdefaults file and you want to see that
change reflected when you run X Windows-based applications, you must execute:
.br
\f(CW
% xrdb {desired .Xdefaults file}
\fP
.br
.PP
If you have problems when running Khoros on a monochrome screen, look at the
\f(CW$KHOROS_HOME/dotfiles/Xdefaults.mono\fP file for examples of lines 
you might try changing, or simply use this Xdefaults file instead.
.sp 3
.NH 1 "X WINDOWS"
.XS
\s12\*(SN  X WINDOWS\s0
.XE
.sp
.PP
Since Khoros runs under the X Windows (X11R4) system, it is helpful to have 
an understanding of X Windows before attempting to use Khoros.  For those that
would like to learn more about X Windows, we recommend the "X Window System
User's Guide" by Valerie Quercia and Tim O'Reilly.  In addition to this book,
O'Reilly and Associates, Inc. have published volumes on X Protocol, Xlib,
the X Toolkit, and XView, some or all of which may prove valuable to the
interested reader.  A brief description of X Windows can be obtained with
the Unix \fBman\fP command:
.br
\f(CW% man X\fP
.br
.PP
The details of managing the windows, such as interpreting mouse and keyboard
commands, moving and resizing, are actually carried out by a program called a
\fIwindow manager\fP.  On many systems the window manager used is \fBtwm\fP.
Another popular window manager (used with SUN's) is \fBolwm\fP, or 
Open Windows window manager.  Use the \f(CW% man\fP command to find out more
about your window manager.  Some window managers have automatic window 
placement, while others use manual window placement;  some window managers
"decorate" the tops of windows, while others do not.  The operations that you
must perform to resize a window, refresh the screen, and so forth are dictated
by your window manager.  If your site supports more than one window manager,
you may have a choice as to which one is the most suitable for you.  As the
window manager will affect the operation of Khoros programs, you should be
reasonably comfortable with your window manager before using the Khoros system.
It should be noted that Khoros was developed primarily under the \fBtwm\fP
window manager;  most Khoros programs have also been tested under \fBolwm\fP.
\fINever\fP attempt to run more than one window manager at the same time.
.PP
Once you have logged onto a system and using the X Window system, you may 
need to tell the system where you want Khoros images to be displayed.  
This is done by setting the environment variable DISPLAY.  The command:
.br
\f(CW% setenv DISPLAY\fP \fIworkstation\fP:0
.br
tells X Windows and Khoros to send images and graphics to the primary screen
(screen 0) of the named \fIworkstation\fP.  If you have originally logged in
to one machine, and then \fBrsh\fP or \fBrlogin\fP to a second machine on which
you are going to be running Khoros applications, you must execute:
.br
\f(CW% xhost {second machine}\fP
.br
on the original machine before going to the second machine and executing the
\f(CWsetenv DISPLAY\fP command given above for the display of the 
second machine.
.sp 3
.NH 1 "USING KHOROS ROUTINES"
.XS
\s12\*(SN  USING KHOROS ROUTINES\s0
.XE
.sp 2
.NH 2 "COMMAND LINE USER INTERFACE"
.XS
      \*(SN  COMMAND LINE USER INTERFACE
.XE
.sp
.PP
The Khoros routines can be invoked as individual programs from the command
line, using a standard, Unix-like interface.  By convention, all of the 
program options are preceded by a minus sign and a flag type.  For example,
the flag \fB-i\fP typically indicates an input file and \fB-o\fP an output file.
Thus, the program to shrink the image contained in file \fIinfile\fP by a 
factor of two and store the result in \fIoutfile\fP, is invoked with:
.br
\f(CW% vshrink -i KHOROS_HOME/data/images/ball.xv -o outfile -s 2\fP
.br
To display an image file on the screen, you can use:
.br
\f(CW% putimage -i KHOROS_HOME/data/images/ball.xv\fP
.br
.PP
If you don't know how to use a program, you can get a brief description by
typing the program name followed by the \fB-U\fP usage flag.  This will 
produce a short description and a list of the required and optional arguments.
For example:
.br
\f(CW% vshrink -U\fP
.sp
.ps 10
produces
.sp
\f(CWvshrink :
.sp
.in +0.5i
Shrink an image by skipping pixels (subsampling)
.sp
-i  input image  (infile)
.br
-o  output (shrunk image)  (outfile)
.sp
[-s]  shrink scale factor (integer, > 0) [2]
.sp
.br
[-V] Gives the version for vshrink
.br
[-U] Gives the usage for vshrink
.br
[-P] Prompts for command line options
.br
[-A [file1]] Creates the answer file called vshrink.ans or file1 
.br
[-a [file1]] Uses vshrink.ans or file1 as the answer file \fP
.in -0.5i
.ps 11
.sp
.PP
If you would prefer to be prompted for the arguments one by one, use the 
\fB-P\fP flag.  The \fB-A\fP option creates an answer file containing the 
parameters you have specified; referencing the program again with \fB-a\fP
flag reads any parameters not specified on the command line from the answer
file (useful if the same parameters are to be used repeatedly).
.sp
.PP
To get a detailed description of a Khoros routine, use the \fBvman\fP command, 
which is patterned after the Unix \fBman\fP command:
.br
\f(CW% vman vshrink\fP
.br
.PP
If you would like to know which routines are associated with a specific
action or idea, use the \fBvman\fP command with the \fB-k\fP \fIkeyword\fP
option.  Thus
.br
\f(CW% vman -k shrink\fP
.br 
produces the listing
.sp
.ps 10
\f(CWvshrink(1) - Shrink an image by skipping pixels (subsampling) 
.br
lvshrink(3) - Shrink an image by skipping pixels (subsampling) \fP
.ps 11
.sp
which tells us that there is a program, \fBvshrink\fP, to shrink an image, 
and a library routine, \fIlvshrink()\fP, that may be called by a program
to perform the shrinking operation.
.sp
.PP
Stdin can be used for any input file but must be specified by using a "-"
for the file name.  Stdout can also be used for any output file.
In this way, the output of one program can be connected to the input of 
another using Unix pipes.
Thus:
.br
\f(CW% vshrink -i image.xv -o - -s 2 | putimage -i -\fP
.br
invokes \fBvshrink\fP to shrink the image in \fIimage.xv\fP, and passes the 
result to the display routine \fBputimage\fP to display it on the screen.
.sp
.LP
Stderr can be used for an ASCII output file but must be specified using 
"#" for the file name.
.sp 2
.NH 2 "GRAPHICAL USER INTERFACE"
.XS
      \*(SN  GRAPHICAL USER INTERFACE
.XE
.sp
.PP
Khoros includes several major application programs that always have a graphical
user interface, in addition to their command line user interface.  Among
others, these include an animation/image sequencing program, an image 
display/manipulation package, an image warping application,  an interactive
imagery/elevation display package, a 2D plotting package, and a 3D plotting
package.  To begin use of these programs, you may want to skip forward to the
section labelled, "APPLICATION DEMOS" to see demos of these applications.
In addition, you might try the following commands as an introduction to these
programs. 
.br
\f(CW% animate -i $KHOROS_HOME/data/sequences/eye/eyes\fP
.br
To see the animation sequence of 60 frames (hit the button labeled ">>" 
to start, "Stop" to stop, "Quit" to end the program).
.sp
\f(CW% editimage -i $KHOROS_HOME/data/images/feath.xv\fP
.br
To see an image displayed.
.sp
\f(CW% xprism2 -i11 $KHOROS_HOME/data/plot_functions/example2.1\fP
.br
To plot a pre-defined set of data points in two dimensions.
.sp
\f(CW% xprism3 -i11 $KHOROS_HOME/data/plot_functions/example3.0\fP
.br
To plot a pre-defined mathematical function in three dimensions.
.sp 2
.NH 2 "VISUAL LANGUAGE INTERFACE"
.XS
      \*(SN  VISUAL LANGUAGE INTERFACE
.XE
.sp
.PP
All the routines available in the Khoros image processing library (ipl),
digital signal processing library (dspl), and file format conversion library
can be accessed using the command line user interface (CLUI).  However, most 
users prefer the graphical user interface (GUI) provided by the visual 
programming language, \fBcantata\fP.  Image and signal processing tasks are 
often naturally expressed as block diagrams or data flow graphs.  By providing 
a programming environment in a similar format, \fBcantata\fP assists in the 
rapid prototyping of applications in those fields.  
.PP
To create a visual program using \fBcantata\fP, you begin with a blank 
\fBcantata\fP workspace.  Selecting the desired Khoros routines to perform
various tasks,  you then create iconfied representations of the Khoros routines,
called \fIglyphs\fP.  Next, you connect the glyphs together with lines that
go from one  glyph's output arrow to another glyph's input arrow. This is
the equivalent of running the first Khoros program from the command line, saving
its output in a temporary file, using the temporary file as input to the next
program, and so forth.  A complete \fBcantata\fP workspace is a visual
program made up of glyphs representing Khoros programs, with lines representing
the flow of data between routines.  The entire program can be run using a 
"Run" button located on the \fBcantata\fP form,  or the program may be run
step by step by clicking on the little "on/off" switches that appear at the
upper left hand corner of each glyph representing an executable Khoros program.
.PP
At any time, a \fBcantata\fP workspace may be saved as an ascii file.  Later, 
\fBcantata\fP may be run, restoring the saved workspace, so that you may 
continue with your visual program where you left off before.
.PP
If you would like to see a simple, easy-to-understand example of a
\fBcantata\fP workspaces, execute:
.br
.ps 9
.vs 11
\f(CW
% cantata -restore $KHOROS_HOME/repos/workspace/examples/example1.Z\fP
.br
.ps 11
.vs 13
.PP
The objective of this first visual program is to enhance a dim image. We will
go through the example step by step, so that you can follow along using 
\fBcantata\fP while reading this section.  The input image is represented 
by the first glyph, labelled, "images".  On this glyph, click on the button 
with the picture of the forms (meant to represent the graphical user interface).
The glyph will open up into the corresponding graphical user interface; in this
case, the Input Data subform with the Images pane displayed. You can see that 
the input image selected is "spine.xv".  This will be the input image for our 
visual program.  Now click on the button at the upper left hand corner of the 
subform, labelled "Glyph".  The Input Data subform will turn back into a glyph,
and go back to its place on the \fBcantata\fP workspace.
.PP
Notice that the "images" glyph's output is connected to two other glyphs:
the "put_update" glyph and the "vconvert" glyph.  This means that the spine.xv 
image will be serving as input to two Khoros routines: \fBputimage\fP 
and \fBvconvert\fP (usually, the glyph name is identical to the name of the
program that it represents - however, the \fBputimage\fP program is a special
case:  it has two glyph representations, "put_update" and "put_multi", which
are used differently).  First, click on the "put_update" glyph's
"run" button, which appears at the top right and has a picture of an electrical
switch. This will run the \fBputimage\fP program with spine.xv as the input.
Since spine.xv is not of data type BYTE, you will be prompted to convert the
image.  Click on "Cont" to indicate "Yes".  The spine.xv image will then be
converted to type BYTE and displayed by \fBputimage\fP.  Notice that the image
of the spine is very dim; most of its colors are on the dark end of the
grey scale spectrum.
.PP
Now, go to the glyph labelled, "vconvert".  It will also have spine.xv as its
input, as indicated by the lines representing data flow.  Click on its run 
button in order to call the \fBvconvert\fP program to convert the data in 
spine.xv to type BYTE in preparation for the next step.
.PP
The \fBvhstr\fP program will do a \fIhistogram stretch\fP on the colors in the
input image.  That is, it will attempt to even out the colors in the image,
so that instead of being all bunched together at the dark end of the grey scale
spectrum, they will cover a larger number of colors ranging from black to white.
To run the \fBvhstr\fP program on the converted spine.xv data, click on the
"run" button of the "vhstr" glyph.  To see the results of the histogram stretch,
click on the "run" button of the last "put_update" glyph.  This will call
\fBputimage\fP once again to display the resulting image.  Note that this 
image is much brighter than the original; vertibrae are easy to distinguish, 
and much more detail is apparent.  So, our example visual program was a success!
.PP
Delete the images displayed by \fBputimage\fP by clicking
the mouse inside them, or clicking the mouse on the "on/off" switch that appears
to the upper right hand corner of the \fBput_update\fP glyph.  
If desired,  you can repeat the entire process quickly 
by hitting the "RESET" button which appears to the left of the \fBcantata\fP 
form, and then clicking on the "RUN" button that appears right above it.  
The visual program will repeat itself all at once, not step by step as in the 
first try.  Glyphs can be moved about by clicking on them with the mouse and 
moving them while holding the mouse button down.
.PP
By clicking on the "Workspace" subform button on the \fBcantata\fP form, you
can set environment options for \fBcantata\fP - for instance, you may prefer
small glyphs instead of large ones, you may wish to indicate when data is
available at inputs and outputs, you may wish \fBcantata\fP to echo program
execution to your tty, or you might want to use the interactive glyph placement
option.  These and other options may be set as desired.  
.PP
There are two other example workspaces in the 
\f(CW$KHOROS_HOME/repos/workspace/examples\fP directory that you are welcome
to try.  We will not go over them here, but the README file in that directory
will explain the objective of each workspace.  You are encouraged to experiment
with these examples of \fBcantata\fP.
.PP
For more information about the \fBcantata\fP program, you can execute
\f(CW% vman cantata\fP;   Chapter 2 of the Khoros User's Manual is recommended
for further understanding of the \fBcantata\fP visual language.  
.sp 3
.NH 1 "APPLICATION DEMOS" 
.XS 
\s12\*(SN  APPLICATION DEMOS\s0
.XE
.sp 2
.NH 2 "SEEING A JOURNAL PLAYBACK"
.XS
      \*(SN SEEING A JOURNAL PLAYBACK 
.XE
.sp
.PP
All Khoros \fIxvroutines\fP, including \fBanimate, composer, editimage,
viewimage, warpimage, xprism2\fP, and \fBxprism3\fP have a built-in journal
record / journal playback capability that is provided via the graphical user
interface.  If you add a new xvroutine to Khoros, it will also have the
journal record / playback ability (see Chapter 1 of the Khoros Programmer's
Manual for more information on xvroutines and journal playback). This journal 
record/playback capability is available so that you may run the demos that 
are provided for you in \f(CWKHOROS_HOME/repos/journal\fP, and create your
own journal sessions, if desired.  Furthermore, the journal record / playback 
capability of these programs is what makes them viable target programs for 
the Khoros collaboration program, \fBconcert\fP (see Chapter 9 of the Khoros 
User's Manual).  Note that because of its complex interpretive implementation,
\fBcantata\fP is not a good subject for either journal playback 
or \fBconcert\fP.
.PP
When playing back a journal session, a small "Journal Control" widget will 
appear.  Since the journal playback session \fIgrabs your keyboard\fP, this
Journal Control widget reminds you of the simple control commands that 
the journal playback mechanism understands.  The command keys will work 
regardless of where the mouse pointer is located when they are hit;  remember,
your keyboard has been grabbed, so you will not be allowed to provide keyboard 
input to any window that may currently be displayed until the journal 
recording is finished.  The following are the three simple commands that 
journal playback understands:
.IP "h or H:" 15
Halts the journal playback session. 
.IP "c or C:"
Continues the journal playback session.
.IP "q or Q:"
Quits the journal playback session, and allows you to continue execution
of the application on your own, at whatever point the journal playback left off.
.PP
There are predefined application demos for all the major Khoros applications.
All of these demos are run by executing the desired application with the 
[-jp {record file}.jp] option, where "jp" stands for "journal playback".  
In addition, any other options that were used when the journal file was 
created must also be used when the journal recording is played back.  
The following is a list of commands that may be run in order
to see the predefined application demos that are provided with the Khoros 1.0
release.  Journal record files are always named with the postfix, ".jp".
.sp
.ps 9
.vs 11
.nf
\f(CW
% animate -i $KHOROS_HOME/data/sequences/bush/bushes 
.br
          -jp $KHOROS_HOME/repos/journals/animate.jp
.sp
% composer -jp  $KHOROS_HOME/repos/journals/composer.jp
.sp
% editimage -jp $KHOROS_HOME/repos/journals/editimage.jp
.sp
% viewimage -i $KHOROS_HOME/data/images/feath.eye 
.br
            -e  $KHOROS_HOME/data/images/flow.eye 
.br
            -jp  $KHOROS_HOME/repos/journals/viewimage.jp
.sp
% warpimage -jp  $KHOROS_HOME/repos/journals/warpimage.jp
.sp
% xprism2 -jp $KHOROS_HOME/repos/journals/xprism2.jp
.sp
% xprism3 -jp $KHOROS_HOME/repos/journals/xprism3.jp
\fP
.na
.sp
.ps 11
.vs 13
.PP
In some cases, the fact that journal playback grabs the keyboard may present
a problem.  If you need to have control of the keyboard while journal playback
is running, you must use the [-jg 0] or [-jg false] (where "jg" stands for
"journal grab") option in addition to the [-jp {journal file}] option.
When this option is used, the Journal Control Widget will not appear.  It
is mainly used for debugging purposes by the Khoros group, but some people may 
find it useful.
.sp 2
.NH 2 "MAKING A JOURNAL RECORDING"
.XS
      \*(SN  MAKING A JOURNAL RECORDING
.XE
.PP
You may wish to create your own application demos using the journal recording
mechanism that is built in to all Khoros xvroutines.  The journal recording 
/ playback mechanism is machine independent, so if you want to record a session 
on one machine and play it back on a differing architecture, this will not pose 
a problem.  If, however, the journal recording was made with a particular font,
and is played back with a different font,  the graphical user interface may
have trouble sizing itself properly.  While this mars the physical appearance
of the application being played back, it will not harm the functionality of
the recording. 
.PP
To make a journal recording of a Khoros xvroutine, simply use the 
[-jr {record file}] option that is available with all Khoros xvroutines.  For
example, say that we would like to make a journal record file of \fBxprism\fP.
We would execute the following:
.br
\f(CW
.ps 9
.vs 11
.nf
% xprism2 -jr my_xprism2_demo.jp
\fP
.na
.br
.ps 11
.vs 13
.PP
This will create the journal recording file, "my_xprism2_demo.jp".  To play back
the recorded session, we execute:
.br
.ps 9
.vs 11
.nf
\f(CW
% xprism2 -jp my_xprism2_demo.jp
\fP
.na
.sp
.ps 11
.vs 13
.PP
Remember that any other options you used when recording the session \fImust
also be used when playing it back\fP.  Therefore, if you record a session
with \fBeditimage\fP as:
.br
.ps 9
.vs 11
.nf
\f(CW
% editimage -i $KHOROS_HOME/data/images/lizard.xv -jr editimage_demo.jp
\fP
.na
.ps 11
.vs 13
.br
.PP
You \fIMUST\fP play back the session with:
.br
.ps 9
.vs 11
.nf
\f(CW
% editimage -i $KHOROS_HOME/data/images/lizard.xv -jp editimage_demo.jp
\fP
.na
.ps 11
.vs 13
.br
.PP
Attempting, for example, to execute a journal playback of \fBeditimage\fP 
without the input file that the journal recording was made with:
.br
.ps 9
.vs 11
.nf
\f(CW
% editimage -jp editimage_demo.jp
\fP
.na
.sp
.ps 11
.vs 13
.PP
Will not work!  We cannot predict exactly what the results will be, but
we can guarantee that they will not be what you recorded.  For this reason,
when making journal recording sessions, it is recommended that you use as
few command line arguments as possible, thus making it less likely to forget
what they were when you play back the session.  
.sp 3
.NH 1 "MAKING BUG REPORTS" 
.XS 
\s12\*(SN  MAKING BUG REPORTS\s0
.XE
.sp 2
.PP
As with any system approaching the size of the Khoros system, you can expect
to find some bugs.  We already are aware of several bugs;  these can be found
in $KHOROS_HOME/repos/BugList.  If you find a bug in the Khoros system, please
look through this file first to see if it is one of the bugs that we already
have on our list.  We \fIstrongly\fP encourage you to report any bugs that
you may find that are not listed in the BugList.  ALL BUGS are to be reported 
via \fIemail\fP, to \f(CWkhoros-bugs@chama.unm.edu\fP.  NOTE:  BUG REPORTS 
ONLY are to be mailed to this address.  If you have comments, questions, 
or other feedback, please see the next section.  There is a 
bug-reporting template, \f(CW$KHOROS_HOME/repos/BugReport\fP, that we 
hope you will use.  If you do not use the template to report the bug, 
\fIplease include the following information:\fP
.IP 1)
The program or library routine containing the bug
.IP 2) 
A clear and concise description of the problem.  If the problem was experienced
when using \fBcantata\fP, a saved workspace that shows the bug is very 
helpful, along with the explanation.
.IP 3)
Step-by-Step instructions for someone else to follow in order to reproduce
the bug
.IP 4)
The machine architecture that you were on when you experienced the bug
.IP 5)
The operating system that you were using when you experienced the bug
.IP 6)
The version of X Windows that is installed on your system (if not X11R4)
.IP 7)
The window manager that you were using at the time
.sp
.PP
Please remember that all the above information is imperative for a bug report,
so that members of the Khoros group will be able to re-produce the bug and
fix it.  
.sp
.NH 1 "QUESTIONS?  COMMENTS?  COMPLIMENTS?  COMPLAINTS?" 
.XS 
\s12\*(SN  QUESTIONS?  COMMENTS?  COMPLIMENTS?  COMPLAINTS?\s0
.XE
.sp 2
.PP
For general discussion purposes, getting answers to questions that are 
not addressed in the Khoros Manuals, writing comments, or giving 
constructive criticism, we have an open-format (unmoderated) mailing group.  
The name of this mailing group is \f(CWkhoros@chama.unm.edu\fP, and was 
created due to popular demand.  In addition, it helps us to separate actual 
bug reports (which, as indicated above, should go to 
\f(CWkhoros-bugs@chama.unm.edu\fP) from other mail.  
.PP
If you would like to become a member of the Khoros mailing list, send your
request to \f(CWkhoros-request@chama.unm.edu\fP.  \fIPLEASE:\fP only requests 
to get on or off the Khoros mailing list should go to this address.  Other mail
is very likely to get lost or be deleted.
.PP
Once a member of the Khoros mailing list, feel free to write to 
\f(CWkhoros@chama.unm.edu\fP.  If you have a question, and it is not 
answered in the Khoros Manuals or Khoros online documentation, you are invited 
to mail your question to this address.  If the Khoros group cannot answer your
question immediately, it is likely that another Khoros user may be able to
(there are well over 150 people on the mailing list already).  Constructive
criticism, suggestions, or open-format discussions are also welcome at
\f(CWkhoros@chama.unm.edu\fP.   Of course, everyone is invited to join the 
mailing list,  but if you use the Khoros system often, we especially 
encourage you to join.  
.sp 3
.NH 1 "ADDITIONAL BACKGROUND" 
.XS 
\s12\*(SN  ADDITIONAL BACKGROUND\s0
.XE
.sp 2
.PP
For most first-time Khoros users, the previous sections will provide enough
information to get started using Khoros.  However, if you were a user of
Khoros Beta and are already familiar with the system, or if you simply would
like to know more about additional features that can be used with the major
Khoros applications, the following sections will provide additional information
that you can take advantage of to customize your environment, and use the
Khoros software more efficiently.
.sp 2
.NH 2 "THE FILE BROWSER AND KEYWORDS CAPABILITY"
.XS
      \*(SN  THE FILE BROWSER AND KEYWORDS CAPABILITY
.XE
.sp 2
.PP
The Khoros Browser provides an alternative to typing in filenames for
input from an InputFile selection that appears on the graphical user of any
Khoros program.  The Khoros Browser can be used in 
two ways: as a file/directory browser, or as a browser for keywords.  
When the Khoros browser is used as a file browser, one uses the mouse to 
move about the directory structure to find the desired input file;  when it is
used as a keyword browser, one uses the mouse to move about the keyword 
structure to find the desired file.  
.sp
.SH
USING THE FILE BROWSER
.LP
The default mode for the Khoros Browser is to act as a File Browser.
The first item in the list of the file browser is the word, "-- keywords --".
By selecting this item, you change the Khoros browser to the second mode,
which is the Keyword Browser; we will talk about this in the next section. 
The rest of the list is the contents of your 
local directory; to enter an input file that is located in your local 
directory, simply select the desired filename.  The browser will go away,
and the parameter box of the InputFile selection from which it originated
will be filled in with the selected filename.  Using the file browser,
you may also move about the directory structure by clicking on "../" to move
up in the directory structure, or by clicking on the name of the desired
directory to move down in the directory structure.  When the item you select
from the browser is the name of a file, the entire path to that file prepended
to the filename will become your input file;  the file browser will go away,
and the file you selected will appear in the InputFile selection.  
.LP
Alternatively, one may also type the entire directory path directory into the
text box at the bottom of the file browser, following the directory path
with a carriage return.  The file browser will immediately update the list 
with the contents of the specified directory.  Notice that the directory box
at the bottom of the file browser continually updates to the current pathname,
so one always knows where the current directory is.
.sp
.SH
USING THE KEYWORD BROWSER
.LP
By selecting the first item of the file browser, "-- keywords --", you cause
the Khoros Browser to change from being a file browser to being a keywords
browser.  The keywords browser provides a convenient shorthand for long
pathnames to input files;  furthermore,  once the controlling Keywords file
is set up, one need not remember the location of an input file - only it's 
keyword. 
.LP
The keywords used by the Khoros system are determined by the Keywords file,
located in KHOROS_HOME/repos/Keywords.  Take a moment now to look at this
file.  Each entry in the Keywords file consists of a single line of text:
the keyword or keyword set, followed by the path that the shorthand represents.
The first entries are single keywords that are shorthand notations for
very frequently used files.  For instance, ":feath" is a shorthand notation
for "KHOROS_HOME/data/images/feath.254.xv".  Once this entry is established 
in the Keywords file, one may use ":feath" anywhere an input file is needed,
in either a command line user interface or a graphical user interface.  
For instance, one might type:
.sp
.ps 9
.vs 11
.nf
\f(CW
% editimage -i :feath
\fP
.na
.sp
.ps 11
.vs 13
.sp
instead of:
.sp
.ps 9
.vs 11
.nf
\f(CW
% editimage -i KHOROS_HOME/data/images/feath.xv
\fP
.na
.sp
.ps 11
.vs 13
.LP
Or, on the Input/Output pane of editimage, one might enter ":feath" in the 
parameter box labeled, "Khoros image file as INPUT:". Note that when 
\fItyped by the user,\fP a single keyword MUST be preceded by the ":" symbol 
to distinguish it from an actual file in one's local directory.
.LP
Finally, one might use the Keyword browser, and select "feath" from the 
Keywords list.  Again, the result is to input the image of the woman with
the feathered hat.
.LP
Keywords may be sub-divided as desired.  For instance, in the 
\f(CWKHOROS_HOME/repos/Keywords\fP file, "plot3D:example3.0" is defined to be
a shorthand for \f(CWKHOROS_HOME/data/plot_functions/example3.0\fP.  
Subdividing keywords allows us to conceptually group input files as desired; 
in this case, the "plot3D" group has 5 elements -- example3.0 through 
example3.4.  In addition, subdivision of keywords causes the Keywords 
Browser to mimic the operation of the File Browser.
.LP
The meaning of ":" following a 
keyword in the Keywords Browser is equivalent to a "/" following a filename 
of a file in the File browser;  ie, when you click on this item, the current
list will be replaced by a list of those items that are subordinate to the
first item.  Our Keywords file defines the "plot2D" keyword as having 
5 subordinate keywords: example2.0 - example2.4.
Thus, when we click on the "Plot2D:" entry of the Keywords Browser,
we are presented with a list of those 5 subordinate keywords.  Now, clicking on
"example2.4" causes the Keyword Browser to expand the Keyword "path" to 
"plot2D:example2.4", which in turn is defined in the Keywords file as the 
shorthand representing \f(CWKHOROS_HOME/data/plot_functions/example2.4\fP.  
.LP
The next time the Khoros Browser
is used, it "remembers" that the last operation was to use the Keywords Browser,
under the "Plot2D" keyword category, so it goes back to that "location" - 
again, we are presented with the list of example2.0 - example2.4.  By clicking
on "<==" (the equivalent of "../" in the File Browser) we go "up" to the 
original Keywords list.  We may now choose another keyword ("moon", for 
instance, is the shorthand to KHOROS_HOME/data/images/moon.xv) or we may
again click on "<==".  Since we are now at the "top" level of the Keyword
Browser, there is no where else to go, except back to the File Browser.
.LP
While complicated to explain, the use of Keywords is very trivial after 
only a little practice;  users are encouraged to take advantage of this 
convenient and time-saving shorthand.  Furthermore, the Keywords file found
in KHOROS_HOME/repos is only meant as a model;  the user is encouraged to
create their own Keywords file, to personalize the operation of keywords.  
When creating your own Keywords file, 
be sure to follow the syntax rules carefully:  
.sp
1) all single keywords must be preceded with a ":".  
.br
2) keywords may be subdivided as many times as desired but remember: if you
subdivide your keywords too much, your shorthand is no longer short!
.br
3) each keyword must be followed by some white space, and then its full 
path definition.
.br
4) each keyword/path pair must appear on a single line
.br
5) comments are preceded by a "#" in the first column.
.sp
Now that you have created your Keywords file, you must tell the khoros 
environment to use it.  You do this by going to the .khoros_env file
in KHOROS_HOME/.khoros_env and changing the line that says, 
.sp
\f(CWsetenv KHOROS_KEYWORDS          $KHOROS_HOME/repos/Keywords\fP
.sp
to:
.sp
\f(CWsetenv KHOROS_KEYWORDS          $USER/\fP\fIKeywords file\fP
.sp
Note that the .khoros_env file must be sourced (source .khoros_env) or
included in your .login or .cshrc file.
From now on, you can use your own keywords to your own best advantage.
.sp 2
.NH 2 "USE OF DIFFERENT FONTS & COLORS"
.XS
      \*(SN  USE OF DIFFERENT FONTS & COLORS
.XE
.sp 2
.PP
There are three ways to specify fonts with Khoros application programs, and
one way to specify colors for use with Khoros applications.  Let us discuss
fonts first.  A specific font may be specified for the entire graphical 
user interface of a Khoros xvroutine by using the [-fn] option that is 
available with all Khoros xvroutines, or by specifying the desired font 
in the .Xdefaults file. 
.sp 
.NH 3 "CHANGING THE FONT FOR AN ENTIRE APPLICATION"
.XS
           \*(SN  CHANGING THE FONT FOR AN ENTIRE APPLICATION
.XE
.sp 2
.PP
The first two ways of changing the font, which will change the font for 
ALL fonts in \fBpreview\fP's graphical user interface, for instance, to kana14:
.sp
\f(CW% preview -fn kana14\fP
.sp
Alternatively, you may edit your .Xdefaults file, and add the line:
.sp
\f(CWpreview.font:   kana14\fP
.sp
If you want *all* Khoros xvroutines to appear in a particular font, you may
use a wildcard for the font specified in the .Xdefaults file, for example:
.sp
\f(CW*.font:   fixed\fP
.sp
This will make the graphical user interface of ALL Khoros xvroutines appear 
in the fixed font.  Now, if you want specific programs to appear in a diffent
font, you can add each one specifically.  For example, suppose you want all
Khoros routines to appear in the fixed font except \fBxprism3\fP, which you 
want to see in 8x13bold.  You would follow the line above with:
.sp
\f(CWxprism3.font:   8x13bold\fP
.sp
This line will over-ride the previous wildcard statement for the xprism3 font.
Alternatively, you could have specified on the command line:
.sp
\f(CW% xprism3 -fn 8x13bold\fP
.sp
Since the [-fn] option always over-rides any specifications found in the 
Xdefaults file.  NOTE: we were unable to get the SGI architecture to get 
specificattions from the .Xdefaults file; if you are running Khoros on an SGI,
you will have to always use the [-fn] option to change fonts.
.sp 2
.NH 3 "CHANGING THE FONTS & COLORS WITHIN AN APPLICATION"
.XS
           \*(SN  CHANGING THE FONTS & COLORS WITHIN AN APPLICATION
.XE
.sp 2
.PP
As a true understanding of this procedure is more complicated, beginning 
Khoros users are advised to save the detailed explanation in the latter 
part of this section until later;  one font is generally enough for an 
application. In addition, the .Xdefaults file provided with Khoros 
already provides 
different border colors for different types of buttons for the graphical 
user interface of Khoros applications.  If these colors do not suit you, 
you may easily change them with a global change editor command, without 
knowing the details that make them work.  You might, for example, edit
the .Xdefaults file and change all occurances of "sea green" to "light green". 
Since this .Xdefaults file \fIonly\fP uses the color "sea green" to specify
the border color of a Help button, doing a global change from "sea green" to
"light green" will result in all Help buttons being displayed with borders
of light green.  If you use the \fIvi\fP visual editor, the global change
is made with:
.br
\f(CW
:1,$ s/sea green/light green/g
\fP
.br
If you use the \fIemacs\fP visual editor, which is more interactive, you can
do a global change by:
.br
\f(CW
<esc> @
\fP
.sp
Note that the colors supported by your display should be listed in
\f(CW/usr/lib/X11/rgb.txt\fP.  Some systems may have the \fBxcolors\fP program,
which displays the available colors with labels, and is very helpful in 
deciding on a good combination of colors.
Remember that changes made to your .Xdefaults file will not take effect until
you execute:
.br
\f(CW
% xrdb .Xdefaults
\fP
.sp
Some more creative users may want to specify a different font for different
parts of the graphical user interface, or a different color for different
parts of the graphical user interface that are not addressed in the .Xdefaults
file distributed with Khoros.  Specifying fonts for different
items in the graphical user interface follows the same procedure as for 
specifying different colors. This process is tedious, but not very difficult.
The tricky thing is that you must know the 
entire, complete name of each widget in the graphical user interface that 
You wish to change the font of.  This information can be deduced from the
UIS file for the Khoros application that you are interested in.
.PP
Let's learn with an example of changing fonts within an application.  
Suppose you want to run \fBpreview\fP, and have 
it come up with the help button in kana14, the quit button in lucidasans-10, 
the "Revisit" and "Edit" action buttons in 6x13bold, and the text of the 
input file parameter in lucidasans-14.  Copy the .Xdefaults file found in
\f(CWKHOROS_HOME/dotfiles\fP. First, you must look at the *.form 
file for \fBpreview\fP, because you will need the names that are specified 
there.  Do:
.br
\f(CW% more KHOROS_HOME/repos/preview/preview.form\fP
.PP
Here, look for the "Form_Name" specified at the end of the [-F] line,
which is "UI_view".  The "Subform_Name" specified at the end of the
[-M] line is "show".  You must recognise that \fBpreview\fP's user interface 
has only a single subform.  There is no master form, as in \fBeditimage\fP,
or \fBxprism2\fP.  So, in the .Xdefaults file, you will refer to the
\fBpreview\fP subform by its full name, which will be X_form_Y_subform,
where X = Form_Name and Y = Subform_Name.  So you know that you must
begin lines in the .Xdefaults file as follows:
.br
\f(CWUI_view_form_show_subform*\fP
.PP
Now, you want to specify fonts for the help and quit buttons.  Help
and quit buttons are always named %d_help_button and %d_quit_button
respectively, where %d is the count of the number of help and quit
buttons on that pane, starting at zero.  There is only one help
button and one quit button on the preview subform, so that means you
put in the .Xdefaults file:
.br
\f(CW
UI_view_form_show_subform*0_help_button: kana14
.br
UI_view_form_show_subform*0_quit_button: lucidasans-10
\fP
.PP
Now, let's see what else we have to work with.  In the preview.form file,
there are two pane action buttons, specified by [-a] lines.  Their
variable names are "revisit" and "edit".  Pane action buttons will
be named x_pane_action_button, where x = variable name.
Therefore, add to the .Xdefaults file:
.br
\f(CW
UI_view_form_show_subform*revisit_pane_action_button*font: 6x13bold
.br
UI_view_form_show_subform*edit_pane_action_button*font: 6x13bold
\fP
.PP
Finally, there is an input file selection.  The backplane widget for
InputFile selections is named "w_input_back"  where w is the variable
name at the end of the [-I] line - in this case "i".  So the last line
must read,
.br
\f(CW
UI_view_form_show_subform*i_input_back*font: lucidasans-14
\fP
.sp
Now, you're all set.  Write the file, and do:
\f(CW
% xrdb .Xdefaults
\fP
.PP
If your fonts do not change properly, look for a line that looks like, 
"\f(CWpreview.font: fixed\fP.  Remember that this will over-ride any other
specifications that you might have;  you must delete this line in order for
the above procedure to work.
.PP
Colors are changed exactly the same as fonts are, except that instead of
referring to "*font", you refer to "*borderColor".  We have found that adding
colors to the graphical user interface is most effective when it is the 
color of the border that is changed.  However, you might also want to experiment
with "*foreground" and "*background" to achieve interesting effects.
.TC 1 "GETTING STARTED"
