: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

# Khoros: $Id$
# $Log$

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#========================================================================
#
#  Program Name: kpack - will pack up toolboxes or objects
#
#       Purpose: The script will pack up toolboxes or objects.  It will
#		 use checksum created by kcrsum to do this if -cksum
#		 specified.  Otherwise, it packs up the entire toolbox
#		 or object.  If nothing specified on the
#                command line than all toolboxes found in the files
#                specified by KHOROS_TOOLBOX and all the objects within
#                are packed.  By default no pack file is create until
#		 -create used, but all the files to be pack will be
#		 place in the current working directory or the directory
#		 specified by -packdir.   Each toolbox will be contained
#		 within a single tar file call {toolbox}.tar.  A file called
#		 INDEX will also be created that will tell kunpack 
#		 the contents of the pack file and the operations to perform.
#
#		 You can specify multiple toolboxes by doing:
# !
# !                   % kpack -tb toolbox1,toolbox2
# !
#                You can specify multiple objects by doing, but the object
#                will have to be in every toolbox:
# !
# !                   % kpack -oname object1,object2
# !
#                If you combine the two options the objects specified must
#                be in every toolbox specified.
# !
# !                   % kpack -tb toolbox1,toolbox2 -oname object1,object2
# !
#
#                If -version is specified than the checksum for the files
#                in the object are compared againts that version.  The
#		 checksum for the object under that version by default is
#		 located in
#	{toolbox}/objects/{object type}/{object}/db/{version}/{object}.cksum.
#		 Where {toolbox} is the path to the toolboxes' top directory,
#                {object type} is library, script, kroutine, etc. and {object}
#                is the object name.
#
#                If -dir is specified than the default checksum directory is
#		 changed from {toolbox}/objects/{object type}/{object}/db to
#		 the directory specified.
#
#		 If -cksum is specified than a checksum is preformed on
#		 only those files with the object that are different are
#		 pack'ed.
#
#		 If -packdir is specified than pack will be built in
#		 this directory.  All the temporary files will also be
#		 created there.
#
#		 If -create is specified than the output of kpack will be the
#		 file specified.  If -tb and -oname not specified and a INDEX
#		 file exists in the pack directory a pack is built without
#		 adding anything new.  If no INDEX file exists than a new pack
#		 file is created with all the toolboxes in KHOROS_TOOLBOX.  If
#		 either -tb or -oname specified the pack directory is updated
#		 and than the pack file is built.
#
#		 If -add is specified than the toolbox(es) specified will
#		 be added to the pack directory.
#
#		 If -delete is specified than the toolbox(es) specified will
#		 be deleted from the pack directory.
#
#		 If -info is specified than the pack information is printed
#		 out.  It can be used inconjunction will -create, -add and
#		 -delete.  If used by itself it will just print out the
#		 information and no changes to the pack will occur.
#
#		 If -dtb is specified than those toolbox(es) specified will
#		 be stored in the INDEX file and when the pack is unpacked
#		 those toolbox(es) will be deleted.
#
#		 If -dobject is specified than that toolbox object will
#		 be stored in the INDEX file and when the pack is unpacked
#		 that toolbox object will be deleted.
#
#		 If -clean is specified than the intermediate toolbox tar files
#		 and the INDEX file will be deleted.  This should only be used
#		 with -create is specified.
#
#		 If -force print the klint output but continue without prompting
#
#     Arguments: tb      - toolbox(es) to checksum
#                oname   - object(s) to checksum
#                version - version of checksum
#                dir     - directory containing checksum files
#                cksum   - specify to compare checksum's
#                packdir - directory to build pack in
#                create  - output pack file to create
#                add     - add the toolbox to the pack directory
#                delete  - delete the toolbox from the pack directory
#                info    - give info on the pack
#                dtb     - toolbox(es) to delete when unpacked
#                dobject - toolbox object to delete when unpacked
#                clean   - clean up pack directory after creating pack file
#                force   - print the klint output but continue without prompting
#
#   Exit Status: 1 if failed, 0 on success
#
#      Comments: This routine uses klint to verify to integrity of the object.
#		 It is recommended that if klint fails that the toolbox or
#		 object not be packed.
#    Written By: John M. Salas and Steve Kubica
#          Date: Apr 4, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#========================================================================
@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "stat.pl";

#
# list of directories which we can expect to see in the toplevel of a toolbox
#
%tbdirs = (     'bin',          'executables',
                'data',         'sample data files',
                'examples',     'example programs',
                'help',         'help files',
                'include',      'public includes',
                'lib',          'library files',
                'mach',         'multiple architecture shadow trees',
                'manual',       'toolbox manual(s)',
                'objects',      'objects live in here',
                'repos',        'toolbox file repository',
                'testsuite',    'testsuites for objects in this toolbox'
        );

$whatis         = 'khoros kpack program';
@kpack_args  = (
  '[tb]',      'toolbox1[,toolbox2]', 'name of toolbox(es) [all defined in KHOROS_TOOLBOX]',
  '[oname]',   'oname1[,oname2]',     'name of object(s) [all in the toolbox]',
  '[version]', 'version', 'the version name to checksum [none]',
  '[dir]',     'dir',     'directory containing checksum files [{toolbox}/objects/{object type}/{object}/db]',
  '[cksum]',   '',        'pack up those files whose cksum is different',
  '[packdir]', 'packdir', 'directory to build pack in [.]',
  '[create]',  'file',    'output pack file to create [none]',
  '[add]',     '',        'add the toolbox to the pack directory [default operation]',
  '[delete]',  '',        'delete the toolbox from the pack directory',
  '[info]',    '',        'give info about the pack being built in the pack directory',
  '[dtb]',      'dtoolbox1[,dtoolbox2]', 'toolbox(es) to delete when unpacked [none]',
  '[dobject]',  'toolbox,object',        'toolbox object to delete when unpacked [none]',
  '[clean]',    '', 'clean up pack directory after creating pack file [no]',
  '[force]',    '', 'print the klint output but continue without prompting [no]',
);

#
# Initialize Khoros perl lib
#
&khoros'initialize("SUPPORT",$whatis,@kpack_args);

# parse command line args
&khoros'parse_args(@ARGV);

#
# Save current working directory
#
$cwd = `pwd`;
chop($cwd);

#
# Get tmp directory to store temporary checksum files and tar files
#
$tmpdir = $ENV{'TMPDIR'};
if ($tmpdir eq '')
{
   $tmpdir = "/usr/tmp";
}

$opt_t     = $khoros'seenswitch{"tb"};
$opt_o     = $khoros'seenswitch{"oname"};
$opt_v     = $khoros'seenswitch{"version"};
$opt_d     = $khoros'seenswitch{"dir"};
$opt_pd    = $khoros'seenswitch{"packdir"};
$opt_ck    = $khoros'seenswitch{"cksum"};
$opt_cr    = $khoros'seenswitch{"create"};
$opt_add   = $khoros'seenswitch{"add"};
$opt_del   = $khoros'seenswitch{"delete"};
$opt_info  = $khoros'seenswitch{"info"};
$opt_dtb   = $khoros'seenswitch{"dtb"};
$opt_dobj  = $khoros'seenswitch{"dobject"};
$opt_clean = $khoros'seenswitch{"clean"};
$opt_force = $khoros'seenswitch{"force"};

$tarcmd = "f";
$tarsuf = "tar";

#
# Make sure only one specified -create, -add or -delete.
#
if (($opt_cr && ($opt_add || $opt_del)) ||
    ($opt_add && ($opt_cr || $opt_del)) ||
    ($opt_del && ($opt_add || $opt_cr)))
{
   print "You can on specify one of the following -create file, -add or -delete\n";
   exit(1);
}

#
# If neither of these flags are specified pack all the toolboxes specified
# in the entirety.
#
$wholetb = 0;
if (! $opt_o && ! $opt_ck)
{
   $wholetb = 1;
}


#
# Determine pack directory.  It is also used to store all temporary files
# except for do_klint output.  If not specifed used the current working
# directory.
#
if ($opt_pd)
{
   $packdir = $khoros'argval{"packdir"};
   if (index($packdir,'/') != 0 && index($packdir,'~') != 0)
   {
      $packdir = "$cwd/$packdir";
   }

   $check = 1;

   while ($check)
   {
      $ans = 'Y';

      if (! -e "$packdir")
      {
         print "$packdir does not exist do you want to create it (y/n) [y]? ";
         $ans = <STDIN>;
         chop($ans);
      }
      elsif (! -d "$packdir")
      {
         print "$packdir is not a directory.\n";
         $ans = 'N';
      }

      if ($ans eq 'N' || $ans eq 'n')
      {
         print "Enter new pack directory? ";
         $packdir = <STDIN>;
         if (index($packdir,'/') != 0 && index($packdir,'~') != 0)
         {
            $packdir = "$cwd/$packdir";
         }
      }
      else
      {
         $check = 0;
      }
   }

   if (! -e "$packdir")
   {
      if ( ! mkdir("$packdir", 0777) )
      {
         print "Can not create pack directory $packdir: $!\n";
         exit (1);
      }
   }
}
else
{
   $packdir = $cwd;
}

#
# Update the INDEX file with those toolboxes that are to be delete when
# the pack file is unpacked.
#
if ($opt_dtb)
{
   chdir("$packdir");

   $_ = $khoros'argval{"dtb"};
   tr/,/\ /;
   tr/A-Z/a-z/;
   @dtoolboxes = split(' ', $_);

   if ( -f "INDEX")
   {
      if (! open(INDEX,">>INDEX"))
      {
         print "Can not append to file that contains index: $packdir/INDEX\n";
         exit (1);
      }
   }
   elsif ( ! open(INDEX,">INDEX") )
   {
      print "Can not open file that contains index: $packdir/INDEX\n";
      exit (1);
   }

   foreach $tb (sort(@dtoolboxes))
   {
      print INDEX "$tb::delete:\n";
   }

   close(INDEX);
}

#
# Update the INDEX file with the toolbox object that is to be delete when
# the pack file is unpacked.
#
if ($opt_dobj)
{
   chdir("$packdir");

   $_ = $khoros'argval{"dobject"};

   if ( -f "INDEX")
   {
      if (! open(INDEX,">>INDEX"))
      {
         print "Can not append to file that contains index: $packdir/INDEX\n";
         exit (1);
      }
   }
   elsif ( ! open(INDEX,">INDEX") )
   {
      print "Can not open file that contains index: $packdir/INDEX\n";
      exit (1);
   }

   print INDEX "$_:delete:\n";

   close(INDEX);
}

#
# If just -info specified do and -create, -add or -delete not than just
# print out the info, else print out the info after the other operation
# is done.
#
$dosomething = 1;
if ( $opt_info && ($opt_add || $opt_cr || $opt_del))
{
   print "\n";
   print "-info operation will be done after other operations performed\n";
   print "\n";
}
elsif ($opt_info)
{
   $dosomething = 0;
}

#
# If none specified, add to pack.
#
if (! $opt_info && ! $opt_cr && ! $opt_add && ! $opt_del)
{
   $opt_add = 1;
}

#
# Get the version to checksum against.
#
if ($opt_v)
{
  if (! $opt_ck)
  {
     print "-version specified but not doing checksums, ignoring\n";
     $opt_v = 0;
  }
  else
  {
     $version = $khoros'argval{"version"};
  }
}

#
# Get the directory containing the checksum files if -cksum specified.
#
if ($opt_d)
{
  if (! $opt_ck)
  {
     print "-dir specified but not doing checksums, ignoring\n";
     $opt_d = 0;
  }
  else
  {
     $dir = $khoros'argval{"dir"};
  }
}

#
# If the output file is specified get it and if it is relative to cwd
# pre-append $cwd to it else it is already an absolute.
#
if ($opt_cr)
{
#
# If no toolboxes specified create the pack file as indicated by the INDEX file
# in the pack directory, if the INDEX file exists.
#
   if (! $opt_t && ! $opt_o && -s "$packdir/INDEX")
   {
      $dosomething = 0;
   }

   $file = $khoros'argval{"create"};
   if (index($file,'/') != 0 && index($file,'~') != 0)
   {
      $file = "$packdir/$file";
   }

   $check = 0;

   while ($check)
   {
      $ans = 'Y';

      if (-d "$file")
      {
         print "$file is a directory.\n";
         $ans = 'N';
      }
      elsif (-s "$file")
      {
         print "$file exist do you want to overwrite it (y/n) [y]? ";
         $ans = <STDIN>;
         chop($ans);
      }

      if ($ans eq 'N' || $ans eq 'n')
      {
         print "Enter new output pack file? ";
         $file = <STDIN>;
         if (index($file,'/') != 0 && index($file,'~') != 0)
         {
            $file = "$packdir/$file";
         }
      }
      else
      {
         $check = 1;
      }
   }
}

#
# If -create, -add or -delete specified, then see if -info specified.
#
if ($dosomething)
{
#
# Get the -tb option.  This option allows multiple toolboxes to be specified
# by doing -tb toolbox1,toolbox2.  If not specified all the toolboxes are
# checked.
#
   if ($opt_t)
   {
      $_ = &khoros'get_tb_name;
      tr/,/\ /;
      tr/A-Z/a-z/;
      @toolboxes = split(' ', $_);
      for ( $i = 0 ; ! $opt_del && $i <= $#toolboxes ; $i++ )
      {
         $tbpath = `kecho -tb $toolboxes[$i] -echo path`;
         if ( $? )
         {
             die "toolbox $toolboxes[$i] does not exist\n";
         }
      }
   }
   else
   {
      $_ = `kecho -echo toolboxes`;
      tr/A-Z/a-z/;
      @toolboxes = split(' ', $_);
   }

#
# Create file containing list of toolboxes being packed
#
   if ( ! $opt_del && ! open(INDEX,">$packdir/INDEX.$$") )
   {
      print "Can not open file that contains index: $packdir/INDEX.$$\n";
      exit (1);
   }

#
# Create check sum for each toolbox specified
#
   TOOLBOX: foreach $tb (sort(@toolboxes))
   {
      print "$tb\n";

#
# If -delete specified update the pack directory and then go to the
# next TOOLBOX.
#
      if ($opt_del)
      {
         chdir("$packdir");

         if ( ! open(INDEX,"<INDEX") )
         {
            print "Can not open file that contains index: $packdir/INDEX\n";
            exit (1);
         }

         if ( ! open(INDEXNEW,">INDEXnew.$$") )
         {
            print "Can not open file that contains new index: $packdir/INDEXnew.$$\n";
	    close(INDEX);
            exit (1);
         }

         while(<INDEX>)
         {
	    @line = split(':',$_);
	    if ( $line[0] ne $tb )
	    {
		print INDEXNEW "$_";
	    }
         }

	 if (-f "$tb.$tarsuf")
	 {
            system("rm $tb.$tarsuf");
	 }

         close(INDEX);
         close(INDEXNEW);
         system("mv INDEXnew.$$ INDEX");
	 next TOOLBOX;
      }

      $appendtopack = 0;
      $alreadydone = 0;

#
# Verify that toolbox exists in database
#
      chop($tbpath = `kecho -tb $tb -echo path`);
      unless ( -d $tbpath )
      {
         print "toolbox directory $tbpath does not exist\n";
         next TOOLBOX;
      }

      $tbdir = &determinetbdir("$tbpath");

      chdir("$tbpath");
#
# If entire toolbox not being packed find the objects to pack.
#
      if (! $wholetb)
      {
#
# Get the -oname option.  This option allows multiple objects to be specified
# by doing -oname object1,object2.  If not specified all the objects in the
# toolbox are checked.
#
         if ($opt_o)
         {
            $_ = $khoros'argval{"oname"};
            tr/,/\ /;
            @objects = split(' ', $_);
            for ( $i = 0 ; $i <= $#objects ; $i++ )
            {
               chop($objectpath = `kecho -tb $tb -oname $objects[$i] -echo path`);
               if ( $? )
               {
	           close("INDEX");
	           unlink("$packdir/INDEX.$$");
                   print "object $objects[$i] does not exist in $tb\n";
		   exit(1);
               }
            }
         }
         else
         {
            @objectsck = sort(split(' ',`kecho -tb $tb -echo objects`));
            @objects = sort(&ckobjects("$tbpath/objects"));
            if ( $#objectsck != $#objects ) 
            {
                print "\t>>> The objects in $tb do not match the database.\n\n";
                print "\t>>> Here is what kecho returns:\n\n";
                print "\t>>> @objectsck\n\n";
                print "\t>>> Here are the directories in the toolbox:\n\n";
                print "\t>>> @objects\n\n";
                print "\t>>> Please fix!\n";
                $exit_status = 1;
                next TOOLBOX;
            }
         }

#
# If using checksum's to determine what to pack determine if checksum directory
# exists.
#
	 if ( $opt_d && $opt_ck )
	 {
            if ( ! -d "$dir" )
            {
               print "Failed in accessing $tbdir/$dir: $!\n";
	       close("INDEX");
	       unlink("$packdir/INDEX.$$");
               exit (1);
            }

            if ( $opt_v && ! -d "$dir/$version" )
            {
               print "Failed in accessing $tbdir/$dir/$version: $!\n";
	       close("INDEX");
	       unlink("$packdir/INDEX.$$");
               exit (1);
            }
	 }
#
# Check each object specified
#
         OBJECT: foreach $object (@objects)
         {
            chdir("$tbpath");
            print "     $object\n";

#
# Verify that object exists in database
#
            chop($objectpath = `kecho -tb $tb -oname $object -echo path`);
            if ( $? )
            {
               print "object $object does not exist in $tb\n";
	       close("INDEX");
	       unlink("$packdir/INDEX.$$");
	       if (-f "$packdir/$tb.$tarsuf.$$")
	       {
	          unlink("$packdir/$tb.$tarsuf.$$");
	       }
	       if (-f "$file")
	       {
	          unlink("$file");
	       }
	       exit(1);
            }

	    $tbdir  = &determinetbdir("$tbpath");
	    $objdir = &determineobjdir("$tbdir","$objectpath");

            @filesck = &sortfiles($objdir,split(' ',`kecho -tb $tb -oname $object -echo allfiles`));

	    $type = &determineobjtype("$objectpath");
#
# If checksum'ing requested compare current file checksum's with previous value.
# Otherwise pre-append $tb to all the files in the object so the object can be
# tar'ed up relative to the directory above $tb.
#
	    if ($opt_ck)
	    {
               if ( ! open(SUMOUT,">$tmpdir/cksum.$$") )
               {
                  print "Can not open output object checksum file $tmpdir/cksum.$$\n";
	          close("INDEX");
	          unlink("$packdir/INDEX.$$");
		  if (-f "$packdir/$tb.$tarsuf.$$")
		  {
	             unlink("$packdir/$tb.$tarsuf.$$");
		  }
		  if (-f "$file")
		  {
	             unlink("$file");
		  }
                  exit (1);
               }

	       if ( ! $opt_d )
	       {
		  $tbdir  = &determinetbdir("$tbpath");
		  $objdir = &determineobjdir("$tbdir","$objectpath");
		  $dir    = "$objdir/db";

		  if ( $opt_v && ! -d "$dir/$version" )
		  {
	             close("INDEX");
	             unlink("$packdir/INDEX.$$");
		     if (-f "$packdir/$tb.$tarsuf.$$")
		     {
	                unlink("$packdir/$tb.$tarsuf.$$");
		     }
		     if (-f "$file")
		     {
	                unlink("$file");
		     }
		     exit (1);
		  }
	       }

               for ( $i = 0 ; $i <= $#filesck ; $i++ )
               {

		  next if ( $filesck[$i] eq "$objdir/db/$object.cksum" );

	          if ( ! open(FILE,"<$filesck[$i]") )
                  {
                     print "Can not open object file $filesck[$i] for pack'ing\n";
	             close("SUMOUT");
	             close("INDEX");
	             unlink("$packdir/cksum.$$");
	             unlink("$packdir/INDEX.$$");
		     if (-f "$packdir/$tb.$tarsuf.$$")
		     {
	                unlink("$packdir/$tb.$tarsuf.$$");
		     }
		     if (-f "$file")
		     {
	                unlink("$file");
		     }
                     exit (1);
                  }
#
# Get checksum SYSV style.
#
	          $checksum = 0;
	          while (<FILE>)
	          {
	             $checksum += unpack("%32C*",$_);
	          }
	          $checksum = $checksum % 65535;
#
# Get blocks and size.
#
	          @stats = stat(FILE);
	          $st_size = @stats[$ST_SIZE];
	          $blocks = int($st_size / 512);
	          $blocks++ if ( $blocks );

	          print SUMOUT "$filesck[$i]:$checksum:$blocks:$st_size\n";
	          close(FILE);
               }

#
# Find which files do not have the same checksum.
#
	       close(SUMOUT);

               if ($opt_v)
               {
                  @ckfiles = &find_changed_files("$tbdir","$tmpdir/cksum.$$","$dir/$version/$object.cksum",@removelist);
               }
               elsif (! $opt_v)
               {
                  @ckfiles = &find_changed_files("$tbdir","$tmpdir/cksum.$$","$dir/$object.cksum",@removelist);
               }
               unlink("$tmpdir/cksum.$$");

#
# If there is no previous checksum file tar up the entire object.
#
	       if ($ckfiles[0] eq "failed to open")
	       {
	          @ckfiles = &preappendstring($tbdir,@filesck);
		  $addto = 1;
	       }
            }
	    else
	    {
	       @ckfiles = &preappendstring($tbdir,@filesck);
	    }

	    if($ckfiles[0] eq "")
	    {
	       print "          Nothing to pack for $object.\n";
	       next OBJECT;
	    }

#
#  Use klint to see if the object is consistant with database.
#
	    if (&do_klint($tb, $object, $tmpdir))
	    {
	       $appendtopack = 1;
	    }
	    else
	    {
	       print "Do you wish to abort (y/n) [y] ";
	       $ans = <STDIN>;
	       chop($ans);
	       if ($ans eq 'N' || $ans eq 'n')
	       {
		  print "Ok, but you probably should have.\n";
	          $appendtopack = 1;
	       }
	       else
	       {
	          close("INDEX");
	          unlink("$packdir/INDEX.$$");
	          if (-f "$packdir/$tb.$tarsuf.$$")
	          {
	             unlink("$packdir/$tb.$tarsuf.$$");
	          }
	          if (-f "$file")
	          {
	             unlink("$file");
	          }
	          exit(1);
	       }
	    }

	    if ($appendtopack)
	    {
	       print "          Packing files from $object.\n";
	       chdir("..");
	       if (! $alreadydone && -f "$packdir/$tb.$tarsuf")
	       {
		  system("cp $packdir/$tb.$tarsuf $packdir/$tb.$tarsuf.$$");
		  $alreadydone = 1;
	       }

	       if (-f "$packdir/$tb.$tarsuf.$$")
	       {
	         system("tar -u$tarcmd $packdir/$tb.$tarsuf.$$ @ckfiles");
	       }
	       else
	       {
	          system("tar -c$tarcmd $packdir/$tb.$tarsuf.$$ @ckfiles");
	       }
	       push(@objectsdone,"$object:$type:$addto");
	       $filesinobject{"$object"} = "@ckfiles";
	       $addto = 0;
	    }
	    undef @ckfiles;
         }
      }
      else
      {
#
#  Use klint to see if the object is consistant with database.
#
	 if (&do_klint($tb, "", $tmpdir))
	 {
	    $appendtopack = 1;
	 }
	 else
	 {
	    print "Do you wish to abort (y/n) [y] ";
	    $ans = <STDIN>;
	    chop($ans);
	    if ($ans eq 'N' || $ans eq 'n')
	    {
	       print "Ok, but you probably should have.\n";
	       $appendtopack = 1;
	    }
	    else
	    {
	       close("INDEX");
	       unlink("$packdir/INDEX.$$");
	       if (-f "$packdir/$tb.$tarsuf.$$")
	       {
	          unlink("$packdir/$tb.$tarsuf.$$");
	       }

	       if (-f "$file")
	       {
	          unlink("$file");
	       }
	       exit(1);
	    }
	 }

	 if ($appendtopack)
	 {
	    print "     Packing $tb.\n";
	    chdir("..");
	    system("tar -c$tarcmd $packdir/$tb.$tarsuf.$$ $tbdir");
            print INDEX  "$tb::add:\n";
	 }
      }

      if (! $appendtopack)
      {
	 print "  Nothing packed for $tb.\n";
	 next TOOLBOX;
      }

#
# If klint passes or packing requested anyway, prepare the $tb.tar file
# for packing.
#
      chdir("$packdir");
      system("mv $tb.$tarsuf.$$ $tb.$tarsuf");

#
# Record toolbox packed into INDEX file, along with the objects done, the
# operation (add, delete or replace) object and if replace the files.  If the
# entire toolbox is done @objectsdone will be blank.
#
      foreach $object (@objectsdone)
      {
	 @tmp = split(':',$object);
	 if ($opt_ck)
	 {
	    @list = split(' ',$filesinobject{$tmp[0]});
	    if ( $tmp[2] )
	    {
	       $addto = 0;
               print INDEX  "$tb:$tmp[0]:add:$tmp[1]\n";
	    }
	    else
	    {
	       foreach $f (@list)
	       {
                  print INDEX  "$tb:$tmp[0]:replace:$f\n";
	       }
	    }
	 }
	 else
	 {
            print INDEX  "$tb:$tmp[0]:add:$tmp[1]\n";
	 }

         foreach $f (@removelist)
         {
            print INDEX  "$tb:$tmp[0]:delete:$f\n";
         }
      }
      undef @objectsdone;
      undef @removelist;
      undef @filesinobject;
   }

#
# Update the INDEX file if not -delete not specified.
#
   if(! $opt_del)
   {
      chdir("$packdir");
#
# Append INDEX to end of $file.  If non-zero, i.e. toolboxes have been packed,
# then append else no toolboxes packed so delete $file.
#
      close(INDEX);
      if (-f "INDEX")
      {
         system("cat INDEX.$$ >> INDEX");
	 unlink("INDEX.$$");
      }
      else
      {
         system("mv INDEX.$$ INDEX");
      }
   }
}

#
# Create pack file if -create specifed.
#
if ($opt_cr)
{
   chdir("$packdir");
   if (-s "INDEX")
   {
      system("tar -cf $file INDEX");
      @toolboxes = &findtbs("INDEX");
#
# For sanity.
#
      if ($toolboxes[0] eq "no toolboxes")
      {
	 exit(1);
      }

      foreach $tb (sort(@toolboxes))
      {
#
# First time through use cf all others append to end of tar file.
#
	 system("compress $tb.$tarsuf");
         system("tar -uf $file $tb.$tarsuf.Z");
	 system("uncompress $tb.$tarsuf.Z");

         if ($opt_clean)
         {
            unlink("$packdir/$tb.$tarsuf.Z");
         }
      }
      if ($opt_clean && ! $opt_info)
      {
         unlink("INDEX");
      }
   }
   else
   {
      print "Nothing to pack, no pack file created!\n";
      unlink($file);
   }
}

#
# Print out info for the pack directory.
#
if ($opt_info)
{
   chdir("$packdir");
   &infoindex("INDEX");
   if ($opt_clean)
   {
      unlink("INDEX");
   }
}

chdir("$cwd");
exit($exit_status);

#------------------------------------------------------------------------
#
#  Routine Name: do_klint - does a klint on the object(s) in a toolbox and prompts user to pack or not
#
#       Purpose: To check the integrity of the the object(s) and make sure that
#		 the user wishes to pack if the object is not correct.  If the
#		 the oname is "" than the entire toolbox is klint'ed.
#
#         Input: tb     - toolbox to check
#		 oname  - object to check
#		 tmpdir - temporary directory to store output of klint
#
#       Returns: TRUE if klint passes or user packs anyway, FALSE if it fails
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 6, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub do_klint {

   local($tb)     = @_[0];
   local($oname)  = @_[1];
   local($tmpdir) = @_[2];
   local($kout)   = "$tmpdir/klint.out.$$";

   if ($oname ne "")
   {
      system("klint -tb $tb -oname $oname > $kout");
   }
   else
   {
      system("klint -tb $tb > $kout");
   }

   if ( $? )
   {
      if ($oname ne "")
      {
         print "Problems with toolbox $tb object $oname discovered by klint\n";
      }
      else
      {
         print "Problems with toolbox $tb discovered by klint\n";
      }

      system("cat $kout");
      if ( ! $opt_force )
      {
         print "Do you wish to pack anyway (y/n) [n]? ";
         $ans = <STDIN>;
         chop($ans);
         unlink("$kout");
         if ($ans eq 'Y' || $ans eq 'y')
         {
            return(1);
         }
      }
      else
      {
         return(1);
      }
   }
   else
   {
      unlink("$kout");
      return(1);
   }
   return(0);
}

#------------------------------------------------------------------------
#
#  Routine Name: find_changed_files - determines which files do match the previous checksum for an object
#
#       Purpose: To determine which files in an object do not match the
#		 previous checksum for an object.  It also will pre-append
#		 the toolbox directory to those files that checksum's to
#		 not match.
#
#         Input: tb       - toolbox directory to pre-append
#		 current  - current checksum file for object
#		 previous - previous checksum file for object
#
#       Returns: TRUE if the same, FALSE if different or bad file name
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 4, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub find_changed_files {
   local($tbdir)      = shift;
   local($current)    = shift;
   local($previous)   = shift;
   local(@removelist) = @_;
   local(@files);
   local(%filename1);
   local(%filename2);
   local(%checksum1);
   local(%checksum2);
   local(%blocks1);
   local(%blocks2);
   local(%size1);
   local(%size2);

#
# Open checksum files
#
   if ( ! open(SUMIN1, "<$current") )
   {
      return ("failed to open");
   }

   if ( ! open(SUMIN2, "<$previous") )
   {
      close(SUMIN1);
      return ("failed to open");
   }

#
# Create associate arrays for each field in the checksum file: the filename,
# checksum, blocks and size.
#
   while(<SUMIN1>)
   {
      chop();
      @line = split(':',$_);
      $filename1{$line[0]} = 1;
      $checksum1{$line[0]} = $line[1];
      $blocks1{$line[0]}   = $line[2];
      $size1{$line[0]}     = $line[3];
   }

   while(<SUMIN2>)
   {
      chop();
      @line = split(':',$_);
      $filename2{$line[0]} = 1;
      $checksum2{$line[0]} = $line[1];
      $blocks2{$line[0]}   = $line[2];
      $size2{$line[0]}     = $line[3];
   }

#
# Compare the current filenames with the previous.
#
   foreach $f (keys %filename1)
   {
      if ( ! defined($filename2{$f}) )
      {
	 push(@files,"$tbdir/$f");
      }
      elsif ( $checksum1{$f} != $checksum2{$f} ||
	      $blocks1{$f}   != $blocks2{$f} ||
	      $size1{$f}     != $size2{$f} )
      {
	 push(@files,"$tbdir/$f");
      }
   }

   foreach $f (keys %filename2)
   {
      if ( ! defined($filename1{$f}) )
      {
         push(@removelist,"$tbdir/$f");
      }
   }

   return(@files);
}

#------------------------------------------------------------------------
#
#  Routine Name: preappendstring - will pre-append a string to an arry of strings 
#
#       Purpose: To pre-append a string to an array of strings.
#
#         Input: pre     - string to pre-append
#		 strings - strings to pre-append to
#
#       Returns: strings that have been pre-appended to
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 5, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub preappendstring {

   local($pre)     = shift;
   local(@strings) = @_;
   local(@prestrings);

   foreach $string (@strings)
   {
      push(@prestrings,"$pre/$string");
   }

   return sort(@prestrings);
}
#------------------------------------------------------------------------
#
#  Routine Name: sortfiles - will parse the files passed on and remove the toolbox name
#
#       Purpose: To parse the files passed in and remove the toolbox name.
# !
# !              $KHOROS/objects/scripts/... will become objects/scripts/...
# !
#
#         Input: files - array of files to parse
#
#       Returns: list of parsed files
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Mar 10, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub sortfiles {

   local(@objdir) = shift;
   local(@files) = @_;
   local(@list);
   local($file);

   foreach $file (@files)
   {
      @parsed = split('/',$file);
      shift(@parsed);
      next if ( $parsed[$#parsed] eq 'Makefile' );
      $file = join("/",@parsed);
      push(@list,$file);
   }

#
#  Since kecho does not return the $object/Imakefile, put it on the list.
#
   push(@list,"$objdir/Imakefile");

   return sort(@list);
}


#------------------------------------------------------------------------
#
#  Routine Name: ckobjects - will return all objects found below directory passed in
#
#       Purpose: To check for directories that contain objects below the
#                directory passed in by the calling routine.  ., .., any
#                normal file, special files Makefile and Imakefile and the
#                directory bootstrap are ignored.
#
#         Input: tbpath - directory containing object directories
#
#       Returns: list of objects
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Mar 10, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub ckobjects {

   local($tbpath) = @_;
   local(@objects);

   opendir(OBJECTSDIR,"$tbpath") || die "can not open $tbpath\n";
   foreach $name ( sort readdir(OBJECTSDIR))
   {
      if ( $name ne "."         && $name ne ".."       &&
           $name ne "bootstrap" && -d "$tbpath/$name"  &&
           $name ne "Imakefile" && $name ne "Makefile" )
      {
         push(@objects, &recordobjects("$tbpath/$name"));
      }
   }
   closedir(OBJECTSDIR);
   return @objects;
}

#------------------------------------------------------------------------
#
#  Routine Name: recordobjects - will create an array of every directory in the directory passed in
#
#       Purpose: To create a list of every directory under the one passed
#                in by the calling routine.  Each directory is an object
#                of the toolbox.  ., .., any normal file and special files
#                like Makefile and Imakefile are ignored.
#
#         Input: typepath - directory to search for directories (objects)
#
#       Returns: list of directories (objects)
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Mar 10, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub recordobjects {

   local($typepath) = @_;
   local(@directories);

   opendir(TYPEDIR,$typepath) || die "can not open $typepath\n";
   foreach $name ( sort readdir(TYPEDIR))
   {
      next if ( $name eq '.' );
      next if ( $name eq '..' );
      next if ( $name eq 'Imakefile' );
      next if ( $name eq 'Makefile' );
      if ( -d "$typepath/$name" )
      {
         push(@directories,$name);
      }
   }
   closedir(TYPEDIR);
   return @directories;
}


#------------------------------------------------------------------------
#
#  Routine Name: findtbs - finds the toolboxes in a INDEX file and returns a list of the names
#
#       Purpose: This routine take the filename passed in an finds the
#		 toolboxes contained within and returns a list of them.
#		 It ignores multiple occurences of the toolbox.
#
#         Input: filename - file containing pack index
#
#       Returns: list of toolboxes in index file
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 11, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub findtbs {

   local($filename) = @_;
   local(%list);
   local(@line);
   local(@toolboxes);

   if ( ! open(FILE,"<$filename") )
   {
      print "Can not open file that contains index: $filename\n";
      return ("no toolboxes");
   }

   while(<FILE>)
   {
      @line = split(':',$_);
      if ( ! defined($list{$line[0]}) && $line[2] ne "delete" )
      {
         push(@toolboxes,"$line[0]");
	 $list{$line[0]} = 1;
      }
   }

   return(@toolboxes);
}

#------------------------------------------------------------------------
#
#  Routine Name: infoindex - to print out the information contained in the INDEX file of a pack
#
#       Purpose: This routine takes the filename passed in an prints out
#		 the information contained within.  The file passed in must
#		 be a INDEX file created by kpack.
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 11, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub infoindex {

   local($filename) = @_;
   local(%list);
   local(@line);
   local(@lasttb);
   local(@lastobject);
   local(@toolboxes);

   if ( ! open(FILE,"<$filename") )
   {
      print "Can not open file that contains index: $filename\n";
      return;
   }

   print "Information:\n";
   while(<FILE>)
   {
      @line = split(':',$_);
      if ($line[2] eq "add")
      {
	 if ($line[1] ne "")
	 {
            print "     Adding object \"$line[1]\" to toolbox \"$line[0]\".\n";
	 }
	 else
	 {
            print "     Adding toolbox \"$line[0]\".\n";
	 }
	 $firstline = 1;
      }
      elsif ($line[2] eq "delete")
      {
	 if ($line[1] ne "")
	 {
            print "     Deleting object \"$line[1]\" from toolbox \"$line[0]\".\n";
	 }
	 else
	 {
            print "     Deleting toolbox \"$line[0]\".\n";
	 }
	 $firstline = 1;
      }
      elsif ($line[2] eq "replace")
      {
	 if ($lasttb ne "$line[0]" || $lastobject ne "$line[1]")
	 {
             print "     In object \"$line[1]\" for toolbox \"$line[0]\":\n";
	     $lasttb     = $line[0];
	     $firstline  = 0;
	     $lastobject = $line[1];
	 }
	 chop($line[3]);
         print "          replacing file \"$line[3]\"\n";
      }
      else
      {
	 print "Unknown operation $line[2].\n";
	 $firstline = 1;
      }
   }
   return;
}

#------------------------------------------------------------------------
#
#  Routine Name: determinetbdir - 
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determinetbdir {
   local($tbpath) = @_[0];
   local(@enddir);

   @enddir = split('/',$tbpath);
   
   return("$enddir[$#enddir]");
}

#------------------------------------------------------------------------
#
#  Routine Name: determineobjtype -
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determineobjtype {
   local($objdir)  = @_[0];
   local($dir);

   @dir = split('/',$objdir);

   return("$dir[$#dir - 1]");
}

#------------------------------------------------------------------------
#
#  Routine Name: determineobjdir -
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determineobjdir {
   local($tbdir)   = @_[0];
   local($objdir)  = @_[1];
   local($i)       = 0;
   local($dir);
   local(@returndir);

   @dir = split('/',$objdir);

   while ( "$dir[$i]" ne "$tbdir" )
   {
      $i++;
   }

   $i++;
   while ( $i <= $#dir )
   {
      push(@returndir,$dir[$i]);
      $i++;
   }

   return(join("/",@returndir));
}

