: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

# Khoros: $Id$
# $Log$

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

$whatis	= 'generate dependencies for khoros manual';
@cli_args	=
(
 'target',	'target-file',	'the make target for manual',
 'toplevel',	'top-file',	'the toplevel file of manual',
 's',           'comment',      'comment which marks start of dependencies'
);

# initialize Khoros perl lib
&khoros'initialize("SUPPORT", $whatis, @cli_args);

# parse the command-line arguments
&khoros'parse_args(@ARGV);
$delimiter = $khoros'argval{'s'};

# build associative array which contains toolbox paths
&GetToolboxPaths();


@dependencies = ();
&GenerateDependencies($khoros'argval{'target'}, $khoros'argval{'toplevel'});
&UpdateMakefile();

sub UpdateMakefile
{
   open(MAKEFILE, "< Makefile") || die "Can't read Makefile.\n";
   open(NEW, "> Makefile.$$") || die "Can't write Makefile.$$\n";
   while (<MAKEFILE>)
   {
      last if /^$delimiter/;
      print NEW;
   }
   print NEW "$delimiter\n";
   foreach $dep (@dependencies)
   {
      print NEW "$dep\n";
   }

   close NEW;
   close MAKEFILE;
   rename ("Makefile", "Makefile.bak") && rename("Makefile.$$", "Makefile");
   unlink ("Makefile.bak");
}

sub GenerateDependencies
{
   local($root,$filename) = @_;
   local(*INFILE);
   local($toolbox);
   local($_);


   if ($filename =~ m!\$([^/]+)/(.*)$!)
   {
      $toolbox = "\U$1";
      unless (defined $toolboxPath{"$toolbox"})
      {
         print STDERR "Could not resolve path: $filename ";
         print STDERR "(toolbox \$$toolbox unknown)\n";
         return;
      }
      $filename = "$toolboxPath{$toolbox}/$2";
   }

   push(@dependencies, "$root: $filename") unless $root eq $filename;
   open(INFILE,"< $filename") || do
   {
      warn "kdocdepend: file $filename not found\n";
      return;
   };

   while (<INFILE>)
   {
      &GenerateDependencies($root,$1) if /^\.\s*include\s+(\S+)/;
      &GenerateDependencies($root,$1) if /^\.\s*so\s+(\S+)/;
      &GenerateDependencies($root,$1) if /^\.\s*help\s+\d+\s+(\S+)/;
   }
   close INFILE;
}

sub GetToolboxPaths
{
   return unless defined $ENV{'KHOROS_TOOLBOX'};
   @TBFILES = split(/:/,$ENV{'KHOROS_TOOLBOX'});
   foreach $file (@TBFILES)
   {
      open(TBFILE, "<$file") || next;
      while (<TBFILE>)
      {
         chop;
         ($toolbox, $tbpath) = split(/:/);
         $toolboxPath{$toolbox} = $tbpath;
      }
   }
}

