: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

# Khoros: $Id$
# $Log$

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

$whatis	= 'generate html from khoros manual';
@cli_args	=
(
 'i',           'filename',      'documentation file to convert',
 'o',           'filename',      'file to write output to',
 '[verbose]',   '',              'verbose mode -- tell you what i\'m doing'
);

# initialize Khoros perl lib
&khoros'initialize("SUPPORT", $whatis, @cli_args);

# parse the command-line arguments
&khoros'parse_args(@ARGV);
$outfile = $khoros'argval{'o'};
$verbose = $khoros'seenswitch{'verbose'};

# build associative array which contains toolbox paths
&GetToolboxPaths();

open(OUTFILE, "> $outfile") || die "Can't write to $outfile\n";
select(OUTFILE);

print "\n";
print "<!-- ------------------------------------------------- -->\n";
print "<!-- Automatically converted from Khoros documentation -->\n";
print "<!-- ------------------------------------------------- -->\n";
print "\n";

&Convert($khoros'argval{'i'});
close(OUTFILE);

# ========================================================================
# Function:	Convert()
#
# Purpose:	This is a recursive function which translates documentation
#		written in the khoros roff macros into html.
#		It calls itself to process files included with the
#		.include and .so macros.
# ========================================================================
sub Convert
{
   local($filename) = @_;
   local(*INFILE);
   local($fullpath);
   local($_);
   local($skipping);


   $fullpath = &fullpath($filename);
   return if $fullpath eq '';
   print STDERR "kdoc2html: translating $filename\n" if $verbose;
   $skipping = 0;

   open(INFILE,"< $filename") || return;
   while (<INFILE>)
   {
      &Convert($1),next if /^\.\s*include\s+(\S+)/;
      &Convert($1),next if /^\.\s*so\s+(\S+)/;

      # === ignore any point-size changes =========================
      s/\\s[+-]\d+//g;
      s/\\s\d+//g;

      # ==== font changes =========================================
      s/\\fI([^\\]+)\\fP/<I>$1<\/I>/g;
      s/\\fB([^\\]+)\\fP/<B>$1<\/B>/g;
      s/\\fH([^\\]+)\\fP/<B>$1<\/B>/g;
      s/\\f\(CW([^\\]+)\\fP/<TT>$1<\/TT>/g;

      # ==== any font changes we missed ===========================
      s/\\f[IPBH]//g;
      s/\\f\(CW//g;

      # ====== don't do anything with .glossary macro just yet ====
      next if /^\.\s*glossary/;

      # ====== postscript figure ==================================
      # create an anchor to the postscript file
      # ===========================================================
      if (/^\.\s*PSPIC\s+(\S+)/)
      {
         print "<P>\n";
         print "<BLOCKQUOTE>\n";
         print "Click ";
         print "<A HREF=\"$1\"> here </A> to view postscript figure\n";
         print "</BLOCKQUOTE>\n";
         print "<P>\n";
         next;
      }

      if (/^\.TS/)
      {
         print STDERR "Ignoring table\n" if $verbose;
         $skipping = 1;
         next;
      }

      ($skipping = 0),next if /^\.TE/;

      next if $skipping;

      #======= .paragraph ===========================================
      (print "<P>\n"),next if /^\.\s*paragraph/;

      #======= .section ===========================================
      # perhaps we should increment the level, and reserve H1
      # for the chapter heading?
      #============================================================
      /^\.\s*section\s+(\d+)\s+"([^"]+)"/ && do
      {
         print "<H$1> $2 </H$1>\n";
         next;
      };

      /^\.\s*section\s+(\d+)\s+(\S+)/ && do
      {
         print "<H$1> $2 </H$1>\n";
         next;
      };

      # ======= skip comments (could format them in html :-) ====
      next if /^\s*\\"/;
      next if /^\.\s*\\"/;

      #======= .begin ===========================================
      /^\.\s*begin\s+(\S+)\s*(\S*)\s*$/ && do
      {
         $environment = $1;
         $envargs     = $2;
         push(@environments, $environment);
         if ($environment eq 'tagged')
         {
            print "<BLOCKQUOTE>\n";
            print "<DL>\n";
         }
         elsif ($environment eq 'itemize')
         {
            print "<UL>\n";
         }
         elsif ($environment eq 'code')
         {
            print "<BLOCKQUOTE>\n";
            print "<CODE>\n";
            print "<PRE>\n";
         }
         elsif ($environment eq 'enumerate')
         {
            print "<OL>\n";
         }
         elsif ($environment eq 'caption')
         {
            print "<HR>\n";
            if ($2 eq 'figure')
            {
               ++$figure;
               print "<B> Figure $figure: </B>\n";
            }
            elsif ($2 eq 'table')
            {
               ++$table;
               print "<B> Table $table: </B>\n";
            }
         }
         next;
      };

      #======= .end ===========================================
      if (/^\.\s*end\s*$/ || /^\.\s*end\s+\S+/)
      {
         $environment = pop(@environments);
         if ($environment eq 'tagged')
         {
            print "</DL>\n";
            print "</BLOCKQUOTE>\n";
         }
         elsif ($environment eq 'itemize')
         {
            print "</UL>\n";
         }
         elsif ($environment eq 'code')
         {
            print "</PRE>\n";
            print "</CODE>\n";
            print "</BLOCKQUOTE>\n";
         }
         elsif ($environment eq 'enumerate')
         {
            print "</OL>\n";
         }
         elsif ($environment eq 'caption')
         {
            print "<HR>\n";
         }
         else
         {
            print STDERR "Unexpected .end seen: $environment\n";
         }
         next;
      };

      /^\.\s*item\s*(.*)$/ && do
      {
         $environment = $environments[$#environments];
         if ($environment eq 'tagged')
         {
            $item = $1;
            $item =~ s/^\s*"(.*)"\s*$/$1/;
            print "<DT> <B> $item </B>\n";
            print "<DD>\n";
         }
         elsif ($environment =~ /(itemize|enumerate)/)
         {
            print "<LI>\n";
         }
         next;
      };

      (print "<BLOCKQUOTE>\n"),next if /^\.\s*RS/;
      (print "</BLOCKQUOTE>\n"),next if /^\.\s*RE/;

      if (/^\.\s*(\S+)/)
      {
         print STDERR "ignoring \"$1\" macro\n" if $verbose;
         next;
      };

      print;
   }
   close(INFILE);
}

# ========================================================================
# Function:	fullpath()
#
# Purpose:	Resolve a path, expanding out any leading toolbox references.
# ========================================================================
sub fullpath
{
   local($path) = @_;
   local($toolbox);

   print STDERR "Expanding: $path\n" if $verbose;
   if ($path =~ m!\$([^/]+)/(.*)$!)
   {
      $toolbox = "\U$1";
      unless (defined $toolboxPath{"$toolbox"})
      {
         print STDERR "Could not resolve path: $path ";
         print STDERR "(toolbox \$$toolbox unknown)\n";
         return '';
      }
      $path = "$toolboxPath{$toolbox}/$2";
   }

   return $path;
}

# ========================================================================
# Function:	GetToolboxPaths()
#
# Purpose:	Build an associative array %toolboxPath, indexed on toolbox
#		name, which holds the fullpath to the top of the toolbox.
# ========================================================================
sub GetToolboxPaths
{
   return unless defined $ENV{'KHOROS_TOOLBOX'};
   @TBFILES = split(/:/,$ENV{'KHOROS_TOOLBOX'});
   foreach $file (@TBFILES)
   {
      open(TBFILE, "<$file") || next;
      while (<TBFILE>)
      {
         chop;
         ($toolbox, $tbpath) = split(/:/);
         $toolboxPath{$toolbox} = $tbpath;
      }
   }
}
