#!/usr/local/gnu/bin/perl
# eval 'exec perl -S $0 $*'
#                if $runnning_under_some_shell;

#========================================================================
# Program Name: kattrtable - no short description specified
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.


if (! defined $ENV{'KHOROS_TOOLBOX'})
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
foreach $toolbox_file (sort split(/:/, $ENV{'KHOROS_TOOLBOX'}))
{
   open(TBS,"<$toolbox_file") || do
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die "KHOROS_TOOLBOX environment variable points to existing files.\n";
   };

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}


@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

$whatis = 'no short description specified';
@clui_args  = (
 '[tb]',     'toolbox',      'name of toolbox',
 '[oname]',  'object-name',  'name of software object',
 'ttype',    'table-type',   'type of table to generate',
 '[t]',      'filename',     'work from a table description file',
 '[cat]',    'category',     'only include attributes of given category',
 '[title]',  'string',       'title string for the table',
 '[i]',      'filename',     'the source file to generate from',
 '[o]',      'filename',     'the output file for the generated table'
);

# ------------------------------------------------------------------------
# table description language to generate
# ------------------------------------------------------------------------
$language = 'tbl';

chop($VERSION = `kecho -tb support -oname kattrtable -echo version`);
chop($DATE = `date`);

# ------------------------------------------------------------------------
# Arrays of legal fields for each type of table
# ------------------------------------------------------------------------

@xv_fields =
   (
    'Attribute', 'Description', 'Type', 'Default', 'Legal Values', 'Resource'
    );

@kcms_fields =
   (
    'Attribute', 'Description', 'Type', 'Default', 'Legal Values',
    'Access', 'Persistence', 'List Type'
    );

@ds_fields =
   (
    'Attribute', 'Type', 'Default', 'Category', 'Legal Values',
    'Description', 'Access', 'Persistence', 'List Type'    
    );

# initialize Khoros perl lib
&khoros'initialize("SUPPORT",$whatis,@clui_args);

&khoros'parse_args(@ARGV);                   # parse the command-line
$tableType = $khoros'argval{'ttype'};        # '

if ($tableType eq 'kcms')
{
    *legal_fields = *kcms_fields;
}
elsif ($tableType eq 'dataserv')
{
    *legal_fields = *ds_fields;
}
elsif ($tableType =~ /^xv(|info|description)$/)
{
    *legal_fields = *ds_fields;
}
$validRE = join('|', @legal_fields);

if ($khoros'seenswitch{'t'})
{
   &ProcessTableFile($khoros'argval{'t'});
   exit 0;
}

if ($khoros'seenswitch{'title'} && $khoros'seenswitch{'i'} &&
    $khoros'seenswitch{'o'})
{
   &GenerateTable($khoros'argval{'i'},
                  $khoros'argval{'o'},
                  $khoros'argval{'title'});
}

# ========================================================================
# Function Name: ParseIncludeFile() - parse include and build assoc arrays
# Purpose:       This function generates the closing part of the table.
#                This function should eventually put a caption on the
#                table...
# ========================================================================
sub ParseIncludeFile
{
   local($filename) = @_;
   local($fullpath);
   local(*INFILE);


   undef @attributes;
   undef %Type;
   undef %ListType;
   undef %Default;
   undef %LegalValues;
   undef %Description;
   undef %Persistence;
   $HEADER = $filename;
   $fullpath = &khoros'fullpath($filename);

   open(INFILE, "< $fullpath") || die "Can't read input file $filename: $!\n";
   $number = 0;
   $inblock = 0;
   while (<INFILE>)
   {
      #-- start of a comment block? -------------------------------------
      if (m!^/\*-+\s*$! && $inblock == 0)
      {
	 $inblock       = 1;
	 $inattrblock   = 0;
	 $indescription = 0;
	 $description   = '';
	 next;
      }
      
      #-- end of a comment block? ---------------------------------------
      if (m!^-+\*/\s*$! && $inblock == 1)
      {
	 $inblock       = 0;
	 $indescription = 0;
	 $inattrblock   = 0;
	 next;
      }

      if (/^\|\s*([A-Za-z ]+):\s*(.*)\s*$/
	  && ($field = $1)
	  && ($value = "$2 ")
	  && $field =~ /($validRE)/i)
      {
	 $value =~ s/\\/\\\\/g;
	 $value =~ s/("|\$)/\\$1/g;
         $value =~ s/(.*)\s+$/$1/g;
	 $value = &expandRoff($value);
	 if ($field eq 'Attribute' && $inblock)
	 {
	    $attribute = $value;
	    $inattrblock = 1;
	    push(@attributes, $attribute);
	 }
	 else
	 {
	    next unless $inattrblock;
	    die "Field \"$field\" seen on line $., but no Attribute: seen.\n"
	       unless defined $attribute;
	    ($assoc = $field) =~ s/\s+//g;
	    $ref = "\$$assoc"."{'$attribute'}";
	    eval "$ref = \"$value\\n\".\"\"";

	 }

	 next;
      }

      next unless $inattrblock;

      if (/^\|\t\t(.*)\s*$/)
      {
	 ($value = $1) =~ s/\\/\\\\/g;
	 $value =~ s/("|\$)/\\$1/g;
         $value = &expandRoff($value);
	 eval "$ref .= \"$value\\n\"";
	 next;
      }

      if (/^\| {15}(.*)\s*$/)
      {
	 ($value = $1) =~ s/\\/\\\\/g;
	 $value =~ s/("|\$)/\\$1/g;
         $value = &expandRoff($value);
	 eval "$ref .= \"$value\\n\"";
	 next;
      }
   }

   close INFILE;

   @attributes = sort @attributes;
}

# ========================================================================
# Function Name: GenerateBody() - generate body of table
# Purpose:       This function generates the closing part of the table.
#                This function should eventually put a caption on the
#                table...
# ========================================================================
sub GenerateBody
{
   ATTRIBUTE: foreach $attribute (@attributes)
   {
      if ($khoros'seenswitch{'cat'}) #'
      {
	 if (!defined $Category{$attribute})
	 {
	    warn "Attribute `$attribute' does not have a category defined\n";
	    next ATTRIBUTE;
	 }
         next ATTRIBUTE if $Category{$attribute} !~ /^$khoros'argval{'cat'}$/i;
      }
      &GenerateTableEntry($attribute);
      print "_\n" if $attribute ne $attributes[$#attributes];
   }
}

# ========================================================================
# Function Name: GenerateTableEntry() - generate one entry in table
# Purpose:       This function generates the closing part of the table.
#                This function should eventually put a caption on the
#                table...
# ========================================================================
sub GenerateTableEntry
{
   local($attribute) = @_;


   if ($tableType eq 'kcms')
   {
      ++$number;
      print "T{\n";
      print ".symbol definitive $attribute\n";
      print "T}:T{\n";
      print ".nf\n";
      if (defined $LegalValues{$attribute})
      {
	 print "$Type{$attribute}";
	 print "  $ListType{$attribute}" if defined $ListType{$attribute};
	 print "\n";
	 print "$LegalValues{$attribute}";
      }
      else
      {
	 print "$Type{$attribute}";
	 print "  $ListType{$attribute}" if defined $ListType{$attribute};
      }
      print ".fi\n";
      print "T}:T{\n";
      print ".na\n";
      print "$Description{$attribute}";
      print ".ad\n";
      print "T}\n";
      print "::_\n";
      print "::T{\n";
      print ".nf\n";
      print "\\fBAccess: \\fP $Access{$attribute}";
      print "\\fBPersistence: \\fP $Persistence{$attribute}";
      print ".fi\n";
      print "T}\n";
   }
   elsif ($tableType eq 'xvinfo')
   {
      print "T{\n";
      print ".symbol definitive $attribute\n";
      if (defined $Resource{$attribute})
      {
	 print ".br\n";
	 print "(\n";
	 print ".symbol definitive ",$Resource{$attribute};
	 print ")\n";
      }

      print "T}:T{\n";

      #-- the Type: field - multiple values? ----------------------------
      print "$Type{$attribute}" if defined $Type{$attribute};
      print "T}:T{\n";
      print "$Default{$attribute}" if defined $Default{$attribute};
      print "T}:T{\n";
      if (defined $LegalValues{$attribute})
      {
	 @lines = split(/\n/, $LegalValues{$attribute});
	 @symbols = grep(/^\.symbol/, @lines);
	 if (int(@symbols) == int(@lines))
	 {
	    print ".nf\n";
	    print "$LegalValues{$attribute}";
	    print ".fi\n";
	 }
	 else
	 {
	    print ".na\n";
	    print "$LegalValues{$attribute}";
	    print ".ad\n";
	 }
      }
      print "T}\n";
   }
   elsif ($tableType eq 'xvdescription')
   {
      print "T{\n";
      print ".symbol definitive $attribute\n";
      print "T}:T{\n";
      print ".na\n";
      print "$Description{$attribute}" if defined $Description{$attribute};
      print ".ad\n";
      print "T}\n";
   }
   elsif ($tableType eq 'dataserv')
   {
      print "T{\n";
      print ".nf\n";
      print ".symbol definitive $attribute\n";
      print "\n";

      #-- type and suggested variable names -----------------------------
      if ($Type{$attribute} =~ /,/)
      {
	 chop($Type{$attribute});
	 @scoop = split(/,\s*/,$Type{$attribute});
	 ($type,$first) = ($scoop[0] =~ m|(.*)\s+(\S+)|);
	 shift(@scoop);
	 @scoop = ($first, @scoop);
	 if ($Default{$attribute} =~ /^\s*$/)
	 {
	    @defs = ();
	 }
	 else
	 {
	    @defs = split(/,\s*/,$Default{$attribute});
	 }
	 if (int(@scoop) != int(@defs) && @defs != 0)
	 {
	    print STDERR "Number of defaults (", int(@defs), ") does not ";
	    print STDERR "match number of arguments (", int(@scoop), ",\n";
	    print STDERR "    for attribute $attribute\n";
	 }
	 print "$type\n";

	 while (@scoop > 0)
	 {
	    $type = shift(@scoop);
	    if (@defs > 0)
	    {
	       $def = shift(@defs);
	       #-- printf("  %-14s  %s\n",$type,$def);
	       printf("  %-14s  %s\n",$type,$def);
	    }
	    else
	    {
	       print " $type\n";
	    }
	 }
      }
      else
      {
         #-- ($type, $name) = ($Type{$attribute} =~ m|(.*)\s*\b([A-Za-z_]+)$|);
	 #-- needed to make this cope with names such as rotate[3]

         #-- ($type, $name) = ($Type{$attribute} =~ m|(.*)\s*\b([A-Za-z_]+)$|);
	 ($type, $name) = ($Type{$attribute} =~ m|(.*)\s*\b([A-Za-z_]+(\[[0-9]+\])?)$|);
	 print "$type\n";
	 print " $name   $Default{$attribute}\n";
      }
      print ".fi\n";

      print "T}:T{\n";

      print ".nf\n";
      print "$LegalValues{$attribute}" if defined $LegalValues{$attribute};
      print ".fi\n";
      print "T}:T{\n";
	   
      if (defined $Description{$attribute})
      {
	 $description = $Description{$attribute};
      }
      elsif (defined $SameAs{$attribute})
      {
	 $sameas = $SameAs{$attribute};
	 eval "\$description = \$Description{$sameas}";
      }
      else
      {
	 $description = "\n";
      }
      print ".na\n";
      print "$description";
      print ".ad\n";
	   
      print "T}\n";
      print "::_\n";
	   
      print "::T{\n\\fBPersistence:\\fP ";
      if (defined $Persistence{$attribute})
      {
	 print "$Persistence{$attribute}";
      }
      else
      {
	 print "\n";
      }
      print "T}\n";
   }
}

# ========================================================================
# Function Name: GenerateHeader - generate the top of the tbl table
# Purpose:       This function generates the top of the table.
# ========================================================================
sub GenerateHeader
{
   local($title) = @_;


   # --------------------------------------------------------------------
   # Standard comment block for all generated tables
   # --------------------------------------------------------------------
   print ".\\\" -- Generated Table ------------------------------------\n";
   print ".\\\" Generated by: kattrtable version $VERSION\n";
   print ".\\\" Description:  Attribute information table\n";
   print ".\\\" Table type:   $tableType\n";
   print ".\\\" Source:       $HEADER\n";
   print ".\\\" Date:         $DATE\n";
   print ".\\\" -- start of table header ------------------------------\n";
   print ".TS H\n";
   print "center box tab(:) ;\n";

   if ($tableType eq 'kcms')
   {
      print "cfB s s\n";
      print "cf(B)p10 | cf(B)p10 | cf(B)p10\n";
      print "lp8w(1.8i) | lp6f(CW)w(1.3i) | lp9w(3.0i) .\n";
      print ".sp .5\n";
      print "$title\n";
      print ".sp .5\n";
      print "_\n";
      print "Attribute:Type:Description\n";
   }
   elsif ($tableType eq 'dataserv')
   {
      print "cfB s s\n";
      print "cf(B)p10w(1.7i) | cf(B)p10w(1.3i) | cf(B)p10w(3.0i)\n";
      print "cf(B)p10w(1.7i) | cf(B)p10w(1.3i) | cf(B)p10w(3.0i)\n";
      print "lp9f(CW)p9w(1.7i) | lp7f(CW)w(1.3i) | lp9w(3.0i) .\n";
      print ".sp .5\n";
      print "$title\n";
      print ".sp .5\n";
      print "_\n";
      print "Attribute:Legal:Definition\n";
      print "and Default:Values:\n";
   }
   elsif ($tableType eq 'xvinfo')
   {
      print "cfB s s s\n";
      print "cf(B)p10 | cf(B)p10 | cf(B)p10 | cf(B)p10\n";
      print "cf(B)p10 | cf(B)p10 | cf(B)p10 | cf(B)p10\n";
      print "lp8w(2.0i) | lp7f(CW)w(0.7i) | lp7f(CW)w(1.1i) | lp8w(1.9i) .\n";
      print ".sp .5\n";
      print "$title\n";
      print ".sp .5\n";
      print "_\n";
      print "Attribute:Type:Default:Legal\n";
      print "(Resource Name):::Values\n";
   }
   elsif ($tableType eq 'xvdescription')
   {
      print "cfB s\n";
      print "cf(B)p10 | cf(B)p10\n";
      print "lp9w(2.6i) | lp9w(3.6i) .\n";
      print ".sp .5\n";
      print "$title\n";
      print ".sp .5\n";
      print "_\n";
      print "Attribute:Description\n";
   }

   # --------------------------------------------------------------------
   # Standard block at end of header for all generated tables
   # --------------------------------------------------------------------
   print "=\n";
   print ".TH\n";
   print ".\\\" -- end of table header --------------------------------\n";
}

# ========================================================================
# Function Name: GenerateFooter - generate the end of the tbl table
# Purpose:       This function generates the closing part of the table.
#                This function should eventually put a caption on the
#                table...
# ========================================================================
sub GenerateFooter
{
   print ".TE\n";
}

# ========================================================================
# Function Name: ProcessTableFile() - handle -t command-line switch
# Purpose:       This function generates the closing part of the table.
#                This function should eventually put a caption on the
#                table...
# ========================================================================
sub ProcessTableFile
{
   local($filename) = @_;
   select(*TABLEFILE);
   local(@fields);


   open(TABLEFILE, "< $filename") || die "Can't read $filename: $!\n";
   print STDERR "Generating tables:\n";
   undef @fields;
   while (<TABLEFILE>)
   {
      next if /^\s*$/;			     # ignore blank lines
      chop;
      s/^\s+//;
      s/\s+$//;
      push(@fields, $_);

      #-- if we have three fields, then generate a table -----------------
      if ($tableType =~ /^(kcms|dataserv|xvinfo|xvdescription)$/)
      {
	 if (@fields == 3)
	 {
	    print STDERR "    $fields[0]\n";
	    &ParseIncludeFile($fields[0]);
	    &GenerateTable(@fields);
	    undef @fields;
	 }
      }
      elsif ($tableType eq 'xv')
      {
	 if (@fields == 5)
	 {
	    print STDERR "    $fields[0]\n";
	    &ParseIncludeFile($fields[0]);

	    $tableType = 'xvinfo';
	    &GenerateTable($fields[0], $fields[1], $fields[2]);

	    $tableType = 'xvdescription';
	    &GenerateTable($fields[0], $fields[3], $fields[4]);
	    undef @fields;

	    $tableType = 'xv';
	 }
      }
   }
   die "Malformed table file -- incorrect number of lines\n" if @fields != 0;
}

# ========================================================================
# Function Name: GenerateTable() - generate a table from include file
# Purpose:       This function generates the closing part of the table.
#                This function should eventually put a caption on the
#                table...
# ========================================================================
sub GenerateTable
{
   local($include, $outfile, $title) = @_;
   local(*TABLE);
   local($oldfh);


   open(TABLE, "> $outfile") || die "Can't write to $outfile: $!\n";
   $oldfh = select(TABLE);

   &GenerateHeader($title);
   &GenerateBody();
   &GenerateFooter();

   select($oldfh);
}

sub expandRoff
{
   local($line) = @_;

   $line =~ s/^\s*\.begin code/.nf\n\\\\f(CW\\\\s-2/;
   $line =~ s/^\s*\.end code/\\\\fP\\\\s+2\n.fi/;

   return $line;
}
