 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgrepobj.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgrepobj_get_args
| 
|       Purpose: Gets command line args for kgrepobj
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgrepobj
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgrepobj_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgrepobj is out of sync with arguments specified in kgrepobj's *.pane file; please rerun ghostwriter on kgrepobj.";


	/*
	 * allocate the kgrepobj structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kgrepobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "kgrepobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "type",
			  &(clui_info->type_string),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kgrepobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "function",
			  &(clui_info->function_string),
			  &(clui_info->function_flag))))
	{
	    kerror(NULL, "kgrepobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "string",
			  &(clui_info->string_string),
			  &(clui_info->string_flag))))
	{
	    kerror(NULL, "kgrepobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "routine",
			  &(clui_info->routine_string),
			  &(clui_info->routine_flag))))
	{
	    kerror(NULL, "kgrepobj_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



