 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kfindobj
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kfindobj.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - search for software objects in toolboxes
|
|       Purpose: main program for kfindobj
|
|         Input:
|		char *clui_info->tb_string; {Toolbox to search}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {Software object name}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		char *clui_info->type_string; {Software object type}
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	klist	*list;
	kobject	toolbox, program;
	int	i, tb_num, token;
	char	*path, **toolboxes;
	int	reqtype = KCMS_KROUTINE,otype;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "SUPPORT");
	kexit_handler(kfindobj_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "SUPPORT", "kfindobj",
		kfindobj_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kfindobj_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if (clui_info->type_string != NULL)
	   reqtype = kcms_attr_string2int(KCMS_CMOBJ_TYPE,
					  clui_info->type_string);
	
	if (clui_info->tb_string != NULL)
	{
	   toolboxes = (char **) karray_add(NULL, clui_info->tb_string, 0);
	   tb_num = 1;
	}
	else if ((toolboxes = kcms_query_toolboxes(&tb_num)) == NULL)
	{
	   kinfo(KSTANDARD, "Warning: No toolboxes accessable in which to \
search for object '%s'", clui_info->oname_string);
	   kexit(KEXIT_FAILURE);
	}
	kinfo(KSTANDARD,"\n");
	kinfo(KSTANDARD,"   Toolbox     Object         Path");
	kinfo(KSTANDARD,"----------------------------------------------------");
/* -main_before_lib_call_end */

/* -main_library_call */
	for (i = 0; i < tb_num; i++)
	{
	   if ((toolbox = kcms_open_toolbox(toolboxes[i])) == NULL)
	   {
	      kinfo(KSTANDARD, "Warning: Cannot open toolbox object '%s'\n",
			toolboxes[i]);
	      continue;
	   }

	   kcms_get_attribute(toolbox, KCMS_TB_SOFTWARE_OBJECTS, &list);
	   if (clui_info->oname_string)
	   {
	      token = kstring_to_token(clui_info->oname_string);
	      if ((list = klist_locate(list, (kaddr) token)) != NULL)
	      {
		 program = klist_clientdata(list);
		 kcms_get_attribute(program, KCMS_CMOBJ_PROGTYPE, &otype);
		 kcms_get_attribute(program, KCMS_CMOBJ_TOPSRC, &path);
		 if (!clui_info->type_string || reqtype == otype)
		    kinfo(KSTANDARD, "%10s %10s   %s", toolboxes[i],
			clui_info->oname_string, path);
	      }
	   }
	   else
	   {
	      while (list != NULL)
	      {
	         program = klist_clientdata(list);
	         kcms_get_attribute(program, KCMS_CMOBJ_TOPSRC, &path);
		 kcms_get_attribute(program, KCMS_CMOBJ_PROGTYPE, &otype);
		 if (!clui_info->type_string || reqtype == otype)
	            kinfo(KSTANDARD, "%10s %10s   %s", toolboxes[i],
			ktoken_to_string((int) list->identifier), path);
		 list = klist_next(list);
	      }
	   }
	   kcms_close(toolbox);
	}
	kfree(toolboxes);
/* -main_library_call_end */

/* -main_after_lib_call */
	kinfo(KSTANDARD,"\n");
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kfindobj_usage_additions
| 
|       Purpose: Prints usage additions in kfindobj_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kfindobj
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kfindobj_usage_additions(void)
{
	kfprintf(kstderr, "\tsearch for software objects in toolboxes\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kfindobj_free_args
| 
|       Purpose: Frees CLUI struct allocated in kfindobj_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kfindobj
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kfindobj_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
	kfree(clui_info->type_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
