 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "uisupdate.h"

/*-----------------------------------------------------------
| 
|  Routine Name: update_uis
| 
|       Purpose: Updates the UIS file
| 
|         Input: filename - old UIS file to be updated
|        Output: 
|       Returns: TRUE on success, FALSE on failure
|    Written By: Danielle Argiro
|          Date: May 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
static int use_count PROTO((int, int *, int));

int update_uis(
    char *filename,
    int  force)
{
	char  temp[KLENGTH];
	char  *startsubform_line, *startpane_line;
	int   *filename_lookup, *linenum_lookup;
	char  **database, **filenames;
	int   flag, i, line_num; 
	int   last_subform_index = 0, last_guide_index = 0;
	int   db_size = 0, filecount = 0, blank_count = 0, help_count = 0;
	int   doing_toggle = 0, toggle_count = 0, toggle_def = 0, var_count;
	int   var_token; 
	int   used_subform_var_count = 0, clean_lines = TRUE;
	int   *used_subform_vars;

	kform     *form;
	kfile     *infile;
	Line_Info line_info, tmp_line_info;

	if ((infile = kfopen(filename, "r")) == NULL)
        {
            kerror(NULL, "update_uis", 
		   "Unable to open '%s' to read UIS", temp);
            return(FALSE);
        }
	filenames = (char **) kcalloc(1,sizeof(char *));
        filenames[0] = kstring_copy(filename, NULL);
        filecount = 0;
        database = kvf_read_database(infile, &line_num, &db_size,
                        &filename_lookup, &linenum_lookup,
                        &filenames, &filecount);

        if (database == NULL)
	    return(FALSE);

        kfclose(infile);

	if (kstrcmp(database[0], 
		    "# Khoros Image Processing System Workspace") == 0)
	    clean_lines = FALSE;

	if ((used_subform_vars = (int *) kmalloc(sizeof(int))) == NULL)
        {
	    kerror("uisupdate", "update_uis",
                   "Can't alloc array of used subform names -- updated UIS \
file may contain subform button lines with identical variable names that will \
have to be modified by hand.");
        }

	kvf_clear_line_info(&line_info);

	for (i = 0; i < line_num; i++)
	{
	     flag = kvf_get_line_type(database[i]);
	     switch(flag)
	     {
		case KUIS_STARTFORM: 
		     if (!(kvf_oldparse_startform_line(database[i], 
				&line_info))) 
			return(FALSE);
		     line_info.width  = 20.0;
		     line_info.height = 5.0;
		     kvf_deparse_startform_line(&line_info, &database[i]);
		     break;

		case KUIS_STARTSUBFORM: 
		     if (!(kvf_oldparse_startsubform_line(database[i], 
				&line_info))) 
			return(FALSE);
		     line_info.width  = 20.0;
		     line_info.height = 5.0;
		     kvf_deparse_startsubform_line(&line_info, &database[i]);
		     break;

		case KUIS_PSEUDOSUBFORM: 
		     if (!(kvf_oldparse_psuedosubform_line(database[i], 
				&line_info))) 
			return(FALSE);
		     kvf_deparse_subformbutton_line(&line_info, &database[i]);
		     break;

		case KUIS_STARTPANE: 
		     if (!(kvf_oldparse_startpane_line(database[i], 
				&line_info))) 
			return(FALSE);
		     line_info.selected = FALSE;
		     kvf_deparse_startpane_line(&line_info, &database[i]);
		     break;

		case KUIS_BLANK: 
		     kfree(line_info.variable);
		     if (kvf_oldparse_blank_line(database[i], &line_info))
		     {
		         ksprintf(temp, "blank%d", blank_count++);
		         if (line_info.variable == NULL)
		             line_info.variable = kstring_copy(temp, NULL);
		         kvf_deparse_blank_line(&line_info, &database[i]);
		         kvf_free_line_info_strings(&line_info);
		     }
		     else
		     {
			kerror(NULL, "update_uis",
			       "Unable to update Blank on line %d of %s",
			       linenum_lookup[i], 
			       filenames[filename_lookup[i]]); 
		     }
		     break;

		case KUIS_HELP: 
		     kfree(line_info.variable);
		     if (kvf_oldparse_help_line(database[i], &line_info))
		     {
			 if (help_count == 0)
		             ksprintf(temp, "help", help_count++);
		         else ksprintf(temp, "help%d", help_count++);
		         if (line_info.variable == NULL)
		             line_info.variable = kstring_copy(temp, NULL);
			 line_info.height = 1.0;
			 line_info.width  = (float) (kstrlen(line_info.title)+2.0);
		         kvf_deparse_help_line(&line_info, &database[i]);
		         kvf_free_line_info_strings(&line_info);
		     }
		     else
		     {
			kerror(NULL, "update_uis",
			       "Unable to update Help on line %d of %s",
			       linenum_lookup[i], 
			       filenames[filename_lookup[i]]); 
		     }
		     break;

		case KUIS_QUIT:
		     if (kvf_oldparse_quit_line(database[i], &line_info))
                     {
                         line_info.height = 1.0;
                         line_info.width  = 6.0;
                         kvf_deparse_quit_line(&line_info, &database[i]);
                         kvf_free_line_info_strings(&line_info);
                     }
                     else
                     {
                        kerror(NULL, "update_uis",
                               "Unable to update Quit on line %d of %s",
                               linenum_lookup[i],
                               filenames[filename_lookup[i]]);
                     }
		     break;


		case KUIS_TOGGLE:
		     doing_toggle = TRUE;
		     toggle_count = 0;
		     if (kvf_oldparse_toggle_line(database[i], &line_info))
			toggle_def = line_info.toggle_def;
		     else
                     {
                        kerror(NULL, "update_uis",
                               "Unable to update %s on line %d of %s",
                               kvf_ascii_typeflag(flag),
                               linenum_lookup[i],
                               filenames[filename_lookup[i]]);
                     }
		     break;

		case KUIS_INTEGER:
		case KUIS_FLOAT:
		case KUIS_CYCLE:
		case KUIS_LIST:
		case KUIS_STARTSUBMENU:
		case KUIS_INPUTFILE:
		case KUIS_OUTPUTFILE:
		case KUIS_LOGICAL:
		case KUIS_STRING:
		case KUIS_FLAG:
		case KUIS_STRINGLIST:
		case KUIS_WORKSPACE:
		     if (kvf_gen_oldparse(database[i], &line_info))
		     {
		         if (flag == KUIS_CYCLE || flag == KUIS_LIST 
			     || flag == KUIS_STRINGLIST) 
		             line_info.int_val = 1;
		         if (flag == KUIS_INTEGER || flag == KUIS_FLOAT) 
			 {
		             line_info.special   = 1;
		             line_info.precision = 0;
			 }
			 if (doing_toggle) 
			 {
			     toggle_count++;
			     if (toggle_count == toggle_def)
			         line_info.opt_sel = 1;
			     else line_info.opt_sel = 0;
			     line_info.optional = 1;
			 }
			 line_info.write = clean_lines;

			 if (!line_info.optional)
			     line_info.opt_sel = 1;
		         kvf_gen_deparse(&line_info, &database[i]);
	             }
		     else
		     {
			kerror(NULL, "update_uis",
			       "Unable to update %s on line %d of %s",
			       kvf_ascii_typeflag(flag),
			       linenum_lookup[i], 
			       filenames[filename_lookup[i]]); 
		     }
		     break;

		case KUIS_END:
		     if (doing_toggle) doing_toggle = FALSE;
		     break;
	     }

	}

	kvf_clear_line_info(&tmp_line_info);
	for (i = 0; i < line_num; i++)
        {
             flag = kvf_get_line_type(database[i]);
             switch(flag)
             {
		case KUIS_SUBFORMBUTTON:
	             if (last_subform_index < i) 
			last_subform_index = i;
		     kvf_oldparse_subformbutton_line(database[i], &line_info);
		     startsubform_line = kvf_oldfind_matching_M_line(database, 
					&last_subform_index, i, 
					filename_lookup, 
					linenum_lookup, filenames);
		     if (startsubform_line == NULL)
			return(FALSE);
		     kvf_oldparse_startsubform_line(startsubform_line, 
						    &tmp_line_info);

		     var_token = kstring_to_token(tmp_line_info.variable);
		     if ((var_count = use_count(var_token, used_subform_vars, 
				                used_subform_var_count)) > 0)
			sprintf(temp, "%s_%d", tmp_line_info.variable, 
					       var_count+1);
		     else sprintf(temp, "%s", tmp_line_info.variable);

		     if ((used_subform_vars = (int *) 
			 krealloc(used_subform_vars, 
			 (used_subform_var_count+1) * sizeof(int))) == NULL)
		     {
			kerror("uisupdate", "update_uis",
                               "Can't alloc array of used subform names -- \
updated UIS file may contain subform button lines with identical variable \
names that will have to be modified by hand.");
		     }
		     if (used_subform_vars != NULL)
		          used_subform_vars[used_subform_var_count++] = 
								var_token;
		 
		     line_info.variable = kstring_copy(temp, NULL);
		     kvf_deparse_subformbutton_line(&line_info, &database[i]);
		     tmp_line_info.variable = kstring_copy(temp, NULL);
		     kvf_deparse_startsubform_line(&tmp_line_info, 
					   &database[last_subform_index]);
                     last_subform_index++;
		     break;
		     

		case KUIS_GUIDEBUTTON:
		     kvf_oldparse_guide_line(database[i], &line_info);
	             if (last_guide_index < i) 
			last_guide_index = i;
		     startpane_line = kvf_oldfind_matching_P_line(database, 
					&last_guide_index, i, 
					filename_lookup, 
					linenum_lookup, filenames);
		     if (startpane_line == NULL)
			return(FALSE);
		     kvf_oldparse_startpane_line(startpane_line, 
						 &tmp_line_info);

                     line_info.variable = kstring_copy(tmp_line_info.variable, 
						       NULL);
		     kvf_deparse_guide_line(&line_info, &database[i]);
                     last_guide_index++;
		     break;
		     
	     }
	}


	form = kvf_build_form(database, NONE, NULL, NULL, filename_lookup, 
			      linenum_lookup, filenames);
	if (form == NULL)
	{
	    kerror(NULL, "update_uis",  "Cannot create updated UIS file, due to syntax error(s) in original UIS file(s).");
	    return(FALSE);
	}
	kvf_print_UIS_file(form, filename, force, TRUE);

	return(TRUE);
}

static int use_count(
     int var_token,
     int *used_token_array,
     int used_token_array_size)
{
	int i, count;

	if (used_token_array == NULL) return (0);

	count = 0;
	for (i = 0; i < used_token_array_size; i++)
	{
	    if (used_token_array[i] == var_token)
		count++;
	}
	return(count);
}

/*----------------------------------------------------------
|
| Routine Name: kvf_oldfind_matching_M_line
|
|      Purpose: A problem results when we must name the (-d) subform button
|               according to the name on the [-M] line, which hasn't
|               been read in yet.  This routine finds the (-M) line to match
|               the (-d) line, to solve that problem.
|
|         Input: database           - ptr to internal UIS struct
|                last_subform_index - for efficiency's sake, points
|                                     to the last [-M] line found, so we
|                                     don't have to search the entire UIS again
|                sfb_index          - index into the UIS of current -d line
|                filename_lookup    - indexes into 'filenames' array
|                linenum_lookup     - holds actual line # of file for UIS line
|                filenames          - array of filenames comprising UIS
|
|        Output: Returns the -M line on success, NULL on failure.
|          Date: Apr 10, 1992
|      KUIS_COMMENTs: Called by kvf_fill_in_master()
|    Written By: Danielle Argiro
| Modifications: Converted from Khoros 1.0 (DA)
|
---------------------------------------------------------------*/

char *kvf_oldfind_matching_M_line(
   char **database,
   int  *last_subform_index,
   int  sfb_index,
   int  *filename_lookup,
   int  *linenum_lookup,
   char **filenames)
{
        int flag;
        char *control_line;
        Line_Info line_info;
        char temp[KLENGTH];

        flag = kvf_get_line_type(database[*last_subform_index]);
        if (flag == -1) return(NULL);

        while (flag != KUIS_STARTSUBFORM)
        {
            (*last_subform_index)++;
            if (database[*last_subform_index] == NULL)
            {
                sprintf(temp, "Cannot find [-M] line that matches the SubformButton [-d] (or PseudoSubform [-u]) line on line %d of %s;  aborting form creation.", linenum_lookup[sfb_index], filenames[filename_lookup[sfb_index]]);
	        errno = KUIS_SYNTAX;
                kerror("kforms", "kvf_create_form",  temp);
                return(NULL);
            }
            flag = kvf_get_line_type(database[*last_subform_index]);
            if (flag == -1) return(NULL);
        }
        kvf_clear_line_info(&line_info);
        if (!(kvf_parse_startsubform_line(database[*last_subform_index],
                                          &line_info)))
        {
             sprintf(temp, "Cannot find [-M] line that matches the SubformButton [-d] (or PseudoSubform [-u]) line on line %d of file %s;  aborting form creation", linenum_lookup[sfb_index], filenames[filename_lookup[sfb_index]]);
	     errno = KUIS_SYNTAX;
             kerror("kforms", "kvf_create_form", temp);
             return(NULL);
        }
        else control_line = database[*last_subform_index];

        kvf_free_line_info_strings(&line_info);

        return(control_line);
}

/*------------------------------------------------------------
|
| Routine Name: kvf_oldfind_matching_P_line
|
|      Purpose: A problem results when we must name the (-g) guide button
|               according to the name on the [-P] line, which hasn't
|               been read in yet.  This routine finds the (-P) line to match
|               the (-g) line, to solve that problem.
|
|         Input: database           - ptr to internal UIS
|                last_guide_index   - for efficiency's sake, points
|                                    to the last [-P] line found, so we
|                                    don't have to search the entire UIS again
|                gb_index           - index into the UIS of (-g) line
|                filename_lookup    - indexes into 'filenames' array
|                linenum_lookup     - holds actual line # of file for UIS line
|                filenames          - array of filenames comprising UIS
|
|        Output: Returns the -P line on success, NULL on failure.
|          Date: Apr 10, 1992
|    Written By: Danielle Argiro
| Modifications: Converted from Khoros 1.0 (DA)
|
---------------------------------------------------------------*/

char *kvf_oldfind_matching_P_line(
   char **database,
   int  *last_guide_index,
   int  gb_index,
   int  *filename_lookup,
   int  *linenum_lookup,
   char **filenames)
{
        int flag;
        char *control_line;
        Line_Info line_info;
        char temp[KLENGTH];


        flag = kvf_get_line_type(database[*last_guide_index]);
        if (flag == -1) return(NULL);

        while (flag != KUIS_STARTPANE)
        {
            (*last_guide_index)++;
            if (database[*last_guide_index] == NULL)
            {
                sprintf(temp, "Cannot find [-P] line that matches the GuideButton [-g] line on line %d of %s;  aborting form creation.", linenum_lookup[gb_index], filenames[filename_lookup[gb_index]]);
                kerror("kforms", "kvf_create_form",
                            temp);
		errno = KUIS_SYNTAX;
                return(NULL);
            }
            flag = kvf_get_line_type(database[*last_guide_index]);
            if (flag == -1) return(NULL);
        }
        kvf_clear_line_info(&line_info);
        if (!(kvf_parse_startpane_line(database[*last_guide_index],
                                          &line_info)))
        {
             sprintf(temp, "Cannot find [-P] line that matches the GuideButton [-g] line on line %d of %s;  aborting form creation", linenum_lookup[gb_index], filenames[filename_lookup[gb_index]]);
             kerror("kforms", "kvf_create_form",
                         temp);
	     errno = KUIS_SYNTAX;
             return(NULL);
        }
        else control_line = database[*last_guide_index];

        kvf_free_line_info_strings(&line_info);
        return(control_line);
}

