 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#ifndef _parser_h_
#define _parser_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>	     file: parser.h					 <<<<
   >>>>                                                          <<<<
   >>>>      contains: Parsing Scan Fields                       <<<<
   >>>>                                                          <<<<
   >>>>	     These scan fields define the model for each type    <<<<
   >>>>	     of User Interface Specification line that is        <<<<
   >>>>      read by kvf_parse_***_line()		         <<<< 
   >>>>                                                          <<<<
   >>>>      written by: Danielle Argiro & Stephanie Hallett,    <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

static char 

/* -F # @ % gs ps 'l' FormInfoName */
*startform_oldscan="-%c%d.%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%s",

/* -S @ mutually_exclusive */
*startmaster_oldscan= "-%c%d%d",

/* -M @ % gs ps 'l' SubFormInfoName */
*startsubform_oldscan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%s",   

/* -D @ % gs ps 'l' SubMenuInfoName */
*startsubmenu_oldscan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%s",   

/* -d @ % gs 'l'*/
*subformbutton_oldscan="-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]", 

/* -u @ % gs 'l'*/
*psuedosubform_oldscan="-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]", 

/* -n @ % gs 'l' 'des' v */
*master_action_oldscan = "-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/* -P @ % gs ps 'l' PaneInfoName*/
*startpane_oldscan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%s", 

/*  -G @ gs ps 'l'*/
*startguide_oldscan= "-%c%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]", 

/* -g @ % gs 'l'*/
*guidebutton_oldscan="-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]", 

/* -Q @ % gs 'l'*/
*quitform_oldscan= "-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]",

/* -m @ % gs 'l' 'des' v */
*subform_action_oldscan = "-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/*  -H @ gs 'l' 'des' help_path */
*help_oldscan= "-%c%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s", 

/* -I @ % * ! ? # gs ps 'def' 'l' 'des' v 'val' 'literal value' */
*input_oldscan= "-%c%d%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",

/* -O @ % * ! ? # gs ps 'def' 'l' 'des' v 'val' 'literal value' */
*output_oldscan= "-%c%d%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",

/* -i @ % * ! ? gs ps L U def 'l' 'des' v val 'literal value' */
*int_oldscan  ="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%d%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%d%*[ ]%*['`]%[^'`]%*['`]",

/* -f @ % * ! ? gs ps L U def 'l' 'des' v val 'literal value' */
*float_oldscan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%f%f%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%f%*[ ]%*['`]%[^'`]%*['`]",

/* -l @ % * ! ? gs ps def 'l' 'label0' 'label1' 'des' v val */
*logic_oldscan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%d",

/* -s @ % * ! ? gs ps 'def' 'l' 'des' v 'val' 'literal value' */
*string_oldscan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",

/* -R @ % exec_type gs 'l' 'des' com */
*routine_oldscan = "-%c%d%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%[^\n]",

/*  -T @ % * ! ? gs ps def 'l' 'des' v */
*toggle_oldscan = "-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%d",

/* -b xpos ypos 'l' */
*blank_oldscan = "-%c%*[ ]+%f+%f%*[ ]%*['`]%[^'`]",

/* -a @ % gs 'l' 'des' v */
*pane_action_oldscan = "-%c%d%d%fx%f+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/* -c @ % * ! ? gs ps num def 'l' 'des' v */
*cycle_oldscan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/* -x @ % * ! ? gs ps num def 'l' 'des' v */
*list_oldscan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/* -p filename */
*includepane_oldscan = "-%c%s",

/* -k filename */
*includesubform_oldscan = "-%c%s",

/* -w gs ps 'l' 'des' v val */
*workspace_oldscan = "-%c%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s%d",

/* -L library_call */
*libcall_oldscan = "-%c%s",

/* -A @ % gs ps 'def' 'l' 'val' 'literal value' */
*ansinfile_oldscan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",

/* -Z @ % gs ps 'def' 'l' 'val' 'literal value' */
*ansoutfile_oldscan= "-%c%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",

/* -y @ % * ! ? gs num start def 'l' 'des' v */
*stringlist_scan="-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%d%d%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s",

/* -t @ % * ! ? gs 'l' 'des' v */
*flag_scan= "-%c%d%d%d%d%d%fx%f+%f+%f%*[ ]+%f+%f%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*[ '`]%s";
#endif
/* Don't add after this line */
