/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:  To provide function declarations and
   >>>>			definitions for the kutils kdbm utilities
   >>>>
   >>>>    Written By:  Mark Young & Jeremy Worley
   >>>>
   >>>>          Date:  Dec 4, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_ksdbm_h_
#define _kutils_ksdbm_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

/*
 * flags to ksdbm_store()
 */
#define KDBM_INSERT	0
#define KDBM_REPLACE	1

        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct
{
	char *dptr;	/* the data pointer		   */
	int   dsize;	/* the size of data stored in dptr */
} ksdatum;

/*
 *  Declare the ksdbm to be a struct _ksdbm.  The declaration for
 *  this structure is actually in the file:
 *
 *              $BOOTSTRAP/objects/library/kutils/dbm.h
 */
typedef struct _ksdbm ksdbm;

 
	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

ksdbm   *ksdbm_open        PROTO((char *, int, int));
void    ksdbm_close       PROTO((ksdbm *));
ksdatum  ksdbm_fetch       PROTO((ksdbm *, ksdatum));
int     ksdbm_store       PROTO((ksdbm *, ksdatum, ksdatum, int));
int     ksdbm_delete      PROTO((ksdbm *, ksdatum));
ksdatum  ksdbm_firstkey    PROTO((ksdbm *));
ksdatum  ksdbm_nextkey     PROTO((ksdbm *));
int     ksdbm_checkkey    PROTO((ksdbm *, ksdatum));
int     ksdbm_read        PROTO((ksdbm *, ksdatum, kaddr, int, int));
int     ksdbm_write       PROTO((ksdbm *, ksdatum, kaddr, int, int));
int     ksdbm_lseek       PROTO((ksdbm *, ksdatum, int, int));
int     ksdbm_getmachtype PROTO((ksdbm *));
int	ksdbm_check	 PROTO((int));

#endif /* _kutils_ksdbm_h_ */
/* Don't add after this point */
