/*
 * Khoros: $Id$
 */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>             _static_routines()
   >>>>  Public:
   >>>>             public_routines()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "dbcnvrt.h"
#include "ksdbm.h"
#include "dbm.h"

int fix_da_viff PROTO((ksdbm *, kdbm *));

/*-----------------------------------------------------------
|
|  Routine Name: convert_tb - convert a kobject's database
|
|       Purpose: Convert a kobject's cms database file from the pre-khoros 2.0
|		 gdbm to the gdbm in the khoros 2.0 final release.
|         Input: tb_name - tb to convert
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steven Jorgensen
|          Date: Aug 25, 1994
------------------------------------------------------------*/
int convert_tb(
	char *tb_name)
{
   char uppertb[KLENGTH], tb_path[KLENGTH], dbpath[KLENGTH], func[KLENGTH];
   char cache[KLENGTH];
   char *opath = NULL, *oname = NULL;
   kobject tb;
   klist *olist;

   if (tb_name == NULL)
   {
      kerror(NULL, "convert_tb", "Null toolbox passed in");
      return(FALSE);
   }

   kstring_upper(tb_name, uppertb);
   ksprintf(tb_path, "$%s/repos/db", uppertb);

   ksprintf(dbpath, "%s/cms", tb_path);
   ksprintf(func, "%s/manpage", tb_path);
   ksprintf(cache, "%s/cache/objects", tb_path);

   if (convert_rename(dbpath, clui_info->rm_flag) == FALSE)
      return(FALSE);

   if (convert_rename(func, clui_info->rm_flag) == FALSE)
      return(FALSE);

   if (convert_rename(cache, clui_info->rm_flag) == FALSE)
      return(FALSE);

   if ((tb = kcms_open_toolbox(tb_name)) == NULL)
   {
      kerror(NULL, NULL,"Cannot open the toolbox '%s'",tb_name);
      return(FALSE);
   }

   if (kcms_get_attribute(tb, KCMS_TB_SOFTWARE_OBJECTS, &olist) == FALSE)
   {
      kerror(NULL, NULL, "Cannot get a list of software objects");
      return(FALSE);
   }

   for (;olist != NULL ; olist = klist_next(olist))
   {
      if ( !kcms_get_attribute((kobject) klist_clientdata(olist),
			       KCMS_NAME, &oname))
      {
	 kerror(NULL, NULL, "Unable to get the name of the sub-object");
	 continue;
      }
      if ( !kcms_get_attribute((kobject) klist_clientdata(olist),
			       KCMS_PATH, &opath))
      {
	 kerror(NULL, NULL, "Unable to get path for object '%s'", oname);
	 continue;
      }
      ksprintf(dbpath, "%s/db/cms", opath);
      ksprintf(func, "%s/db/function", opath);
      if (convert_rename(dbpath, clui_info->rm_flag) == FALSE)
         continue;
      (void) convert_rename(func, clui_info->rm_flag);
   }

   return(TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: convert_rename - rename to old before converting
|
|       Purpose: rename to *.old before converting
|         Input: file - filename to convert
|    Written By: Steven Jorgensen
|          Date: Aug 26, 1994
------------------------------------------------------------*/
int convert_rename(
	char *file,
	int   rm)
{
   char oldfile[KLENGTH];
   if (file == NULL)
   {
      kerror(NULL,"convert_rename", "NULL file passed in");
      return(FALSE);
   }
   if (kaccess(file, F_OK) == -1)
      return(TRUE);
   ksprintf(oldfile, "%s.old", file);
   if (krename(file, oldfile) == -1)
   {
      kerror(NULL,"convert_rename", "Cannot rename '%s' to '%s'", file,oldfile);
      return(FALSE);
   }
   return(convert_file(oldfile, file, rm));
}

/*-----------------------------------------------------------
|
|  Routine Name: convert_file - convert the db file from
|
|       Purpose: convert a pre-2.0 gdbm file to a post-2.0 gdbm file
|
|         Input: in_file  - input filename
|		 out_file - output filename
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Steven Jorgensen
|          Date: Aug 25, 1994
------------------------------------------------------------*/
int convert_file(
	char *in_file,
	char *out_file,
	int   rm)
{
   ksdbm *sdbm;
   ksdatum skey, sdata;
   kdbm *dbm;
   kdatum key, data;
   ksdatum viff_cookie_tag;

   if (kaccess(in_file, F_OK) == -1)
      return(TRUE);

   if (!(sdbm = ksdbm_open(in_file, O_RDONLY, 0666)))
   {
      kerror(NULL,"convert_file", "Cannot open database file '%s'", in_file);
      return(FALSE);
   }
   if (!(dbm = kdbm_open(out_file, O_WRONLY|O_CREAT|O_TRUNC, 0666)))
   {
      kerror(NULL,"convert_file", "Cannot open database file '%s'", out_file);
      return(FALSE);
   }

   /*JW*/
   viff_cookie_tag.dptr = kstring_copy("ViffMagicCookie", NULL);
   viff_cookie_tag.dsize = kstrlen(viff_cookie_tag.dptr) + 1;
   sdata = ksdbm_fetch(sdbm, viff_cookie_tag);

   if (sdata.dsize > 0)
   {
      fix_da_viff(sdbm, dbm);
   }
   else
   {
      for (skey = ksdbm_firstkey(sdbm); skey.dptr != NULL;
					skey = ksdbm_nextkey(sdbm))
      {
	 sdata = ksdbm_fetch(sdbm, skey);
	 key.dptr = skey.dptr;
	 key.dsize = skey.dsize;
	 data.dptr = sdata.dptr;
	 data.dsize = sdata.dsize;
	 kdbm_store(dbm, key, data, KDBM_REPLACE);
      }
   }
   
   ksdbm_close(sdbm);
   kdbm_close(dbm);

   if (rm && (kunlink(in_file) == -1))
      kwarn(NULL,"convert_file", "Unable to remove the original database file");

   return(TRUE);
}
