#! /bin/sh

echo "running test1.sh for mmul ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: diagonal matrix X col vector
# ------------------------------------------------------------------------
test_num=1
descr="diagonal matrix X col vector"
cat <<EOF > $tmpdir/ascii1.$$
1 0 0
0 2 0
0 0 4
EOF
cat <<EOF > $tmpdir/ascii2.$$
1
2
3
EOF
mmul -i1 $tmpdir/ascii1.$$ -i2 $tmpdir/ascii2.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
1
4
12
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$
/bin/rm -f $tmpdir/ascii1.$$ $tmpdir/ascii2.$$

# ------------------------------------------------------------------------
# Test  2: diagonal matrix X unit matrix
# ------------------------------------------------------------------------
test_num=2
descr="diagonal matrix X unit matrix (non-square)"
cat <<EOF > $tmpdir/ascii1.$$
1 0 0
0 -2 0
0 0 4
EOF
cat <<EOF > $tmpdir/ascii2.$$
1 1 1 1 1 1
1 1 1 1 1 1
1 1 1 1 1 1
EOF
mmul -i1 $tmpdir/ascii1.$$ -i2 $tmpdir/ascii2.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
1  1  1  1  1  1
-2 -2 -2 -2 -2 -2
4 4 4 4 4 4
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$
/bin/rm -f $tmpdir/ascii1.$$ $tmpdir/ascii2.$$

# ------------------------------------------------------------------------
# Test  3: col vector X row vector
# ------------------------------------------------------------------------
test_num=3
descr="col vector X row vector"
cat <<EOF > $tmpdir/ascii1.$$
1
2
3
EOF
cat <<EOF > $tmpdir/ascii2.$$
2 3 4
EOF
mmul -i1 $tmpdir/ascii1.$$ -i2 $tmpdir/ascii2.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
2 3 4
4 6 8
6 9 12
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$
/bin/rm -f $tmpdir/ascii1.$$ $tmpdir/ascii2.$$

# ------------------------------------------------------------------------
# Test  4: row vector X col vector
# ------------------------------------------------------------------------
test_num=4
descr="row vector X col vector"
cat <<EOF > $tmpdir/ascii1.$$
1 2 3
EOF
cat <<EOF > $tmpdir/ascii2.$$
2
3
4
EOF
mmul -i1 $tmpdir/ascii1.$$ -i2 $tmpdir/ascii2.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
20
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$
/bin/rm -f $tmpdir/ascii1.$$ $tmpdir/ascii2.$$

# ------------------------------------------------------------------------
# Test  5: non-square matrix X non-square matrix
# ------------------------------------------------------------------------
test_num=5
descr="non-square matrix X non-square matrix"
cat <<EOF > $tmpdir/ascii1.$$
1 2 3
4 5 6
7 8 9
1 2 3
EOF
cat <<EOF > $tmpdir/ascii2.$$
1 2
1 2
1 2
EOF
mmul -i1 $tmpdir/ascii1.$$ -i2 $tmpdir/ascii2.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
6 12
15 30
24 48
6 12
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$
/bin/rm -f $tmpdir/ascii1.$$ $tmpdir/ascii2.$$

# ------------------------------------------------------------------------
# Test  6: row vector X col vector (complex)
# ------------------------------------------------------------------------
test_num=6
descr="row vector X col vector (complex)"
cat <<EOF > $tmpdir/ascii1.$$
(1,0) (2,1)
EOF
cat <<EOF > $tmpdir/ascii2.$$
(2,1)
(3,1)
EOF
mmul -i1 $tmpdir/ascii1.$$ -i2 $tmpdir/ascii2.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
(7,6)
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$
/bin/rm -f $tmpdir/ascii1.$$ $tmpdir/ascii2.$$

exit $status

