#! /bin/sh 

echo "running test1.sh for mlud ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: diagonal matrix, U triangle
# ------------------------------------------------------------------------
test_num=1
descr="diagonal matrix, U triangle"
cat <<EOF > $tmpdir/ascii1.$$
1 0 0
0 2 0
0 0 4
EOF
mlud -i $tmpdir/ascii1.$$ -o1 $tmpdir/outl.$$ -o2 $tmpdir/outu.$$
cat <<EOF > $tmpdir/asciiu.$$
1 0 0
0 2 0
0 0 4
EOF
report $test_num "$tmpdir/outu.$$" "$tmpdir/asciiu.$$" "$descr"

# ------------------------------------------------------------------------
# Test  2: diagonal matrix, L triangle
# ------------------------------------------------------------------------
test_num=2
descr="diagonal matrix, L triangle"
cat <<EOF > $tmpdir/asciil.$$
1 0 0
0 1 0
0 0 1
EOF
report $test_num "$tmpdir/outl.$$" "$tmpdir/asciil.$$" "$descr"
/bin/rm -f $tmpdir/outu.$$ $tmpdir/outl.$$
/bin/rm -f $tmpdir/ascii1.$$ $tmpdir/asciiu.$$ $tmpdir/asciil.$$

# ------------------------------------------------------------------------
# Test  3: general matrix, U triangle
# ------------------------------------------------------------------------
test_num=3
descr="general matrix, U triangle"
cat <<EOF > $tmpdir/ascii1.$$
6 7 8
3 4 5
1 2 3
EOF
mlud -i $tmpdir/ascii1.$$ -o1 $tmpdir/outl.$$ -o2 $tmpdir/outu.$$
cat <<EOF > $tmpdir/asciiu.$$
6 7 8
0 .833333 1.666667
0 0 0 
EOF
report $test_num "$tmpdir/outu.$$" "$tmpdir/asciiu.$$" "$descr"

# ------------------------------------------------------------------------
# Test  4: general matrix, L triangle
# ------------------------------------------------------------------------
test_num=4
descr="general matrix, L triangle"
cat <<EOF > $tmpdir/asciil.$$
1 0  0  
0.166667 1 0  
0.5 0.6 1  
EOF
report $test_num "$tmpdir/outl.$$" "$tmpdir/asciil.$$" "$descr"
/bin/rm -f $tmpdir/outu.$$ $tmpdir/outl.$$
/bin/rm -f $tmpdir/ascii1.$$ $tmpdir/asciiu.$$ $tmpdir/asciil.$$

exit $status

