#! /bin/sh

echo "running test1.sh for mexchg ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: real, non-square, first row to last row
# ------------------------------------------------------------------------
test_num=1
descr="real, non-square, first row to last row"
cat <<EOF > $tmpdir/ascii.$$
2 3 4 1 
4 6 8 1
6 9 12 1
EOF
mexchg -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -r1 0 -r2 2
cat <<EOF > $tmpdir/ascii.$$
6 9 12 1
4 6 8 1
2 3 4 1 
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2: complex, non-square, first row to last row
# ------------------------------------------------------------------------
test_num=2
descr="complex, non-square, first row to last row"
cat <<EOF > $tmpdir/ascii.$$
(2,-5) (3,-5)
(4,-5) (6,-5)
(6,-5) (9,-5)
EOF
mexchg -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -r1 0 -r2 2
cat <<EOF > $tmpdir/ascii.$$
(6,-5) (9,-5)
(4,-5) (6,-5)
(2,-5) (3,-5)
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  3: real, non-square, first col to last col
# ------------------------------------------------------------------------
test_num=3
descr="real, non-square, first col to last col"
cat <<EOF > $tmpdir/ascii.$$
2 3 4 1
4 6 8 1
6 9 12 1
EOF
mexchg -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -c1 0 -c2 3
cat <<EOF > $tmpdir/ascii.$$
1 3 4 2
1 6 8 4
1 9 12 6
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  4: complex, non-square, first col to last col
# ------------------------------------------------------------------------
test_num=4
descr="complex, non-square, first col to last col"
cat <<EOF > $tmpdir/ascii.$$
(2,-5) (3,-5)
(4,-5) (6,-5)
(6,-5) (9,-5)
EOF
mexchg -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -c1 0 -c2 1
cat <<EOF > $tmpdir/ascii.$$
(3,-5) (2,-5)
(6,-5) (4,-5)
(9,-5) (6,-5)
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

exit $status

