#! /bin/sh 

echo "running test1.sh for meigen ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: general square matrix, eigenvalues
# ------------------------------------------------------------------------
test_num=1
descr="general square matrix, eigenvalues"
cat <<EOF > $tmpdir/ascii1.$$
1 2 3
4 5 7
11 3 2
EOF
meigen -i $tmpdir/ascii1.$$ -o1 $tmpdir/outvec.$$ -o2 $tmpdir/outval.$$
cat <<EOF > $tmpdir/asciival.$$
(11.79939098,0) (0,0) (0, 0)  
(0,0)  (-3.843491581,0)  (0,0)  
(0,0)  (0,0)  (0.04410059707,0)
EOF
report $test_num "$tmpdir/outval.$$" "$tmpdir/asciival.$$" "$descr"
/bin/rm $tmpdir/asciival.$$ $tmpdir/outval.$$
/bin/rm $tmpdir/ascii1.$$

# ------------------------------------------------------------------------
# Test  2: general square matrix, eigenvectors
# ------------------------------------------------------------------------
test_num=2
descr="general square matrix, eigenvectors"
cat <<EOF > $tmpdir/asciivec.$$
(0.7140826604,0) (0.4475551879,0) (0.538312463,0)  
(0.9227209112,0) (-0.08082101156,0) (-0.376900629,0)  
(0.9096918194,0) (-0.4093741515,0) (0.0698111581,0)  
EOF
report $test_num "$tmpdir/outvec.$$" "$tmpdir/asciivec.$$" "$descr"
/bin/rm $tmpdir/asciivec.$$ $tmpdir/outvec.$$

exit $status

