 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for mmul
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lmmul
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lmmul - form matrix product C=AB
* 
*       Purpose: lmmul forms the matrix product C=AB where A is
*                MxN, B is NxP, and C is MxP.
*
*         Input: kobject a_obj - A matrix object
*                kobject b_obj - B matrix object
*
*        Output: kobject c_obj - C matrix object
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Scott Wilson
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lmmul( kobject a_obj, kobject b_obj, kobject c_obj)
/* -library_def_end */

/* -library_code */
{
        char *lib = "kmatrix", *rtn = "lmmul";
        double *A=NULL,*B=NULL,*C=NULL;
        kdcomplex *AZ=NULL,*BZ=NULL,*CZ=NULL;
        int i,j,k,num,nplanes;
        int typea, typeb, itype, otype;
        int wa,ha,da,ta,ea;
        int wb,hb,db,tb,eb;
        int wc,hc,dc,tc,ec;
        klist *objlist=NULL;
        double sum;
        kdcomplex sumZ,tmp;

        /* Make sure we have valid objects */
        if (a_obj == KOBJECT_INVALID || b_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus input object");
            return(FALSE);
          }
        if (c_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus output object");
            return(FALSE);
          }

        /* Reference the input objects to avoid side effects, then add the
           references to the list of goodies to be autmatically free'd on
           error. */
        KCALL((a_obj = kpds_reference_object(a_obj)));
        objlist = klist_add(objlist,a_obj,"KOBJECT");
        KCALL((b_obj = kpds_reference_object(b_obj)));
        objlist = klist_add(objlist,b_obj,"KOBJECT");

        /* Figure out if was should act real or complex */
        KCALL(kpds_get_attribute(a_obj,KPDS_VALUE_DATA_TYPE,&typea));
        KCALL(kpds_get_attribute(b_obj,KPDS_VALUE_DATA_TYPE,&typeb));
        if (typea == KCOMPLEX || typea == KDCOMPLEX ||
            typeb == KCOMPLEX || typeb == KDCOMPLEX)\
          {
            itype = KDCOMPLEX;
            otype = KDCOMPLEX;
          }
        else
          {
            itype = KDOUBLE;
            otype = KDOUBLE;
          }

        /* Constrain the input data to double real or double complex for read */
        KCALL(kpds_set_attribute(a_obj,KPDS_VALUE_DATA_TYPE, itype));
        KCALL(kpds_set_attribute(b_obj,KPDS_VALUE_DATA_TYPE, itype));

        /* See what size the data is */
        KCALL(kpds_get_attribute(a_obj,KPDS_VALUE_SIZE,&wa,&ha,&da,&ta,&ea));
        KCALL(kpds_get_attribute(b_obj,KPDS_VALUE_SIZE,&wb,&hb,&db,&tb,&eb));
        if (wa != hb)
          {
            kinfo(KSTANDARD,"Number of cols in A must match number of rows in B\n");
            (void)klist_free(objlist, (kfunc_void)lkcall_free);
            return(0);
          }
        wc = wb;
        hc = ha;
        if (da != db || ta != tb || ea != eb)
          {
            kinfo(KSTANDARD,"D,T,E in A must match D,T,E in B\n");
            (void)klist_free(objlist, (kfunc_void)lkcall_free);
            return(0);
          }
        dc = da;
        tc = ta;
        ec = ea;

        /* Set the output object size, data type, and region size */
        if (!kpds_query_value(c_obj)) KCALL(kpds_create_value(c_obj));
        KCALL(kpds_set_attributes(c_obj,
                             KPDS_VALUE_SIZE,wc,hc,dc,tc,ec,
                             KPDS_VALUE_DATA_TYPE,otype,NULL));
        KCALL((c_obj = kpds_reference_object(c_obj)));
        objlist = klist_add(objlist,c_obj,"KOBJECT");
        KCALL(kpds_set_attribute(c_obj,KPDS_VALUE_REGION_SIZE,wc,hc,1,1,1));

        /* Set the input object region sizes */
        KCALL(kpds_set_attribute(a_obj,KPDS_VALUE_REGION_SIZE,wa,ha,1,1,1));
        KCALL(kpds_set_attribute(b_obj,KPDS_VALUE_REGION_SIZE,wb,hb,1,1,1));

        /* Allocate plane buffers */
        if (otype == KDOUBLE)
          {
            KCALL(!((A=(double *)kmalloc(wa*ha*sizeof(double))) == NULL));
            objlist = klist_add(objlist,A,"KMALLOC");
            KCALL(!((B=(double *)kmalloc(wb*hb*sizeof(double))) == NULL));
            objlist = klist_add(objlist,B,"KMALLOC");
            KCALL(!((C=(double *)kmalloc(wc*hc*sizeof(double))) == NULL));
            objlist = klist_add(objlist,C,"KMALLOC");
          }
        else
          {
            KCALL(!((AZ=(kdcomplex *)kmalloc(wa*ha*sizeof(kdcomplex)))== NULL));
            objlist = klist_add(objlist,AZ,"KMALLOC");
            KCALL(!((BZ=(kdcomplex *)kmalloc(wb*hb*sizeof(kdcomplex)))== NULL));
            objlist = klist_add(objlist,BZ,"KMALLOC");
            KCALL(!((CZ=(kdcomplex *)kmalloc(wc*hc*sizeof(kdcomplex)))== NULL));
            objlist = klist_add(objlist,CZ,"KMALLOC");
          }

        nplanes = da*ta*ea;

        for (num=0; num<nplanes; num++)
          {
            /* Get a plane from the input objects */
            if (otype == KDOUBLE)
              {
                A = (double *)kpds_get_data(a_obj,KPDS_VALUE_REGION,(kaddr)A);
                B = (double *)kpds_get_data(b_obj,KPDS_VALUE_REGION,(kaddr)B);
              }
            else
              {
                AZ=(kdcomplex *)kpds_get_data(a_obj,KPDS_VALUE_REGION,(kaddr)AZ);
                BZ=(kdcomplex *)kpds_get_data(b_obj,KPDS_VALUE_REGION,(kaddr)BZ);
              }

            /* Form matrix product */
            if (otype == KDOUBLE)
              {
                for (i=0; i<ha; i++)
                  {
                    for (j=0; j<wb; j++)
                      {
                        sum = 0.0;
                        for (k=0; k<wa; k++)
                          sum += A[i*wa+k]*B[k*wb+j];
                        C[i*wc+j] = sum;
                      }
                  }
              }
            else
              {
                for (i=0; i<ha; i++)
                  {
                    for (j=0; j<wb; j++)
                      {
                        sumZ.r = 0.0;
                        sumZ.i = 0.0;
                        for (k=0; k<wa; k++)
                          sumZ = kdcadd(sumZ,kdcmult(AZ[i*wa+k],BZ[k*wb+j]));
                        CZ[i*wc+j] = sumZ;
                      }
                  }
              }

            /* Write the output data */
            if (otype == KDOUBLE)
              {
                KCALL(kpds_put_data(c_obj,KPDS_VALUE_REGION,(kaddr)C));
              }
            else
              {
                KCALL(kpds_put_data(c_obj,KPDS_VALUE_REGION,(kaddr)CZ));
              }
          }

        (void)klist_free(objlist, (kfunc_void)lkcall_free);
	return TRUE;
}
/* -library_code_end */
