 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "mmul.h"
/*-----------------------------------------------------------
| 
|  Routine Name: mmul_get_args
| 
|       Purpose: Gets command line args for mmul
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mmul
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mmul_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for mmul is out of sync with arguments specified in mmul's *.pane file; please rerun ghostwriter on mmul.";


	/*
	 * allocate the mmul structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "mmul_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "mmul_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "mmul_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



