 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for mlud
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "mlud.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compute LU Decomposition of Matrix  (Input = L*U)
|
|       Purpose: main program for mlud
|
|         Input:
|		char *clui_info->i_file; {Input matrix}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o1_file; {Resulting lower triangular output matrix}
|		int   clui_info->o1_flag; {TRUE if -o1 specified}
|
|		char *clui_info->o2_file; {Resulting upper triangular output  matrix}
|		int   clui_info->o2_flag; {TRUE if -o2 specified}
|
|		char *clui_info->o3_file; {Pivot index vector}
|		int   clui_info->o3_flag; {TRUE if -o3 specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj = NULL;
kobject lt_obj = NULL;
kobject ut_obj = NULL;
kobject pi_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(mlud_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "mlud",
		mlud_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	mlud_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((in_obj = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID)
        {
           kerror("mlud","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->o1_flag)
          {
	    if ((lt_obj = kpds_open_output_object(clui_info->o1_file)) 
		    == KOBJECT_INVALID)
              {
                kerror("mlud","main", "Cannot open output object.");
                kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj, lt_obj))
	      {
                kerror("mlud","main", 
		  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }
        if (clui_info->o2_flag)
          {
	    if ((ut_obj = kpds_open_output_object(clui_info->o2_file)) 
		== KOBJECT_INVALID)
              {
                 kerror("mlud","main", "Cannot open output object.");
                 kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj, ut_obj))
	      {
                kerror("mlud","main", 
		  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }
        if (clui_info->o3_flag)
          {
            if ((pi_obj = kpds_open_output_object(clui_info->o3_file))
                == KOBJECT_INVALID)
              {
                 kerror("mlud","main", "Cannot open output object.");
                 kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj, pi_obj))
              {
                kerror("mlud","main",
                  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lmlud(in_obj,lt_obj,ut_obj,pi_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output objects and write */
        if (clui_info->o1_flag)
          {
	    if (!kpds_set_attribute(lt_obj,KPDS_HISTORY,kpds_history_string()))
	      {
	        kerror("mlud", "main","Unable to set history on output object");
                kexit(KEXIT_FAILURE);
	      }
            kpds_close_object(lt_obj);
          }
        if (clui_info->o2_flag)
          {
	    if (!kpds_set_attribute(ut_obj,KPDS_HISTORY,kpds_history_string()))
	      {
	        kerror("mlud", "main","Unable to set history on output object");
                kexit(KEXIT_FAILURE);
              }
	    kpds_close_object(ut_obj);
	  }
        if (clui_info->o3_flag)
          {
	    if (!kpds_set_attribute(pi_obj,KPDS_HISTORY,kpds_history_string()))
	      {
	        kerror("mlud", "main","Unable to set history on output object");
                kexit(KEXIT_FAILURE);
              }
	    kpds_close_object(pi_obj);
	  }

	kpds_close_object(in_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mlud_usage_additions
| 
|       Purpose: Prints usage additions in mlud_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mlud
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mlud_usage_additions(void)
{
	kfprintf(kstderr, "\tCompute LU Decomposition of Matrix  (Input = L*U)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: mlud_free_args
| 
|       Purpose: Frees CLUI struct allocated in mlud_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mlud
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
mlud_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o1_file);
	kfree(clui_info->o2_file);
	kfree(clui_info->o3_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
