 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "mgdiag.h"
/*-----------------------------------------------------------
| 
|  Routine Name: mgdiag_get_args
| 
|       Purpose: Gets command line args for mgdiag
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mgdiag
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mgdiag_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for mgdiag is out of sync with arguments specified in mgdiag's *.pane file; please rerun ghostwriter on mgdiag.";


	/*
	 * allocate the mgdiag structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_double(pane, "cr",
			  &(clui_info->cr_double),
			  &(clui_info->cr_flag))))
	{
	    kerror(NULL, "mgdiag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "ci",
			  &(clui_info->ci_double),
			  &(clui_info->ci_flag))))
	{
	    kerror(NULL, "mgdiag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "mgdiag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_cycle),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "mgdiag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "mgdiag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "r",
			  &(clui_info->r_int),
			  &(clui_info->r_flag))))
	{
	    kerror(NULL, "mgdiag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "c",
			  &(clui_info->c_int),
			  &(clui_info->c_flag))))
	{
	    kerror(NULL, "mgdiag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



