 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for mextract_diag
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _mextract_diag_h_
#define _mextract_diag_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <matrix.h>

/* -include_includes */
#include <kmatrix/kmatrix.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$MATRIX/objects/kroutine/mextract_diag/uis/mextract_diag.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input matrix (required infile)
 */
char	*i_file;	/* Input matrix FILENAME */
int	 i_flag;	/* Input matrix FLAG */

/*
 *  Output vector (required outfile)
 */
char	*o_file;	/* Output vector FILENAME */
int	 o_flag;	/* Output vector FLAG */

/*----- required ME group ----*/
/*
 *  Extract row (optional flag)
 */
int	 row_flag;  	/* Extract row FLAG */

/*
 *  Extract column (optional flag)
 */
int	 col_flag;  	/* Extract column FLAG */

/*
 *  Extract diagonal (optional flag)
 */
int	 diag_flag;  	/* Extract diagonal FLAG */

/*-- required ME group end ---*/

/*
 *  Row or column number (optional integer)
 */
int	 num_int; 	/* Row or column number INT */
int	 num_flag;	/* Row or column number FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void mextract_diag_get_args PROTO((kform *));
void mextract_diag_usage_additions PROTO((void));
void mextract_diag_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
