#! /bin/sh

echo "running test.sh for itexture ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-4 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}
tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/images"

# ---------- Test 1 --> L5L5 on impulse (double)
 
test_num=1
descr="L5L5 on impulse (double)"

kimpulse -o $tmpdir/in.$$ -wsize 19 -hsize 19 -wnum 1 -hnum 1 -woff 9 -hoff 9 -fgreal 1.0 -type 11

itexture -L5L5 -i $tmpdir/in.$$ -o $tmpdir/out.$$

cat << EOF > $tmpdir/result.$$
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  1  4  6  4  1  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  4 16 24 16  4  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  6 24 36 24  6  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  4 16 24 16  4  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  1  4  6  4  1  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
EOF

report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/in.$$ $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ---------- Test 2 --> E5R5 on impulse (byte)
 
test_num=2
descr="E5R5 on impulse (byte)"

kimpulse -o $tmpdir/in.$$ -wsize 19 -hsize 19 -wnum 1 -hnum 1 -woff 9 -hoff 9 -fgreal 1.0 -type 2

itexture -i $tmpdir/in.$$ -E5R5 -o $tmpdir/out.$$

cat << EOF > $tmpdir/ascii.$$
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0 -1  4 -6  4 -1  0  0  0  0  0
         0  0  0  0  0  0  0  0  0 -2  8 -12 8 -2  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  2 -8 12 -8  2  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  1 -4  6 -4  1  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 19 -hsize 19 -type 8 -o $tmpdir/result.$$

report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/in.$$ $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ---------- Test 3 --> L5L5 and E5R5 on impulse (byte)
 
test_num=3
descr="L5L5 and E5R5 on impulse (byte)"

kimpulse -o $tmpdir/in.$$ -wsize 19 -hsize 19 -wnum 1 -hnum 1 -woff 9 -hoff 9 -fgreal 1.0 -type 2

itexture -i $tmpdir/in.$$ -L5L5 -E5R5 -o $tmpdir/out.$$

cat << EOF > $tmpdir/ascii.$$
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  1  4  6  4  1  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  4 16 24 16  4  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  6 24 36 24  6  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  4 16 24 16  4  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  1  4  6  4  1  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0 -1  4 -6  4 -1  0  0  0  0  0
         0  0  0  0  0  0  0  0  0 -2  8 -12 8 -2  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  2 -8 12 -8  2  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  1 -4  6 -4  1  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
         0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 19 -hsize 19 -esize 2 -type 8 -o $tmpdir/result.$$

report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/in.$$ $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

exit $status
exit $status
