#! /bin/sh

echo "running test1.sh for irotate ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  non-square, no map, no mask, ubyte, planes
# ------------------------------------------------------------------------
test_num=1
descr="non-square, no map, no mask, ubyte, planes"
kshrink -i image:moon -o $tmpdir/in.$$ -wmag 0.03125 -hmag 0.0625
irotate -i $tmpdir/in.$$ -o $tmpdir/out.$$ -wctr -hctr -angle 28 -planes
cat <<EOF > $tmpdir/ascii.$$
0  0  0  0  0  0  0  0  147  127  128  137  0  0  0  0  0  0  0  0  0  0  0  
146  148  141  139  132  127  140  0  0  0  0  0  0  0  0  0  154  145  137  
134  136  129  143  140  146  0  0  0  0  0  0  149  151  142  155  144  123  
133  140  142  141  0  0  0  0  0  0  156  142  111  158  180  123  138  139  
135  125  0  0  0  0  0  157  158  139  59  193  147  128  139  137  134  140  
0  0  0  0  0  161  155  163  153  160  137  133  138  134  140  147  0  0  
0  0  130  154  153  158  147  143  138  140  142  136  129  137  0  0  0  
137  154  146  149  154  147  142  133  131  132  145  120  107  0  0  0  146  
152  134  140  147  143  135  132  135  137  145  119  59  0  0  142  143  135  
136  143  139  134  125  125  133  148  181  78  86  0  0  140  131  123  132  
144  125  127  136  136  111  149  168  54  139  0  145  143  130  135  134  
124  126  129  136  137  77  156  93  97  136  0  141  140  133  137  141  
120  124  119  122  100  96  125  101  145  160  136  128  133  121  131  
130  125  104  80  115  116  123  138  142  151  157  130  125  123  115  
119  122  117  74  95  109  115  123  129  155  156  160  133  130  117  105  
110  111  96  56  97  116  122  121  140  155  160  162  139  125  106  110  
111  111  114  91  103  118  121  126  148  156  162  156  114  116  110  
114  114  110  102  79  96  117  125  128  146  149  148  0  123  124  117  
112  109  85  90  99  99  114  129  141  152  151  154  0  132  127  110  
109  112  102  102  102  107  123  136  148  157  158  0  0  122  117  118  
119  97  107  113  106  120  129  134  145  153  158  0  0  119  112  132  100  
89  106  107  102  112  124  140  142  145  0  0  0  114  121  130  67  71  
102  105  104  98  116  136  129  151  0  0  0  115  115  98  66  73  107  
110  110  111  118  110  132  0  0  0  0  113  105  81  79  91  103  114  112  
117  133  139  0  0  0  0  0  117  118  52  51  84  95  125  139  128  141  
156  0  0  0  0  0  107  104  15  36  88  108  119  120  126  147  0  0  0  
0  0  0  156  93  56  65  102  118  105  113  117  138  0  0  0  0  0  0  127  
75  83  106  115  113  111  119  118  0  0  0  0  0  0  0  0  0  105  116  123  
119  105  133  145  0  0  0  0  0  0  0  0  0  0  0  118  121  122  138  0  
0  0  0  0  0  0  0  
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 16 -hsize 32 -type 3 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$
 
exit $status

