#! /bin/sh
# This testsuite has 4 basic tests for igauss_func. For the single gaussian
# case 2 cases are tested. Error checks on the segments are tested for the
# multiple gaussian case.

echo "running test1.sh for igauss_func ... "


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/usr/tmp}

# ------------------------------------------------------------------------
# Test  1:  Floating point gaussian function
# ------------------------------------------------------------------------
test_num=1
descr="Floating point single gaussian function"
igauss_func -o $tmpdir/out.$$ -hsize 64 -wsize 64 -wpeak 32 -hpeak 32 -wvar 100 -hvar 100 -peakval 1.0 -coeff 0.0 -type "float"
report $test_num "$tmpdir/out.$$" "test1.results/64x64float.xv" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2:  Integer gaussian function with peak outside the image
# ------------------------------------------------------------------------
test_num=2
descr="Integer gaussian function with peak outside the image"
igauss_func -o $tmpdir/out.$$ -wpeak -5 -hpeak -5 -wvar 100 -hvar 100 -coeff 0.707 -peakval 200.0 -hsize 64 -wsize 64 -type "integer"
report $test_num "$tmpdir/out.$$" "test1.results/64x64integer.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3: Error check on multiple gaussian case
# -----------------------------------------------------------------------
test_num=3
descr="Error check on multiple gaussian case (mask present)"
igauss_func -o $tmpdir/out.$$ -i $dpath/2x3ival_6x3fmap_2x3bmask.viff -norm 0 >$tmpdir/err.$$ 2>&1

#if cmp -s $tmpdir/err.$$ test1.results/err_check1; then
#       echo "Passed:  Test  $test_num --> "$descr""
#else
#       status=1
#       echo "FAILED:  Test  $test_num --> "$descr""
#fi

if [ $? = 0 ]
then
   echo "FAILED:  Test  $test_num --> $descr"
   status=1
else
   echo "Passed:  Test  $test_num --> $descr"
fi

/bin/rm -f $tmpdir/err.$$ $tmpdir/out.$$


# ------------------------------------------------------------------------
# Test  4: Error check on multiple gaussian case
# -----------------------------------------------------------------------
test_num=4
descr="Error check on multiple gaussian case (<6 elements)"
igauss_func -o $tmpdir/out.$$ -i $dpath/2x5ival_6x3fmap.viff -norm 0 >$tmpdir/err.$$ 2>&1

#if cmp -s $tmpdir/err.$$ test1.results/err_check2; then
#        echo "Passed:  Test  $test_num --> "$descr""
#else
#        status=1
#        echo "FAILED:  Test  $test_num --> "$descr""
#fi

if [ $? = 0 ]
then
   echo "FAILED:  Test  $test_num --> $descr"
   status=1
else
   echo "Passed:  Test  $test_num --> $descr"
fi

/bin/rm -f $tmpdir/err.$$ $tmpdir/out.$$

exit $status
