 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for irotate
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "irotate.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Rotate Object by Arbitrary Angle
|
|       Purpose: main program for irotate
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    double clui_info->wc_double; {W coordinate of center of rotation}
|		    int    clui_info->wc_flag; {TRUE if -wc specified}
|
|		    int clui_info->wctr_flag; {TRUE if -wctr specified}
|
|		Required M.E. group:
|		    double clui_info->hc_double; {H coordinate of center of rotation}
|		    int    clui_info->hc_flag; {TRUE if -hc specified}
|
|		    int clui_info->hctr_flag; {TRUE if -hctr specified}
|
|		double clui_info->angle_double; {rotation angle (degrees, positive is CW)}
|		int    clui_info->angle_flag; {TRUE if -angle specified}
|
|		int clui_info->resize_flag; {TRUE if -resize specified}
|
|		int clui_info->planes_flag; {TRUE if -planes specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in_obj = NULL;
	kobject out_obj = NULL;
        int w,h,d,t,e;
        double wc,hc;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "IMAGE");
	kexit_handler(irotate_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "IMAGE", "irotate",
		irotate_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	irotate_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((in_obj = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID)
        {
           kerror("irotate","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

	if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID)
        {
           kerror("irotate","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (!kpds_copy_object_attr(in_obj, out_obj))
	{
           kerror("irotate","main", 
		  "Unable to copy attributes from input to output object.");
           kexit(KEXIT_FAILURE);
        }

        /* Set up the default COR coordinates if needed */
        wc = clui_info->wc_double;
        hc = clui_info->hc_double;
        if (clui_info->wctr_flag || clui_info->hctr_flag)
          {
            kpds_get_attribute(in_obj,KPDS_VALUE_SIZE,&w,&h,&d,&t,&e);
            if (clui_info->wctr_flag) wc = (double)(w-1)/2.0;
            if (clui_info->hctr_flag) hc = (double)(h-1)/2.0;
          }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lirotate(in_obj,
			wc, hc,
                        clui_info->resize_flag,
                        clui_info->planes_flag,
                        clui_info->angle_double,
			out_obj))
                 kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("irotate", "main", 
		  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
	}
	
	kpds_close_object(in_obj);
	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: irotate_usage_additions
| 
|       Purpose: Prints usage additions in irotate_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname irotate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void irotate_usage_additions(void)
{
	kfprintf(kstderr, "\tRotate Object by Arbitrary Angle\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: irotate_free_args
| 
|       Purpose: Frees CLUI struct allocated in irotate_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname irotate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
irotate_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
