 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "imedian.h"
/*-----------------------------------------------------------
| 
|  Routine Name: imedian_get_args
| 
|       Purpose: Gets command line args for imedian
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname imedian
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void imedian_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for imedian is out of sync with arguments specified in imedian's *.pane file; please rerun ghostwriter on imedian.";


	/*
	 * allocate the imedian structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "imedian_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "imedian_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "imedian_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "reps",
			  &(clui_info->reps_int),
			  &(clui_info->reps_flag))))
	{
	    kerror(NULL, "imedian_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "imedian_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



