 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for igradient
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "igradient.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Gradient Operators (Roberts, Sobel, Prewitt, Isotrophic)
|
|       Purpose: main program for igradient
|
|         Input:
|		char *clui_info->i_file; {input image filename}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output image filename}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->roberts_flag; {TRUE if -roberts specified}
|
|		    int clui_info->sobel_flag; {TRUE if -sobel specified}
|
|		    int clui_info->prewitt_flag; {TRUE if -prewitt specified}
|
|		    int clui_info->isotropic_flag; {TRUE if -isotropic specified}
|
|		int clui_info->abs_logic; {Calculate gradient using absolute value or square root}
|		int clui_info->abs_flag; {TRUE if -abs specified}
|
|        Output:
|       Returns:
|
|    Written By: Ramiro Jordan, Jeremy Worley
|          Date: Apr 12, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject src;
        kobject dest;
        int operation_type;
        int gradient_type=0;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "IMAGE");
	kexit_handler(igradient_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "IMAGE", "igradient",
		igradient_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	igradient_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /*
         * Open the source and destination data objects using the
         * kpds_open_input_object and kpds_open_output_object calls.
         * These calls will open the source and
         * destination data objects with the flags set correctly.  If an open
         * fails, report the error using kerror, close opened objects if
         * necessary, and exit the program using the kexit call.
         */

        if ((src = kpds_open_input_object(clui_info ->i_file)) 
		== KOBJECT_INVALID)
        {
            kerror( NULL, "igradient", "Cannot open source object.");
            kexit(KEXIT_FAILURE);
        }
 
        if ((dest = kpds_open_output_object(clui_info ->o_file))
		== KOBJECT_INVALID)
        {
            kerror( NULL, "igradient", "Cannot open destination object.");
            kpds_close_object(src);
            kexit(KEXIT_FAILURE);
        }

        /*
         * The ligradient library should have no side effects on the destination
         * object.  It will only manipulate the value data,
         * the mask, if it exists, and the attributes of the destination
         * data object that are related to the gradient operation.
         *
         * Since the source object may contain additional attributes
         * that may or may not be part of the image data model,
         * the source object needs to be copied to the destination object
         * so that the user is not surprised by unwanted side effects.
         * Example: removal of map or location data.
         *
         * NOTE: The user can use the kpds_copy_data and kpds_copy_attributes
         * functions to copy data and attributes between source and destination
         * objects separatedly.
         *
         * If the copy function fails, report the error and exit.  The
         * objects will be closed by kexit().  Since, the exit status is
         * KEXIT_FAILURE the output object will not be wrtten to a perminent
         * transport.
         */
 
        if (!kpds_copy_object(src, dest))
        {
            kerror( NULL, "igradient", "kpds_copy_object failed.");
            kexit(KEXIT_FAILURE);
        }
 
        /*
         * Assign variables.  The clui_info structure is created by
         * the code generators using the user interface specification file
         * (igradient.pane), and this structure is located in the igradient.h
         * file.
         *
         * Below, we have assigned the structure variables to local
         * variables.  In this example, this step is not required, since
         * nothing is done to the variables before they are passed to the
         * library ligradient.
         *
         * The operation_type variable receives the user selection on the
         * method to perform the gradient operation.  There are two options:
         * 1) absolute value (default)
         * 2) square root.
         *
         * The gradient_type variable is set to 3x3 gradient templates.
         * 0) robert's (2x2)
         * 1) sobel (3x3)
         * 2) prewitt (3x3)
         * 3) isotropic (3x3)
         */
 
        operation_type = clui_info->abs_logic;

	if (clui_info->roberts_flag == 1)
           gradient_type = 0;
	else if (clui_info->sobel_flag == 1)
		gradient_type = 1;
        else if (clui_info->prewitt_flag == 1)
	        gradient_type = 2;
        else if (clui_info->isotropic_flag == 1)
	        gradient_type = 3;
	else
	{
	   kerror(NULL,"igradient","unrecognized gradient operation specified");
	   kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
        /*
         * Once all of the preliminary work has been done, pass the source
         * and destination data objects, and the parameters to the library.
         * After procedure is performed by ligradient close the objects, and
         * exit the routine.
         */
 
        if (!ligradient(src, gradient_type, operation_type, dest))
        {
            kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(dest, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror(NULL, "igradient", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

       /*
        * If the library call succeeded, close the source and destination
        * data objects using kpds_close_object, and exit using kexit.
        */
        kpds_close_object(src);
        kpds_close_object(dest);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: igradient_usage_additions
| 
|       Purpose: Prints usage additions in igradient_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igradient
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void igradient_usage_additions(void)
{
	kfprintf(kstderr, "\tGradient Operators (Roberts, Sobel, Prewitt, Isotrophic)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: igradient_free_args
| 
|       Purpose: Frees CLUI struct allocated in igradient_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igradient
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
igradient_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
