
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#ifndef __light_h_
#define __light_h_

#define LIGHT_ON 1
#define LIGHT_OFF 0

#define NLIGHT_TYPES 4

#define DIRECTIONAL_LIGHT 0
#define BIDIRECTIONAL_LIGHT 1
#define POINT_LIGHT 2
#define AMBIENT_LIGHT 3

static char *light_type_strings[] =
{
    "Directional",
    "Bidirectional",
    "Point Light",
    "Ambient"
};

/**
  * NOTE: rmonster.form has a line which determines the number of
  * lights.  the UIS list of lights will be reconscructed based
  * upon the following #define.
**/
#define MAX_LIGHTS 3

typedef struct light_struct
{
    int light_type;        /* one of the supported types. */
    vertex_3d position;    /* required for point and area sources. */
    vertex_3d direction;   /* required for directional lights */
    float rgb[3];          /* light color */
    int light_on;          /* toggle on/off */
} light_struct;

void init_lights PROTO(());

int set_current_light PROTO((int));
int get_current_light PROTO((int *));

int set_light_color PROTO((int, float, float, float));
int get_light_color PROTO((int, float *, float *, float *));

int set_light_onoff PROTO((int, int));
int get_light_onoff PROTO((int, int *));

int set_light_type PROTO((int, int));
int get_light_type PROTO((int, int *));

int set_light_direction PROTO((int, vertex_3d *));
int get_light_direction PROTO((int, vertex_3d *));

int set_light_position PROTO((int, vertex_3d *));
int get_light_position PROTO((int, vertex_3d *));

int get_ambient_light_color PROTO((vertex_3d *));
int set_ambient_light_color PROTO((vertex_3d *));

int get_num_lights PROTO((int *));
int set_num_lights PROTO((int));

#endif
