
#ifndef __imaging_h_
#define __imaging_h_

#ifdef __GL_GL_H__
#define PROTO(s) s
#else
#include "xvinclude.h"
#include "xvisual/xvisual.h"
#endif

#define MAX_RENDERER_NAME_STR_LENGTH 64
#define SOFTWARE_RENDERER 0
#define NATIVE_RENDERER 1

/**
  * this struct hold info about the capabilities on the output side of
  * a renderer.
**/

typedef struct renderer_struct
{
    int ndisplay_options;
    int selected_display_option; /* 14 march 95 - at some point we may want
				  to have per-renderer display choices, but
				  this seems kinda weird right now.  at the
				  moment, all renderers will dispaly the same
				  way, as much as is possible */
    int display_options[8];
    char *display_options_txt[8];
    int renderer_active;
    char renderer_name[MAX_RENDERER_NAME_STR_LENGTH];

    /* routines which build and tear down the renderer-specific
       display mechanism. */
    int (*init_output_func)();
    int (*shutdown_output_func)();

    /* renderer invocation function */
    int (*render_func)();

    /* renderer-specific camera functions */
    int (*set_camera_func)();
    
} renderer_struct;

#define s332_DISPLAY 0
#define s24_DISPLAY 1
#define sQUANT_DISPLAY 2
#define sDITHER_DISPLAY 3
#define sNO_DISPLAY 4

static char s332_STRING[]={"3-3-2 TrueColor (8bit display)"};
static char s24BIT_STRING[]={"24-Bit TrueColor (24bit display)"};
static char sQUANT_STRING[]={"Color Quantized Image (8bit display)"};
static char sDITHER_STRING[]={"Dithered Image (8bit display)"};
static char sNODISPLAY_STRING[]={"No Display"};

#define DEFAULT_BACKGROUND_RED 0.25
#define DEFAULT_BACKGROUND_GREEN 0.25
#define DEFAULT_BACKGROUND_BLUE 0.4

int set_background_color PROTO((float, float, float));
int get_background_color PROTO((float *, float *, float *));

int clear_framebuffer PROTO(());

int read_dot PROTO((int,int,float *,float *,float *));
int write_dot PROTO((int, int, float, float, float));

int get_image_display_choice PROTO((int *));
int set_image_display_choice PROTO((int));

int get_display_depth PROTO((int *));
int set_display_depth PROTO((int));

int change_image_width PROTO((int));
int change_image_height PROTO((int));

int repaint_imaging_pane PROTO((void));

#ifdef __GL_GL_H__
#else
void rmonster_create_gc PROTO((xvobject, kaddr, XEvent *, Boolean *));
void rmonster_handler PROTO((xvobject , kaddr,XEvent *,Boolean  *));
#endif

int have_graphics_hardware PROTO((renderer_struct *));
/** we really should have a machine.h..... **/
int find_gfx_hardware PROTO((char **,int, char *, char *));
void identify_native_renderer PROTO(());
void identify_software_renderer PROTO(());

int get_all_renderers_info PROTO((int *n,renderer_struct ***r));

int set_active_renderer PROTO((int));
int get_active_renderer PROTO((void));

void renderer_init_func PROTO((void));
void renderer_shutdown_func PROTO((void));
void renderer_invoke_func PROTO((void));

#endif
