 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_Master
   >>>> 	_xvf_free_Master
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_Master_warning
   >>>> 	_xvf_init_Master_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"

static void _xvf_init_Master_warning PROTO((char *));
static void _xvf_init_Master_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_Master
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_Master_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 15, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_Master(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *guidepane;
	/*
	 * initializing 'Master' Form Info structure
	 */

	forminfo->RenderMonster_struct =
	    kvf_create_struct_from_subformname(form, "Master.RenderMonster");
	if (forminfo->RenderMonster_struct == NULL)
	{
	    _xvf_init_Master_error("subform 'RenderMonster' on form 'Master'", 
			    "Master_RenderMonster");
	    return(FALSE);
	}

	/*
	 * initializing 'Master->RenderMonster' Subform Info structure
	 */

	forminfo->RenderMonster = (Master_RenderMonster *)
				kcalloc(1, sizeof(Master_RenderMonster));
	subform = forminfo->RenderMonster_struct->Subformptr;
	guidepane = subform->guidepane;
	forminfo->RenderMonster->license_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "Master.RenderMonster.license");
	if (forminfo->RenderMonster->license_struct == NULL)
		    _xvf_init_Master_warning("unknown selection 'license' on subform 'RenderMonster'");

	forminfo->RenderMonster->help_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "Master.RenderMonster.help");
	if (forminfo->RenderMonster->help_struct == NULL)
		    _xvf_init_Master_warning("unknown selection 'help' on subform 'RenderMonster'");

	forminfo->RenderMonster->quit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "Master.RenderMonster.quit");
	if (forminfo->RenderMonster->quit_struct == NULL)
		    _xvf_init_Master_warning("quit button 'quit' on subform 'RenderMonster'");
	forminfo->RenderMonster->quit = FALSE;

	forminfo->RenderMonster->refresh_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "Master.RenderMonster.refresh");
	if (forminfo->RenderMonster->refresh_struct == NULL)
	    _xvf_init_Master_warning("pane action button 'refresh' on subform 'RenderMonster'");
	forminfo->RenderMonster->refresh = FALSE;
	selection = forminfo->RenderMonster->refresh_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->RenderMonster->b0_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "Master.RenderMonster.b0");
	if (forminfo->RenderMonster->b0_struct == NULL)
	    _xvf_init_Master_warning("blank selection 'b0' on subform 'RenderMonster'");

	/*
	 * initializing 'Master->RenderMonster->Objects' Pane Info structure
	 */

	forminfo->RenderMonster->Objects = (RenderMonster_Objects *)
				kcalloc(1, sizeof(RenderMonster_Objects));
	forminfo->RenderMonster->Objects_struct =
	    kvf_create_struct_from_panename(subform, "Master.RenderMonster.Objects");
	if (forminfo->RenderMonster->Objects_struct == NULL)
	{
	    _xvf_init_Master_error("pane 'Objects' on subform 'RenderMonster'", "RenderMonster_Objects");
	    return(FALSE);
	}
	pane = forminfo->RenderMonster->Objects_struct->Controlptr;
	forminfo->RenderMonster->Objects->current_object_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.current_object");
	if (forminfo->RenderMonster->Objects->current_object_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->current_object_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->current_object_struct, KVF_LIST_VAL,
	                    &(forminfo->RenderMonster->Objects->current_object));
	    kvf_get_attribute(forminfo->RenderMonster->Objects->current_object_struct, KVF_LIST_LABEL,
	                    &(forminfo->RenderMonster->Objects->current_object_label));
	}
	else
	    _xvf_init_Master_warning("list selection 'current_object' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->current_object_selected = FALSE;

	forminfo->RenderMonster->Objects->object_shader_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.object_shader");
	if (forminfo->RenderMonster->Objects->object_shader_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->object_shader_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->object_shader_struct, KVF_LIST_VAL,
	                    &(forminfo->RenderMonster->Objects->object_shader));
	    kvf_get_attribute(forminfo->RenderMonster->Objects->object_shader_struct, KVF_LIST_LABEL,
	                    &(forminfo->RenderMonster->Objects->object_shader_label));
	}
	else
	    _xvf_init_Master_warning("list selection 'object_shader' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->object_shader_selected = FALSE;

	forminfo->RenderMonster->Objects->post_obj_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.post_obj");
	if (forminfo->RenderMonster->Objects->post_obj_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->post_obj_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->post_obj_struct, KVF_LOGIC_DEF,
	                    &(forminfo->RenderMonster->Objects->post_obj));
	    kvf_get_attribute(forminfo->RenderMonster->Objects->post_obj_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->RenderMonster->Objects->post_obj_label));
	}
	else
	    _xvf_init_Master_warning("logical selection 'post_obj' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->post_obj_selected = FALSE;

	forminfo->RenderMonster->Objects->obj_red_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.obj_red");
	if (forminfo->RenderMonster->Objects->obj_red_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->obj_red_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->obj_red_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Objects->obj_red));
	}
	else
	    _xvf_init_Master_warning("float selection 'obj_red' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->obj_red_selected = FALSE;
	forminfo->RenderMonster->Objects->obj_red_optsel = TRUE;

	forminfo->RenderMonster->Objects->obj_green_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.obj_green");
	if (forminfo->RenderMonster->Objects->obj_green_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->obj_green_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->obj_green_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Objects->obj_green));
	}
	else
	    _xvf_init_Master_warning("float selection 'obj_green' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->obj_green_selected = FALSE;
	forminfo->RenderMonster->Objects->obj_green_optsel = TRUE;

	forminfo->RenderMonster->Objects->obj_blue_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.obj_blue");
	if (forminfo->RenderMonster->Objects->obj_blue_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->obj_blue_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->obj_blue_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Objects->obj_blue));
	}
	else
	    _xvf_init_Master_warning("float selection 'obj_blue' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->obj_blue_selected = FALSE;
	forminfo->RenderMonster->Objects->obj_blue_optsel = TRUE;

	forminfo->RenderMonster->Objects->obj_alpha_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.obj_alpha");
	if (forminfo->RenderMonster->Objects->obj_alpha_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->obj_alpha_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->obj_alpha_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Objects->obj_alpha));
	}
	else
	    _xvf_init_Master_warning("float selection 'obj_alpha' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->obj_alpha_selected = FALSE;
	forminfo->RenderMonster->Objects->obj_alpha_optsel = TRUE;

	forminfo->RenderMonster->Objects->obj_ambient_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.obj_ambient");
	if (forminfo->RenderMonster->Objects->obj_ambient_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->obj_ambient_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->obj_ambient_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Objects->obj_ambient));
	}
	else
	    _xvf_init_Master_warning("float selection 'obj_ambient' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->obj_ambient_selected = FALSE;
	forminfo->RenderMonster->Objects->obj_ambient_optsel = TRUE;

	forminfo->RenderMonster->Objects->obj_diffuse_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.obj_diffuse");
	if (forminfo->RenderMonster->Objects->obj_diffuse_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->obj_diffuse_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->obj_diffuse_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Objects->obj_diffuse));
	}
	else
	    _xvf_init_Master_warning("float selection 'obj_diffuse' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->obj_diffuse_selected = FALSE;
	forminfo->RenderMonster->Objects->obj_diffuse_optsel = TRUE;

	forminfo->RenderMonster->Objects->obj_spec_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.obj_spec");
	if (forminfo->RenderMonster->Objects->obj_spec_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->obj_spec_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->obj_spec_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Objects->obj_spec));
	}
	else
	    _xvf_init_Master_warning("float selection 'obj_spec' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->obj_spec_selected = FALSE;
	forminfo->RenderMonster->Objects->obj_spec_optsel = TRUE;

	forminfo->RenderMonster->Objects->obj_spec_exp_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.obj_spec_exp");
	if (forminfo->RenderMonster->Objects->obj_spec_exp_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->obj_spec_exp_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->obj_spec_exp_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Objects->obj_spec_exp));
	}
	else
	    _xvf_init_Master_warning("float selection 'obj_spec_exp' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->obj_spec_exp_selected = FALSE;
	forminfo->RenderMonster->Objects->obj_spec_exp_optsel = TRUE;

	forminfo->RenderMonster->Objects->obj_spec_metal_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.obj_spec_metal");
	if (forminfo->RenderMonster->Objects->obj_spec_metal_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Objects->obj_spec_metal_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Objects->obj_spec_metal_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Objects->obj_spec_metal));
	}
	else
	    _xvf_init_Master_warning("float selection 'obj_spec_metal' on pane 'Objects' of subform 'RenderMonster'");

	forminfo->RenderMonster->Objects->obj_spec_metal_selected = FALSE;
	forminfo->RenderMonster->Objects->obj_spec_metal_optsel = TRUE;

	forminfo->RenderMonster->Objects->object_info_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.object_info");
	if (forminfo->RenderMonster->Objects->object_info_struct == NULL)
	    _xvf_init_Master_warning("pane action button 'object_info' on pane 'Objects' of subform 'RenderMonster'");
	forminfo->RenderMonster->Objects->object_info = FALSE;
	selection = forminfo->RenderMonster->Objects->object_info_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->RenderMonster->Objects->action1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.action1");
	if (forminfo->RenderMonster->Objects->action1_struct == NULL)
	    _xvf_init_Master_warning("pane action button 'action1' on pane 'Objects' of subform 'RenderMonster'");
	forminfo->RenderMonster->Objects->action1 = FALSE;
	selection = forminfo->RenderMonster->Objects->action1_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->RenderMonster->Objects->object_properties_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Objects.object_properties");
	if (forminfo->RenderMonster->Objects->object_properties_struct == NULL)
	    _xvf_init_Master_warning("blank selection 'object_properties' on pane 'Objects' of subform 'RenderMonster'");

	/*
	 * initializing 'Master->RenderMonster->Cameras' Pane Info structure
	 */

	forminfo->RenderMonster->Cameras = (RenderMonster_Cameras *)
				kcalloc(1, sizeof(RenderMonster_Cameras));
	forminfo->RenderMonster->Cameras_struct =
	    kvf_create_struct_from_panename(subform, "Master.RenderMonster.Cameras");
	if (forminfo->RenderMonster->Cameras_struct == NULL)
	{
	    _xvf_init_Master_error("pane 'Cameras' on subform 'RenderMonster'", "RenderMonster_Cameras");
	    return(FALSE);
	}
	pane = forminfo->RenderMonster->Cameras_struct->Controlptr;
	forminfo->RenderMonster->Cameras->projection_cycle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.projection_cycle");
	if (forminfo->RenderMonster->Cameras->projection_cycle_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->projection_cycle_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->projection_cycle_struct, KVF_CYCLE_VAL,
	                    &(forminfo->RenderMonster->Cameras->projection_cycle));
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->projection_cycle_struct, KVF_CYCLE_LABEL,
	                    &(forminfo->RenderMonster->Cameras->projection_cycle_label));
	}
	else
	    _xvf_init_Master_warning("cycle selection 'projection_cycle' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->projection_cycle_selected = FALSE;

	forminfo->RenderMonster->Cameras->eye_x_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.eye_x");
	if (forminfo->RenderMonster->Cameras->eye_x_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->eye_x_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->eye_x_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->eye_x));
	}
	else
	    _xvf_init_Master_warning("float selection 'eye_x' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->eye_x_selected = FALSE;
	forminfo->RenderMonster->Cameras->eye_x_optsel = TRUE;

	forminfo->RenderMonster->Cameras->up_x_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.up_x");
	if (forminfo->RenderMonster->Cameras->up_x_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->up_x_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->up_x_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->up_x));
	}
	else
	    _xvf_init_Master_warning("float selection 'up_x' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->up_x_selected = FALSE;
	forminfo->RenderMonster->Cameras->up_x_optsel = TRUE;

	forminfo->RenderMonster->Cameras->at_x_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.at_x");
	if (forminfo->RenderMonster->Cameras->at_x_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->at_x_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->at_x_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->at_x));
	}
	else
	    _xvf_init_Master_warning("float selection 'at_x' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->at_x_selected = FALSE;
	forminfo->RenderMonster->Cameras->at_x_optsel = TRUE;

	forminfo->RenderMonster->Cameras->eye_y_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.eye_y");
	if (forminfo->RenderMonster->Cameras->eye_y_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->eye_y_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->eye_y_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->eye_y));
	}
	else
	    _xvf_init_Master_warning("float selection 'eye_y' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->eye_y_selected = FALSE;
	forminfo->RenderMonster->Cameras->eye_y_optsel = TRUE;

	forminfo->RenderMonster->Cameras->up_y_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.up_y");
	if (forminfo->RenderMonster->Cameras->up_y_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->up_y_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->up_y_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->up_y));
	}
	else
	    _xvf_init_Master_warning("float selection 'up_y' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->up_y_selected = FALSE;
	forminfo->RenderMonster->Cameras->up_y_optsel = TRUE;

	forminfo->RenderMonster->Cameras->at_y_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.at_y");
	if (forminfo->RenderMonster->Cameras->at_y_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->at_y_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->at_y_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->at_y));
	}
	else
	    _xvf_init_Master_warning("float selection 'at_y' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->at_y_selected = FALSE;
	forminfo->RenderMonster->Cameras->at_y_optsel = TRUE;

	forminfo->RenderMonster->Cameras->eye_z_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.eye_z");
	if (forminfo->RenderMonster->Cameras->eye_z_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->eye_z_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->eye_z_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->eye_z));
	}
	else
	    _xvf_init_Master_warning("float selection 'eye_z' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->eye_z_selected = FALSE;
	forminfo->RenderMonster->Cameras->eye_z_optsel = TRUE;

	forminfo->RenderMonster->Cameras->up_z_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.up_z");
	if (forminfo->RenderMonster->Cameras->up_z_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->up_z_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->up_z_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->up_z));
	}
	else
	    _xvf_init_Master_warning("float selection 'up_z' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->up_z_selected = FALSE;
	forminfo->RenderMonster->Cameras->up_z_optsel = TRUE;

	forminfo->RenderMonster->Cameras->at_z_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.at_z");
	if (forminfo->RenderMonster->Cameras->at_z_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->at_z_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->at_z_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->at_z));
	}
	else
	    _xvf_init_Master_warning("float selection 'at_z' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->at_z_selected = FALSE;
	forminfo->RenderMonster->Cameras->at_z_optsel = TRUE;

	forminfo->RenderMonster->Cameras->hither_clip_form_loc_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.hither_clip_form_loc");
	if (forminfo->RenderMonster->Cameras->hither_clip_form_loc_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->hither_clip_form_loc_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->hither_clip_form_loc_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->hither_clip_form_loc));
	}
	else
	    _xvf_init_Master_warning("float selection 'hither_clip_form_loc' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->hither_clip_form_loc_selected = FALSE;
	forminfo->RenderMonster->Cameras->hither_clip_form_loc_optsel = TRUE;

	forminfo->RenderMonster->Cameras->yon_clip_form_loc_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.yon_clip_form_loc");
	if (forminfo->RenderMonster->Cameras->yon_clip_form_loc_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->yon_clip_form_loc_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->yon_clip_form_loc_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->yon_clip_form_loc));
	}
	else
	    _xvf_init_Master_warning("float selection 'yon_clip_form_loc' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->yon_clip_form_loc_selected = FALSE;
	forminfo->RenderMonster->Cameras->yon_clip_form_loc_optsel = TRUE;

	forminfo->RenderMonster->Cameras->back_clip_form_on_off_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.back_clip_form_on_off");
	if (forminfo->RenderMonster->Cameras->back_clip_form_on_off_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->back_clip_form_on_off_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->back_clip_form_on_off_struct, KVF_LOGIC_DEF,
	                    &(forminfo->RenderMonster->Cameras->back_clip_form_on_off));
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->back_clip_form_on_off_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->RenderMonster->Cameras->back_clip_form_on_off_label));
	}
	else
	    _xvf_init_Master_warning("logical selection 'back_clip_form_on_off' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->back_clip_form_on_off_selected = FALSE;

	forminfo->RenderMonster->Cameras->fov_input_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.fov_input");
	if (forminfo->RenderMonster->Cameras->fov_input_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->fov_input_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->fov_input_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->fov_input));
	}
	else
	    _xvf_init_Master_warning("float selection 'fov_input' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->fov_input_selected = FALSE;
	forminfo->RenderMonster->Cameras->fov_input_optsel = TRUE;

	forminfo->RenderMonster->Cameras->aspect_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.aspect");
	if (forminfo->RenderMonster->Cameras->aspect_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Cameras->aspect_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Cameras->aspect_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Cameras->aspect));
	}
	else
	    _xvf_init_Master_warning("float selection 'aspect' on pane 'Cameras' of subform 'RenderMonster'");

	forminfo->RenderMonster->Cameras->aspect_selected = FALSE;
	forminfo->RenderMonster->Cameras->aspect_optsel = TRUE;

	forminfo->RenderMonster->Cameras->normalize_cam_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.normalize_cam");
	if (forminfo->RenderMonster->Cameras->normalize_cam_struct == NULL)
	    _xvf_init_Master_warning("pane action button 'normalize_cam' on pane 'Cameras' of subform 'RenderMonster'");
	forminfo->RenderMonster->Cameras->normalize_cam = FALSE;
	selection = forminfo->RenderMonster->Cameras->normalize_cam_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->RenderMonster->Cameras->reset_camera_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.reset_camera");
	if (forminfo->RenderMonster->Cameras->reset_camera_struct == NULL)
	    _xvf_init_Master_warning("pane action button 'reset_camera' on pane 'Cameras' of subform 'RenderMonster'");
	forminfo->RenderMonster->Cameras->reset_camera = FALSE;
	selection = forminfo->RenderMonster->Cameras->reset_camera_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->RenderMonster->Cameras->normalize_camera_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.normalize_camera");
	if (forminfo->RenderMonster->Cameras->normalize_camera_struct == NULL)
	    _xvf_init_Master_warning("blank selection 'normalize_camera' on pane 'Cameras' of subform 'RenderMonster'");
	forminfo->RenderMonster->Cameras->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.blank1");
	if (forminfo->RenderMonster->Cameras->blank1_struct == NULL)
	    _xvf_init_Master_warning("blank selection 'blank1' on pane 'Cameras' of subform 'RenderMonster'");
	forminfo->RenderMonster->Cameras->blank2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.blank2");
	if (forminfo->RenderMonster->Cameras->blank2_struct == NULL)
	    _xvf_init_Master_warning("blank selection 'blank2' on pane 'Cameras' of subform 'RenderMonster'");
	forminfo->RenderMonster->Cameras->blank3_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.blank3");
	if (forminfo->RenderMonster->Cameras->blank3_struct == NULL)
	    _xvf_init_Master_warning("blank selection 'blank3' on pane 'Cameras' of subform 'RenderMonster'");
	forminfo->RenderMonster->Cameras->blank4_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Cameras.blank4");
	if (forminfo->RenderMonster->Cameras->blank4_struct == NULL)
	    _xvf_init_Master_warning("blank selection 'blank4' on pane 'Cameras' of subform 'RenderMonster'");

	/*
	 * initializing 'Master->RenderMonster->Lights' Pane Info structure
	 */

	forminfo->RenderMonster->Lights = (RenderMonster_Lights *)
				kcalloc(1, sizeof(RenderMonster_Lights));
	forminfo->RenderMonster->Lights_struct =
	    kvf_create_struct_from_panename(subform, "Master.RenderMonster.Lights");
	if (forminfo->RenderMonster->Lights_struct == NULL)
	{
	    _xvf_init_Master_error("pane 'Lights' on subform 'RenderMonster'", "RenderMonster_Lights");
	    return(FALSE);
	}
	pane = forminfo->RenderMonster->Lights_struct->Controlptr;
	forminfo->RenderMonster->Lights->light_list_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Lights.light_list");
	if (forminfo->RenderMonster->Lights->light_list_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Lights->light_list_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Lights->light_list_struct, KVF_LIST_VAL,
	                    &(forminfo->RenderMonster->Lights->light_list));
	    kvf_get_attribute(forminfo->RenderMonster->Lights->light_list_struct, KVF_LIST_LABEL,
	                    &(forminfo->RenderMonster->Lights->light_list_label));
	}
	else
	    _xvf_init_Master_warning("list selection 'light_list' on pane 'Lights' of subform 'RenderMonster'");

	forminfo->RenderMonster->Lights->light_list_selected = FALSE;

	forminfo->RenderMonster->Lights->light_onoff_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Lights.light_onoff");
	if (forminfo->RenderMonster->Lights->light_onoff_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Lights->light_onoff_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Lights->light_onoff_struct, KVF_LOGIC_DEF,
	                    &(forminfo->RenderMonster->Lights->light_onoff));
	    kvf_get_attribute(forminfo->RenderMonster->Lights->light_onoff_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->RenderMonster->Lights->light_onoff_label));
	}
	else
	    _xvf_init_Master_warning("logical selection 'light_onoff' on pane 'Lights' of subform 'RenderMonster'");

	forminfo->RenderMonster->Lights->light_onoff_selected = FALSE;

	forminfo->RenderMonster->Lights->light_type_list_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Lights.light_type_list");
	if (forminfo->RenderMonster->Lights->light_type_list_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Lights->light_type_list_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Lights->light_type_list_struct, KVF_LIST_VAL,
	                    &(forminfo->RenderMonster->Lights->light_type_list));
	    kvf_get_attribute(forminfo->RenderMonster->Lights->light_type_list_struct, KVF_LIST_LABEL,
	                    &(forminfo->RenderMonster->Lights->light_type_list_label));
	}
	else
	    _xvf_init_Master_warning("list selection 'light_type_list' on pane 'Lights' of subform 'RenderMonster'");

	forminfo->RenderMonster->Lights->light_type_list_selected = FALSE;

	forminfo->RenderMonster->Lights->light_position_string_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Lights.light_position_string");
	if (forminfo->RenderMonster->Lights->light_position_string_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Lights->light_position_string_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Lights->light_position_string_struct, KVF_STRING_DEF,
	                    &(forminfo->RenderMonster->Lights->light_position_string));
	}
	else
	    _xvf_init_Master_warning("string selection 'light_position_string' on pane 'Lights' of subform 'RenderMonster'");

	forminfo->RenderMonster->Lights->light_position_string_selected = FALSE;
	forminfo->RenderMonster->Lights->light_position_string_optsel = TRUE;

	forminfo->RenderMonster->Lights->light_direction_string_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Lights.light_direction_string");
	if (forminfo->RenderMonster->Lights->light_direction_string_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Lights->light_direction_string_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Lights->light_direction_string_struct, KVF_STRING_DEF,
	                    &(forminfo->RenderMonster->Lights->light_direction_string));
	}
	else
	    _xvf_init_Master_warning("string selection 'light_direction_string' on pane 'Lights' of subform 'RenderMonster'");

	forminfo->RenderMonster->Lights->light_direction_string_selected = FALSE;
	forminfo->RenderMonster->Lights->light_direction_string_optsel = TRUE;

	forminfo->RenderMonster->Lights->current_light_color_string_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Lights.current_light_color_string");
	if (forminfo->RenderMonster->Lights->current_light_color_string_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Lights->current_light_color_string_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Lights->current_light_color_string_struct, KVF_STRING_DEF,
	                    &(forminfo->RenderMonster->Lights->current_light_color_string));
	}
	else
	    _xvf_init_Master_warning("string selection 'current_light_color_string' on pane 'Lights' of subform 'RenderMonster'");

	forminfo->RenderMonster->Lights->current_light_color_string_selected = FALSE;
	forminfo->RenderMonster->Lights->current_light_color_string_optsel = TRUE;

	forminfo->RenderMonster->Lights->ambient_light_color_string_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Lights.ambient_light_color_string");
	if (forminfo->RenderMonster->Lights->ambient_light_color_string_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Lights->ambient_light_color_string_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Lights->ambient_light_color_string_struct, KVF_STRING_DEF,
	                    &(forminfo->RenderMonster->Lights->ambient_light_color_string));
	}
	else
	    _xvf_init_Master_warning("string selection 'ambient_light_color_string' on pane 'Lights' of subform 'RenderMonster'");

	forminfo->RenderMonster->Lights->ambient_light_color_string_selected = FALSE;
	forminfo->RenderMonster->Lights->ambient_light_color_string_optsel = TRUE;


	/*
	 * initializing 'Master->RenderMonster->Imaging' Pane Info structure
	 */

	forminfo->RenderMonster->Imaging = (RenderMonster_Imaging *)
				kcalloc(1, sizeof(RenderMonster_Imaging));
	forminfo->RenderMonster->Imaging_struct =
	    kvf_create_struct_from_panename(subform, "Master.RenderMonster.Imaging");
	if (forminfo->RenderMonster->Imaging_struct == NULL)
	{
	    _xvf_init_Master_error("pane 'Imaging' on subform 'RenderMonster'", "RenderMonster_Imaging");
	    return(FALSE);
	}
	pane = forminfo->RenderMonster->Imaging_struct->Controlptr;
	forminfo->RenderMonster->Imaging->image_width_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.image_width");
	if (forminfo->RenderMonster->Imaging->image_width_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->image_width_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->image_width_struct, KVF_INT_DEF,
	                    &(forminfo->RenderMonster->Imaging->image_width));
	}
	else
	    _xvf_init_Master_warning("integer selection 'image_width' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->image_width_selected = FALSE;
	forminfo->RenderMonster->Imaging->image_width_optsel = TRUE;

	forminfo->RenderMonster->Imaging->image_height_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.image_height");
	if (forminfo->RenderMonster->Imaging->image_height_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->image_height_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->image_height_struct, KVF_INT_DEF,
	                    &(forminfo->RenderMonster->Imaging->image_height));
	}
	else
	    _xvf_init_Master_warning("integer selection 'image_height' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->image_height_selected = FALSE;
	forminfo->RenderMonster->Imaging->image_height_optsel = TRUE;

	forminfo->RenderMonster->Imaging->image_display_choice_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.image_display_choice");
	if (forminfo->RenderMonster->Imaging->image_display_choice_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->image_display_choice_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->image_display_choice_struct, KVF_LIST_VAL,
	                    &(forminfo->RenderMonster->Imaging->image_display_choice));
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->image_display_choice_struct, KVF_LIST_LABEL,
	                    &(forminfo->RenderMonster->Imaging->image_display_choice_label));
	}
	else
	    _xvf_init_Master_warning("list selection 'image_display_choice' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->image_display_choice_selected = FALSE;

	forminfo->RenderMonster->Imaging->red_background_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.red_background");
	if (forminfo->RenderMonster->Imaging->red_background_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->red_background_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->red_background_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Imaging->red_background));
	}
	else
	    _xvf_init_Master_warning("float selection 'red_background' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->red_background_selected = FALSE;
	forminfo->RenderMonster->Imaging->red_background_optsel = TRUE;

	forminfo->RenderMonster->Imaging->green_background_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.green_background");
	if (forminfo->RenderMonster->Imaging->green_background_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->green_background_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->green_background_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Imaging->green_background));
	}
	else
	    _xvf_init_Master_warning("float selection 'green_background' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->green_background_selected = FALSE;
	forminfo->RenderMonster->Imaging->green_background_optsel = TRUE;

	forminfo->RenderMonster->Imaging->blue_background_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.blue_background");
	if (forminfo->RenderMonster->Imaging->blue_background_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->blue_background_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->blue_background_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Imaging->blue_background));
	}
	else
	    _xvf_init_Master_warning("float selection 'blue_background' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->blue_background_selected = FALSE;
	forminfo->RenderMonster->Imaging->blue_background_optsel = TRUE;

	forminfo->RenderMonster->Imaging->renderer_choice_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.renderer_choice");
	if (forminfo->RenderMonster->Imaging->renderer_choice_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->renderer_choice_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->renderer_choice_struct, KVF_LIST_VAL,
	                    &(forminfo->RenderMonster->Imaging->renderer_choice));
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->renderer_choice_struct, KVF_LIST_LABEL,
	                    &(forminfo->RenderMonster->Imaging->renderer_choice_label));
	}
	else
	    _xvf_init_Master_warning("list selection 'renderer_choice' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->renderer_choice_selected = FALSE;

	forminfo->RenderMonster->Imaging->transparency_choice_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.transparency_choice");
	if (forminfo->RenderMonster->Imaging->transparency_choice_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->transparency_choice_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->transparency_choice_struct, KVF_LIST_VAL,
	                    &(forminfo->RenderMonster->Imaging->transparency_choice));
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->transparency_choice_struct, KVF_LIST_LABEL,
	                    &(forminfo->RenderMonster->Imaging->transparency_choice_label));
	}
	else
	    _xvf_init_Master_warning("list selection 'transparency_choice' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->transparency_choice_selected = FALSE;

	forminfo->RenderMonster->Imaging->invoke_renderer_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.invoke_renderer");
	if (forminfo->RenderMonster->Imaging->invoke_renderer_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->invoke_renderer_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->invoke_renderer_struct, KVF_LOGIC_DEF,
	                    &(forminfo->RenderMonster->Imaging->invoke_renderer));
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->invoke_renderer_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->RenderMonster->Imaging->invoke_renderer_label));
	}
	else
	    _xvf_init_Master_warning("logical selection 'invoke_renderer' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->invoke_renderer_selected = FALSE;

	forminfo->RenderMonster->Imaging->antialias_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.antialias");
	if (forminfo->RenderMonster->Imaging->antialias_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Imaging->antialias_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->antialias_struct, KVF_LOGIC_DEF,
	                    &(forminfo->RenderMonster->Imaging->antialias));
	    kvf_get_attribute(forminfo->RenderMonster->Imaging->antialias_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->RenderMonster->Imaging->antialias_label));
	}
	else
	    _xvf_init_Master_warning("logical selection 'antialias' on pane 'Imaging' of subform 'RenderMonster'");

	forminfo->RenderMonster->Imaging->antialias_selected = FALSE;

	forminfo->RenderMonster->Imaging->render_controls_label_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.render_controls_label");
	if (forminfo->RenderMonster->Imaging->render_controls_label_struct == NULL)
	    _xvf_init_Master_warning("blank selection 'render_controls_label' on pane 'Imaging' of subform 'RenderMonster'");
	forminfo->RenderMonster->Imaging->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Imaging.blank1");
	if (forminfo->RenderMonster->Imaging->blank1_struct == NULL)
	    _xvf_init_Master_warning("blank selection 'blank1' on pane 'Imaging' of subform 'RenderMonster'");

	/*
	 * initializing 'Master->RenderMonster->Transformations' Pane Info structure
	 */

	forminfo->RenderMonster->Transformations = (RenderMonster_Transformations *)
				kcalloc(1, sizeof(RenderMonster_Transformations));
	forminfo->RenderMonster->Transformations_struct =
	    kvf_create_struct_from_panename(subform, "Master.RenderMonster.Transformations");
	if (forminfo->RenderMonster->Transformations_struct == NULL)
	{
	    _xvf_init_Master_error("pane 'Transformations' on subform 'RenderMonster'", "RenderMonster_Transformations");
	    return(FALSE);
	}
	pane = forminfo->RenderMonster->Transformations_struct->Controlptr;
	forminfo->RenderMonster->Transformations->x_rotate_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Transformations.x_rotate");
	if (forminfo->RenderMonster->Transformations->x_rotate_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Transformations->x_rotate_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Transformations->x_rotate_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Transformations->x_rotate));
	}
	else
	    _xvf_init_Master_warning("float selection 'x_rotate' on pane 'Transformations' of subform 'RenderMonster'");

	forminfo->RenderMonster->Transformations->x_rotate_selected = FALSE;
	forminfo->RenderMonster->Transformations->x_rotate_optsel = TRUE;

	forminfo->RenderMonster->Transformations->y_rotate_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Transformations.y_rotate");
	if (forminfo->RenderMonster->Transformations->y_rotate_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Transformations->y_rotate_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Transformations->y_rotate_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Transformations->y_rotate));
	}
	else
	    _xvf_init_Master_warning("float selection 'y_rotate' on pane 'Transformations' of subform 'RenderMonster'");

	forminfo->RenderMonster->Transformations->y_rotate_selected = FALSE;
	forminfo->RenderMonster->Transformations->y_rotate_optsel = TRUE;

	forminfo->RenderMonster->Transformations->z_rotate_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Transformations.z_rotate");
	if (forminfo->RenderMonster->Transformations->z_rotate_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Transformations->z_rotate_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Transformations->z_rotate_struct, KVF_FLOAT_DEF,
	                    &(forminfo->RenderMonster->Transformations->z_rotate));
	}
	else
	    _xvf_init_Master_warning("float selection 'z_rotate' on pane 'Transformations' of subform 'RenderMonster'");

	forminfo->RenderMonster->Transformations->z_rotate_selected = FALSE;
	forminfo->RenderMonster->Transformations->z_rotate_optsel = TRUE;

	forminfo->RenderMonster->Transformations->center_point_string_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Transformations.center_point_string");
	if (forminfo->RenderMonster->Transformations->center_point_string_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Transformations->center_point_string_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Transformations->center_point_string_struct, KVF_STRING_DEF,
	                    &(forminfo->RenderMonster->Transformations->center_point_string));
	}
	else
	    _xvf_init_Master_warning("string selection 'center_point_string' on pane 'Transformations' of subform 'RenderMonster'");

	forminfo->RenderMonster->Transformations->center_point_string_selected = FALSE;
	forminfo->RenderMonster->Transformations->center_point_string_optsel = TRUE;

	forminfo->RenderMonster->Transformations->translate_vector_string_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Transformations.translate_vector_string");
	if (forminfo->RenderMonster->Transformations->translate_vector_string_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Transformations->translate_vector_string_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Transformations->translate_vector_string_struct, KVF_STRING_DEF,
	                    &(forminfo->RenderMonster->Transformations->translate_vector_string));
	}
	else
	    _xvf_init_Master_warning("string selection 'translate_vector_string' on pane 'Transformations' of subform 'RenderMonster'");

	forminfo->RenderMonster->Transformations->translate_vector_string_selected = FALSE;
	forminfo->RenderMonster->Transformations->translate_vector_string_optsel = TRUE;

	forminfo->RenderMonster->Transformations->xyz_scale_string_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Transformations.xyz_scale_string");
	if (forminfo->RenderMonster->Transformations->xyz_scale_string_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Transformations->xyz_scale_string_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Transformations->xyz_scale_string_struct, KVF_STRING_DEF,
	                    &(forminfo->RenderMonster->Transformations->xyz_scale_string));
	}
	else
	    _xvf_init_Master_warning("string selection 'xyz_scale_string' on pane 'Transformations' of subform 'RenderMonster'");

	forminfo->RenderMonster->Transformations->xyz_scale_string_selected = FALSE;
	forminfo->RenderMonster->Transformations->xyz_scale_string_optsel = TRUE;

	forminfo->RenderMonster->Transformations->transformation_mode_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Transformations.transformation_mode");
	if (forminfo->RenderMonster->Transformations->transformation_mode_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Transformations->transformation_mode_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Transformations->transformation_mode_struct, KVF_LOGIC_DEF,
	                    &(forminfo->RenderMonster->Transformations->transformation_mode));
	    kvf_get_attribute(forminfo->RenderMonster->Transformations->transformation_mode_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->RenderMonster->Transformations->transformation_mode_label));
	}
	else
	    _xvf_init_Master_warning("logical selection 'transformation_mode' on pane 'Transformations' of subform 'RenderMonster'");

	forminfo->RenderMonster->Transformations->transformation_mode_selected = FALSE;


	/*
	 * initializing 'Master->RenderMonster->Input' Pane Info structure
	 */

	forminfo->RenderMonster->Input = (RenderMonster_Input *)
				kcalloc(1, sizeof(RenderMonster_Input));
	forminfo->RenderMonster->Input_struct =
	    kvf_create_struct_from_panename(subform, "Master.RenderMonster.Input");
	if (forminfo->RenderMonster->Input_struct == NULL)
	{
	    _xvf_init_Master_error("pane 'Input' on subform 'RenderMonster'", "RenderMonster_Input");
	    return(FALSE);
	}
	pane = forminfo->RenderMonster->Input_struct->Controlptr;
	forminfo->RenderMonster->Input->input_object_1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Input.input_object_1");
	if (forminfo->RenderMonster->Input->input_object_1_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Input->input_object_1_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Input->input_object_1_struct, KVF_FILE_DEF,
	                    &(forminfo->RenderMonster->Input->input_object_1));
	}
	else
	    _xvf_init_Master_warning("input selection 'input_object_1' on pane 'Input' of subform 'RenderMonster'");

	forminfo->RenderMonster->Input->input_object_1_selected = FALSE;
	forminfo->RenderMonster->Input->input_object_1_optsel = FALSE;

	forminfo->RenderMonster->Input->input_object_2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Input.input_object_2");
	if (forminfo->RenderMonster->Input->input_object_2_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Input->input_object_2_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Input->input_object_2_struct, KVF_FILE_DEF,
	                    &(forminfo->RenderMonster->Input->input_object_2));
	}
	else
	    _xvf_init_Master_warning("input selection 'input_object_2' on pane 'Input' of subform 'RenderMonster'");

	forminfo->RenderMonster->Input->input_object_2_selected = FALSE;
	forminfo->RenderMonster->Input->input_object_2_optsel = FALSE;

	forminfo->RenderMonster->Input->input_object_3_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Input.input_object_3");
	if (forminfo->RenderMonster->Input->input_object_3_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Input->input_object_3_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Input->input_object_3_struct, KVF_FILE_DEF,
	                    &(forminfo->RenderMonster->Input->input_object_3));
	}
	else
	    _xvf_init_Master_warning("input selection 'input_object_3' on pane 'Input' of subform 'RenderMonster'");

	forminfo->RenderMonster->Input->input_object_3_selected = FALSE;
	forminfo->RenderMonster->Input->input_object_3_optsel = FALSE;

	forminfo->RenderMonster->Input->input_object_4_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Input.input_object_4");
	if (forminfo->RenderMonster->Input->input_object_4_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Input->input_object_4_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Input->input_object_4_struct, KVF_FILE_DEF,
	                    &(forminfo->RenderMonster->Input->input_object_4));
	}
	else
	    _xvf_init_Master_warning("input selection 'input_object_4' on pane 'Input' of subform 'RenderMonster'");

	forminfo->RenderMonster->Input->input_object_4_selected = FALSE;
	forminfo->RenderMonster->Input->input_object_4_optsel = FALSE;


	/*
	 * initializing 'Master->RenderMonster->Output' Pane Info structure
	 */

	forminfo->RenderMonster->Output = (RenderMonster_Output *)
				kcalloc(1, sizeof(RenderMonster_Output));
	forminfo->RenderMonster->Output_struct =
	    kvf_create_struct_from_panename(subform, "Master.RenderMonster.Output");
	if (forminfo->RenderMonster->Output_struct == NULL)
	{
	    _xvf_init_Master_error("pane 'Output' on subform 'RenderMonster'", "RenderMonster_Output");
	    return(FALSE);
	}
	pane = forminfo->RenderMonster->Output_struct->Controlptr;
	forminfo->RenderMonster->Output->output_image_fname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "Master.RenderMonster.Output.output_image_fname");
	if (forminfo->RenderMonster->Output->output_image_fname_struct != NULL)
	{
	    selection = forminfo->RenderMonster->Output->output_image_fname_struct->Selptr;
	    kvf_get_attribute(forminfo->RenderMonster->Output->output_image_fname_struct, KVF_FILE_DEF,
	                    &(forminfo->RenderMonster->Output->output_image_fname));
	}
	else
	    _xvf_init_Master_warning("output selection 'output_image_fname' on pane 'Output' of subform 'RenderMonster'");

	forminfo->RenderMonster->Output->output_image_fname_selected = FALSE;
	forminfo->RenderMonster->Output->output_image_fname_optsel = FALSE;


	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_Master_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 15, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_Master_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_Master_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 15, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_Master_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_Master
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_Master_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 15, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_Master(
    gui_info_struct *forminfo)
{
	if (forminfo->RenderMonster->license_struct != NULL)
	    kfree(forminfo->RenderMonster->license_struct);
	if (forminfo->RenderMonster->help_struct != NULL)
	    kfree(forminfo->RenderMonster->help_struct);
	if (forminfo->RenderMonster->quit_struct != NULL)
	    kfree(forminfo->RenderMonster->quit_struct);
	if (forminfo->RenderMonster->refresh_struct != NULL)
	    kfree(forminfo->RenderMonster->refresh_struct);
	if (forminfo->RenderMonster->b0_struct != NULL)
	    kfree(forminfo->RenderMonster->b0_struct);
	if (forminfo->RenderMonster->Objects->current_object_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->current_object_struct);
	kfree(forminfo->RenderMonster->Objects->current_object_label);
	if (forminfo->RenderMonster->Objects->object_shader_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->object_shader_struct);
	kfree(forminfo->RenderMonster->Objects->object_shader_label);
	if (forminfo->RenderMonster->Objects->post_obj_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->post_obj_struct);
	kfree(forminfo->RenderMonster->Objects->post_obj_label);
	if (forminfo->RenderMonster->Objects->obj_red_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->obj_red_struct);
	if (forminfo->RenderMonster->Objects->obj_green_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->obj_green_struct);
	if (forminfo->RenderMonster->Objects->obj_blue_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->obj_blue_struct);
	if (forminfo->RenderMonster->Objects->obj_alpha_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->obj_alpha_struct);
	if (forminfo->RenderMonster->Objects->obj_ambient_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->obj_ambient_struct);
	if (forminfo->RenderMonster->Objects->obj_diffuse_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->obj_diffuse_struct);
	if (forminfo->RenderMonster->Objects->obj_spec_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->obj_spec_struct);
	if (forminfo->RenderMonster->Objects->obj_spec_exp_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->obj_spec_exp_struct);
	if (forminfo->RenderMonster->Objects->obj_spec_metal_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->obj_spec_metal_struct);
	if (forminfo->RenderMonster->Objects->object_info_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->object_info_struct);
	if (forminfo->RenderMonster->Objects->action1_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->action1_struct);
	if (forminfo->RenderMonster->Objects->object_properties_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects->object_properties_struct);
	kfree(forminfo->RenderMonster->Objects);
	if (forminfo->RenderMonster->Objects_struct != NULL)
	    kfree(forminfo->RenderMonster->Objects_struct);

	if (forminfo->RenderMonster->Cameras->projection_cycle_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->projection_cycle_struct);
	kfree(forminfo->RenderMonster->Cameras->projection_cycle_label);
	if (forminfo->RenderMonster->Cameras->eye_x_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->eye_x_struct);
	if (forminfo->RenderMonster->Cameras->up_x_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->up_x_struct);
	if (forminfo->RenderMonster->Cameras->at_x_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->at_x_struct);
	if (forminfo->RenderMonster->Cameras->eye_y_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->eye_y_struct);
	if (forminfo->RenderMonster->Cameras->up_y_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->up_y_struct);
	if (forminfo->RenderMonster->Cameras->at_y_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->at_y_struct);
	if (forminfo->RenderMonster->Cameras->eye_z_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->eye_z_struct);
	if (forminfo->RenderMonster->Cameras->up_z_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->up_z_struct);
	if (forminfo->RenderMonster->Cameras->at_z_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->at_z_struct);
	if (forminfo->RenderMonster->Cameras->hither_clip_form_loc_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->hither_clip_form_loc_struct);
	if (forminfo->RenderMonster->Cameras->yon_clip_form_loc_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->yon_clip_form_loc_struct);
	if (forminfo->RenderMonster->Cameras->back_clip_form_on_off_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->back_clip_form_on_off_struct);
	kfree(forminfo->RenderMonster->Cameras->back_clip_form_on_off_label);
	if (forminfo->RenderMonster->Cameras->fov_input_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->fov_input_struct);
	if (forminfo->RenderMonster->Cameras->aspect_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->aspect_struct);
	if (forminfo->RenderMonster->Cameras->normalize_cam_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->normalize_cam_struct);
	if (forminfo->RenderMonster->Cameras->reset_camera_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->reset_camera_struct);
	if (forminfo->RenderMonster->Cameras->normalize_camera_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->normalize_camera_struct);
	if (forminfo->RenderMonster->Cameras->blank1_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->blank1_struct);
	if (forminfo->RenderMonster->Cameras->blank2_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->blank2_struct);
	if (forminfo->RenderMonster->Cameras->blank3_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->blank3_struct);
	if (forminfo->RenderMonster->Cameras->blank4_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras->blank4_struct);
	kfree(forminfo->RenderMonster->Cameras);
	if (forminfo->RenderMonster->Cameras_struct != NULL)
	    kfree(forminfo->RenderMonster->Cameras_struct);

	if (forminfo->RenderMonster->Lights->light_list_struct != NULL)
	    kfree(forminfo->RenderMonster->Lights->light_list_struct);
	kfree(forminfo->RenderMonster->Lights->light_list_label);
	if (forminfo->RenderMonster->Lights->light_onoff_struct != NULL)
	    kfree(forminfo->RenderMonster->Lights->light_onoff_struct);
	kfree(forminfo->RenderMonster->Lights->light_onoff_label);
	if (forminfo->RenderMonster->Lights->light_type_list_struct != NULL)
	    kfree(forminfo->RenderMonster->Lights->light_type_list_struct);
	kfree(forminfo->RenderMonster->Lights->light_type_list_label);
	kfree(forminfo->RenderMonster->Lights->light_position_string);
	if (forminfo->RenderMonster->Lights->light_position_string_struct != NULL)
	    kfree(forminfo->RenderMonster->Lights->light_position_string_struct);
	kfree(forminfo->RenderMonster->Lights->light_direction_string);
	if (forminfo->RenderMonster->Lights->light_direction_string_struct != NULL)
	    kfree(forminfo->RenderMonster->Lights->light_direction_string_struct);
	kfree(forminfo->RenderMonster->Lights->current_light_color_string);
	if (forminfo->RenderMonster->Lights->current_light_color_string_struct != NULL)
	    kfree(forminfo->RenderMonster->Lights->current_light_color_string_struct);
	kfree(forminfo->RenderMonster->Lights->ambient_light_color_string);
	if (forminfo->RenderMonster->Lights->ambient_light_color_string_struct != NULL)
	    kfree(forminfo->RenderMonster->Lights->ambient_light_color_string_struct);
	kfree(forminfo->RenderMonster->Lights);
	if (forminfo->RenderMonster->Lights_struct != NULL)
	    kfree(forminfo->RenderMonster->Lights_struct);

	if (forminfo->RenderMonster->Imaging->image_width_struct != NULL)
	     kfree(forminfo->RenderMonster->Imaging->image_width_struct);
	if (forminfo->RenderMonster->Imaging->image_height_struct != NULL)
	     kfree(forminfo->RenderMonster->Imaging->image_height_struct);
	if (forminfo->RenderMonster->Imaging->image_display_choice_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->image_display_choice_struct);
	kfree(forminfo->RenderMonster->Imaging->image_display_choice_label);
	if (forminfo->RenderMonster->Imaging->red_background_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->red_background_struct);
	if (forminfo->RenderMonster->Imaging->green_background_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->green_background_struct);
	if (forminfo->RenderMonster->Imaging->blue_background_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->blue_background_struct);
	if (forminfo->RenderMonster->Imaging->renderer_choice_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->renderer_choice_struct);
	kfree(forminfo->RenderMonster->Imaging->renderer_choice_label);
	if (forminfo->RenderMonster->Imaging->transparency_choice_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->transparency_choice_struct);
	kfree(forminfo->RenderMonster->Imaging->transparency_choice_label);
	if (forminfo->RenderMonster->Imaging->invoke_renderer_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->invoke_renderer_struct);
	kfree(forminfo->RenderMonster->Imaging->invoke_renderer_label);
	if (forminfo->RenderMonster->Imaging->antialias_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->antialias_struct);
	kfree(forminfo->RenderMonster->Imaging->antialias_label);
	if (forminfo->RenderMonster->Imaging->render_controls_label_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->render_controls_label_struct);
	if (forminfo->RenderMonster->Imaging->blank1_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging->blank1_struct);
	kfree(forminfo->RenderMonster->Imaging);
	if (forminfo->RenderMonster->Imaging_struct != NULL)
	    kfree(forminfo->RenderMonster->Imaging_struct);

	if (forminfo->RenderMonster->Transformations->x_rotate_struct != NULL)
	    kfree(forminfo->RenderMonster->Transformations->x_rotate_struct);
	if (forminfo->RenderMonster->Transformations->y_rotate_struct != NULL)
	    kfree(forminfo->RenderMonster->Transformations->y_rotate_struct);
	if (forminfo->RenderMonster->Transformations->z_rotate_struct != NULL)
	    kfree(forminfo->RenderMonster->Transformations->z_rotate_struct);
	kfree(forminfo->RenderMonster->Transformations->center_point_string);
	if (forminfo->RenderMonster->Transformations->center_point_string_struct != NULL)
	    kfree(forminfo->RenderMonster->Transformations->center_point_string_struct);
	kfree(forminfo->RenderMonster->Transformations->translate_vector_string);
	if (forminfo->RenderMonster->Transformations->translate_vector_string_struct != NULL)
	    kfree(forminfo->RenderMonster->Transformations->translate_vector_string_struct);
	kfree(forminfo->RenderMonster->Transformations->xyz_scale_string);
	if (forminfo->RenderMonster->Transformations->xyz_scale_string_struct != NULL)
	    kfree(forminfo->RenderMonster->Transformations->xyz_scale_string_struct);
	if (forminfo->RenderMonster->Transformations->transformation_mode_struct != NULL)
	    kfree(forminfo->RenderMonster->Transformations->transformation_mode_struct);
	kfree(forminfo->RenderMonster->Transformations->transformation_mode_label);
	kfree(forminfo->RenderMonster->Transformations);
	if (forminfo->RenderMonster->Transformations_struct != NULL)
	    kfree(forminfo->RenderMonster->Transformations_struct);

	kfree(forminfo->RenderMonster->Input->input_object_1);
	if (forminfo->RenderMonster->Input->input_object_1_struct != NULL)
	    kfree(forminfo->RenderMonster->Input->input_object_1_struct);
	kfree(forminfo->RenderMonster->Input->input_object_2);
	if (forminfo->RenderMonster->Input->input_object_2_struct != NULL)
	    kfree(forminfo->RenderMonster->Input->input_object_2_struct);
	kfree(forminfo->RenderMonster->Input->input_object_3);
	if (forminfo->RenderMonster->Input->input_object_3_struct != NULL)
	    kfree(forminfo->RenderMonster->Input->input_object_3_struct);
	kfree(forminfo->RenderMonster->Input->input_object_4);
	if (forminfo->RenderMonster->Input->input_object_4_struct != NULL)
	    kfree(forminfo->RenderMonster->Input->input_object_4_struct);
	kfree(forminfo->RenderMonster->Input);
	if (forminfo->RenderMonster->Input_struct != NULL)
	    kfree(forminfo->RenderMonster->Input_struct);

	kfree(forminfo->RenderMonster->Output->output_image_fname);
	if (forminfo->RenderMonster->Output->output_image_fname_struct != NULL)
	    kfree(forminfo->RenderMonster->Output->output_image_fname_struct);
	kfree(forminfo->RenderMonster->Output);
	if (forminfo->RenderMonster->Output_struct != NULL)
	    kfree(forminfo->RenderMonster->Output_struct);


	if (forminfo->RenderMonster_struct != NULL)
	    kfree(forminfo->RenderMonster_struct);
	kfree(forminfo->RenderMonster);
	kfree(forminfo);
}
