 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_Master
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_RenderMonster
   >>>> 	_xvf_get_Objects
   >>>> 	_xvf_get_Cameras
   >>>> 	_xvf_get_Lights
   >>>> 	_xvf_get_Imaging
   >>>> 	_xvf_get_Transformations
   >>>> 	_xvf_get_Input
   >>>> 	_xvf_get_Output
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Master
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Master(
     gui_info_struct *forminfo)
{
	ksubform   *subform;
	if (forminfo->RenderMonster_struct != NULL)
	{
	    subform = forminfo->RenderMonster_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->RenderMonster_selected));
	    _xvf_get_RenderMonster(forminfo->RenderMonster);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_RenderMonster
| 
|       Purpose: Extracts information from RenderMonster subform
| 
|         Input: subforminfo - pointer to Master_RenderMonster structure
| 
|        Output: none
|    Written By: conductor -name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_RenderMonster(
     Master_RenderMonster *subforminfo)
{
	kselection *selection;
	kcontrol   *pane;
	if (subforminfo->quit_struct != NULL)
	{
	    selection = subforminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->quit));

	}

	if (subforminfo->refresh_struct != NULL)
	{
	    selection = subforminfo->refresh_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->refresh));

	}

	if (subforminfo->Objects_struct != NULL)
	{
	    pane = subforminfo->Objects_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->Objects_selected));
	    _xvf_get_Objects(subforminfo->Objects);
	}

	if (subforminfo->Cameras_struct != NULL)
	{
	    pane = subforminfo->Cameras_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->Cameras_selected));
	    _xvf_get_Cameras(subforminfo->Cameras);
	}

	if (subforminfo->Lights_struct != NULL)
	{
	    pane = subforminfo->Lights_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->Lights_selected));
	    _xvf_get_Lights(subforminfo->Lights);
	}

	if (subforminfo->Imaging_struct != NULL)
	{
	    pane = subforminfo->Imaging_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->Imaging_selected));
	    _xvf_get_Imaging(subforminfo->Imaging);
	}

	if (subforminfo->Transformations_struct != NULL)
	{
	    pane = subforminfo->Transformations_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->Transformations_selected));
	    _xvf_get_Transformations(subforminfo->Transformations);
	}

	if (subforminfo->Input_struct != NULL)
	{
	    pane = subforminfo->Input_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->Input_selected));
	    _xvf_get_Input(subforminfo->Input);
	}

	if (subforminfo->Output_struct != NULL)
	{
	    pane = subforminfo->Output_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->Output_selected));
	    _xvf_get_Output(subforminfo->Output);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Objects
| 
|       Purpose: Extracts information from Objects pane
| 
|         Input: paneinfo - pointer to RenderMonster_Objects structure
| 
|        Output: none
|    Written By: conductor -name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Objects(
     RenderMonster_Objects *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'Master->RenderMonster->Objects' Pane Info structure
	 */

	if (paneinfo->current_object_struct != NULL)
	{
	    selection = paneinfo->current_object_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->current_object));
	    if (paneinfo->current_object_label != NULL) kfree(paneinfo->current_object_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->current_object_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->current_object_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->current_object_optsel));
	    }

	}

	if (paneinfo->object_shader_struct != NULL)
	{
	    selection = paneinfo->object_shader_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->object_shader));
	    if (paneinfo->object_shader_label != NULL) kfree(paneinfo->object_shader_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->object_shader_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->object_shader_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->object_shader_optsel));
	    }

	}

	if (paneinfo->post_obj_struct != NULL)
	{
	   selection = paneinfo->post_obj_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->post_obj));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->post_obj_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->post_obj_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->post_obj_optsel));
	    }

	}

	if (paneinfo->obj_red_struct != NULL)
	{
	    selection = paneinfo->obj_red_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->obj_red));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->obj_red_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->obj_red_optsel));
	    }

	}

	if (paneinfo->obj_green_struct != NULL)
	{
	    selection = paneinfo->obj_green_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->obj_green));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->obj_green_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->obj_green_optsel));
	    }

	}

	if (paneinfo->obj_blue_struct != NULL)
	{
	    selection = paneinfo->obj_blue_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->obj_blue));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->obj_blue_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->obj_blue_optsel));
	    }

	}

	if (paneinfo->obj_alpha_struct != NULL)
	{
	    selection = paneinfo->obj_alpha_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->obj_alpha));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->obj_alpha_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->obj_alpha_optsel));
	    }

	}

	if (paneinfo->obj_ambient_struct != NULL)
	{
	    selection = paneinfo->obj_ambient_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->obj_ambient));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->obj_ambient_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->obj_ambient_optsel));
	    }

	}

	if (paneinfo->obj_diffuse_struct != NULL)
	{
	    selection = paneinfo->obj_diffuse_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->obj_diffuse));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->obj_diffuse_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->obj_diffuse_optsel));
	    }

	}

	if (paneinfo->obj_spec_struct != NULL)
	{
	    selection = paneinfo->obj_spec_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->obj_spec));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->obj_spec_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->obj_spec_optsel));
	    }

	}

	if (paneinfo->obj_spec_exp_struct != NULL)
	{
	    selection = paneinfo->obj_spec_exp_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->obj_spec_exp));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->obj_spec_exp_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->obj_spec_exp_optsel));
	    }

	}

	if (paneinfo->obj_spec_metal_struct != NULL)
	{
	    selection = paneinfo->obj_spec_metal_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->obj_spec_metal));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->obj_spec_metal_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->obj_spec_metal_optsel));
	    }

	}

	if (paneinfo->object_info_struct != NULL)
	{
	    selection = paneinfo->object_info_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->object_info));

	}

	if (paneinfo->action1_struct != NULL)
	{
	    selection = paneinfo->action1_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->action1));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Cameras
| 
|       Purpose: Extracts information from Cameras pane
| 
|         Input: paneinfo - pointer to RenderMonster_Cameras structure
| 
|        Output: none
|    Written By: conductor -name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Cameras(
     RenderMonster_Cameras *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'Master->RenderMonster->Cameras' Pane Info structure
	 */

	if (paneinfo->projection_cycle_struct != NULL)
	{
	    selection = paneinfo->projection_cycle_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_VAL,
	                    &(paneinfo->projection_cycle));
	    if (paneinfo->projection_cycle_label != NULL) kfree(paneinfo->projection_cycle_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_LABEL,
	                    &(paneinfo->projection_cycle_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->projection_cycle_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->projection_cycle_optsel));
	    }

	}

	if (paneinfo->eye_x_struct != NULL)
	{
	    selection = paneinfo->eye_x_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->eye_x));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->eye_x_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->eye_x_optsel));
	    }

	}

	if (paneinfo->up_x_struct != NULL)
	{
	    selection = paneinfo->up_x_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->up_x));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->up_x_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->up_x_optsel));
	    }

	}

	if (paneinfo->at_x_struct != NULL)
	{
	    selection = paneinfo->at_x_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->at_x));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->at_x_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->at_x_optsel));
	    }

	}

	if (paneinfo->eye_y_struct != NULL)
	{
	    selection = paneinfo->eye_y_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->eye_y));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->eye_y_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->eye_y_optsel));
	    }

	}

	if (paneinfo->up_y_struct != NULL)
	{
	    selection = paneinfo->up_y_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->up_y));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->up_y_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->up_y_optsel));
	    }

	}

	if (paneinfo->at_y_struct != NULL)
	{
	    selection = paneinfo->at_y_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->at_y));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->at_y_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->at_y_optsel));
	    }

	}

	if (paneinfo->eye_z_struct != NULL)
	{
	    selection = paneinfo->eye_z_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->eye_z));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->eye_z_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->eye_z_optsel));
	    }

	}

	if (paneinfo->up_z_struct != NULL)
	{
	    selection = paneinfo->up_z_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->up_z));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->up_z_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->up_z_optsel));
	    }

	}

	if (paneinfo->at_z_struct != NULL)
	{
	    selection = paneinfo->at_z_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->at_z));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->at_z_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->at_z_optsel));
	    }

	}

	if (paneinfo->hither_clip_form_loc_struct != NULL)
	{
	    selection = paneinfo->hither_clip_form_loc_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->hither_clip_form_loc));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->hither_clip_form_loc_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->hither_clip_form_loc_optsel));
	    }

	}

	if (paneinfo->yon_clip_form_loc_struct != NULL)
	{
	    selection = paneinfo->yon_clip_form_loc_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->yon_clip_form_loc));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->yon_clip_form_loc_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->yon_clip_form_loc_optsel));
	    }

	}

	if (paneinfo->back_clip_form_on_off_struct != NULL)
	{
	   selection = paneinfo->back_clip_form_on_off_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->back_clip_form_on_off));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->back_clip_form_on_off_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->back_clip_form_on_off_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->back_clip_form_on_off_optsel));
	    }

	}

	if (paneinfo->fov_input_struct != NULL)
	{
	    selection = paneinfo->fov_input_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->fov_input));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->fov_input_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->fov_input_optsel));
	    }

	}

	if (paneinfo->aspect_struct != NULL)
	{
	    selection = paneinfo->aspect_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->aspect));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->aspect_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->aspect_optsel));
	    }

	}

	if (paneinfo->normalize_cam_struct != NULL)
	{
	    selection = paneinfo->normalize_cam_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->normalize_cam));

	}

	if (paneinfo->reset_camera_struct != NULL)
	{
	    selection = paneinfo->reset_camera_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->reset_camera));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Lights
| 
|       Purpose: Extracts information from Lights pane
| 
|         Input: paneinfo - pointer to RenderMonster_Lights structure
| 
|        Output: none
|    Written By: conductor -name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Lights(
     RenderMonster_Lights *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'Master->RenderMonster->Lights' Pane Info structure
	 */

	if (paneinfo->light_list_struct != NULL)
	{
	    selection = paneinfo->light_list_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->light_list));
	    if (paneinfo->light_list_label != NULL) kfree(paneinfo->light_list_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->light_list_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->light_list_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->light_list_optsel));
	    }

	}

	if (paneinfo->light_onoff_struct != NULL)
	{
	   selection = paneinfo->light_onoff_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->light_onoff));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->light_onoff_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->light_onoff_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->light_onoff_optsel));
	    }

	}

	if (paneinfo->light_type_list_struct != NULL)
	{
	    selection = paneinfo->light_type_list_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->light_type_list));
	    if (paneinfo->light_type_list_label != NULL) kfree(paneinfo->light_type_list_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->light_type_list_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->light_type_list_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->light_type_list_optsel));
	    }

	}

	if (paneinfo->light_position_string_struct != NULL)
	{
	    selection = paneinfo->light_position_string_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->light_position_string != NULL) kfree(paneinfo->light_position_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->light_position_string));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->light_position_string_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->light_position_string_optsel));
	    }

	}

	if (paneinfo->light_direction_string_struct != NULL)
	{
	    selection = paneinfo->light_direction_string_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->light_direction_string != NULL) kfree(paneinfo->light_direction_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->light_direction_string));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->light_direction_string_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->light_direction_string_optsel));
	    }

	}

	if (paneinfo->current_light_color_string_struct != NULL)
	{
	    selection = paneinfo->current_light_color_string_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->current_light_color_string != NULL) kfree(paneinfo->current_light_color_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->current_light_color_string));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->current_light_color_string_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->current_light_color_string_optsel));
	    }

	}

	if (paneinfo->ambient_light_color_string_struct != NULL)
	{
	    selection = paneinfo->ambient_light_color_string_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->ambient_light_color_string != NULL) kfree(paneinfo->ambient_light_color_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->ambient_light_color_string));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->ambient_light_color_string_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->ambient_light_color_string_optsel));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Imaging
| 
|       Purpose: Extracts information from Imaging pane
| 
|         Input: paneinfo - pointer to RenderMonster_Imaging structure
| 
|        Output: none
|    Written By: conductor -name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Imaging(
     RenderMonster_Imaging *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'Master->RenderMonster->Imaging' Pane Info structure
	 */

	if (paneinfo->image_width_struct != NULL)
	{
	    selection = paneinfo->image_width_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->image_width));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->image_width_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->image_width_optsel));
	    }
	}

	if (paneinfo->image_height_struct != NULL)
	{
	    selection = paneinfo->image_height_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->image_height));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->image_height_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->image_height_optsel));
	    }
	}

	if (paneinfo->image_display_choice_struct != NULL)
	{
	    selection = paneinfo->image_display_choice_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->image_display_choice));
	    if (paneinfo->image_display_choice_label != NULL) kfree(paneinfo->image_display_choice_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->image_display_choice_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->image_display_choice_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->image_display_choice_optsel));
	    }

	}

	if (paneinfo->red_background_struct != NULL)
	{
	    selection = paneinfo->red_background_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->red_background));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->red_background_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->red_background_optsel));
	    }

	}

	if (paneinfo->green_background_struct != NULL)
	{
	    selection = paneinfo->green_background_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->green_background));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->green_background_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->green_background_optsel));
	    }

	}

	if (paneinfo->blue_background_struct != NULL)
	{
	    selection = paneinfo->blue_background_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->blue_background));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->blue_background_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->blue_background_optsel));
	    }

	}

	if (paneinfo->renderer_choice_struct != NULL)
	{
	    selection = paneinfo->renderer_choice_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->renderer_choice));
	    if (paneinfo->renderer_choice_label != NULL) kfree(paneinfo->renderer_choice_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->renderer_choice_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->renderer_choice_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->renderer_choice_optsel));
	    }

	}

	if (paneinfo->transparency_choice_struct != NULL)
	{
	    selection = paneinfo->transparency_choice_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->transparency_choice));
	    if (paneinfo->transparency_choice_label != NULL) kfree(paneinfo->transparency_choice_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->transparency_choice_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->transparency_choice_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->transparency_choice_optsel));
	    }

	}

	if (paneinfo->invoke_renderer_struct != NULL)
	{
	   selection = paneinfo->invoke_renderer_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->invoke_renderer));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->invoke_renderer_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->invoke_renderer_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->invoke_renderer_optsel));
	    }

	}

	if (paneinfo->antialias_struct != NULL)
	{
	   selection = paneinfo->antialias_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->antialias));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->antialias_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->antialias_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->antialias_optsel));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Transformations
| 
|       Purpose: Extracts information from Transformations pane
| 
|         Input: paneinfo - pointer to RenderMonster_Transformations structure
| 
|        Output: none
|    Written By: conductor -name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Transformations(
     RenderMonster_Transformations *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'Master->RenderMonster->Transformations' Pane Info structure
	 */

	if (paneinfo->x_rotate_struct != NULL)
	{
	    selection = paneinfo->x_rotate_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->x_rotate));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->x_rotate_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->x_rotate_optsel));
	    }

	}

	if (paneinfo->y_rotate_struct != NULL)
	{
	    selection = paneinfo->y_rotate_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->y_rotate));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->y_rotate_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->y_rotate_optsel));
	    }

	}

	if (paneinfo->z_rotate_struct != NULL)
	{
	    selection = paneinfo->z_rotate_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->z_rotate));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->z_rotate_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->z_rotate_optsel));
	    }

	}

	if (paneinfo->center_point_string_struct != NULL)
	{
	    selection = paneinfo->center_point_string_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->center_point_string != NULL) kfree(paneinfo->center_point_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->center_point_string));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->center_point_string_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->center_point_string_optsel));
	    }

	}

	if (paneinfo->translate_vector_string_struct != NULL)
	{
	    selection = paneinfo->translate_vector_string_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->translate_vector_string != NULL) kfree(paneinfo->translate_vector_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->translate_vector_string));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->translate_vector_string_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->translate_vector_string_optsel));
	    }

	}

	if (paneinfo->xyz_scale_string_struct != NULL)
	{
	    selection = paneinfo->xyz_scale_string_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->xyz_scale_string != NULL) kfree(paneinfo->xyz_scale_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->xyz_scale_string));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->xyz_scale_string_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->xyz_scale_string_optsel));
	    }

	}

	if (paneinfo->transformation_mode_struct != NULL)
	{
	   selection = paneinfo->transformation_mode_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->transformation_mode));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->transformation_mode_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->transformation_mode_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->transformation_mode_optsel));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Input
| 
|       Purpose: Extracts information from Input pane
| 
|         Input: paneinfo - pointer to RenderMonster_Input structure
| 
|        Output: none
|    Written By: conductor -name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Input(
     RenderMonster_Input *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'Master->RenderMonster->Input' Pane Info structure
	 */

	if (paneinfo->input_object_1_struct != NULL)
	{
	    selection = paneinfo->input_object_1_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->input_object_1 != NULL) kfree(paneinfo->input_object_1);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->input_object_1));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->input_object_1_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->input_object_1_optsel));
	    }
	}

	if (paneinfo->input_object_2_struct != NULL)
	{
	    selection = paneinfo->input_object_2_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->input_object_2 != NULL) kfree(paneinfo->input_object_2);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->input_object_2));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->input_object_2_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->input_object_2_optsel));
	    }
	}

	if (paneinfo->input_object_3_struct != NULL)
	{
	    selection = paneinfo->input_object_3_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->input_object_3 != NULL) kfree(paneinfo->input_object_3);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->input_object_3));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->input_object_3_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->input_object_3_optsel));
	    }
	}

	if (paneinfo->input_object_4_struct != NULL)
	{
	    selection = paneinfo->input_object_4_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->input_object_4 != NULL) kfree(paneinfo->input_object_4);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->input_object_4));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->input_object_4_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->input_object_4_optsel));
	    }
	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Output
| 
|       Purpose: Extracts information from Output pane
| 
|         Input: paneinfo - pointer to RenderMonster_Output structure
| 
|        Output: none
|    Written By: conductor -name rmonster -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Output(
     RenderMonster_Output *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'Master->RenderMonster->Output' Pane Info structure
	 */

	if (paneinfo->output_image_fname_struct != NULL)
	{
	    selection = paneinfo->output_image_fname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->output_image_fname != NULL) kfree(paneinfo->output_image_fname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->output_image_fname));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->output_image_fname_selected));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->output_image_fname_optsel));
	    }
	}

}


