 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane Transformations
   >>>> 
   >>>>  Private: 
   >>>> 	Transformations_to_transform_list
   >>>> 	Transformations_x_rotate
   >>>> 	Transformations_y_rotate
   >>>> 	Transformations_z_rotate
   >>>> 	Transformations_center_point_string
   >>>> 	Transformations_translate_vector_string
   >>>> 	Transformations_xyz_scale_string
   >>>> 	Transformations_transformation_mode
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"
#include "rmatrix.h"
#include "rmonster_mouse.h"

static void build_transformation_matrix PROTO((matrix4x4 *,float,float,float,float,float,float,float));
static void gather_and_apply_transformations PROTO((RenderMonster_Transformations *));

static RenderMonster_Transformations *loc_Transformations;

/*-----------------------------------------------------------
| 
|  Routine Name: Transformations_to_transform_list
| 
|       Purpose: Do routine which is called when
|                  list selection to_transform_list is used
| 
|         Input: Transformations_info - ptr to PaneInfo struct for Transformations pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Transformations_to_transform_list(
     RenderMonster_Transformations *Transformations_info)
{
	/* PUT YOUR CODE HERE ! */
    gather_and_apply_transformations(Transformations_info);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Transformations_x_rotate
| 
|       Purpose: Do routine which is called when
|                  float selection x_rotate is used
| 
|         Input: Transformations_info - ptr to PaneInfo struct for Transformations pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Transformations_x_rotate(
     RenderMonster_Transformations *Transformations_info)
{
	/* PUT YOUR CODE HERE ! */
    set_xrot_relative(Transformations_info->x_rotate);
#if 0
    gather_and_apply_transformations(Transformations_info);
#endif
}


/*-----------------------------------------------------------
| 
|  Routine Name: Transformations_y_rotate
| 
|       Purpose: Do routine which is called when
|                  float selection y_rotate is used
| 
|         Input: Transformations_info - ptr to PaneInfo struct for Transformations pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Transformations_y_rotate(
     RenderMonster_Transformations *Transformations_info)
{
	/* PUT YOUR CODE HERE ! */
    set_yrot_relative(Transformations_info->y_rotate);
#if 0
    gather_and_apply_transformations(Transformations_info);
#endif
}


/*-----------------------------------------------------------
| 
|  Routine Name: Transformations_z_rotate
| 
|       Purpose: Do routine which is called when
|                  float selection z_rotate is used
| 
|         Input: Transformations_info - ptr to PaneInfo struct for Transformations pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Transformations_z_rotate(
     RenderMonster_Transformations *Transformations_info)
{
	/* PUT YOUR CODE HERE ! */
    set_zrot_relative(Transformations_info->z_rotate);
#if 0
    gather_and_apply_transformations(Transformations_info);
#endif

}


/*-----------------------------------------------------------
| 
|  Routine Name: Transformations_center_point_string
| 
|       Purpose: Do routine which is called when
|                  string selection center_point_string is used
| 
|         Input: Transformations_info - ptr to PaneInfo struct for Transformations pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Transformations_center_point_string(
     RenderMonster_Transformations *Transformations_info)
{
	/* PUT YOUR CODE HERE ! */

}


/*-----------------------------------------------------------
| 
|  Routine Name: Transformations_translate_vector_string
| 
|       Purpose: Do routine which is called when
|                  string selection translate_vector_string is used
| 
|         Input: Transformations_info - ptr to PaneInfo struct for Transformations pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Transformations_translate_vector_string(
     RenderMonster_Transformations *Transformations_info)
{
	/* PUT YOUR CODE HERE ! */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Transformations_xyz_scale_string
| 
|       Purpose: Do routine which is called when
|                  string selection xyz_scale_string is used
| 
|         Input: Transformations_info - ptr to PaneInfo struct for Transformations pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Transformations_xyz_scale_string(
     RenderMonster_Transformations *Transformations_info)
{
	/* PUT YOUR CODE HERE ! */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Transformations_transformation_mode
| 
|       Purpose: Do routine which is called when
|                  logical selection transformation_mode is used
| 
|         Input: Transformations_info - ptr to PaneInfo struct for Transformations pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Transformations_transformation_mode(
     RenderMonster_Transformations *Transformations_info)
{
	/* PUT YOUR CODE HERE ! */
}

/*-----------------------------------------------------------
| 
|  Routine Name: update_transformation_pane
| 
|       Purpose: set all items in the transformation pane
| 
|         Input: rmonsterobj - values for scale, rotate, etc. will
|                be used to set the values in the pane
|
|      Current Limitiations:
|              1. rotate and scaling values not yet set, and won't be
|                 until the KGEOM_ROTATE and KGEOM_SCALE parms come on line.
| 
|        Output: None
|    Written By: Chewbacca Darth
|          Date: Jul 29, 1994
| Modifications: 
| 
------------------------------------------------------------*/
void
update_transformation_pane(rmonsterobj *r)
{
/*    extern RenderMonster_Transformations *Transformations;  */
    RenderMonster_Transformations *pt; 
/*    extern kform_struct *Transformations_struct;
    kform_struct *ts; */
    char buffer[128];

/*    ts = Transformations_struct; */
    pt = loc_Transformations;
    if (pt == NULL)  /* this condition happens in the initialization phase */
        return;

    ksprintf(buffer,"%g %g %g",r->center.v[0],r->center.v[1],r->center.v[2]);
    xvf_set_attribute(pt->center_point_string_struct,
                   XVF_STRING_VAL,
                   buffer);
    
    ksprintf(buffer,"%g %g %g",r->translate_vect.v[0],r->translate_vect.v[1],r->
translate_vect.v[2]);
    xvf_set_attribute(pt->translate_vector_string_struct,
                   XVF_STRING_VAL,
                   buffer);

    ksprintf(buffer," not ready yet ");
    xvf_set_attribute(pt->xyz_scale_string_struct,
                   XVF_STRING_VAL,
                   buffer);

}

static void
gather_and_apply_transformations(RenderMonster_Transformations *tr)
{
    rmonsterobj *r;
    matrix4x4 m;
    float xrot,yrot,zrot;
    float xtrans,ytrans,ztrans;
    float isoscale;


    xrot = tr->x_rotate;
    yrot = tr->y_rotate;
    zrot = tr->z_rotate;
#if 0
    xtrans = tr->x_trans;
    ytrans = tr->y_trans;
    ztrans = tr->z_trans;
    isoscale = tr->iso_scale;
#endif

    build_transformation_matrix(&m,xrot,yrot,zrot,
                                xtrans,ytrans,ztrans,
                                isoscale);

    r = get_current_object();

    /* copy transformation matrix to object. */
    memcpy((char *)&(r->xfrm),(char *)&m,sizeof(matrix4x4));
}

static void build_transformation_matrix(matrix4x4 *m,
                                        float xrot, float yrot, float zrot,
                                        float xtrans, float ytrans, float ztrans,
                                        float isoscale)
{
    matrix4x4 xr,yr,zr,trans,scale,comp;
    double c,s,t;

    identity_4x4(&comp);
    identity_4x4(&xr);
    identity_4x4(&yr);
    identity_4x4(&zr);
    identity_4x4(&trans);
    identity_4x4(&scale);


t;
    t = DEGREES_TO_RADIANS(t);
    c = kcos(t);
    s = ksin(t);
    xr.m[1][1] = xr.m[2][2] = c;
    xr.m[1][2] = s;
    xr.m[2][1] = -1. * s;
    
    t = yrot;
    t = DEGREES_TO_RADIANS(t);
    c = kcos(t);
    s = ksin(t);
    yr.m[0][0] = yr.m[2][2] = c;
    yr.m[0][2] = -1. * s;
    yr.m[2][0] = s;
    
    t = zrot;
    t = DEGREES_TO_RADIANS(t);
    c = kcos(t);
    s = ksin(t);
    zr.m[0][0] = zr.m[1][1] = c;
    zr.m[0][1] = s;
    zr.m[1][0] = -1. * s;

    trans.m[3][0] = xtrans;
    trans.m[3][1] = ytrans;
    trans.m[3][2] = ztrans;

    scale.m[0][0] = scale.m[1][1] = scale.m[2][2] = isoscale;

    mmul_4x4(&comp,&scale,&comp);
    mmul_4x4(&comp,&xr,&comp);
    mmul_4x4(&comp,&yr,&comp);
    mmul_4x4(&comp,&zr,&comp);
    mmul_4x4(&comp,&trans,m);
}

void
init_transformations(RenderMonster_Transformations *t)
{
    loc_Transformations = t;
    set_xrot_relative(t->x_rotate);
    set_yrot_relative(t->y_rotate);
    set_zrot_relative(t->z_rotate);
}
