 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane Lights
   >>>> 
   >>>>  Private: 
   >>>> 	Lights_light_list
   >>>> 	Lights_light_onoff
   >>>> 	Lights_light_type_list
   >>>> 	Lights_light_position_string
   >>>> 	Lights_light_direction_string
   >>>> 	Lights_current_light_color_string
   >>>> 	Lights_ambient_light_color_string
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"

#define RESTORE_3TUPLE(v1,v2,v3,s) \
{ \
      char work[256]; \
      ksprintf(work,"%g %g %g",(v1),(v2),(v3)); \
      xvf_set_attribute((s),XVF_STRING_VAL, work); \
}


/* Some protos */
int init_lights_pane PROTO((RenderMonster_Lights *));
int update_lights_gui PROTO((RenderMonster_Lights *));

/*-----------------------------------------------------------
| 
|  Routine Name: Lights_light_list
| 
|       Purpose: Do routine which is called when
|                  list selection light_list is used
| 
|         Input: Lights_info - ptr to PaneInfo struct for Lights pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Lights_light_list(
     RenderMonster_Lights *Lights_info)
{
	/* PUT YOUR CODE HERE ! */
    int i;
    i = Lights_info->light_list;
    set_current_light(i);
    update_lights_gui(Lights_info);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Lights_light_onoff
| 
|       Purpose: Do routine which is called when
|                  logical selection light_onoff is used
| 
|         Input: Lights_info - ptr to PaneInfo struct for Lights pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Lights_light_onoff(
     RenderMonster_Lights *Lights_info)
{
	/* PUT YOUR CODE HERE ! */
     int lit_status, current_light;

     get_current_light(&current_light);
     get_light_onoff(current_light,&lit_status);
     lit_status = (lit_status == LIGHT_ON) ? LIGHT_OFF : LIGHT_ON;
     set_light_onoff(current_light,lit_status);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Lights_light_type_list
| 
|       Purpose: Do routine which is called when
|                  list selection light_type_list is used
| 
|         Input: Lights_info - ptr to PaneInfo struct for Lights pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Lights_light_type_list(
     RenderMonster_Lights *Lights_info)
{
	/* PUT YOUR CODE HERE ! */
    int newval,curlight;

    newval = Lights_info->light_type_list;
    get_current_light(&curlight);
    set_light_type(curlight,newval);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Lights_light_position_string
| 
|       Purpose: Do routine which is called when
|                  string selection light_position_string is used
| 
|         Input: Lights_info - ptr to PaneInfo struct for Lights pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Lights_light_position_string(
     RenderMonster_Lights *Lights_info)
{
	/* PUT YOUR CODE HERE ! */
    /**
      * this routine is valid only when the current light is a
      * point light.  later, we might support spotlights,but not now.
    **/
    int current_light,current_light_type,i;
    vertex_3d new_position,old_position;
    extern double strtod PROTO((const char *, char **));
    double t;
    char *s1,*s2;

    get_current_light(&current_light);
    get_light_type(current_light,&current_light_type);
    get_light_position(current_light,&old_position);

    if (current_light_type != POINT_LIGHT)
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","Light type mismatch","Can't set position on Directional light sources.");
        RESTORE_3TUPLE(old_position.v[0],old_position.v[1],old_position.v[2],
                       Lights_info->light_position_string_struct);
        return;
    }

    get_current_light(&current_light);
    s1 = Lights_info->light_position_string;
    s2 = s1;
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","Lights position string","bad numeric value: <%s>",s1)
;
        RESTORE_3TUPLE(old_position.v[0],old_position.v[1],old_position.v[2],
                       Lights_info->light_position_string_struct);
        return;
    }

    new_position.v[0] = t;
    s1 = s2;
   
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","Lights position string","bad numeric value: <%s>",s1)
;
        RESTORE_3TUPLE(old_position.v[0],old_position.v[1],old_position.v[2],
                       Lights_info->light_position_string_struct);
        return;
    }
    new_position.v[1] = t;
    s1 = s2;
    
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","Lights Position String","bad numeric value: <%s>",s1)
;
        RESTORE_3TUPLE(old_position.v[0],old_position.v[1],old_position.v[2],
                       Lights_info->light_position_string_struct);
        return;
    }
    new_position.v[2] = t;
    set_light_position(current_light,&new_position);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Lights_light_direction_string
| 
|       Purpose: Do routine which is called when
|                  string selection light_direction_string is used
| 
|         Input: Lights_info - ptr to PaneInfo struct for Lights pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Lights_light_direction_string(
     RenderMonster_Lights *Lights_info)
{
	/* PUT YOUR CODE HERE ! */
    vertex_3d direction,old_direction;
    extern double strtod PROTO((const char *, char **));
    double t;
    char *s1,*s2;
    int current_light,current_light_type,i;

    get_current_light(&current_light);
    get_light_type(current_light,&current_light_type);
    get_light_direction(current_light,&old_direction);
    
    if ((current_light_type == POINT_LIGHT) ||
        (current_light_type == AMBIENT_LIGHT))
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","Light type mismatch","Can't set direction on an Ambient or Point light source");
        RESTORE_3TUPLE(old_direction.v[0],old_direction.v[1],old_direction.v[2],
                       Lights_info->light_direction_string_struct);
        return;
    }


    s1 = Lights_info->light_direction_string;
    s2 = s1;
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","Lights direction string","bad numeric value: <%s>",s1
);
        RESTORE_3TUPLE(old_direction.v[0],old_direction.v[1],old_direction.v[2],
                       Lights_info->light_direction_string_struct);
        return;
    }

    direction.v[0] = t;
    s1 = s2;
   
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","Lights direction string","bad numeric value: <%s>",s1);
        RESTORE_3TUPLE(old_direction.v[0],old_direction.v[1],old_direction.v[2],
                       Lights_info->light_direction_string_struct);
        return;
    }
    direction.v[1] = t;
    s1 = s2;
    
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","Lights Direction String","bad numeric value: <%s>",s1);
        RESTORE_3TUPLE(old_direction.v[0],old_direction.v[1],old_direction.v[2],
                       Lights_info->light_direction_string_struct);
        return;
    }
    direction.v[2] = t;


    set_light_direction(current_light,&direction);
    RESTORE_3TUPLE(direction.v[0],direction.v[1],direction.v[2],
                   Lights_info->light_direction_string_struct);

}


/*-----------------------------------------------------------
| 
|  Routine Name: Lights_current_light_color_string
| 
|       Purpose: Do routine which is called when
|                  string selection current_light_color_string is used
| 
|         Input: Lights_info - ptr to PaneInfo struct for Lights pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Lights_current_light_color_string(
     RenderMonster_Lights *Lights_info)
{
	/* PUT YOUR CODE HERE ! */
    /* PUT YOUR CODE HERE ! */
    vertex_3d new_color,old_color;
    extern double strtod PROTO((const char *, char **));
    double t;
    char *s1,*s2;
    char work[256];
    int i;

    get_current_light(&i);
    get_light_color(i,&(old_color.v[0]),&(old_color.v[1]),&(old_color.v[2]));

    s1 = Lights_info->current_light_color_string;
    s2 = s1;
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","current_light_color_string","bad numeric value: <%s>",s1);
        
        RESTORE_3TUPLE(old_color.v[0],old_color.v[1],old_color.v[2],Lights_info->current_light_color_string_struct);
        return;
    }

    if ((t < 0.) || (t > 1.))
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","current_light_color_string","value out of range :<%lf>. it should be between 0 and 1. ",t);
        RESTORE_3TUPLE(old_color.v[0],old_color.v[1],old_color.v[2],Lights_info->current_light_color_string_struct);
        return;
    }

    new_color.v[0] = t;
    s1 = s2;
   
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","current_light_color_string","bad numeric value: <%s>" ,s1);
        RESTORE_3TUPLE(old_color.v[0],old_color.v[1],old_color.v[2],Lights_info->current_light_color_string_struct);
        return;
    }
    if ((t < 0.) || (t > 1.))
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","current_light_color_string","value out of range :<%lf>. it should be between 0 and 1. ",t);
        RESTORE_3TUPLE(old_color.v[0],old_color.v[1],old_color.v[2],Lights_info->current_light_color_string_struct);
        return;
    }

    new_color.v[1] = t;
    s1 = s2;
    
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","current_light_color_string","bad numeric value: <%s>" ,s1);
        RESTORE_3TUPLE(old_color.v[0],old_color.v[1],old_color.v[2],Lights_info->current_light_color_string_struct);
        return;
    }
    if ((t < 0.) || (t > 1.))
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","current_light_color_string","value out of range :<%lf>. it should be between 0 and 1. ",t);

        RESTORE_3TUPLE(old_color.v[0],old_color.v[1],old_color.v[2],Lights_info->current_light_color_string_struct);
        
        return;
    }
    new_color.v[2] = t;

    set_light_color(i,new_color.v[0],new_color.v[1],new_color.v[2]);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Lights_ambient_light_color_string
| 
|       Purpose: Do routine which is called when
|                  string selection ambient_light_color_string is used
| 
|         Input: Lights_info - ptr to PaneInfo struct for Lights pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Lights_ambient_light_color_string(
     RenderMonster_Lights *Lights_info)
{
	/* PUT YOUR CODE HERE ! */
    /* PUT YOUR CODE HERE ! */
    vertex_3d ambient_color,old_ambient_color;
    extern double strtod PROTO((const char *, char **));
    double t;
    char *s1,*s2;
    char work[256];

    get_ambient_light_color(&old_ambient_color);

    s1 = Lights_info->ambient_light_color_string;
    s2 = s1;
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","ambient_light_color_string","bad numeric value: <%s>"
,s1);
        
        RESTORE_3TUPLE(old_ambient_color.v[0],old_ambient_color.v[1],old_ambient_color.v[2],Lights_info->ambient_light_color_string_struct);
        return;
    }

    if ((t < 0.) || (t > 1.))
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","ambient_light_color_string","value out of range :<%lf>. it should be between 0 and 1. ",t);
        RESTORE_3TUPLE(old_ambient_color.v[0],old_ambient_color.v[1],old_ambient_color.v[2],Lights_info->ambient_light_color_string_struct);
        return;
    }

    ambient_color.v[0] = t;
    s1 = s2;
   
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","ambient_light_color_string","bad numeric value: <%s>",s1);
        RESTORE_3TUPLE(old_ambient_color.v[0],old_ambient_color.v[1],old_ambient_color.v[2],Lights_info->ambient_light_color_string_struct);
        return;
    }
    if ((t < 0.) || (t > 1.))
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","ambient_light_color_string","value out of range :<%lf>. it should be between 0 and 1. ",t);
        RESTORE_3TUPLE(old_ambient_color.v[0],old_ambient_color.v[1],old_ambient_color.v[2],Lights_info->ambient_light_color_string_struct);
        return;
    }

    ambient_color.v[1] = t;
    s1 = s2;
    
    t = strtod(s1,&s2);
    if (s2 == s1) /* input error */
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","ambient_light_color_string","bad numeric value: <%s>",s1);
        RESTORE_3TUPLE(old_ambient_color.v[0],old_ambient_color.v[1],old_ambient_color.v[2],Lights_info->ambient_light_color_string_struct);
        return;
    }
    if ((t < 0.) || (t > 1.))
    {
        errno = KINVALID_PARAMETER;
        kerror("GEOMETRY","ambient_light_color_string","value out of range :<%lf>. it should be between 0 and 1. ",t);

        RESTORE_3TUPLE(old_ambient_color.v[0],old_ambient_color.v[1],old_ambient_color.v[2],Lights_info->ambient_light_color_string_struct);
        
        return;
    }
    ambient_color.v[2] = t;

    set_ambient_light_color(&ambient_color);
}

init_lights_pane(RenderMonster_Lights *Lights_info)
{
    char *list[MAX_LIGHTS];
    int i;

    for (i=0;i<MAX_LIGHTS;i++)
        list[i] = kmalloc(32);  /* some strings for use */

    for (i=0;i<MAX_LIGHTS;i++)
        ksprintf(list[i],"Light%d",i+1);

    /* first, remove any items from the lights list */
    xvf_set_attribute(Lights_info->light_list_struct,
                   XVF_LIST_DELETEALL,
                   NULL);

    /* now, add the lights in one at a time. */
    for (i=0;i<MAX_LIGHTS;i++)
        xvf_set_attribute(Lights_info->light_list_struct,
                       XVF_LIST_ADD,
                       list[i]);

    /* now, make Light1 the current light. */
    xvf_set_attribute(Lights_info->light_list_struct,
                   XVF_LIST_VAL,
                   0);

    /* scrub the lights type list and rebuild it according to lights.h */
    xvf_set_attribute(Lights_info->light_type_list_struct,
                   XVF_LIST_DELETEALL,
                   NULL);

    /* build the list from scratch */
    for (i=0;i<NLIGHT_TYPES;i++)
        xvf_set_attribute(Lights_info->light_type_list_struct,
                       XVF_LIST_ADD,
                       light_type_strings[i]);

    update_lights_gui(Lights_info);

    /** need to build a list of light type strings?? */

    return(CHILL);
}

update_lights_gui(RenderMonster_Lights *Lights_info)
{
    int i;
    float r,g,b;
    vertex_3d direction, position,ambient_color;
    int onoff,type;
    char work[64];
    
    get_current_light(&i);
    get_light_color(i,&r,&g,&b);
    get_light_direction(i,&direction);
    get_light_position(i,&position);
    get_light_onoff(i,&onoff);
    get_light_type(i,&type);
    get_ambient_light_color(&ambient_color);

    /* assume that we don't need to update the list...assume it's current */
    xvf_set_attribute(Lights_info->light_onoff_struct,
                   XVF_LOGIC_VAL,
                   onoff);

    xvf_set_attribute(Lights_info->light_type_list_struct,
                   XVF_LIST_VAL,
                   type);

    ksprintf(work,"%g %g %g",position.v[0],position.v[1],position.v[2]);
    xvf_set_attribute(Lights_info->light_position_string_struct,
                   XVF_STRING_VAL,
                   work);
    
    ksprintf(work,"%g %g %g",direction.v[0],direction.v[1],direction.v[2]);
    xvf_set_attribute(Lights_info->light_direction_string_struct,
                   XVF_STRING_VAL,
                   work);
    
    ksprintf(work,"%g %g %g",r,g,b);
    xvf_set_attribute(Lights_info->current_light_color_string_struct,
                      XVF_STRING_VAL,
                      work);
    
    ksprintf(work,"%g %g %g",ambient_color.v[0],ambient_color.v[1],
             ambient_color.v[2]);
    xvf_set_attribute(Lights_info->ambient_light_color_string_struct,
                      XVF_STRING_VAL,
                      work);
    return(CHILL);
}
