/*####################################################################

Copyright (C) 1993, 1994 Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is nearly 100% hand-crafted by a human being in the USA"

####################################################################*/
 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


#include "internals.h"


/****************************************************************
* 
*  Routine Name: lget_coords - obtain coordinate (location) data
* 
*       Purpose: This function allows access to location data in a
*                consistent way.  The idea is that all geometry
*                visualization tools need coordinate information
*                from the input data file.  If location data is
*                available, it is used.  If not, the convention
*                taken is that the u,v,w indeces are used as
*                coordinate values.  This convention may change over
*                time, thus the API rather than having lots of
*                duplicated code for dealing with this problem.
*
*         Input: kobj - data object to scan
* 		 i - width index 
* 	         j - height index
*                k - depth index 
*
*        Output: v - 3d vertex
*
*       Returns: CHILL (1) on success, WHACKED (0) on failure
*  Restrictions: 
*    Written By: Wes Bethel
*          Date: Jun 14, 1993
*      Verified: 
*  Side Effects: 
* Modifications:
*
*   Declaration: lget_coords (
*		 !    kobject kobj,
*		 !    int i,
*		 !    int j,
*		 !    int k,
*		 !    vertex_3d *v)
****************************************************************/
/* -library_def */
int lget_coords (
		 kobject kobj,
		 int i,
		 int j,
		 int k,
		 vertex_3d *v)

/* -library_def_end */
/* -library_code */
{
    int loc_avail,lw,lh,ld,ldim;
    int vw,vh,vd,vt,ve;
    float coords[3];

    /* first, check to see if there is _any_ location data. */
    loc_avail = kpds_query_location(kobj);

    /* if so, then use it. */
    if (loc_avail == TRUE)
    {
	kpds_get_attribute(kobj,KPDS_LOCATION_SIZE,&lw,&lh,&ld,&ldim);
	/* and insist on floating point presentation. */
	kpds_set_attribute(kobj,KPDS_LOCATION_DATA_TYPE,KFLOAT);
	
	if (ldim == 3) /* the usual case. */
        {
	    kpds_set_attribute(kobj,KPDS_LOCATION_POSITION,i,j,k,0);
	    kpds_get_data(kobj,KPDS_LOCATION_VECTOR,coords);
	    v->v[0] = coords[0];
	    v->v[1] = coords[1];
	    v->v[2] = coords[2];
	}
	else  /* for now, an error condition. */
        {
/* KERROR CAT: "library" */
	    kerror("GEOMETRY","lget_coords","the Input data doesn't have 3 dimensions of location data.  ");
	    return(WHACKED);
	}
    }
    else
    {
        kpds_get_attribute(kobj,KPDS_VALUE_SIZE,&vw,&vh,&vd,&ve,&vt);
        if ((i < 0) || (i > vw-1))
	    return(WHACKED);
	if ((j<0) || (j > vh-1))
	    return(WHACKED);
	if ((k<0) || (k > vd-1))
	    return(WHACKED);

	/* no coordinate information - return the indeces */
	v->v[0] = i;
	v->v[1] = j;
	v->v[2] = k;
    }
    
    return(CHILL);
}
