 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kslicer.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kslicer_get_args
| 
|       Purpose: Gets command line args for kslicer
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kslicer
|          Date: Dec 13, 1994
| Modifications: 
| 
------------------------------------------------------------*/
void kslicer_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kslicer is out of sync with arguments specified in kslicer's *.pane file; please rerun ghostwriter on kslicer.";

	char  *value_string;


	/*
	 * allocate the kslicer structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kslicer_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "p", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->p_flag))))
	{
	    kerror(NULL, "kslicer_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->p_toggle = atoi(value_string);

	if (!(kclui_get_flag(pane, "reo",
			  &(clui_info->reo_flag))))
	{
	    kerror(NULL, "kslicer_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "loc",
			  &(clui_info->loc_flag))))
	{
	    kerror(NULL, "kslicer_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kslicer_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "ps",
			  &(clui_info->ps_float),
			  &(clui_info->ps_flag))))
	{
	    kerror(NULL, "kslicer_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "s",
			  &(clui_info->s_float),
			  &(clui_info->s_flag))))
	{
	    kerror(NULL, "kslicer_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



