 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kslicer
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kslicer.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Extract (N-1)D Region from (N)D Object
|
|       Purpose: main program for kslicer
|
|         Input:
|		char *clui_info->i_file; {input file to slice}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output file containing slice}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->p_toggle; {choose orthogonal slice plane}
|		int clui_info->p_flag; {TRUE if -p specified}
|
|		int clui_info->reo_flag; {TRUE if -reo specified}
|
|		int clui_info->loc_flag; {TRUE if -loc specified}
|
|		Optional M.E. group:
|		    float clui_info->ps_float; {slice at percentage depth on slice plane}
|		    int   clui_info->ps_flag; {TRUE if -ps specified}
|
|		    float clui_info->s_float; {slice at position on slice plane}
|		    int   clui_info->s_flag; {TRUE if -s specified}
|
|        Output:
|       Returns:
|
|    Written By: Steven Kubica
|          Date: Dec 13, 1994
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject i, o;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(kslicer_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "kslicer",
		kslicer_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kslicer_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((i = kpds_open_input_object(clui_info->i_file))==NULL)
        {
	   errno = KINVALID_FILE;
           kerror(NULL,"kslicer",
                  "Unable to open input file %s as a data services object", 
                  clui_info->i_file );
           kexit(KEXIT_FAILURE);
        }

        if ((o = kpds_open_output_object(clui_info->o_file))==NULL)
        {
	   errno = KINVALID_FILE;
           kerror(NULL,"kslicer",
                  "Unable to open output file %s as a data services object", 
                  clui_info->o_file );

           kpds_close_object(i);
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	lkslicer(i,
                 clui_info->p_toggle - 1,  /* Which slice plane? */
                 TRUE,   /* clui_info->int_logic, Force integer plane */
                 clui_info->s_flag,        /* TRUE if positional slice */
                 clui_info->s_float,       /* slice number */
		 clui_info->ps_flag,       /* TRUE if percentage slice */
		 clui_info->ps_float,      /* percentage slice depth */
                 clui_info->reo_flag,      /* Reorient to face image plane */
                 clui_info->loc_flag,      /* Add explicit location data */
                 o);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* copy any extraneous segments which have been missed */
	if (!kpds_copy_remaining_data(i, o))
	{
           kerror(NULL,"kslicer",
                  "Unable to copy remaining segments.");
           kexit(KEXIT_FAILURE);
	}
	
	if (!kpds_close_object(i))
	{
           kerror(NULL,"kslicer",
                  "Unable to close input file %s", clui_info->i_file );
           kexit(KEXIT_FAILURE);
	}
	
	if (!kpds_close_object(o))
	{
           kerror(NULL,"kslicer",
                  "Unable to close output file %s", clui_info->o_file );
           kexit(KEXIT_FAILURE);
	}
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kslicer_usage_additions
| 
|       Purpose: Prints usage additions in kslicer_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kslicer
|          Date: Dec 13, 1994
| Modifications: 
| 
------------------------------------------------------------*/
void kslicer_usage_additions(void)
{
	kfprintf(kstderr, "\tExtract (N-1)D Region from (N)D Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kslicer_free_args
| 
|       Purpose: Frees CLUI struct allocated in kslicer_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kslicer
|          Date: Dec 13, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void kslicer_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info == NULL) return;
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info);

/* -free_handler_additions */
/* -free_handler_additions_end */
}
