 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gspheres
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gspheres.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Produce Spheres Whose Radii are Determined from Data
|
|       Purpose: main program for gspheres
|
|         Input:
|		char *clui_info->i_file; {input data object }
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output geometry object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->cmap_file; {input vis colormap}
|		int   clui_info->cmap_flag; {TRUE if -cmap specified}
|
|		char *clui_info->name_string; {object name}
|		int   clui_info->name_flag; {TRUE if -name specified}
|
|		float clui_info->scale_float; {scale factor for radii}
|		int   clui_info->scale_flag; {TRUE if -scale specified}
|
|        Output:
|       Returns:
|
|    Written By: wes
|          Date: Apr 12, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
    kobject datafile,mapfile,outfile;
    int have_mapfile;
    float radius_scale;
    int w,h,d,dims,e,t;
    char *name;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gspheres_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gspheres",
		gspheres_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gspheres_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
    datafile = kpds_open_object(clui_info->i_file,KOBJ_READ);
    outfile = kgeom_open_output_object(clui_info->o_file);

    if (clui_info->cmap_flag)
    {
	mapfile = kpds_open_object(clui_info->cmap_file,KOBJ_READ);
	have_mapfile = TRUE;
    }
    else
	have_mapfile = FALSE;
    radius_scale = clui_info->scale_float;
    name = clui_info->name_string;
/* -main_before_lib_call_end */

/* -main_library_call */
    lgspheres(datafile,mapfile,outfile,have_mapfile,&radius_scale,name);
/* -main_library_call_end */

/* -main_after_lib_call */
    kpds_close_object(datafile);
    if (have_mapfile)
	kpds_close_object(mapfile);
    kgeom_close_object(outfile);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gspheres_usage_additions
| 
|       Purpose: Prints usage additions in gspheres_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gspheres
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gspheres_usage_additions(void)
{
	kfprintf(kstderr, "\tProduce Spheres Whose Radii are Determined from Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gspheres_free_args
| 
|       Purpose: Frees CLUI struct allocated in gspheres_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gspheres
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gspheres_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->cmap_file);
	kfree(clui_info->name_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
