 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "ggridder2d.h"
/*-----------------------------------------------------------
| 
|  Routine Name: ggridder2d_get_args
| 
|       Purpose: Gets command line args for ggridder2d
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ggridder2d
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ggridder2d_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for ggridder2d is out of sync with arguments specified in ggridder2d's *.pane file; please rerun ghostwriter on ggridder2d.";


	/*
	 * allocate the ggridder2d structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "grid_size_x",
			  &(clui_info->grid_size_x_int),
			  &(clui_info->grid_size_x_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "grid_size_y",
			  &(clui_info->grid_size_y_int),
			  &(clui_info->grid_size_y_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "inverse_distance_method",
			  &(clui_info->inverse_distance_method_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "inverse_distance_radius",
			  &(clui_info->inverse_distance_radius_double),
			  &(clui_info->inverse_distance_radius_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "inverse_distance_exponent",
			  &(clui_info->inverse_distance_exponent_double),
			  &(clui_info->inverse_distance_exponent_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "inverse_distance_undefined_value",
			  &(clui_info->inverse_distance_undefined_value_double),
			  &(clui_info->inverse_distance_undefined_value_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "idsfft_method",
			  &(clui_info->idsfft_method_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "idsfft_npoints",
			  &(clui_info->idsfft_npoints_double),
			  &(clui_info->idsfft_npoints_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "compute_grid_min_max",
			  &(clui_info->compute_grid_min_max_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "user_grid_min_max",
			  &(clui_info->user_grid_min_max_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "user_grid_x_min",
			  &(clui_info->user_grid_x_min_double),
			  &(clui_info->user_grid_x_min_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "user_grid_y_min",
			  &(clui_info->user_grid_y_min_double),
			  &(clui_info->user_grid_y_min_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "user_grid_x_max",
			  &(clui_info->user_grid_x_max_double),
			  &(clui_info->user_grid_x_max_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "user_grid_y_max",
			  &(clui_info->user_grid_y_max_double),
			  &(clui_info->user_grid_y_max_flag))))
	{
	    kerror(NULL, "ggridder2d_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



