 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ggridder2d
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ggridder2d.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compute z=f(x,y) over a user-defined grid given scatter data.
|
|       Purpose: main program for ggridder2d
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->grid_size_x_int; {value indicating x-resolution of output grid}
|		int clui_info->grid_size_x_flag; {TRUE if -grid_size_x specified}
|
|		int clui_info->grid_size_y_int; {value indicating y-resolution of output grid}
|		int clui_info->grid_size_y_flag; {TRUE if -grid_size_y specified}
|
|		Optional M.E. group:
|		    M.I. group:
|			int clui_info->inverse_distance_method_flag; {TRUE if -inverse_distance_method specified}
|
|			double clui_info->inverse_distance_radius_double; {user-defined radius, inside which points will be averaged }
|			int    clui_info->inverse_distance_radius_flag; {TRUE if -inverse_distance_radius specified}
|
|			double clui_info->inverse_distance_exponent_double; {exponent to use in denominator of inversion equation}
|			int    clui_info->inverse_distance_exponent_flag; {TRUE if -inverse_distance_exponent specified}
|
|			double clui_info->inverse_distance_undefined_value_double; {the value to use when the output grid point is not defined}
|			int    clui_info->inverse_distance_undefined_value_flag; {TRUE if -inverse_distance_undefined_value specified}
|
|		    M.I. group:
|			int clui_info->idsfft_method_flag; {TRUE if -idsfft_method specified}
|
|			double clui_info->idsfft_npoints_double; {number of points to use in computing partial derivatives}
|			int    clui_info->idsfft_npoints_flag; {TRUE if -idsfft_npoints specified}
|
|		Optional M.E. group:
|		    int clui_info->compute_grid_min_max_flag; {TRUE if -compute_grid_min_max specified}
|
|		    M.I. group:
|			int clui_info->user_grid_min_max_flag; {TRUE if -user_grid_min_max specified}
|
|			double clui_info->user_grid_x_min_double; {X min coordinate for interpolation grid}
|			int    clui_info->user_grid_x_min_flag; {TRUE if -user_grid_x_min specified}
|
|			double clui_info->user_grid_y_min_double; {Y min coordinate for interpolation grid}
|			int    clui_info->user_grid_y_min_flag; {TRUE if -user_grid_y_min specified}
|
|			double clui_info->user_grid_x_max_double; {X max coordinate for interpolation grid}
|			int    clui_info->user_grid_x_max_flag; {TRUE if -user_grid_x_max specified}
|
|			double clui_info->user_grid_y_max_double; {Y max coordinate for interpolation grid}
|			int    clui_info->user_grid_y_max_flag; {TRUE if -user_grid_y_max specified}
|
|        Output:
|       Returns:
|
|    Written By: Wes Bethel
|          Date: Apr 12, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject inobj,outobj;
	int xres,yres;
	int numerical_method;
	float grid_parms[5];  /* holding area for gridding parms for
				 each algorithm */
	float grid_bounds[4];
	int autocompute_grid_extents;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(ggridder2d_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "geometry", "ggridder2d",
		ggridder2d_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	ggridder2d_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/** open the objects **/
	inobj = kpds_open_object(clui_info->i_file,KOBJ_READ);
	outobj = kpds_open_object(clui_info->o_file,KOBJ_WRITE);

	/** grab the grid resolution parms. **/
	xres = clui_info->grid_size_x_int;
	yres = clui_info->grid_size_y_int;

	/** determinte grid interpolation method, and grab associated
	  parms. **/
	
	if (clui_info->inverse_distance_method_flag)
	{
	    numerical_method = INVERSE_DISTANCE_2D;
	    grid_parms[0] = clui_info->inverse_distance_radius_double;
	    grid_parms[1] = clui_info->inverse_distance_exponent_double;
	    grid_parms[2] = clui_info->inverse_distance_undefined_value_double;
	}
	else /** assume fft until we add more methods **/
	{
	    numerical_method = FOURIER_ANALYSIS_2D;
	    grid_parms[0] = clui_info->idsfft_npoints_double;
	}

	/* determine we need to compute the grid extents, or use the
	   user's values. */

	if (clui_info->compute_grid_min_max_flag)
	    autocompute_grid_extents = TRUE;
	else
	{
	    autocompute_grid_extents = FALSE;
	    grid_bounds[0] = clui_info->user_grid_x_min_double;
	    grid_bounds[1] = clui_info->user_grid_y_min_double;
	    grid_bounds[2] = clui_info->user_grid_x_max_double;
	    grid_bounds[3] = clui_info->user_grid_y_max_double;
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	lggridder2d(inobj,outobj,numerical_method,grid_parms,
		     autocompute_grid_extents,grid_bounds,xres,yres);
/* -main_library_call_end */

/* -main_after_lib_call */
	kpds_close_object(inobj);
	kpds_close_object(outobj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ggridder2d_usage_additions
| 
|       Purpose: Prints usage additions in ggridder2d_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ggridder2d
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ggridder2d_usage_additions(void)
{
	kfprintf(kstderr, "\tCompute z=f(x,y) over a user-defined grid given scatter data.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ggridder2d_free_args
| 
|       Purpose: Frees CLUI struct allocated in ggridder2d_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ggridder2d
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ggridder2d_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
