 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for ggencmap
   >>>> 
   >>>>    Written By: Wes Bethel
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 13, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _ggencmap_h_
#define _ggencmap_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <geometry.h>

/* -include_includes */
#include "geometry/geometry.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$GEOMETRY/objects/kroutine/ggencmap/uis/ggencmap.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  output vis colormap (required outfile)
 */
char	*outf_file;	/* output vis colormap FILENAME */
int	 outf_flag;	/* output vis colormap FLAG */

/*----- required ME group ----*/
	/*---- nested optional MI group ----*/
/*
 *  color parameters in HSV space (optional flag)
 */
int	 use_hsv_flag;  	/* color parameters in HSV space FLAG */

/*
 *  hue start value (optional float)
 */
float	 hs_float;	/* hue start value FLOAT */
int	 hs_flag;   	/* hue start value FLAG */

/*
 *  hue end value (optional float)
 */
float	 he_float;	/* hue end value FLOAT */
int	 he_flag;   	/* hue end value FLAG */

/*
 *  saturation start value (optional float)
 */
float	 ss_float;	/* saturation start value FLOAT */
int	 ss_flag;   	/* saturation start value FLAG */

/*
 *  saturation end value (optional float)
 */
float	 se_float;	/* saturation end value FLOAT */
int	 se_flag;   	/* saturation end value FLAG */

/*
 *  value start value (optional float)
 */
float	 vs_float;	/* value start value FLOAT */
int	 vs_flag;   	/* value start value FLAG */

/*
 *  value end value (optional float)
 */
float	 ve_float;	/* value end value FLOAT */
int	 ve_flag;   	/* value end value FLAG */

	/*-- nested optional MI group end --*/

	/*---- nested optional MI group ----*/
/*
 *  color parameters in RGB space (optional flag)
 */
int	 use_rgb_flag;  	/* color parameters in RGB space FLAG */

/*
 *  red start value (optional float)
 */
float	 rs_float;	/* red start value FLOAT */
int	 rs_flag;   	/* red start value FLAG */

/*
 *  red end value (optional float)
 */
float	 re_float;	/* red end value FLOAT */
int	 re_flag;   	/* red end value FLAG */

/*
 *  green start value (optional float)
 */
float	 gs_float;	/* green start value FLOAT */
int	 gs_flag;   	/* green start value FLAG */

/*
 *  green end value (optional float)
 */
float	 ge_float;	/* green end value FLOAT */
int	 ge_flag;   	/* green end value FLAG */

/*
 *  blue start value (optional float)
 */
float	 bs_float;	/* blue start value FLOAT */
int	 bs_flag;   	/* blue start value FLAG */

/*
 *  blue end value (optional float)
 */
float	 be_float;	/* blue end value FLOAT */
int	 be_flag;   	/* blue end value FLAG */

	/*-- nested optional MI group end --*/

/*-- required ME group end ---*/

/*
 *  number of entries in the vis colormap. (optional integer)
 */
int	 n_int; 	/* number of entries in the vis colormap. INT */
int	 n_flag;	/* number of entries in the vis colormap. FLAG */

/*
 *  value used for minimum bracket value in vis colormap (optional float)
 */
float	 minval_float;	/* value used for minimum bracket value in vis colormap FLOAT */
int	 minval_flag;   	/* value used for minimum bracket value in vis colormap FLAG */

/*
 *  value assioated with maximum bracket value in map. (optional float)
 */
float	 maxval_float;	/* value assioated with maximum bracket value in map. FLOAT */
int	 maxval_flag;   	/* value assioated with maximum bracket value in map. FLAG */

/*----- optional MI group ----*/
/*
 *  include opacity info in alpha channel of colormap (optional flag)
 */
int	 use_alpha_flag;  	/* include opacity info in alpha channel of colormap FLAG */

/*
 *  alpha start value (optional float)
 */
float	 as_float;	/* alpha start value FLOAT */
int	 as_flag;   	/* alpha start value FLAG */

/*
 *  alpha end value (optional float)
 */
float	 ae_float;	/* alpha end value FLOAT */
int	 ae_flag;   	/* alpha end value FLAG */

/*-- optional MI group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void ggencmap_get_args PROTO((kform *));
void ggencmap_usage_additions PROTO((void));
void ggencmap_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
