 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "gextents.h"
/*-----------------------------------------------------------
| 
|  Routine Name: gextents_get_args
| 
|       Purpose: Gets command line args for gextents
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gextents
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gextents_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for gextents is out of sync with arguments specified in gextents's *.pane file; please rerun ghostwriter on gextents.";

	char  *value_string;


	/*
	 * allocate the gextents structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "gextents_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "color", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->color_flag))))
	{
	    kerror(NULL, "gextents_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->color_toggle = atoi(value_string);

	if (!(kclui_get_value(pane, "type", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "gextents_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->type_toggle = atoi(value_string);

	if (!(kclui_get_string(pane, "name",
			  &(clui_info->name_string),
			  &(clui_info->name_flag))))
	{
	    kerror(NULL, "gextents_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "gextents_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



