 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gcmaplegend
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gcmaplegend.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Construct Geometry Representing a Color Legend
|
|       Purpose: main program for gcmaplegend
|
|         Input:
|		char *clui_info->i_file; {input vis colormap}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output geometry object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->name_string; {color legend}
|		int   clui_info->name_flag; {TRUE if -name specified}
|
|		int clui_info->orient_toggle; {legend orientation}
|		int clui_info->orient_flag; {TRUE if -orient specified}
|
|		int clui_info->reverse_logic; {reverse colors?}
|		int clui_info->reverse_flag; {TRUE if -reverse specified}
|
|		int clui_info->outline_logic; {make outline?}
|		int clui_info->outline_flag; {TRUE if -outline specified}
|
|		float clui_info->length_float; {length of legend}
|		int   clui_info->length_flag; {TRUE if -length specified}
|
|		float clui_info->thickness_float; {thickness of legend}
|		int   clui_info->thickness_flag; {TRUE if -thickness specified}
|
|		float clui_info->xpos_float; {x position}
|		int   clui_info->xpos_flag; {TRUE if -xpos specified}
|
|		float clui_info->ypos_float; {y position}
|		int   clui_info->ypos_flag; {TRUE if -ypos specified}
|
|        Output:
|       Returns:
|
|    Written By: Wes Bethel
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
    kobject input,output;
    char *name;
    int reverse,outline,horiz_vert;
    float length, thickness;
    float xpos, ypos;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gcmaplegend_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gcmaplegend",
		gcmaplegend_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gcmaplegend_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
    /* gather the parameters for the library call. */
    
    input = kpds_open_object(clui_info->i_file,KOBJ_READ);
    output = kgeom_open_output_object(clui_info->o_file);

    name = clui_info->name_string;
    reverse = clui_info->reverse_logic;
    outline = clui_info->outline_logic;
    length = clui_info->length_float;
    thickness = clui_info->thickness_float;
    horiz_vert = clui_info->orient_toggle;
    xpos = clui_info->xpos_float;
    ypos = clui_info->ypos_float;

    /* make assertions for the output object */
    /* kpds_set_attribute(output,KPDS_FORMAT,KVIFF); */
/* -main_before_lib_call_end */

/* -main_library_call */
    lgcmaplegend(input,output,name,reverse,outline,horiz_vert,&length,&thickness,&xpos,&ypos);
/* -main_library_call_end */

/* -main_after_lib_call */
    kpds_close_object(input);
    kgeom_close_object(output);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gcmaplegend_usage_additions
| 
|       Purpose: Prints usage additions in gcmaplegend_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gcmaplegend
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gcmaplegend_usage_additions(void)
{
	kfprintf(kstderr, "\tConstruct Geometry Representing a Color Legend\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gcmaplegend_free_args
| 
|       Purpose: Frees CLUI struct allocated in gcmaplegend_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gcmaplegend
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gcmaplegend_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->name_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
