
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/
#ifndef __rmatrix_h_
#define __rmatrix_h_

#include "geometry/geometry.h"

int identity_4x4 PROTO((matrix4x4 *));
int clear_4x1 PROTO((vector4 *));
int print_4x4matrix PROTO((matrix4x4 *));
int print_4x1vector PROTO((vector4 *));
int vector_4copy PROTO((vector4 *, vector4 *));
int matrix_4x4copy PROTO((matrix4x4 *,matrix4x4 *));
int point_xfrm PROTO((vector4 *,matrix4x4 *,vector4 *));
int mmul_4x4 PROTO((matrix4x4 *,matrix4x4 *,matrix4x4 *));
int clear_4x4 PROTO((matrix4x4 *));
int vector_4add PROTO((vector4 *,vector4 *,vector4 *));
int vector_4sub PROTO((vector4 *,vector4 *,vector4 *));
int vector_4scale PROTO((vector4 *, KGEOM_VERTEX_TYPE *, vector4 *));
int vector_4unit PROTO((vector4 *, double *));
int vector_4mag PROTO((vector4 *, double *));
int vector_4cross PROTO((vector4 *,vector4 *,vector4 *));
int npoint_diff PROTO((KGEOM_VERTEX_TYPE *,KGEOM_VERTEX_TYPE *,KGEOM_VERTEX_TYPE *, int ));
int npoint_add PROTO((KGEOM_VERTEX_TYPE *,KGEOM_VERTEX_TYPE *,KGEOM_VERTEX_TYPE *, int));
int npoint_xfrm PROTO((float *,matrix4x4 *,float *,int ));
int add_const_then_scale PROTO((KGEOM_VERTEX_TYPE *,KGEOM_VERTEX_TYPE,KGEOM_VERTEX_TYPE,KGEOM_VERTEX_TYPE *,int,int));
int scale_then_add_const PROTO((KGEOM_VERTEX_TYPE *,KGEOM_VERTEX_TYPE,KGEOM_VERTEX_TYPE,KGEOM_VERTEX_TYPE *,int,int));
int scale_vector PROTO((KGEOM_VERTEX_TYPE *,KGEOM_VERTEX_TYPE,KGEOM_VERTEX_TYPE *, int ,int));
int vect_min PROTO((KGEOM_VERTEX_TYPE *, int,int,int,KGEOM_VERTEX_TYPE *));
int vect_max PROTO((KGEOM_VERTEX_TYPE *,int,int,int,KGEOM_VERTEX_TYPE *));
int vmemset PROTO((char *,int,int,int,int));

int normal_xfrm PROTO((vertex_3d *,matrix4x4 *,vertex_3d *));
int nnormal_xfrm PROTO((vertex_3d *,matrix4x4 *,vertex_3d *,int));
int nnormal_unit PROTO((vertex_3d *, vertex_3d *, int ));

int vertex_copy PROTO((vertex_3d *, vertex_3d *,int));
int vertex_unit PROTO((vertex_3d *,double *));
int vertex_cross PROTO((vertex_3d *, vertex_3d *, vertex_3d *));

void nvertex_dot PROTO((vertex_3d *,vertex_3d *,float *,int));
int vertex_mag PROTO((vertex_3d *, double *));

int matrix_inverse PROTO((matrix4x4 *, matrix4x4 *));
void vert_aBX PROTO((vertex_3d *, vertex_3d *,float *,float *, int));
void nvertex_dot PROTO((vertex_3d *, vertex_3d *, float *, int));
void nvertex_dot_abs PROTO((vertex_3d *, vertex_3d *, float *, int));
void npoints_diff PROTO((vertex_3d *, vertex_3d *, vertex_3d *, int));
void f_pow PROTO((float *, float *, float *, int));
void f_ax PROTO((float *, float *, float *, int));

#endif
