 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "spectrum.h"
/*-----------------------------------------------------------
| 
|  Routine Name: spectrum_get_args
| 
|       Purpose: Gets command line args for spectrum
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname spectrum
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void spectrum_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for spectrum is out of sync with arguments specified in spectrum's *.pane file; please rerun ghostwriter on spectrum.";


	/*
	 * allocate the spectrum structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "spectrum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "l",
			  &(clui_info->l_file),
			  &(clui_info->l_flag))))
	{
	    kerror(NULL, "spectrum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "t",
			  &(clui_info->t_file),
			  &(clui_info->t_flag))))
	{
	    kerror(NULL, "spectrum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "visual", KVF_LIST_LABEL,
			  &(clui_info->visual_label),
			  &(clui_info->visual_flag)) &&
	      kclui_get_value(pane, "visual", KVF_LIST_VAL,
			  &(clui_info->visual_cycle),
			  &(clui_info->visual_flag))))
	{
	    kerror(NULL, "spectrum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "method", KVF_LIST_LABEL,
			  &(clui_info->method_label),
			  &(clui_info->method_flag)) &&
	      kclui_get_value(pane, "method", KVF_LIST_VAL,
			  &(clui_info->method_cycle),
			  &(clui_info->method_flag))))
	{
	    kerror(NULL, "spectrum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "form",
	                &(clui_info->form_file),
	                &(clui_info->form_flag))))
	{
	    kerror(NULL, "spectrum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "x",
	                &(clui_info->x_int),
	                &(clui_info->x_flag))))
	{
	    kerror(NULL, "spectrum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "y",
	                &(clui_info->y_int),
	                &(clui_info->y_flag))))
	{
	    kerror(NULL, "spectrum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

}



