 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for spectrum
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "spectrum.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Interactive Image Classification System
|
|       Purpose: main program for spectrum
|
|         Input:
|		char *clui_info->i_file; {Filename of Object with Input Image}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->l_file; {Filename of Object with Input Legend}
|		int   clui_info->l_flag; {TRUE if -l specified}
|
|		char *clui_info->t_file; {input display environment file}
|		int   clui_info->t_flag; {TRUE if -t specified}
|
|		int   clui_info->visual_cycle; {Read Only or Read Write Visual}
|		char *clui_info->visual_label;
|		int   clui_info->visual_flag; {TRUE if -visual specified}
|
|		int   clui_info->method_cycle; {method}
|		char *clui_info->method_label;
|		int   clui_info->method_flag; {TRUE if -method specified}
|
|		int clui_info->x_int; {x location for GUI autoplacement}
|		int clui_info->x_flag; {TRUE if -x specified}
|
|		int clui_info->y_int; {y location for GUI autoplacement}
|		int clui_info->y_flag; {TRUE if -y specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for spectrum    */ 
	char   *form_pathname;   /* location of spectrum.form   */
	char   *form_fullpath;   /* expanded spectrum.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	int    *zoommode;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(spectrum_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "ENVISION", "spectrum",
		spectrum_usage_additions);

	spectrum_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of spectrum.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("spectrum.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/spectrum/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for spectrum 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_spectrum, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_spectrum(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */
	spc_initialize();

	spc_create_zoom_display();
	spc_create_curve_display(); 
	spc_create_scatter_display(); 
	spc_create_contents_display(); 
	spc_create_stats_display(); 

	if ((clui_info->i_flag) && (clui_info->i_file != NULL))
	    spc_input_new_image(clui_info->i_file);

	spc_create_legend_display();

	/* read legend file */
	if ((clui_info->l_flag) && (clui_info->l_file != NULL))
	{
	    spc_read_legend_file(clui_info->l_file);
	    spc_update_all_classcontents_labels();
	}
	spc_initialize_legend_list();

	/* read display environment file */
	if ((clui_info->t_flag) && (clui_info->t_file != NULL))
	{
	    spc_read_environ_file(clui_info->t_file);
	}

	if (spc_legend_list != NULL)
	    spc_set_current_class(spc_legend_list);

	/* on opening of zoom subform, set update mode to button press */
	zoommode = (int *) kmalloc(sizeof(int));
	*zoommode = KZOOM_UM_BUTTON_PRESS;
        xvf_add_extra_call(gui_info->Zoom_struct, 
			   spc_set_zoommode, (kaddr) zoommode, XVF_CALL_LAST);

	/* on closing of zoom subform, set update mode to continuous */
	zoommode = (int *) kmalloc(sizeof(int));
	*zoommode = KZOOM_UM_CONTINUOUS;
	xvf_add_extra_call(gui_info->Zoom->zoom->quit_struct,
			   spc_set_zoommode, (kaddr) zoommode, XVF_CALL_LAST);
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: spectrum_usage_additions
| 
|       Purpose: Prints usage additions in spectrum_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname spectrum
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void spectrum_usage_additions(void)
{
	kfprintf(kstderr, "\tInteractive Image Classification System\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: spectrum_free_args
| 
|       Purpose: Frees CLUI struct allocated in spectrum_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname spectrum
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
spectrum_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
		kfree(clui_info->form_file);
	kfree(clui_info->i_file);
	kfree(clui_info->l_file);
	kfree(clui_info->t_file);
	kfree(clui_info->visual_label);
	kfree(clui_info->method_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
	spc_cleanup();
/* -free_handler_additions_end */
}
