 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_spectrum
   >>>> 	_xvf_free_spectrum
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_spectrum_warning
   >>>> 	_xvf_init_spectrum_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "spectrum.h"

static void _xvf_init_spectrum_warning PROTO((char *));
static void _xvf_init_spectrum_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_spectrum
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_spectrum_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_spectrum(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *master;

	master = form->master;
	/*
	 * initializing 'spectrum' Form Info structure
	 */

	forminfo->license_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.license");
	if (forminfo->license_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'license' on master form");

	forminfo->help_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.help");
	if (forminfo->help_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'help' on master form");

	forminfo->quit_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.quit");
	if (forminfo->quit_struct == NULL)
		    _xvf_init_spectrum_warning("quit button 'quit' on master form");
	forminfo->quit = FALSE;

	forminfo->image_workspace_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.image_workspace");
	if (forminfo->image_workspace_struct == NULL)
	    _xvf_init_spectrum_warning("workspace 'image_workspace' on master form");
	else
	{
	    kvf_get_attribute(forminfo->image_workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->image_workspace));

	}
	forminfo->add_class_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.add_class");
	if (forminfo->add_class_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'add_class' on master form");
	forminfo->add_class = FALSE;
	selection = forminfo->add_class_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->delete_class_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.delete_class");
	if (forminfo->delete_class_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'delete_class' on master form");
	forminfo->delete_class = FALSE;
	selection = forminfo->delete_class_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->select_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.select");
	if (forminfo->select_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'select' on master form");
	forminfo->select = FALSE;
	selection = forminfo->select_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->cluster_operation_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.cluster_operation");
	if (forminfo->cluster_operation_struct != NULL)
	{
	    selection = forminfo->cluster_operation_struct->Selptr;
	    kvf_get_attribute(forminfo->cluster_operation_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->cluster_operation_num));
	    forminfo->cluster_operation_val = 1;
	}
	else
	    _xvf_init_spectrum_warning("toggle selection 'cluster_operation' on master form");

	forminfo->cluster_operation_selected = FALSE;

	forminfo->add_cluster_manually_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.add_cluster_manually");
	if (forminfo->add_cluster_manually_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'add_cluster_manually' on master form");
	forminfo->add_cluster_manually = FALSE;
	selection = forminfo->add_cluster_manually_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->delete_cluster_manually_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.delete_cluster_manually");
	if (forminfo->delete_cluster_manually_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'delete_cluster_manually' on master form");
	forminfo->delete_cluster_manually = FALSE;
	selection = forminfo->delete_cluster_manually_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->reassign_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.reassign");
	if (forminfo->reassign_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'reassign' on master form");
	forminfo->reassign = FALSE;
	selection = forminfo->reassign_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->autoclass_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.autoclass");
	if (forminfo->autoclass_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'autoclass' on master form");
	forminfo->autoclass = FALSE;
	selection = forminfo->autoclass_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->b0_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.b0");
	if (forminfo->b0_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'b0' on master form");
	forminfo->cl_blk_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.cl_blk");
	if (forminfo->cl_blk_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'cl_blk' on master form");
	forminfo->select_blk_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.select_blk");
	if (forminfo->select_blk_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'select_blk' on master form");
	forminfo->label_blk_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.label_blk");
	if (forminfo->label_blk_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'label_blk' on master form");
	forminfo->currclass_blk_struct =
	    kvf_create_struct_from_selname(master->sel_list, "spectrum.currclass_blk");
	if (forminfo->currclass_blk_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'currclass_blk' on master form");
	forminfo->Files_struct =
	    kvf_create_struct_from_subformname(form, "spectrum.Files");
	if (forminfo->Files_struct == NULL)
	{
	    _xvf_init_spectrum_error("subform 'Files' on form 'spectrum'", 
			    "spectrum_Files");
	    return(FALSE);
	}

	/*
	 * initializing 'spectrum->Files' Subform Info structure
	 */

	forminfo->Files = (spectrum_Files *)
				kcalloc(1, sizeof(spectrum_Files));
	subform = forminfo->Files_struct->Subformptr;

	/*
	 * initializing 'spectrum->Files->files' Pane Info structure
	 */

	forminfo->Files->files = (Files_files *)
				kcalloc(1, sizeof(Files_files));
	forminfo->Files->files_struct =
	    kvf_create_struct_from_panename(subform, "spectrum.Files.files");
	if (forminfo->Files->files_struct == NULL)
	{
	    _xvf_init_spectrum_error("pane 'files' on subform 'Files'", "Files_files");
	    return(FALSE);
	}
	pane = forminfo->Files->files_struct->Controlptr;
	forminfo->Files->files->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.help");
	if (forminfo->Files->files->help_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'help' on pane 'files' of subform 'Files'");

	forminfo->Files->files->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.quit");
	if (forminfo->Files->files->quit_struct == NULL)
		    _xvf_init_spectrum_warning("quit button 'quit' on pane 'files' of subform 'Files'");
	forminfo->Files->files->quit = FALSE;

	forminfo->Files->files->in_image_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.in_image");
	if (forminfo->Files->files->in_image_struct != NULL)
	{
	    selection = forminfo->Files->files->in_image_struct->Selptr;
	    kvf_get_attribute(forminfo->Files->files->in_image_struct, KVF_FILE_DEF,
	                    &(forminfo->Files->files->in_image));
	}
	else
	    _xvf_init_spectrum_warning("input selection 'in_image' on pane 'files' of subform 'Files'");

	forminfo->Files->files->in_image_selected = FALSE;

	forminfo->Files->files->in_legend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.in_legend");
	if (forminfo->Files->files->in_legend_struct != NULL)
	{
	    selection = forminfo->Files->files->in_legend_struct->Selptr;
	    kvf_get_attribute(forminfo->Files->files->in_legend_struct, KVF_FILE_DEF,
	                    &(forminfo->Files->files->in_legend));
	}
	else
	    _xvf_init_spectrum_warning("input selection 'in_legend' on pane 'files' of subform 'Files'");

	forminfo->Files->files->in_legend_selected = FALSE;

	forminfo->Files->files->in_environ_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.in_environ");
	if (forminfo->Files->files->in_environ_struct != NULL)
	{
	    selection = forminfo->Files->files->in_environ_struct->Selptr;
	    kvf_get_attribute(forminfo->Files->files->in_environ_struct, KVF_FILE_DEF,
	                    &(forminfo->Files->files->in_environ));
	}
	else
	    _xvf_init_spectrum_warning("input selection 'in_environ' on pane 'files' of subform 'Files'");

	forminfo->Files->files->in_environ_selected = FALSE;

	forminfo->Files->files->out_image_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.out_image");
	if (forminfo->Files->files->out_image_struct != NULL)
	{
	    selection = forminfo->Files->files->out_image_struct->Selptr;
	    kvf_get_attribute(forminfo->Files->files->out_image_struct, KVF_FILE_DEF,
	                    &(forminfo->Files->files->out_image));
	}
	else
	    _xvf_init_spectrum_warning("output selection 'out_image' on pane 'files' of subform 'Files'");

	forminfo->Files->files->out_image_selected = FALSE;

	forminfo->Files->files->out_legend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.out_legend");
	if (forminfo->Files->files->out_legend_struct != NULL)
	{
	    selection = forminfo->Files->files->out_legend_struct->Selptr;
	    kvf_get_attribute(forminfo->Files->files->out_legend_struct, KVF_FILE_DEF,
	                    &(forminfo->Files->files->out_legend));
	}
	else
	    _xvf_init_spectrum_warning("output selection 'out_legend' on pane 'files' of subform 'Files'");

	forminfo->Files->files->out_legend_selected = FALSE;

	forminfo->Files->files->out_group_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.out_group");
	if (forminfo->Files->files->out_group_struct != NULL)
	{
	    selection = forminfo->Files->files->out_group_struct->Selptr;
	    kvf_get_attribute(forminfo->Files->files->out_group_struct, KVF_FILE_DEF,
	                    &(forminfo->Files->files->out_group));
	}
	else
	    _xvf_init_spectrum_warning("output selection 'out_group' on pane 'files' of subform 'Files'");

	forminfo->Files->files->out_group_selected = FALSE;

	forminfo->Files->files->out_maps_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.out_maps");
	if (forminfo->Files->files->out_maps_struct != NULL)
	{
	    selection = forminfo->Files->files->out_maps_struct->Selptr;
	    kvf_get_attribute(forminfo->Files->files->out_maps_struct, KVF_FILE_DEF,
	                    &(forminfo->Files->files->out_maps));
	}
	else
	    _xvf_init_spectrum_warning("output selection 'out_maps' on pane 'files' of subform 'Files'");

	forminfo->Files->files->out_maps_selected = FALSE;

	forminfo->Files->files->blk1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.blk1");
	if (forminfo->Files->files->blk1_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'blk1' on pane 'files' of subform 'Files'");
	forminfo->Files->files->blk10_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Files.files.blk10");
	if (forminfo->Files->files->blk10_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'blk10' on pane 'files' of subform 'Files'");
	forminfo->Disp_struct =
	    kvf_create_struct_from_subformname(form, "spectrum.Disp");
	if (forminfo->Disp_struct == NULL)
	{
	    _xvf_init_spectrum_error("subform 'Disp' on form 'spectrum'", 
			    "spectrum_Disp");
	    return(FALSE);
	}

	/*
	 * initializing 'spectrum->Disp' Subform Info structure
	 */

	forminfo->Disp = (spectrum_Disp *)
				kcalloc(1, sizeof(spectrum_Disp));
	subform = forminfo->Disp_struct->Subformptr;

	/*
	 * initializing 'spectrum->Disp->disp' Pane Info structure
	 */

	forminfo->Disp->disp = (Disp_disp *)
				kcalloc(1, sizeof(Disp_disp));
	forminfo->Disp->disp_struct =
	    kvf_create_struct_from_panename(subform, "spectrum.Disp.disp");
	if (forminfo->Disp->disp_struct == NULL)
	{
	    _xvf_init_spectrum_error("pane 'disp' on subform 'Disp'", "Disp_disp");
	    return(FALSE);
	}
	pane = forminfo->Disp->disp_struct->Controlptr;
	forminfo->Disp->disp->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.help");
	if (forminfo->Disp->disp->help_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'help' on pane 'disp' of subform 'Disp'");

	forminfo->Disp->disp->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.quit");
	if (forminfo->Disp->disp->quit_struct == NULL)
		    _xvf_init_spectrum_warning("quit button 'quit' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->quit = FALSE;

	forminfo->Disp->disp->norm_type_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.norm_type");
	if (forminfo->Disp->disp->norm_type_struct != NULL)
	{
	    selection = forminfo->Disp->disp->norm_type_struct->Selptr;
	    kvf_get_attribute(forminfo->Disp->disp->norm_type_struct, KVF_CYCLE_VAL,
	                    &(forminfo->Disp->disp->norm_type));
	    kvf_get_attribute(forminfo->Disp->disp->norm_type_struct, KVF_CYCLE_LABEL,
	                    &(forminfo->Disp->disp->norm_type_label));
	}
	else
	    _xvf_init_spectrum_warning("cycle selection 'norm_type' on pane 'disp' of subform 'Disp'");

	forminfo->Disp->disp->norm_type_selected = FALSE;

	forminfo->Disp->disp->norm_method_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.norm_method");
	if (forminfo->Disp->disp->norm_method_struct != NULL)
	{
	    selection = forminfo->Disp->disp->norm_method_struct->Selptr;
	    kvf_get_attribute(forminfo->Disp->disp->norm_method_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->Disp->disp->norm_method_num));
	    forminfo->Disp->disp->norm_method_val = 3;
	}
	else
	    _xvf_init_spectrum_warning("toggle selection 'norm_method' on pane 'disp' of subform 'Disp'");

	forminfo->Disp->disp->norm_method_selected = FALSE;

	forminfo->Disp->disp->change_mapcol_names_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.change_mapcol_names");
	if (forminfo->Disp->disp->change_mapcol_names_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'change_mapcol_names' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->change_mapcol_names = FALSE;
	selection = forminfo->Disp->disp->change_mapcol_names_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Disp->disp->list_mapcol_names_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.list_mapcol_names");
	if (forminfo->Disp->disp->list_mapcol_names_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'list_mapcol_names' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->list_mapcol_names = FALSE;
	selection = forminfo->Disp->disp->list_mapcol_names_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Disp->disp->t_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.t");
	if (forminfo->Disp->disp->t_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 't' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->t = FALSE;
	selection = forminfo->Disp->disp->t_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Disp->disp->red_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.red");
	if (forminfo->Disp->disp->red_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'red' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->red = FALSE;
	selection = forminfo->Disp->disp->red_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Disp->disp->green_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.green");
	if (forminfo->Disp->disp->green_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'green' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->green = FALSE;
	selection = forminfo->Disp->disp->green_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Disp->disp->blue_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.blue");
	if (forminfo->Disp->disp->blue_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'blue' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->blue = FALSE;
	selection = forminfo->Disp->disp->blue_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Disp->disp->red_func_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.red_func");
	if (forminfo->Disp->disp->red_func_struct != NULL)
	{
	    selection = forminfo->Disp->disp->red_func_struct->Selptr;
	    kvf_get_attribute(forminfo->Disp->disp->red_func_struct, KVF_STRING_DEF,
	                    &(forminfo->Disp->disp->red_func));
	}
	else
	    _xvf_init_spectrum_warning("string selection 'red_func' on pane 'disp' of subform 'Disp'");

	forminfo->Disp->disp->red_func_selected = FALSE;

	forminfo->Disp->disp->green_func_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.green_func");
	if (forminfo->Disp->disp->green_func_struct != NULL)
	{
	    selection = forminfo->Disp->disp->green_func_struct->Selptr;
	    kvf_get_attribute(forminfo->Disp->disp->green_func_struct, KVF_STRING_DEF,
	                    &(forminfo->Disp->disp->green_func));
	}
	else
	    _xvf_init_spectrum_warning("string selection 'green_func' on pane 'disp' of subform 'Disp'");

	forminfo->Disp->disp->green_func_selected = FALSE;

	forminfo->Disp->disp->blue_func_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.blue_func");
	if (forminfo->Disp->disp->blue_func_struct != NULL)
	{
	    selection = forminfo->Disp->disp->blue_func_struct->Selptr;
	    kvf_get_attribute(forminfo->Disp->disp->blue_func_struct, KVF_STRING_DEF,
	                    &(forminfo->Disp->disp->blue_func));
	}
	else
	    _xvf_init_spectrum_warning("string selection 'blue_func' on pane 'disp' of subform 'Disp'");

	forminfo->Disp->disp->blue_func_selected = FALSE;

	forminfo->Disp->disp->blank3A_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.blank3A");
	if (forminfo->Disp->disp->blank3A_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'blank3A' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->blank4A_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.blank4A");
	if (forminfo->Disp->disp->blank4A_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'blank4A' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->blank4B_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.blank4B");
	if (forminfo->Disp->disp->blank4B_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'blank4B' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->redcol_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.redcol");
	if (forminfo->Disp->disp->redcol_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'redcol' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->grcol_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.grcol");
	if (forminfo->Disp->disp->grcol_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'grcol' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->blcol_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.blcol");
	if (forminfo->Disp->disp->blcol_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'blcol' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->blank7_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.blank7");
	if (forminfo->Disp->disp->blank7_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'blank7' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->blank1A_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.blank1A");
	if (forminfo->Disp->disp->blank1A_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'blank1A' on pane 'disp' of subform 'Disp'");
	forminfo->Disp->disp->curr_trans_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Disp.disp.curr_trans");
	if (forminfo->Disp->disp->curr_trans_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'curr_trans' on pane 'disp' of subform 'Disp'");
	forminfo->Curve_struct =
	    kvf_create_struct_from_subformname(form, "spectrum.Curve");
	if (forminfo->Curve_struct == NULL)
	{
	    _xvf_init_spectrum_error("subform 'Curve' on form 'spectrum'", 
			    "spectrum_Curve");
	    return(FALSE);
	}

	/*
	 * initializing 'spectrum->Curve' Subform Info structure
	 */

	forminfo->Curve = (spectrum_Curve *)
				kcalloc(1, sizeof(spectrum_Curve));
	subform = forminfo->Curve_struct->Subformptr;

	/*
	 * initializing 'spectrum->Curve->curve' Pane Info structure
	 */

	forminfo->Curve->curve = (Curve_curve *)
				kcalloc(1, sizeof(Curve_curve));
	forminfo->Curve->curve_struct =
	    kvf_create_struct_from_panename(subform, "spectrum.Curve.curve");
	if (forminfo->Curve->curve_struct == NULL)
	{
	    _xvf_init_spectrum_error("pane 'curve' on subform 'Curve'", "Curve_curve");
	    return(FALSE);
	}
	pane = forminfo->Curve->curve_struct->Controlptr;
	forminfo->Curve->curve->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Curve.curve.help");
	if (forminfo->Curve->curve->help_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'help' on pane 'curve' of subform 'Curve'");

	forminfo->Curve->curve->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Curve.curve.quit");
	if (forminfo->Curve->curve->quit_struct == NULL)
		    _xvf_init_spectrum_warning("quit button 'quit' on pane 'curve' of subform 'Curve'");
	forminfo->Curve->curve->quit = FALSE;

	forminfo->Curve->curve->update_mode_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Curve.curve.update_mode");
	if (forminfo->Curve->curve->update_mode_struct != NULL)
	{
	    selection = forminfo->Curve->curve->update_mode_struct->Selptr;
	    kvf_get_attribute(forminfo->Curve->curve->update_mode_struct, KVF_LOGIC_DEF,
	                    &(forminfo->Curve->curve->update_mode));
	    kvf_get_attribute(forminfo->Curve->curve->update_mode_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->Curve->curve->update_mode_label));
	}
	else
	    _xvf_init_spectrum_warning("logical selection 'update_mode' on pane 'curve' of subform 'Curve'");

	forminfo->Curve->curve->update_mode_selected = FALSE;

	forminfo->Curve->curve->clear_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Curve.curve.clear");
	if (forminfo->Curve->curve->clear_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'clear' on pane 'curve' of subform 'Curve'");
	forminfo->Curve->curve->clear = FALSE;
	selection = forminfo->Curve->curve->clear_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Curve(forminfo->Curve);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_curve(forminfo->Curve->curve);
	forminfo->Curve->curve->curve_workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Curve.curve.curve_workspace");
	if (forminfo->Curve->curve->curve_workspace_struct == NULL)
	    _xvf_init_spectrum_warning("workspace 'curve_workspace' on pane 'curve' of subform 'Curve'");
	else
	{
	    kvf_get_attribute(forminfo->Curve->curve->curve_workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->Curve->curve->curve_workspace));

	}
	forminfo->Legend_struct =
	    kvf_create_struct_from_subformname(form, "spectrum.Legend");
	if (forminfo->Legend_struct == NULL)
	{
	    _xvf_init_spectrum_error("subform 'Legend' on form 'spectrum'", 
			    "spectrum_Legend");
	    return(FALSE);
	}

	/*
	 * initializing 'spectrum->Legend' Subform Info structure
	 */

	forminfo->Legend = (spectrum_Legend *)
				kcalloc(1, sizeof(spectrum_Legend));
	subform = forminfo->Legend_struct->Subformptr;

	/*
	 * initializing 'spectrum->Legend->legend' Pane Info structure
	 */

	forminfo->Legend->legend = (Legend_legend *)
				kcalloc(1, sizeof(Legend_legend));
	forminfo->Legend->legend_struct =
	    kvf_create_struct_from_panename(subform, "spectrum.Legend.legend");
	if (forminfo->Legend->legend_struct == NULL)
	{
	    _xvf_init_spectrum_error("pane 'legend' on subform 'Legend'", "Legend_legend");
	    return(FALSE);
	}
	pane = forminfo->Legend->legend_struct->Controlptr;
	forminfo->Legend->legend->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Legend.legend.help");
	if (forminfo->Legend->legend->help_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'help' on pane 'legend' of subform 'Legend'");

	forminfo->Legend->legend->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Legend.legend.quit");
	if (forminfo->Legend->legend->quit_struct == NULL)
		    _xvf_init_spectrum_warning("quit button 'quit' on pane 'legend' of subform 'Legend'");
	forminfo->Legend->legend->quit = FALSE;

	forminfo->Legend->legend->empty_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Legend.legend.empty");
	if (forminfo->Legend->legend->empty_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'empty' on pane 'legend' of subform 'Legend'");
	forminfo->Legend->legend->empty = FALSE;
	selection = forminfo->Legend->legend->empty_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Legend->legend->show_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Legend.legend.show");
	if (forminfo->Legend->legend->show_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'show' on pane 'legend' of subform 'Legend'");
	forminfo->Legend->legend->show = FALSE;
	selection = forminfo->Legend->legend->show_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Legend->legend->catch_all_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Legend.legend.catch_all");
	if (forminfo->Legend->legend->catch_all_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'catch_all' on pane 'legend' of subform 'Legend'");
	forminfo->Legend->legend->catch_all = FALSE;
	selection = forminfo->Legend->legend->catch_all_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Legend->legend->hide_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Legend.legend.hide");
	if (forminfo->Legend->legend->hide_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'hide' on pane 'legend' of subform 'Legend'");
	forminfo->Legend->legend->hide = FALSE;
	selection = forminfo->Legend->legend->hide_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Legend->legend->transfer_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Legend.legend.transfer");
	if (forminfo->Legend->legend->transfer_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'transfer' on pane 'legend' of subform 'Legend'");
	forminfo->Legend->legend->transfer = FALSE;
	selection = forminfo->Legend->legend->transfer_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Legend(forminfo->Legend);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_legend(forminfo->Legend->legend);
	forminfo->Legend->legend->legend_workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Legend.legend.legend_workspace");
	if (forminfo->Legend->legend->legend_workspace_struct == NULL)
	    _xvf_init_spectrum_warning("workspace 'legend_workspace' on pane 'legend' of subform 'Legend'");
	else
	{
	    kvf_get_attribute(forminfo->Legend->legend->legend_workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->Legend->legend->legend_workspace));

	}
	forminfo->Zoom_struct =
	    kvf_create_struct_from_subformname(form, "spectrum.Zoom");
	if (forminfo->Zoom_struct == NULL)
	{
	    _xvf_init_spectrum_error("subform 'Zoom' on form 'spectrum'", 
			    "spectrum_Zoom");
	    return(FALSE);
	}

	/*
	 * initializing 'spectrum->Zoom' Subform Info structure
	 */

	forminfo->Zoom = (spectrum_Zoom *)
				kcalloc(1, sizeof(spectrum_Zoom));
	subform = forminfo->Zoom_struct->Subformptr;

	/*
	 * initializing 'spectrum->Zoom->zoom' Pane Info structure
	 */

	forminfo->Zoom->zoom = (Zoom_zoom *)
				kcalloc(1, sizeof(Zoom_zoom));
	forminfo->Zoom->zoom_struct =
	    kvf_create_struct_from_panename(subform, "spectrum.Zoom.zoom");
	if (forminfo->Zoom->zoom_struct == NULL)
	{
	    _xvf_init_spectrum_error("pane 'zoom' on subform 'Zoom'", "Zoom_zoom");
	    return(FALSE);
	}
	pane = forminfo->Zoom->zoom_struct->Controlptr;
	forminfo->Zoom->zoom->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Zoom.zoom.help");
	if (forminfo->Zoom->zoom->help_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'help' on pane 'zoom' of subform 'Zoom'");

	forminfo->Zoom->zoom->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Zoom.zoom.quit");
	if (forminfo->Zoom->zoom->quit_struct == NULL)
		    _xvf_init_spectrum_warning("quit button 'quit' on pane 'zoom' of subform 'Zoom'");
	forminfo->Zoom->zoom->quit = FALSE;

	forminfo->Zoom->zoom->zoommode_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Zoom.zoom.zoommode");
	if (forminfo->Zoom->zoom->zoommode_struct != NULL)
	{
	    selection = forminfo->Zoom->zoom->zoommode_struct->Selptr;
	    kvf_get_attribute(forminfo->Zoom->zoom->zoommode_struct, KVF_LOGIC_DEF,
	                    &(forminfo->Zoom->zoom->zoommode));
	    kvf_get_attribute(forminfo->Zoom->zoom->zoommode_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->Zoom->zoom->zoommode_label));
	}
	else
	    _xvf_init_spectrum_warning("logical selection 'zoommode' on pane 'zoom' of subform 'Zoom'");

	forminfo->Zoom->zoom->zoommode_selected = FALSE;

	forminfo->Zoom->zoom->zoomfactor_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Zoom.zoom.zoomfactor");
	if (forminfo->Zoom->zoom->zoomfactor_struct != NULL)
	{
	    selection = forminfo->Zoom->zoom->zoomfactor_struct->Selptr;
	    kvf_get_attribute(forminfo->Zoom->zoom->zoomfactor_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->Zoom->zoom->zoomfactor));
	}
	else
	    _xvf_init_spectrum_warning("double selection 'zoomfactor' on pane 'zoom' of subform 'Zoom'");

	forminfo->Zoom->zoom->zoomfactor_selected = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Zoom(forminfo->Zoom);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_zoom(forminfo->Zoom->zoom);
	forminfo->Zoom->zoom->zoom_workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Zoom.zoom.zoom_workspace");
	if (forminfo->Zoom->zoom->zoom_workspace_struct == NULL)
	    _xvf_init_spectrum_warning("workspace 'zoom_workspace' on pane 'zoom' of subform 'Zoom'");
	else
	{
	    kvf_get_attribute(forminfo->Zoom->zoom->zoom_workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->Zoom->zoom->zoom_workspace));

	}
	forminfo->Scatter_struct =
	    kvf_create_struct_from_subformname(form, "spectrum.Scatter");
	if (forminfo->Scatter_struct == NULL)
	{
	    _xvf_init_spectrum_error("subform 'Scatter' on form 'spectrum'", 
			    "spectrum_Scatter");
	    return(FALSE);
	}

	/*
	 * initializing 'spectrum->Scatter' Subform Info structure
	 */

	forminfo->Scatter = (spectrum_Scatter *)
				kcalloc(1, sizeof(spectrum_Scatter));
	subform = forminfo->Scatter_struct->Subformptr;

	/*
	 * initializing 'spectrum->Scatter->scatter' Pane Info structure
	 */

	forminfo->Scatter->scatter = (Scatter_scatter *)
				kcalloc(1, sizeof(Scatter_scatter));
	forminfo->Scatter->scatter_struct =
	    kvf_create_struct_from_panename(subform, "spectrum.Scatter.scatter");
	if (forminfo->Scatter->scatter_struct == NULL)
	{
	    _xvf_init_spectrum_error("pane 'scatter' on subform 'Scatter'", "Scatter_scatter");
	    return(FALSE);
	}
	pane = forminfo->Scatter->scatter_struct->Controlptr;
	forminfo->Scatter->scatter->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.help");
	if (forminfo->Scatter->scatter->help_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'help' on pane 'scatter' of subform 'Scatter'");

	forminfo->Scatter->scatter->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.quit");
	if (forminfo->Scatter->scatter->quit_struct == NULL)
		    _xvf_init_spectrum_warning("quit button 'quit' on pane 'scatter' of subform 'Scatter'");
	forminfo->Scatter->scatter->quit = FALSE;

	forminfo->Scatter->scatter->x_column_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.x_column");
	if (forminfo->Scatter->scatter->x_column_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'x_column' on pane 'scatter' of subform 'Scatter'");
	forminfo->Scatter->scatter->x_column = FALSE;
	selection = forminfo->Scatter->scatter->x_column_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Scatter->scatter->y_column_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.y_column");
	if (forminfo->Scatter->scatter->y_column_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'y_column' on pane 'scatter' of subform 'Scatter'");
	forminfo->Scatter->scatter->y_column = FALSE;
	selection = forminfo->Scatter->scatter->y_column_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Scatter->scatter->x_func_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.x_func");
	if (forminfo->Scatter->scatter->x_func_struct != NULL)
	{
	    selection = forminfo->Scatter->scatter->x_func_struct->Selptr;
	    kvf_get_attribute(forminfo->Scatter->scatter->x_func_struct, KVF_STRING_DEF,
	                    &(forminfo->Scatter->scatter->x_func));
	}
	else
	    _xvf_init_spectrum_warning("string selection 'x_func' on pane 'scatter' of subform 'Scatter'");

	forminfo->Scatter->scatter->x_func_selected = FALSE;

	forminfo->Scatter->scatter->y_func_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.y_func");
	if (forminfo->Scatter->scatter->y_func_struct != NULL)
	{
	    selection = forminfo->Scatter->scatter->y_func_struct->Selptr;
	    kvf_get_attribute(forminfo->Scatter->scatter->y_func_struct, KVF_STRING_DEF,
	                    &(forminfo->Scatter->scatter->y_func));
	}
	else
	    _xvf_init_spectrum_warning("string selection 'y_func' on pane 'scatter' of subform 'Scatter'");

	forminfo->Scatter->scatter->y_func_selected = FALSE;

	forminfo->Scatter->scatter->set_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.set");
	if (forminfo->Scatter->scatter->set_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'set' on pane 'scatter' of subform 'Scatter'");
	forminfo->Scatter->scatter->set = FALSE;
	selection = forminfo->Scatter->scatter->set_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Scatter->scatter->reset_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.reset");
	if (forminfo->Scatter->scatter->reset_struct == NULL)
	    _xvf_init_spectrum_warning("pane action button 'reset' on pane 'scatter' of subform 'Scatter'");
	forminfo->Scatter->scatter->reset = FALSE;
	selection = forminfo->Scatter->scatter->reset_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Scatter(forminfo->Scatter);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_scatter(forminfo->Scatter->scatter);
	forminfo->Scatter->scatter->plot_workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.plot_workspace");
	if (forminfo->Scatter->scatter->plot_workspace_struct == NULL)
	    _xvf_init_spectrum_warning("workspace 'plot_workspace' on pane 'scatter' of subform 'Scatter'");
	else
	{
	    kvf_get_attribute(forminfo->Scatter->scatter->plot_workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->Scatter->scatter->plot_workspace));

	}
	forminfo->Scatter->scatter->xcol_blank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.xcol_blank");
	if (forminfo->Scatter->scatter->xcol_blank_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'xcol_blank' on pane 'scatter' of subform 'Scatter'");
	forminfo->Scatter->scatter->ycol_blank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Scatter.scatter.ycol_blank");
	if (forminfo->Scatter->scatter->ycol_blank_struct == NULL)
	    _xvf_init_spectrum_warning("blank selection 'ycol_blank' on pane 'scatter' of subform 'Scatter'");
	forminfo->Stats_struct =
	    kvf_create_struct_from_subformname(form, "spectrum.Stats");
	if (forminfo->Stats_struct == NULL)
	{
	    _xvf_init_spectrum_error("subform 'Stats' on form 'spectrum'", 
			    "spectrum_Stats");
	    return(FALSE);
	}

	/*
	 * initializing 'spectrum->Stats' Subform Info structure
	 */

	forminfo->Stats = (spectrum_Stats *)
				kcalloc(1, sizeof(spectrum_Stats));
	subform = forminfo->Stats_struct->Subformptr;

	/*
	 * initializing 'spectrum->Stats->stats' Pane Info structure
	 */

	forminfo->Stats->stats = (Stats_stats *)
				kcalloc(1, sizeof(Stats_stats));
	forminfo->Stats->stats_struct =
	    kvf_create_struct_from_panename(subform, "spectrum.Stats.stats");
	if (forminfo->Stats->stats_struct == NULL)
	{
	    _xvf_init_spectrum_error("pane 'stats' on subform 'Stats'", "Stats_stats");
	    return(FALSE);
	}
	pane = forminfo->Stats->stats_struct->Controlptr;
	forminfo->Stats->stats->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Stats.stats.help");
	if (forminfo->Stats->stats->help_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'help' on pane 'stats' of subform 'Stats'");

	forminfo->Stats->stats->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Stats.stats.quit");
	if (forminfo->Stats->stats->quit_struct == NULL)
		    _xvf_init_spectrum_warning("quit button 'quit' on pane 'stats' of subform 'Stats'");
	forminfo->Stats->stats->quit = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Stats(forminfo->Stats);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_stats(forminfo->Stats->stats);
	forminfo->Stats->stats->stats_wksp_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Stats.stats.stats_wksp");
	if (forminfo->Stats->stats->stats_wksp_struct == NULL)
	    _xvf_init_spectrum_warning("workspace 'stats_wksp' on pane 'stats' of subform 'Stats'");
	else
	{
	    kvf_get_attribute(forminfo->Stats->stats->stats_wksp_struct, KVF_WORKSPACE,
	                    &(forminfo->Stats->stats->stats_wksp));

	}
	forminfo->Contents_struct =
	    kvf_create_struct_from_subformname(form, "spectrum.Contents");
	if (forminfo->Contents_struct == NULL)
	{
	    _xvf_init_spectrum_error("subform 'Contents' on form 'spectrum'", 
			    "spectrum_Contents");
	    return(FALSE);
	}

	/*
	 * initializing 'spectrum->Contents' Subform Info structure
	 */

	forminfo->Contents = (spectrum_Contents *)
				kcalloc(1, sizeof(spectrum_Contents));
	subform = forminfo->Contents_struct->Subformptr;

	/*
	 * initializing 'spectrum->Contents->contents' Pane Info structure
	 */

	forminfo->Contents->contents = (Contents_contents *)
				kcalloc(1, sizeof(Contents_contents));
	forminfo->Contents->contents_struct =
	    kvf_create_struct_from_panename(subform, "spectrum.Contents.contents");
	if (forminfo->Contents->contents_struct == NULL)
	{
	    _xvf_init_spectrum_error("pane 'contents' on subform 'Contents'", "Contents_contents");
	    return(FALSE);
	}
	pane = forminfo->Contents->contents_struct->Controlptr;
	forminfo->Contents->contents->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Contents.contents.help");
	if (forminfo->Contents->contents->help_struct == NULL)
		    _xvf_init_spectrum_warning("unknown selection 'help' on pane 'contents' of subform 'Contents'");

	forminfo->Contents->contents->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Contents.contents.quit");
	if (forminfo->Contents->contents->quit_struct == NULL)
		    _xvf_init_spectrum_warning("quit button 'quit' on pane 'contents' of subform 'Contents'");
	forminfo->Contents->contents->quit = FALSE;

	forminfo->Contents->contents->o_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Contents.contents.o");
	if (forminfo->Contents->contents->o_struct != NULL)
	{
	    selection = forminfo->Contents->contents->o_struct->Selptr;
	    kvf_get_attribute(forminfo->Contents->contents->o_struct, KVF_FILE_DEF,
	                    &(forminfo->Contents->contents->o));
	}
	else
	    _xvf_init_spectrum_warning("output selection 'o' on pane 'contents' of subform 'Contents'");

	forminfo->Contents->contents->o_selected = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Contents(forminfo->Contents);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_contents(forminfo->Contents->contents);
	forminfo->Contents->contents->contents_wksp_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "spectrum.Contents.contents.contents_wksp");
	if (forminfo->Contents->contents->contents_wksp_struct == NULL)
	    _xvf_init_spectrum_warning("workspace 'contents_wksp' on pane 'contents' of subform 'Contents'");
	else
	{
	    kvf_get_attribute(forminfo->Contents->contents->contents_wksp_struct, KVF_WORKSPACE,
	                    &(forminfo->Contents->contents->contents_wksp));

	}
	forminfo->spectrum_struct =
	    kvf_create_struct_from_mastername(form, "spectrum");
	if (forminfo->spectrum_struct == NULL)
	{
	    _xvf_init_spectrum_error("form 'spectrum'",
			    "gui_info");
	    return(FALSE);
	}

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_spectrum_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_spectrum_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_spectrum_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_spectrum_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_spectrum
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_spectrum_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_spectrum(
    gui_info_struct *forminfo)
{
	if (forminfo->license_struct != NULL)
	    kfree(forminfo->license_struct);
	if (forminfo->help_struct != NULL)
	    kfree(forminfo->help_struct);
	if (forminfo->quit_struct != NULL)
	    kfree(forminfo->quit_struct);
	if (forminfo->image_workspace_struct != NULL)
	    kfree(forminfo->image_workspace_struct);
	if (forminfo->add_class_struct != NULL)
	    kfree(forminfo->add_class_struct);
	if (forminfo->delete_class_struct != NULL)
	    kfree(forminfo->delete_class_struct);
	if (forminfo->select_struct != NULL)
	    kfree(forminfo->select_struct);
	if (forminfo->cluster_operation_struct != NULL)
	    kfree(forminfo->cluster_operation_struct);
	if (forminfo->add_cluster_manually_struct != NULL)
	    kfree(forminfo->add_cluster_manually_struct);
	if (forminfo->delete_cluster_manually_struct != NULL)
	    kfree(forminfo->delete_cluster_manually_struct);
	if (forminfo->reassign_struct != NULL)
	    kfree(forminfo->reassign_struct);
	if (forminfo->autoclass_struct != NULL)
	    kfree(forminfo->autoclass_struct);
	if (forminfo->b0_struct != NULL)
	    kfree(forminfo->b0_struct);
	if (forminfo->cl_blk_struct != NULL)
	    kfree(forminfo->cl_blk_struct);
	if (forminfo->select_blk_struct != NULL)
	    kfree(forminfo->select_blk_struct);
	if (forminfo->label_blk_struct != NULL)
	    kfree(forminfo->label_blk_struct);
	if (forminfo->currclass_blk_struct != NULL)
	    kfree(forminfo->currclass_blk_struct);
	if (forminfo->Files->files->help_struct != NULL)
	    kfree(forminfo->Files->files->help_struct);
	if (forminfo->Files->files->quit_struct != NULL)
	    kfree(forminfo->Files->files->quit_struct);
	kfree(forminfo->Files->files->in_image);
	if (forminfo->Files->files->in_image_struct != NULL)
	    kfree(forminfo->Files->files->in_image_struct);
	kfree(forminfo->Files->files->in_legend);
	if (forminfo->Files->files->in_legend_struct != NULL)
	    kfree(forminfo->Files->files->in_legend_struct);
	kfree(forminfo->Files->files->in_environ);
	if (forminfo->Files->files->in_environ_struct != NULL)
	    kfree(forminfo->Files->files->in_environ_struct);
	kfree(forminfo->Files->files->out_image);
	if (forminfo->Files->files->out_image_struct != NULL)
	    kfree(forminfo->Files->files->out_image_struct);
	kfree(forminfo->Files->files->out_legend);
	if (forminfo->Files->files->out_legend_struct != NULL)
	    kfree(forminfo->Files->files->out_legend_struct);
	kfree(forminfo->Files->files->out_group);
	if (forminfo->Files->files->out_group_struct != NULL)
	    kfree(forminfo->Files->files->out_group_struct);
	kfree(forminfo->Files->files->out_maps);
	if (forminfo->Files->files->out_maps_struct != NULL)
	    kfree(forminfo->Files->files->out_maps_struct);
	if (forminfo->Files->files->blk1_struct != NULL)
	    kfree(forminfo->Files->files->blk1_struct);
	if (forminfo->Files->files->blk10_struct != NULL)
	    kfree(forminfo->Files->files->blk10_struct);
	kfree(forminfo->Files->files);
	if (forminfo->Files->files_struct != NULL)
	    kfree(forminfo->Files->files_struct);


	if (forminfo->Files_struct != NULL)
	    kfree(forminfo->Files_struct);
	kfree(forminfo->Files);
	if (forminfo->Disp->disp->help_struct != NULL)
	    kfree(forminfo->Disp->disp->help_struct);
	if (forminfo->Disp->disp->quit_struct != NULL)
	    kfree(forminfo->Disp->disp->quit_struct);
	if (forminfo->Disp->disp->norm_type_struct != NULL)
	    kfree(forminfo->Disp->disp->norm_type_struct);
	kfree(forminfo->Disp->disp->norm_type_label);
	if (forminfo->Disp->disp->norm_method_struct != NULL)
	    kfree(forminfo->Disp->disp->norm_method_struct);
	if (forminfo->Disp->disp->change_mapcol_names_struct != NULL)
	    kfree(forminfo->Disp->disp->change_mapcol_names_struct);
	if (forminfo->Disp->disp->list_mapcol_names_struct != NULL)
	    kfree(forminfo->Disp->disp->list_mapcol_names_struct);
	if (forminfo->Disp->disp->t_struct != NULL)
	    kfree(forminfo->Disp->disp->t_struct);
	if (forminfo->Disp->disp->red_struct != NULL)
	    kfree(forminfo->Disp->disp->red_struct);
	if (forminfo->Disp->disp->green_struct != NULL)
	    kfree(forminfo->Disp->disp->green_struct);
	if (forminfo->Disp->disp->blue_struct != NULL)
	    kfree(forminfo->Disp->disp->blue_struct);
	kfree(forminfo->Disp->disp->red_func);
	if (forminfo->Disp->disp->red_func_struct != NULL)
	    kfree(forminfo->Disp->disp->red_func_struct);
	kfree(forminfo->Disp->disp->green_func);
	if (forminfo->Disp->disp->green_func_struct != NULL)
	    kfree(forminfo->Disp->disp->green_func_struct);
	kfree(forminfo->Disp->disp->blue_func);
	if (forminfo->Disp->disp->blue_func_struct != NULL)
	    kfree(forminfo->Disp->disp->blue_func_struct);
	if (forminfo->Disp->disp->blank3A_struct != NULL)
	    kfree(forminfo->Disp->disp->blank3A_struct);
	if (forminfo->Disp->disp->blank4A_struct != NULL)
	    kfree(forminfo->Disp->disp->blank4A_struct);
	if (forminfo->Disp->disp->blank4B_struct != NULL)
	    kfree(forminfo->Disp->disp->blank4B_struct);
	if (forminfo->Disp->disp->redcol_struct != NULL)
	    kfree(forminfo->Disp->disp->redcol_struct);
	if (forminfo->Disp->disp->grcol_struct != NULL)
	    kfree(forminfo->Disp->disp->grcol_struct);
	if (forminfo->Disp->disp->blcol_struct != NULL)
	    kfree(forminfo->Disp->disp->blcol_struct);
	if (forminfo->Disp->disp->blank7_struct != NULL)
	    kfree(forminfo->Disp->disp->blank7_struct);
	if (forminfo->Disp->disp->blank1A_struct != NULL)
	    kfree(forminfo->Disp->disp->blank1A_struct);
	if (forminfo->Disp->disp->curr_trans_struct != NULL)
	    kfree(forminfo->Disp->disp->curr_trans_struct);
	kfree(forminfo->Disp->disp);
	if (forminfo->Disp->disp_struct != NULL)
	    kfree(forminfo->Disp->disp_struct);


	if (forminfo->Disp_struct != NULL)
	    kfree(forminfo->Disp_struct);
	kfree(forminfo->Disp);
	if (forminfo->Curve->curve->help_struct != NULL)
	    kfree(forminfo->Curve->curve->help_struct);
	if (forminfo->Curve->curve->quit_struct != NULL)
	    kfree(forminfo->Curve->curve->quit_struct);
	if (forminfo->Curve->curve->update_mode_struct != NULL)
	    kfree(forminfo->Curve->curve->update_mode_struct);
	kfree(forminfo->Curve->curve->update_mode_label);
	if (forminfo->Curve->curve->clear_struct != NULL)
	    kfree(forminfo->Curve->curve->clear_struct);
	if (forminfo->Curve->curve->curve_workspace_struct != NULL)
	    kfree(forminfo->Curve->curve->curve_workspace_struct);
	kfree(forminfo->Curve->curve);
	if (forminfo->Curve->curve_struct != NULL)
	    kfree(forminfo->Curve->curve_struct);


	if (forminfo->Curve_struct != NULL)
	    kfree(forminfo->Curve_struct);
	kfree(forminfo->Curve);
	if (forminfo->Legend->legend->help_struct != NULL)
	    kfree(forminfo->Legend->legend->help_struct);
	if (forminfo->Legend->legend->quit_struct != NULL)
	    kfree(forminfo->Legend->legend->quit_struct);
	if (forminfo->Legend->legend->empty_struct != NULL)
	    kfree(forminfo->Legend->legend->empty_struct);
	if (forminfo->Legend->legend->show_struct != NULL)
	    kfree(forminfo->Legend->legend->show_struct);
	if (forminfo->Legend->legend->catch_all_struct != NULL)
	    kfree(forminfo->Legend->legend->catch_all_struct);
	if (forminfo->Legend->legend->hide_struct != NULL)
	    kfree(forminfo->Legend->legend->hide_struct);
	if (forminfo->Legend->legend->transfer_struct != NULL)
	    kfree(forminfo->Legend->legend->transfer_struct);
	if (forminfo->Legend->legend->legend_workspace_struct != NULL)
	    kfree(forminfo->Legend->legend->legend_workspace_struct);
	kfree(forminfo->Legend->legend);
	if (forminfo->Legend->legend_struct != NULL)
	    kfree(forminfo->Legend->legend_struct);


	if (forminfo->Legend_struct != NULL)
	    kfree(forminfo->Legend_struct);
	kfree(forminfo->Legend);
	if (forminfo->Zoom->zoom->help_struct != NULL)
	    kfree(forminfo->Zoom->zoom->help_struct);
	if (forminfo->Zoom->zoom->quit_struct != NULL)
	    kfree(forminfo->Zoom->zoom->quit_struct);
	if (forminfo->Zoom->zoom->zoommode_struct != NULL)
	    kfree(forminfo->Zoom->zoom->zoommode_struct);
	kfree(forminfo->Zoom->zoom->zoommode_label);
	if (forminfo->Zoom->zoom->zoomfactor_struct != NULL)
	    kfree(forminfo->Zoom->zoom->zoomfactor_struct);
	if (forminfo->Zoom->zoom->zoom_workspace_struct != NULL)
	    kfree(forminfo->Zoom->zoom->zoom_workspace_struct);
	kfree(forminfo->Zoom->zoom);
	if (forminfo->Zoom->zoom_struct != NULL)
	    kfree(forminfo->Zoom->zoom_struct);


	if (forminfo->Zoom_struct != NULL)
	    kfree(forminfo->Zoom_struct);
	kfree(forminfo->Zoom);
	if (forminfo->Scatter->scatter->help_struct != NULL)
	    kfree(forminfo->Scatter->scatter->help_struct);
	if (forminfo->Scatter->scatter->quit_struct != NULL)
	    kfree(forminfo->Scatter->scatter->quit_struct);
	if (forminfo->Scatter->scatter->x_column_struct != NULL)
	    kfree(forminfo->Scatter->scatter->x_column_struct);
	if (forminfo->Scatter->scatter->y_column_struct != NULL)
	    kfree(forminfo->Scatter->scatter->y_column_struct);
	kfree(forminfo->Scatter->scatter->x_func);
	if (forminfo->Scatter->scatter->x_func_struct != NULL)
	    kfree(forminfo->Scatter->scatter->x_func_struct);
	kfree(forminfo->Scatter->scatter->y_func);
	if (forminfo->Scatter->scatter->y_func_struct != NULL)
	    kfree(forminfo->Scatter->scatter->y_func_struct);
	if (forminfo->Scatter->scatter->set_struct != NULL)
	    kfree(forminfo->Scatter->scatter->set_struct);
	if (forminfo->Scatter->scatter->reset_struct != NULL)
	    kfree(forminfo->Scatter->scatter->reset_struct);
	if (forminfo->Scatter->scatter->plot_workspace_struct != NULL)
	    kfree(forminfo->Scatter->scatter->plot_workspace_struct);
	if (forminfo->Scatter->scatter->xcol_blank_struct != NULL)
	    kfree(forminfo->Scatter->scatter->xcol_blank_struct);
	if (forminfo->Scatter->scatter->ycol_blank_struct != NULL)
	    kfree(forminfo->Scatter->scatter->ycol_blank_struct);
	kfree(forminfo->Scatter->scatter);
	if (forminfo->Scatter->scatter_struct != NULL)
	    kfree(forminfo->Scatter->scatter_struct);


	if (forminfo->Scatter_struct != NULL)
	    kfree(forminfo->Scatter_struct);
	kfree(forminfo->Scatter);
	if (forminfo->Stats->stats->help_struct != NULL)
	    kfree(forminfo->Stats->stats->help_struct);
	if (forminfo->Stats->stats->quit_struct != NULL)
	    kfree(forminfo->Stats->stats->quit_struct);
	if (forminfo->Stats->stats->stats_wksp_struct != NULL)
	    kfree(forminfo->Stats->stats->stats_wksp_struct);
	kfree(forminfo->Stats->stats);
	if (forminfo->Stats->stats_struct != NULL)
	    kfree(forminfo->Stats->stats_struct);


	if (forminfo->Stats_struct != NULL)
	    kfree(forminfo->Stats_struct);
	kfree(forminfo->Stats);
	if (forminfo->Contents->contents->help_struct != NULL)
	    kfree(forminfo->Contents->contents->help_struct);
	if (forminfo->Contents->contents->quit_struct != NULL)
	    kfree(forminfo->Contents->contents->quit_struct);
	kfree(forminfo->Contents->contents->o);
	if (forminfo->Contents->contents->o_struct != NULL)
	    kfree(forminfo->Contents->contents->o_struct);
	if (forminfo->Contents->contents->contents_wksp_struct != NULL)
	    kfree(forminfo->Contents->contents->contents_wksp_struct);
	kfree(forminfo->Contents->contents);
	if (forminfo->Contents->contents_struct != NULL)
	    kfree(forminfo->Contents->contents_struct);


	if (forminfo->Contents_struct != NULL)
	    kfree(forminfo->Contents_struct);
	kfree(forminfo->Contents);
	kfree(forminfo);
}
