 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for getimage
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "getimage.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Capture Khoros 2.0 VIFF Image From Screen
|
|       Purpose: main program for getimage
|
|         Input:
|		char *clui_info->o_file; {Output filename}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->screen_flag; {TRUE if -screen specified}
|
|		    int clui_info->win_flag; {TRUE if -win specified}
|
|		    char *clui_info->wname_string; {Name/ID of source window}
|		    int   clui_info->wname_flag; {TRUE if -wname specified}
|
|		int clui_info->all_flag; {TRUE if -all specified}
|
|		int clui_info->decor_flag; {TRUE if -decor specified}
|
|		int clui_info->b_flag; {TRUE if -b specified}
|
|		Optional M.E. group:
|		    int clui_info->ascii_flag; {TRUE if -ascii specified}
|
|		    int clui_info->viff_flag; {TRUE if -viff specified}
|
|		    int clui_info->avs_flag; {TRUE if -avs specified}
|
|		    int clui_info->xbm_flag; {TRUE if -xbm specified}
|
|		    int clui_info->pnm_flag; {TRUE if -pnm specified}
|
|		    int clui_info->xvimage_flag; {TRUE if -xvimage specified}
|
|		    int clui_info->eps_flag; {TRUE if -eps specified}
|
|		    int clui_info->xwd_flag; {TRUE if -xwd specified}
|
|		    int clui_info->raw_flag; {TRUE if -raw specified}
|
|		    int clui_info->xpm_flag; {TRUE if -xpm specified}
|
|		    int clui_info->rast_flag; {TRUE if -rast specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 15, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(getimage_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "ENVISION", "getimage",
		               getimage_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	getimage_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

/* -main_before_lib_call */
/* -main_before_lib_call_end */

/* -main_library_call */
	capture_image();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: getimage_usage_additions
| 
|       Purpose: Prints usage additions in getimage_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname getimage
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void getimage_usage_additions(void)
{
	kfprintf(kstderr, "\tCapture Khoros 2.0 VIFF Image From Screen\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: getimage_free_args
| 
|       Purpose: Frees CLUI struct allocated in getimage_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname getimage
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
getimage_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
