 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for extractor
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _extractor_h_
#define _extractor_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <envision.h>
#include <xvinclude.h>
#include "form_info.h"

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#define EXTRACT_W_MOUSE 1
#define EXTRACT_W_KEYBD 2
/* -include_defines_end */

#define PANEPATH "$ENVISION/objects/xvroutine/extractor/uis/extractor.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input image from which to extract ROI (required infile)
 */
char	*i_file;	/* input image from which to extract ROI FILENAME */
int	 i_flag;	/* input image from which to extract ROI FLAG */

/*
 *  Alternate UIS file (optional infile)
 */
char	*form_file;	/* Alternate UIS file FILENAME */
int	 form_flag;	/* Alternate UIS file FLAG */

/*
 *  (x,y) position for automatic GUI placement */

int	 x_int;		/* x position INT */
int	 x_flag;	/* x position FLAG */

int	 y_int;		/* y position INT */
int	 y_flag;	/* y position FLAG */

/*
 *  output image in which to save ROI (optional outfile)
 */
char	*o_file;	/* output image in which to save ROI FILENAME */
int	 o_flag;	/* output image in which to save ROI FLAG */

/*
 *  ROI extraction policy (Optional list)
 */
int	 policy_list;	/* ROI extraction policy LIST INDEX */
char	 *policy_label;	/* ROI extraction policy LIST LABEL */
int	 policy_flag;	/* ROI extraction policy FLAG */

/*
 *  display extracted ROI in separate window (optional logical)
 */
int	 disp_logic;	/* display extracted ROI in separate window LOGIC */
int	 disp_flag;  	/* display extracted ROI in separate window FLAG */

/*
 *  extract multiple ROIs from the same window (optional logical)
 */
int	 mult_logic;	/* extract multiple ROIs from the same window LOGIC */
int	 mult_flag;  	/* extract multiple ROIs from the same window FLAG */

/*
 *  ROI presentation (Optional list)
 */
int	 pres_list;	/* ROI presentation LIST INDEX */
char	 *pres_label;	/* ROI presentation LIST LABEL */
int	 pres_flag;	/* ROI presentation FLAG */

/*
 * specifies desired shape for ROI (Optional flag toggle)
 *	1 (Rectangle)
 *	2 (Polyline)
 *	3 (Circle)
 *	4 (Ellipse)
 *	5 (Line)
 *	6 (Freehand),
 */
int	 shape_toggle;		/* specifies desired shape for ROI FLAG TOGGLE */
int	 shape_flag;		/* specifies desired shape for ROI FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
extern gui_info_struct *gui_info;

/* -include_variables */
extern xvobject image;
extern xvobject position;
extern xvobject disp_roi;
extern xvobject disp_image;
extern xvobject disp_area;
extern xvobject disp_axis2d;
extern xvobject disp_plot2d;
extern xvobject disp_plot3d;
extern xvobject panicon;
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void extractor_get_args PROTO((kform *));
void extractor_usage_additions PROTO((void));
void extractor_free_args PROTO((int, kaddr));

/* -include_routines */
void startup_from_clui         PROTO((void));
void get_roi                   PROTO((xvobject, kaddr, XEvent *, int *));
void adjust_gui_from_roi_shape PROTO((void));
void adjust_gui_from_roi_mode  PROTO((void));
/* -include_routines_end */

#endif
