 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_editimage
   >>>> 	_xvf_free_editimage
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_editimage_warning
   >>>> 	_xvf_init_editimage_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"

static void _xvf_init_editimage_warning PROTO((char *));
static void _xvf_init_editimage_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_editimage
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_editimage_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_editimage(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *master;
	kcontrol   *guidepane;

	master = form->master;
	/*
	 * initializing 'editimage' Form Info structure
	 */

	forminfo->license_struct =
	    kvf_create_struct_from_selname(master->sel_list, "editimage.license");
	if (forminfo->license_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'license' on master form");

	forminfo->help_struct =
	    kvf_create_struct_from_selname(master->sel_list, "editimage.help");
	if (forminfo->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on master form");

	forminfo->quit_struct =
	    kvf_create_struct_from_selname(master->sel_list, "editimage.quit");
	if (forminfo->quit_struct == NULL)
		    _xvf_init_editimage_warning("quit button 'quit' on master form");
	forminfo->quit = FALSE;

	forminfo->workspace_struct =
	    kvf_create_struct_from_selname(master->sel_list, "editimage.workspace");
	if (forminfo->workspace_struct == NULL)
	    _xvf_init_editimage_warning("workspace 'workspace' on master form");
	else
	{
	    kvf_get_attribute(forminfo->workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->workspace));

	}
	forminfo->b0_struct =
	    kvf_create_struct_from_selname(master->sel_list, "editimage.b0");
	if (forminfo->b0_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'b0' on master form");
	forminfo->File_struct =
	    kvf_create_struct_from_subformname(form, "editimage.File");
	if (forminfo->File_struct == NULL)
	{
	    _xvf_init_editimage_error("subform 'File' on form 'editimage'", 
			    "editimage_File");
	    return(FALSE);
	}

	/*
	 * initializing 'editimage->File' Subform Info structure
	 */

	forminfo->File = (editimage_File *)
				kcalloc(1, sizeof(editimage_File));
	subform = forminfo->File_struct->Subformptr;

	/*
	 * initializing 'editimage->File->file' Pane Info structure
	 */

	forminfo->File->file = (File_file *)
				kcalloc(1, sizeof(File_file));
	forminfo->File->file_struct =
	    kvf_create_struct_from_panename(subform, "editimage.File.file");
	if (forminfo->File->file_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'file' on subform 'File'", "File_file");
	    return(FALSE);
	}
	pane = forminfo->File->file_struct->Controlptr;
	forminfo->File->file->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.File.file.help");
	if (forminfo->File->file->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'file' of subform 'File'");

	forminfo->File->file->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.File.file.quit");
	if (forminfo->File->file->quit_struct == NULL)
		    _xvf_init_editimage_warning("quit button 'quit' on pane 'file' of subform 'File'");
	forminfo->File->file->quit = FALSE;

	forminfo->File->file->i_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.File.file.i");
	if (forminfo->File->file->i_struct != NULL)
	{
	    selection = forminfo->File->file->i_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->i_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->i));
	}
	else
	    _xvf_init_editimage_warning("input selection 'i' on pane 'file' of subform 'File'");

	forminfo->File->file->i_selected = FALSE;

	forminfo->File->file->c_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.File.file.c");
	if (forminfo->File->file->c_struct != NULL)
	{
	    selection = forminfo->File->file->c_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->c_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->c));
	}
	else
	    _xvf_init_editimage_warning("input selection 'c' on pane 'file' of subform 'File'");

	forminfo->File->file->c_selected = FALSE;

	forminfo->File->file->cmap_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.File.file.cmap");
	if (forminfo->File->file->cmap_struct != NULL)
	{
	    selection = forminfo->File->file->cmap_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->cmap_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->cmap));
	}
	else
	    _xvf_init_editimage_warning("input selection 'cmap' on pane 'file' of subform 'File'");

	forminfo->File->file->cmap_selected = FALSE;

	forminfo->File->file->format_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.File.file.format");
	if (forminfo->File->file->format_struct != NULL)
	{
	    selection = forminfo->File->file->format_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->format_struct, KVF_LIST_VAL,
	                    &(forminfo->File->file->format));
	    kvf_get_attribute(forminfo->File->file->format_struct, KVF_LIST_LABEL,
	                    &(forminfo->File->file->format_label));
	}
	else
	    _xvf_init_editimage_warning("displaylist selection 'format' on pane 'file' of subform 'File'");

	forminfo->File->file->o_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.File.file.o");
	if (forminfo->File->file->o_struct != NULL)
	{
	    selection = forminfo->File->file->o_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->o_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->o));
	}
	else
	    _xvf_init_editimage_warning("output selection 'o' on pane 'file' of subform 'File'");

	forminfo->File->file->o_selected = FALSE;

	forminfo->File->file->out_cmap_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.File.file.out_cmap");
	if (forminfo->File->file->out_cmap_struct != NULL)
	{
	    selection = forminfo->File->file->out_cmap_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->out_cmap_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->out_cmap));
	}
	else
	    _xvf_init_editimage_warning("output selection 'out_cmap' on pane 'file' of subform 'File'");

	forminfo->File->file->out_cmap_selected = FALSE;

	forminfo->File->file->d_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.File.file.d");
	if (forminfo->File->file->d_struct != NULL)
	{
	    selection = forminfo->File->file->d_struct->Selptr;
	    kvf_get_attribute(forminfo->File->file->d_struct, KVF_FILE_DEF,
	                    &(forminfo->File->file->d));
	}
	else
	    _xvf_init_editimage_warning("output selection 'd' on pane 'file' of subform 'File'");

	forminfo->File->file->d_selected = FALSE;

	forminfo->options_struct =
	    kvf_create_struct_from_subformname(form, "editimage.options");
	if (forminfo->options_struct == NULL)
	{
	    _xvf_init_editimage_error("subform 'options' on form 'editimage'", 
			    "editimage_options");
	    return(FALSE);
	}

	/*
	 * initializing 'editimage->options' Subform Info structure
	 */

	forminfo->options = (editimage_options *)
				kcalloc(1, sizeof(editimage_options));
	subform = forminfo->options_struct->Subformptr;
	guidepane = subform->guidepane;
	forminfo->options->help_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "editimage.options.help");
	if (forminfo->options->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on subform 'options'");

	forminfo->options->quit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "editimage.options.quit");
	if (forminfo->options->quit_struct == NULL)
		    _xvf_init_editimage_warning("quit button 'quit' on subform 'options'");
	forminfo->options->quit = FALSE;


	/*
	 * initializing 'editimage->options->capture' Pane Info structure
	 */

	forminfo->options->capture = (options_capture *)
				kcalloc(1, sizeof(options_capture));
	forminfo->options->capture_struct =
	    kvf_create_struct_from_panename(subform, "editimage.options.capture");
	if (forminfo->options->capture_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'capture' on subform 'options'", "options_capture");
	    return(FALSE);
	}
	pane = forminfo->options->capture_struct->Controlptr;
	forminfo->options->capture->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.capture.help");
	if (forminfo->options->capture->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'capture' of subform 'options'");

	forminfo->options->capture->all_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.capture.all");
	if (forminfo->options->capture->all_struct != NULL)
	{
	    selection = forminfo->options->capture->all_struct->Selptr;
	    kvf_get_attribute(forminfo->options->capture->all_struct, KVF_OPTSEL,
	                    &(forminfo->options->capture->all));
	}
	else
	    _xvf_init_editimage_warning("flag selection 'all' on pane 'capture' of subform 'options'");

	forminfo->options->capture->decor_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.capture.decor");
	if (forminfo->options->capture->decor_struct != NULL)
	{
	    selection = forminfo->options->capture->decor_struct->Selptr;
	    kvf_get_attribute(forminfo->options->capture->decor_struct, KVF_OPTSEL,
	                    &(forminfo->options->capture->decor));
	}
	else
	    _xvf_init_editimage_warning("flag selection 'decor' on pane 'capture' of subform 'options'");

	forminfo->options->capture->b_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.capture.b");
	if (forminfo->options->capture->b_struct != NULL)
	{
	    selection = forminfo->options->capture->b_struct->Selptr;
	    kvf_get_attribute(forminfo->options->capture->b_struct, KVF_OPTSEL,
	                    &(forminfo->options->capture->b));
	}
	else
	    _xvf_init_editimage_warning("flag selection 'b' on pane 'capture' of subform 'options'");

	forminfo->options->capture->o_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.capture.o");
	if (forminfo->options->capture->o_struct != NULL)
	{
	    selection = forminfo->options->capture->o_struct->Selptr;
	    kvf_get_attribute(forminfo->options->capture->o_struct, KVF_FILE_DEF,
	                    &(forminfo->options->capture->o));
	}
	else
	    _xvf_init_editimage_warning("output selection 'o' on pane 'capture' of subform 'options'");

	forminfo->options->capture->o_selected = FALSE;

	forminfo->options->capture->capture_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.capture.capture");
	if (forminfo->options->capture->capture_struct == NULL)
	    _xvf_init_editimage_warning("pane action button 'capture' on pane 'capture' of subform 'options'");
	forminfo->options->capture->capture = FALSE;
	selection = forminfo->options->capture->capture_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->capture->screen_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.capture.screen");
	if (forminfo->options->capture->screen_struct != NULL)
	{
	    selection = forminfo->options->capture->screen_struct->Selptr;
	    kvf_get_attribute(forminfo->options->capture->screen_struct, KVF_OPTSEL,
	                    &(forminfo->options->capture->screen));
	}
	else
	    _xvf_init_editimage_warning("flag selection 'screen' on pane 'capture' of subform 'options'");

	forminfo->options->capture->win_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.capture.win");
	if (forminfo->options->capture->win_struct != NULL)
	{
	    selection = forminfo->options->capture->win_struct->Selptr;
	    kvf_get_attribute(forminfo->options->capture->win_struct, KVF_OPTSEL,
	                    &(forminfo->options->capture->win));
	}
	else
	    _xvf_init_editimage_warning("flag selection 'win' on pane 'capture' of subform 'options'");

	forminfo->options->capture->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.capture.blank1");
	if (forminfo->options->capture->blank1_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'blank1' on pane 'capture' of subform 'options'");

	/*
	 * initializing 'editimage->options->lists' Pane Info structure
	 */

	forminfo->options->lists = (options_lists *)
				kcalloc(1, sizeof(options_lists));
	forminfo->options->lists_struct =
	    kvf_create_struct_from_panename(subform, "editimage.options.lists");
	if (forminfo->options->lists_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'lists' on subform 'options'", "options_lists");
	    return(FALSE);
	}
	pane = forminfo->options->lists_struct->Controlptr;
	forminfo->options->lists->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.lists.help");
	if (forminfo->options->lists->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'lists' of subform 'options'");

	forminfo->options->lists->image_list_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.lists.image_list");
	if (forminfo->options->lists->image_list_struct != NULL)
	{
	    selection = forminfo->options->lists->image_list_struct->Selptr;
	    kvf_get_attribute(forminfo->options->lists->image_list_struct, KVF_LIST_VAL,
	                    &(forminfo->options->lists->image_list));
	    kvf_get_attribute(forminfo->options->lists->image_list_struct, KVF_LIST_LABEL,
	                    &(forminfo->options->lists->image_list_label));
	}
	else
	    _xvf_init_editimage_warning("displaylist selection 'image_list' on pane 'lists' of subform 'options'");

	forminfo->options->lists->image_list_selected = FALSE;

	forminfo->options->lists->band_list_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.lists.band_list");
	if (forminfo->options->lists->band_list_struct != NULL)
	{
	    selection = forminfo->options->lists->band_list_struct->Selptr;
	    kvf_get_attribute(forminfo->options->lists->band_list_struct, KVF_LIST_VAL,
	                    &(forminfo->options->lists->band_list));
	    kvf_get_attribute(forminfo->options->lists->band_list_struct, KVF_LIST_LABEL,
	                    &(forminfo->options->lists->band_list_label));
	}
	else
	    _xvf_init_editimage_warning("displaylist selection 'band_list' on pane 'lists' of subform 'options'");

	forminfo->options->lists->band_list_selected = FALSE;

	forminfo->options->lists->elements_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.lists.elements");
	if (forminfo->options->lists->elements_struct != NULL)
	{
	    selection = forminfo->options->lists->elements_struct->Selptr;
	    kvf_get_attribute(forminfo->options->lists->elements_struct, KVF_OPTSEL,
	                    &(forminfo->options->lists->elements));
	}
	else
	    _xvf_init_editimage_warning("flag selection 'elements' on pane 'lists' of subform 'options'");

	forminfo->options->lists->elements_selected = FALSE;

	forminfo->options->lists->depth_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.lists.depth");
	if (forminfo->options->lists->depth_struct != NULL)
	{
	    selection = forminfo->options->lists->depth_struct->Selptr;
	    kvf_get_attribute(forminfo->options->lists->depth_struct, KVF_OPTSEL,
	                    &(forminfo->options->lists->depth));
	}
	else
	    _xvf_init_editimage_warning("flag selection 'depth' on pane 'lists' of subform 'options'");

	forminfo->options->lists->depth_selected = FALSE;

	forminfo->options->lists->time_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.lists.time");
	if (forminfo->options->lists->time_struct != NULL)
	{
	    selection = forminfo->options->lists->time_struct->Selptr;
	    kvf_get_attribute(forminfo->options->lists->time_struct, KVF_OPTSEL,
	                    &(forminfo->options->lists->time));
	}
	else
	    _xvf_init_editimage_warning("flag selection 'time' on pane 'lists' of subform 'options'");

	forminfo->options->lists->time_selected = FALSE;

	forminfo->options->lists->image_band_label_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.lists.image_band_label");
	if (forminfo->options->lists->image_band_label_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'image_band_label' on pane 'lists' of subform 'options'");

	/*
	 * initializing 'editimage->options->display' Pane Info structure
	 */

	forminfo->options->display = (options_display *)
				kcalloc(1, sizeof(options_display));
	forminfo->options->display_struct =
	    kvf_create_struct_from_panename(subform, "editimage.options.display");
	if (forminfo->options->display_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'display' on subform 'options'", "options_display");
	    return(FALSE);
	}
	pane = forminfo->options->display_struct->Controlptr;
	forminfo->options->display->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.help");
	if (forminfo->options->display->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'display' of subform 'options'");

	forminfo->options->display->norm_type_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.norm_type");
	if (forminfo->options->display->norm_type_struct != NULL)
	{
	    selection = forminfo->options->display->norm_type_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->norm_type_struct, KVF_CYCLE_VAL,
	                    &(forminfo->options->display->norm_type));
	    kvf_get_attribute(forminfo->options->display->norm_type_struct, KVF_CYCLE_LABEL,
	                    &(forminfo->options->display->norm_type_label));
	}
	else
	    _xvf_init_editimage_warning("cycle selection 'norm_type' on pane 'display' of subform 'options'");

	forminfo->options->display->norm_type_selected = FALSE;

	forminfo->options->display->norm_method_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.norm_method");
	if (forminfo->options->display->norm_method_struct != NULL)
	{
	    selection = forminfo->options->display->norm_method_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->norm_method_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->options->display->norm_method_num));
	    forminfo->options->display->norm_method_val = 1;
	}
	else
	    _xvf_init_editimage_warning("toggle selection 'norm_method' on pane 'display' of subform 'options'");

	forminfo->options->display->norm_method_selected = FALSE;

	forminfo->options->display->red_mapcol_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.red_mapcol");
	if (forminfo->options->display->red_mapcol_struct == NULL)
	    _xvf_init_editimage_warning("pane action button 'red_mapcol' on pane 'display' of subform 'options'");
	forminfo->options->display->red_mapcol = FALSE;
	selection = forminfo->options->display->red_mapcol_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->display->green_mapcol_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.green_mapcol");
	if (forminfo->options->display->green_mapcol_struct == NULL)
	    _xvf_init_editimage_warning("pane action button 'green_mapcol' on pane 'display' of subform 'options'");
	forminfo->options->display->green_mapcol = FALSE;
	selection = forminfo->options->display->green_mapcol_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->display->blue_mapcol_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.blue_mapcol");
	if (forminfo->options->display->blue_mapcol_struct == NULL)
	    _xvf_init_editimage_warning("pane action button 'blue_mapcol' on pane 'display' of subform 'options'");
	forminfo->options->display->blue_mapcol = FALSE;
	selection = forminfo->options->display->blue_mapcol_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->display->red_function_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.red_function");
	if (forminfo->options->display->red_function_struct != NULL)
	{
	    selection = forminfo->options->display->red_function_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->red_function_struct, KVF_STRING_DEF,
	                    &(forminfo->options->display->red_function));
	}
	else
	    _xvf_init_editimage_warning("string selection 'red_function' on pane 'display' of subform 'options'");

	forminfo->options->display->red_function_selected = FALSE;

	forminfo->options->display->green_function_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.green_function");
	if (forminfo->options->display->green_function_struct != NULL)
	{
	    selection = forminfo->options->display->green_function_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->green_function_struct, KVF_STRING_DEF,
	                    &(forminfo->options->display->green_function));
	}
	else
	    _xvf_init_editimage_warning("string selection 'green_function' on pane 'display' of subform 'options'");

	forminfo->options->display->green_function_selected = FALSE;

	forminfo->options->display->blue_function_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.blue_function");
	if (forminfo->options->display->blue_function_struct != NULL)
	{
	    selection = forminfo->options->display->blue_function_struct->Selptr;
	    kvf_get_attribute(forminfo->options->display->blue_function_struct, KVF_STRING_DEF,
	                    &(forminfo->options->display->blue_function));
	}
	else
	    _xvf_init_editimage_warning("string selection 'blue_function' on pane 'display' of subform 'options'");

	forminfo->options->display->blue_function_selected = FALSE;

	forminfo->options->display->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.blank1");
	if (forminfo->options->display->blank1_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'blank1' on pane 'display' of subform 'options'");
	forminfo->options->display->blank2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.display.blank2");
	if (forminfo->options->display->blank2_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'blank2' on pane 'display' of subform 'options'");

	/*
	 * initializing 'editimage->options->comment' Pane Info structure
	 */

	forminfo->options->comment = (options_comment *)
				kcalloc(1, sizeof(options_comment));
	forminfo->options->comment_struct =
	    kvf_create_struct_from_panename(subform, "editimage.options.comment");
	if (forminfo->options->comment_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'comment' on subform 'options'", "options_comment");
	    return(FALSE);
	}
	pane = forminfo->options->comment_struct->Controlptr;
	forminfo->options->comment->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.comment.help");
	if (forminfo->options->comment->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'comment' of subform 'options'");

	forminfo->options->comment->comment_string_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.comment.comment_string");
	if (forminfo->options->comment->comment_string_struct != NULL)
	{
	    selection = forminfo->options->comment->comment_string_struct->Selptr;
	    kvf_get_attribute(forminfo->options->comment->comment_string_struct, KVF_STRING_DEF,
	                    &(forminfo->options->comment->comment_string));
	}
	else
	    _xvf_init_editimage_warning("string selection 'comment_string' on pane 'comment' of subform 'options'");


	forminfo->options->comment->change_comment_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.comment.change_comment");
	if (forminfo->options->comment->change_comment_struct == NULL)
	    _xvf_init_editimage_warning("pane action button 'change_comment' on pane 'comment' of subform 'options'");
	forminfo->options->comment->change_comment = FALSE;
	selection = forminfo->options->comment->change_comment_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->comment->comment_label_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.comment.comment_label");
	if (forminfo->options->comment->comment_label_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'comment_label' on pane 'comment' of subform 'options'");

	/*
	 * initializing 'editimage->options->colormap' Pane Info structure
	 */

	forminfo->options->colormap = (options_colormap *)
				kcalloc(1, sizeof(options_colormap));
	forminfo->options->colormap_struct =
	    kvf_create_struct_from_panename(subform, "editimage.options.colormap");
	if (forminfo->options->colormap_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'colormap' on subform 'options'", "options_colormap");
	    return(FALSE);
	}
	pane = forminfo->options->colormap_struct->Controlptr;
	forminfo->options->colormap->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.colormap.help");
	if (forminfo->options->colormap->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'colormap' of subform 'options'");

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_options(forminfo->options);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_colormap(forminfo->options->colormap);
	forminfo->options->colormap->wksp1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.colormap.wksp1");
	if (forminfo->options->colormap->wksp1_struct == NULL)
	    _xvf_init_editimage_warning("workspace 'wksp1' on pane 'colormap' of subform 'options'");
	else
	{
	    kvf_get_attribute(forminfo->options->colormap->wksp1_struct, KVF_WORKSPACE,
	                    &(forminfo->options->colormap->wksp1));

	}
	forminfo->options->colormap->wksp2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.colormap.wksp2");
	if (forminfo->options->colormap->wksp2_struct == NULL)
	    _xvf_init_editimage_warning("workspace 'wksp2' on pane 'colormap' of subform 'options'");
	else
	{
	    kvf_get_attribute(forminfo->options->colormap->wksp2_struct, KVF_WORKSPACE,
	                    &(forminfo->options->colormap->wksp2));

	}
	forminfo->options->colormap->b1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.colormap.b1");
	if (forminfo->options->colormap->b1_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'b1' on pane 'colormap' of subform 'options'");
	forminfo->options->colormap->b2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.colormap.b2");
	if (forminfo->options->colormap->b2_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'b2' on pane 'colormap' of subform 'options'");

	/*
	 * initializing 'editimage->options->roi' Pane Info structure
	 */

	forminfo->options->roi = (options_roi *)
				kcalloc(1, sizeof(options_roi));
	forminfo->options->roi_struct =
	    kvf_create_struct_from_panename(subform, "editimage.options.roi");
	if (forminfo->options->roi_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'roi' on subform 'options'", "options_roi");
	    return(FALSE);
	}
	pane = forminfo->options->roi_struct->Controlptr;
	forminfo->options->roi->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.help");
	if (forminfo->options->roi->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'roi' of subform 'options'");

	forminfo->options->roi->o_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.o");
	if (forminfo->options->roi->o_struct != NULL)
	{
	    selection = forminfo->options->roi->o_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->o_struct, KVF_FILE_DEF,
	                    &(forminfo->options->roi->o));
	}
	else
	    _xvf_init_editimage_warning("output selection 'o' on pane 'roi' of subform 'options'");

	forminfo->options->roi->o_selected = FALSE;

	forminfo->options->roi->policy_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.policy");
	if (forminfo->options->roi->policy_struct != NULL)
	{
	    selection = forminfo->options->roi->policy_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->policy_struct, KVF_LIST_VAL,
	                    &(forminfo->options->roi->policy));
	    kvf_get_attribute(forminfo->options->roi->policy_struct, KVF_LIST_LABEL,
	                    &(forminfo->options->roi->policy_label));
	}
	else
	    _xvf_init_editimage_warning("list selection 'policy' on pane 'roi' of subform 'options'");

	forminfo->options->roi->policy_selected = FALSE;

	forminfo->options->roi->disp_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.disp");
	if (forminfo->options->roi->disp_struct != NULL)
	{
	    selection = forminfo->options->roi->disp_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->disp_struct, KVF_LOGIC_DEF,
	                    &(forminfo->options->roi->disp));
	    kvf_get_attribute(forminfo->options->roi->disp_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->options->roi->disp_label));
	}
	else
	    _xvf_init_editimage_warning("logical selection 'disp' on pane 'roi' of subform 'options'");

	forminfo->options->roi->disp_selected = FALSE;

	forminfo->options->roi->mult_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.mult");
	if (forminfo->options->roi->mult_struct != NULL)
	{
	    selection = forminfo->options->roi->mult_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->mult_struct, KVF_LOGIC_DEF,
	                    &(forminfo->options->roi->mult));
	    kvf_get_attribute(forminfo->options->roi->mult_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->options->roi->mult_label));
	}
	else
	    _xvf_init_editimage_warning("logical selection 'mult' on pane 'roi' of subform 'options'");

	forminfo->options->roi->mult_selected = FALSE;

	forminfo->options->roi->pres_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.pres");
	if (forminfo->options->roi->pres_struct != NULL)
	{
	    selection = forminfo->options->roi->pres_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->pres_struct, KVF_LIST_VAL,
	                    &(forminfo->options->roi->pres));
	    kvf_get_attribute(forminfo->options->roi->pres_struct, KVF_LIST_LABEL,
	                    &(forminfo->options->roi->pres_label));
	}
	else
	    _xvf_init_editimage_warning("list selection 'pres' on pane 'roi' of subform 'options'");

	forminfo->options->roi->pres_selected = FALSE;

	forminfo->options->roi->shape_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.shape");
	if (forminfo->options->roi->shape_struct != NULL)
	{
	    selection = forminfo->options->roi->shape_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->shape_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->options->roi->shape_num));
	    forminfo->options->roi->shape_val = 1;
	}
	else
	    _xvf_init_editimage_warning("toggle selection 'shape' on pane 'roi' of subform 'options'");

	forminfo->options->roi->shape_selected = FALSE;

	forminfo->options->roi->mode_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.mode");
	if (forminfo->options->roi->mode_struct != NULL)
	{
	    selection = forminfo->options->roi->mode_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->mode_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->options->roi->mode_num));
	    forminfo->options->roi->mode_val = 1;
	}
	else
	    _xvf_init_editimage_warning("toggle selection 'mode' on pane 'roi' of subform 'options'");

	forminfo->options->roi->mode_selected = FALSE;

	forminfo->options->roi->line_x1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.line_x1");
	if (forminfo->options->roi->line_x1_struct != NULL)
	{
	    selection = forminfo->options->roi->line_x1_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->line_x1_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->line_x1));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'line_x1' on pane 'roi' of subform 'options'");


	forminfo->options->roi->circle_x_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.circle_x");
	if (forminfo->options->roi->circle_x_struct != NULL)
	{
	    selection = forminfo->options->roi->circle_x_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->circle_x_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->circle_x));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'circle_x' on pane 'roi' of subform 'options'");


	forminfo->options->roi->ellipse_x_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.ellipse_x");
	if (forminfo->options->roi->ellipse_x_struct != NULL)
	{
	    selection = forminfo->options->roi->ellipse_x_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->ellipse_x_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->ellipse_x));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'ellipse_x' on pane 'roi' of subform 'options'");


	forminfo->options->roi->rect_x_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.rect_x");
	if (forminfo->options->roi->rect_x_struct != NULL)
	{
	    selection = forminfo->options->roi->rect_x_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->rect_x_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->rect_x));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'rect_x' on pane 'roi' of subform 'options'");


	forminfo->options->roi->line_x2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.line_x2");
	if (forminfo->options->roi->line_x2_struct != NULL)
	{
	    selection = forminfo->options->roi->line_x2_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->line_x2_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->line_x2));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'line_x2' on pane 'roi' of subform 'options'");


	forminfo->options->roi->circle_radius_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.circle_radius");
	if (forminfo->options->roi->circle_radius_struct != NULL)
	{
	    selection = forminfo->options->roi->circle_radius_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->circle_radius_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->circle_radius));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'circle_radius' on pane 'roi' of subform 'options'");


	forminfo->options->roi->ellipse_a_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.ellipse_a");
	if (forminfo->options->roi->ellipse_a_struct != NULL)
	{
	    selection = forminfo->options->roi->ellipse_a_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->ellipse_a_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->ellipse_a));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'ellipse_a' on pane 'roi' of subform 'options'");


	forminfo->options->roi->rect_width_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.rect_width");
	if (forminfo->options->roi->rect_width_struct != NULL)
	{
	    selection = forminfo->options->roi->rect_width_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->rect_width_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->rect_width));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'rect_width' on pane 'roi' of subform 'options'");


	forminfo->options->roi->extract_roi_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.extract_roi");
	if (forminfo->options->roi->extract_roi_struct == NULL)
	    _xvf_init_editimage_warning("pane action button 'extract_roi' on pane 'roi' of subform 'options'");
	forminfo->options->roi->extract_roi = FALSE;
	selection = forminfo->options->roi->extract_roi_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->roi->line_y1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.line_y1");
	if (forminfo->options->roi->line_y1_struct != NULL)
	{
	    selection = forminfo->options->roi->line_y1_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->line_y1_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->line_y1));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'line_y1' on pane 'roi' of subform 'options'");


	forminfo->options->roi->circle_y_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.circle_y");
	if (forminfo->options->roi->circle_y_struct != NULL)
	{
	    selection = forminfo->options->roi->circle_y_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->circle_y_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->circle_y));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'circle_y' on pane 'roi' of subform 'options'");


	forminfo->options->roi->ellipse_y_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.ellipse_y");
	if (forminfo->options->roi->ellipse_y_struct != NULL)
	{
	    selection = forminfo->options->roi->ellipse_y_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->ellipse_y_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->ellipse_y));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'ellipse_y' on pane 'roi' of subform 'options'");


	forminfo->options->roi->rect_y_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.rect_y");
	if (forminfo->options->roi->rect_y_struct != NULL)
	{
	    selection = forminfo->options->roi->rect_y_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->rect_y_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->rect_y));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'rect_y' on pane 'roi' of subform 'options'");


	forminfo->options->roi->line_y2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.line_y2");
	if (forminfo->options->roi->line_y2_struct != NULL)
	{
	    selection = forminfo->options->roi->line_y2_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->line_y2_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->line_y2));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'line_y2' on pane 'roi' of subform 'options'");


	forminfo->options->roi->ellipse_b_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.ellipse_b");
	if (forminfo->options->roi->ellipse_b_struct != NULL)
	{
	    selection = forminfo->options->roi->ellipse_b_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->ellipse_b_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->ellipse_b));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'ellipse_b' on pane 'roi' of subform 'options'");


	forminfo->options->roi->rect_height_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.roi.rect_height");
	if (forminfo->options->roi->rect_height_struct != NULL)
	{
	    selection = forminfo->options->roi->rect_height_struct->Selptr;
	    kvf_get_attribute(forminfo->options->roi->rect_height_struct, KVF_INT_DEF,
	                    &(forminfo->options->roi->rect_height));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'rect_height' on pane 'roi' of subform 'options'");



	/*
	 * initializing 'editimage->options->function' Pane Info structure
	 */

	forminfo->options->function = (options_function *)
				kcalloc(1, sizeof(options_function));
	forminfo->options->function_struct =
	    kvf_create_struct_from_panename(subform, "editimage.options.function");
	if (forminfo->options->function_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'function' on subform 'options'", "options_function");
	    return(FALSE);
	}
	pane = forminfo->options->function_struct->Controlptr;
	forminfo->options->function->create_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.create");
	if (forminfo->options->function->create_struct == NULL)
	    _xvf_init_editimage_warning("pane action button 'create' on pane 'function' of subform 'options'");
	forminfo->options->function->create = FALSE;
	selection = forminfo->options->function->create_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->function->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.help");
	if (forminfo->options->function->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'function' of subform 'options'");

	forminfo->options->function->expr_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.expr");
	if (forminfo->options->function->expr_struct != NULL)
	{
	    selection = forminfo->options->function->expr_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->expr_struct, KVF_STRING_DEF,
	                    &(forminfo->options->function->expr));
	}
	else
	    _xvf_init_editimage_warning("string selection 'expr' on pane 'function' of subform 'options'");


	forminfo->options->function->wbegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.wbegin");
	if (forminfo->options->function->wbegin_struct != NULL)
	{
	    selection = forminfo->options->function->wbegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->wbegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->wbegin));
	}
	else
	    _xvf_init_editimage_warning("double selection 'wbegin' on pane 'function' of subform 'options'");

	forminfo->options->function->wbegin_optsel = TRUE;

	forminfo->options->function->wend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.wend");
	if (forminfo->options->function->wend_struct != NULL)
	{
	    selection = forminfo->options->function->wend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->wend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->wend));
	}
	else
	    _xvf_init_editimage_warning("double selection 'wend' on pane 'function' of subform 'options'");

	forminfo->options->function->wend_optsel = TRUE;

	forminfo->options->function->wsize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.wsize");
	if (forminfo->options->function->wsize_struct != NULL)
	{
	    selection = forminfo->options->function->wsize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->wsize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->wsize));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'wsize' on pane 'function' of subform 'options'");

	forminfo->options->function->wsize_optsel = TRUE;

	forminfo->options->function->hbegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.hbegin");
	if (forminfo->options->function->hbegin_struct != NULL)
	{
	    selection = forminfo->options->function->hbegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->hbegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->hbegin));
	}
	else
	    _xvf_init_editimage_warning("double selection 'hbegin' on pane 'function' of subform 'options'");

	forminfo->options->function->hbegin_optsel = TRUE;

	forminfo->options->function->hend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.hend");
	if (forminfo->options->function->hend_struct != NULL)
	{
	    selection = forminfo->options->function->hend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->hend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->hend));
	}
	else
	    _xvf_init_editimage_warning("double selection 'hend' on pane 'function' of subform 'options'");

	forminfo->options->function->hend_optsel = TRUE;

	forminfo->options->function->hsize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.hsize");
	if (forminfo->options->function->hsize_struct != NULL)
	{
	    selection = forminfo->options->function->hsize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->hsize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->hsize));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'hsize' on pane 'function' of subform 'options'");

	forminfo->options->function->hsize_optsel = TRUE;

	forminfo->options->function->dbegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.dbegin");
	if (forminfo->options->function->dbegin_struct != NULL)
	{
	    selection = forminfo->options->function->dbegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->dbegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->dbegin));
	}
	else
	    _xvf_init_editimage_warning("double selection 'dbegin' on pane 'function' of subform 'options'");

	forminfo->options->function->dbegin_optsel = TRUE;

	forminfo->options->function->dend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.dend");
	if (forminfo->options->function->dend_struct != NULL)
	{
	    selection = forminfo->options->function->dend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->dend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->dend));
	}
	else
	    _xvf_init_editimage_warning("double selection 'dend' on pane 'function' of subform 'options'");

	forminfo->options->function->dend_optsel = TRUE;

	forminfo->options->function->dsize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.dsize");
	if (forminfo->options->function->dsize_struct != NULL)
	{
	    selection = forminfo->options->function->dsize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->dsize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->dsize));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'dsize' on pane 'function' of subform 'options'");

	forminfo->options->function->dsize_optsel = TRUE;

	forminfo->options->function->tbegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.tbegin");
	if (forminfo->options->function->tbegin_struct != NULL)
	{
	    selection = forminfo->options->function->tbegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->tbegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->tbegin));
	}
	else
	    _xvf_init_editimage_warning("double selection 'tbegin' on pane 'function' of subform 'options'");

	forminfo->options->function->tbegin_optsel = TRUE;

	forminfo->options->function->tend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.tend");
	if (forminfo->options->function->tend_struct != NULL)
	{
	    selection = forminfo->options->function->tend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->tend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->tend));
	}
	else
	    _xvf_init_editimage_warning("double selection 'tend' on pane 'function' of subform 'options'");

	forminfo->options->function->tend_optsel = TRUE;

	forminfo->options->function->tsize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.tsize");
	if (forminfo->options->function->tsize_struct != NULL)
	{
	    selection = forminfo->options->function->tsize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->tsize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->tsize));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'tsize' on pane 'function' of subform 'options'");

	forminfo->options->function->tsize_optsel = TRUE;

	forminfo->options->function->ebegin_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.ebegin");
	if (forminfo->options->function->ebegin_struct != NULL)
	{
	    selection = forminfo->options->function->ebegin_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->ebegin_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->ebegin));
	}
	else
	    _xvf_init_editimage_warning("double selection 'ebegin' on pane 'function' of subform 'options'");

	forminfo->options->function->ebegin_optsel = TRUE;

	forminfo->options->function->eend_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.eend");
	if (forminfo->options->function->eend_struct != NULL)
	{
	    selection = forminfo->options->function->eend_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->eend_struct, KVF_DOUBLE_DEF,
	                    &(forminfo->options->function->eend));
	}
	else
	    _xvf_init_editimage_warning("double selection 'eend' on pane 'function' of subform 'options'");

	forminfo->options->function->eend_optsel = TRUE;

	forminfo->options->function->esize_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.esize");
	if (forminfo->options->function->esize_struct != NULL)
	{
	    selection = forminfo->options->function->esize_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->esize_struct, KVF_INT_DEF,
	                    &(forminfo->options->function->esize));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'esize' on pane 'function' of subform 'options'");

	forminfo->options->function->esize_optsel = TRUE;

	forminfo->options->function->type_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.type");
	if (forminfo->options->function->type_struct != NULL)
	{
	    selection = forminfo->options->function->type_struct->Selptr;
	    kvf_get_attribute(forminfo->options->function->type_struct, KVF_LIST_VAL,
	                    &(forminfo->options->function->type));
	    kvf_get_attribute(forminfo->options->function->type_struct, KVF_LIST_LABEL,
	                    &(forminfo->options->function->type_label));
	}
	else
	    _xvf_init_editimage_warning("list selection 'type' on pane 'function' of subform 'options'");

	forminfo->options->function->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.blank1");
	if (forminfo->options->function->blank1_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'blank1' on pane 'function' of subform 'options'");
	forminfo->options->function->blank2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.blank2");
	if (forminfo->options->function->blank2_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'blank2' on pane 'function' of subform 'options'");
	forminfo->options->function->blank3_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.blank3");
	if (forminfo->options->function->blank3_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'blank3' on pane 'function' of subform 'options'");
	forminfo->options->function->blank4_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.blank4");
	if (forminfo->options->function->blank4_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'blank4' on pane 'function' of subform 'options'");
	forminfo->options->function->blank5_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.options.function.blank5");
	if (forminfo->options->function->blank5_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'blank5' on pane 'function' of subform 'options'");
	forminfo->Zoom_struct =
	    kvf_create_struct_from_subformname(form, "editimage.Zoom");
	if (forminfo->Zoom_struct == NULL)
	{
	    _xvf_init_editimage_error("subform 'Zoom' on form 'editimage'", 
			    "editimage_Zoom");
	    return(FALSE);
	}

	/*
	 * initializing 'editimage->Zoom' Subform Info structure
	 */

	forminfo->Zoom = (editimage_Zoom *)
				kcalloc(1, sizeof(editimage_Zoom));
	subform = forminfo->Zoom_struct->Subformptr;

	/*
	 * initializing 'editimage->Zoom->zoom' Pane Info structure
	 */

	forminfo->Zoom->zoom = (Zoom_zoom *)
				kcalloc(1, sizeof(Zoom_zoom));
	forminfo->Zoom->zoom_struct =
	    kvf_create_struct_from_panename(subform, "editimage.Zoom.zoom");
	if (forminfo->Zoom->zoom_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'zoom' on subform 'Zoom'", "Zoom_zoom");
	    return(FALSE);
	}
	pane = forminfo->Zoom->zoom_struct->Controlptr;
	forminfo->Zoom->zoom->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Zoom.zoom.help");
	if (forminfo->Zoom->zoom->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'zoom' of subform 'Zoom'");

	forminfo->Zoom->zoom->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Zoom.zoom.quit");
	if (forminfo->Zoom->zoom->quit_struct == NULL)
		    _xvf_init_editimage_warning("quit button 'quit' on pane 'zoom' of subform 'Zoom'");
	forminfo->Zoom->zoom->quit = FALSE;

	forminfo->Zoom->zoom->zoomfactor_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Zoom.zoom.zoomfactor");
	if (forminfo->Zoom->zoom->zoomfactor_struct != NULL)
	{
	    selection = forminfo->Zoom->zoom->zoomfactor_struct->Selptr;
	    kvf_get_attribute(forminfo->Zoom->zoom->zoomfactor_struct, KVF_FLOAT_DEF,
	                    &(forminfo->Zoom->zoom->zoomfactor));
	}
	else
	    _xvf_init_editimage_warning("float selection 'zoomfactor' on pane 'zoom' of subform 'Zoom'");

	forminfo->Zoom->zoom->zoomfactor_selected = FALSE;

	forminfo->Zoom->zoom->update_mode_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Zoom.zoom.update_mode");
	if (forminfo->Zoom->zoom->update_mode_struct != NULL)
	{
	    selection = forminfo->Zoom->zoom->update_mode_struct->Selptr;
	    kvf_get_attribute(forminfo->Zoom->zoom->update_mode_struct, KVF_LOGIC_DEF,
	                    &(forminfo->Zoom->zoom->update_mode));
	    kvf_get_attribute(forminfo->Zoom->zoom->update_mode_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->Zoom->zoom->update_mode_label));
	}
	else
	    _xvf_init_editimage_warning("logical selection 'update_mode' on pane 'zoom' of subform 'Zoom'");

	forminfo->Zoom->zoom->update_mode_selected = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Zoom(forminfo->Zoom);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_zoom(forminfo->Zoom->zoom);
	forminfo->Zoom->zoom->zoom_object_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Zoom.zoom.zoom_object");
	if (forminfo->Zoom->zoom->zoom_object_struct == NULL)
	    _xvf_init_editimage_warning("workspace 'zoom_object' on pane 'zoom' of subform 'Zoom'");
	else
	{
	    kvf_get_attribute(forminfo->Zoom->zoom->zoom_object_struct, KVF_WORKSPACE,
	                    &(forminfo->Zoom->zoom->zoom_object));

	}
	forminfo->Pixel_struct =
	    kvf_create_struct_from_subformname(form, "editimage.Pixel");
	if (forminfo->Pixel_struct == NULL)
	{
	    _xvf_init_editimage_error("subform 'Pixel' on form 'editimage'", 
			    "editimage_Pixel");
	    return(FALSE);
	}

	/*
	 * initializing 'editimage->Pixel' Subform Info structure
	 */

	forminfo->Pixel = (editimage_Pixel *)
				kcalloc(1, sizeof(editimage_Pixel));
	subform = forminfo->Pixel_struct->Subformptr;

	/*
	 * initializing 'editimage->Pixel->pixel' Pane Info structure
	 */

	forminfo->Pixel->pixel = (Pixel_pixel *)
				kcalloc(1, sizeof(Pixel_pixel));
	forminfo->Pixel->pixel_struct =
	    kvf_create_struct_from_panename(subform, "editimage.Pixel.pixel");
	if (forminfo->Pixel->pixel_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'pixel' on subform 'Pixel'", "Pixel_pixel");
	    return(FALSE);
	}
	pane = forminfo->Pixel->pixel_struct->Controlptr;
	forminfo->Pixel->pixel->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Pixel.pixel.help");
	if (forminfo->Pixel->pixel->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'pixel' of subform 'Pixel'");

	forminfo->Pixel->pixel->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Pixel.pixel.quit");
	if (forminfo->Pixel->pixel->quit_struct == NULL)
		    _xvf_init_editimage_warning("quit button 'quit' on pane 'pixel' of subform 'Pixel'");
	forminfo->Pixel->pixel->quit = FALSE;

	forminfo->Pixel->pixel->update_mode_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Pixel.pixel.update_mode");
	if (forminfo->Pixel->pixel->update_mode_struct != NULL)
	{
	    selection = forminfo->Pixel->pixel->update_mode_struct->Selptr;
	    kvf_get_attribute(forminfo->Pixel->pixel->update_mode_struct, KVF_LOGIC_DEF,
	                    &(forminfo->Pixel->pixel->update_mode));
	    kvf_get_attribute(forminfo->Pixel->pixel->update_mode_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->Pixel->pixel->update_mode_label));
	}
	else
	    _xvf_init_editimage_warning("logical selection 'update_mode' on pane 'pixel' of subform 'Pixel'");

	forminfo->Pixel->pixel->update_mode_selected = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Pixel(forminfo->Pixel);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_pixel(forminfo->Pixel->pixel);
	forminfo->Pixel->pixel->pixel_object_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Pixel.pixel.pixel_object");
	if (forminfo->Pixel->pixel->pixel_object_struct == NULL)
	    _xvf_init_editimage_warning("workspace 'pixel_object' on pane 'pixel' of subform 'Pixel'");
	else
	{
	    kvf_get_attribute(forminfo->Pixel->pixel->pixel_object_struct, KVF_WORKSPACE,
	                    &(forminfo->Pixel->pixel->pixel_object));

	}
	forminfo->MapValues_struct =
	    kvf_create_struct_from_subformname(form, "editimage.MapValues");
	if (forminfo->MapValues_struct == NULL)
	{
	    _xvf_init_editimage_error("subform 'MapValues' on form 'editimage'", 
			    "editimage_MapValues");
	    return(FALSE);
	}

	/*
	 * initializing 'editimage->MapValues' Subform Info structure
	 */

	forminfo->MapValues = (editimage_MapValues *)
				kcalloc(1, sizeof(editimage_MapValues));
	subform = forminfo->MapValues_struct->Subformptr;

	/*
	 * initializing 'editimage->MapValues->mapvals' Pane Info structure
	 */

	forminfo->MapValues->mapvals = (MapValues_mapvals *)
				kcalloc(1, sizeof(MapValues_mapvals));
	forminfo->MapValues->mapvals_struct =
	    kvf_create_struct_from_panename(subform, "editimage.MapValues.mapvals");
	if (forminfo->MapValues->mapvals_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'mapvals' on subform 'MapValues'", "MapValues_mapvals");
	    return(FALSE);
	}
	pane = forminfo->MapValues->mapvals_struct->Controlptr;
	forminfo->MapValues->mapvals->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.MapValues.mapvals.help");
	if (forminfo->MapValues->mapvals->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'mapvals' of subform 'MapValues'");

	forminfo->MapValues->mapvals->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.MapValues.mapvals.quit");
	if (forminfo->MapValues->mapvals->quit_struct == NULL)
		    _xvf_init_editimage_warning("quit button 'quit' on pane 'mapvals' of subform 'MapValues'");
	forminfo->MapValues->mapvals->quit = FALSE;

	forminfo->MapValues->mapvals->update_mode_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.MapValues.mapvals.update_mode");
	if (forminfo->MapValues->mapvals->update_mode_struct != NULL)
	{
	    selection = forminfo->MapValues->mapvals->update_mode_struct->Selptr;
	    kvf_get_attribute(forminfo->MapValues->mapvals->update_mode_struct, KVF_LOGIC_DEF,
	                    &(forminfo->MapValues->mapvals->update_mode));
	    kvf_get_attribute(forminfo->MapValues->mapvals->update_mode_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->MapValues->mapvals->update_mode_label));
	}
	else
	    _xvf_init_editimage_warning("logical selection 'update_mode' on pane 'mapvals' of subform 'MapValues'");

	forminfo->MapValues->mapvals->update_mode_selected = FALSE;

	forminfo->MapValues->mapvals->policy_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.MapValues.mapvals.policy");
	if (forminfo->MapValues->mapvals->policy_struct != NULL)
	{
	    selection = forminfo->MapValues->mapvals->policy_struct->Selptr;
	    kvf_get_attribute(forminfo->MapValues->mapvals->policy_struct, KVF_CYCLE_VAL,
	                    &(forminfo->MapValues->mapvals->policy));
	    kvf_get_attribute(forminfo->MapValues->mapvals->policy_struct, KVF_CYCLE_LABEL,
	                    &(forminfo->MapValues->mapvals->policy_label));
	}
	else
	    _xvf_init_editimage_warning("cycle selection 'policy' on pane 'mapvals' of subform 'MapValues'");

	forminfo->MapValues->mapvals->policy_selected = FALSE;

	forminfo->MapValues->mapvals->display_width_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.MapValues.mapvals.display_width");
	if (forminfo->MapValues->mapvals->display_width_struct != NULL)
	{
	    selection = forminfo->MapValues->mapvals->display_width_struct->Selptr;
	    kvf_get_attribute(forminfo->MapValues->mapvals->display_width_struct, KVF_INT_DEF,
	                    &(forminfo->MapValues->mapvals->display_width));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'display_width' on pane 'mapvals' of subform 'MapValues'");

	forminfo->MapValues->mapvals->display_width_selected = FALSE;

	forminfo->MapValues->mapvals->display_height_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.MapValues.mapvals.display_height");
	if (forminfo->MapValues->mapvals->display_height_struct != NULL)
	{
	    selection = forminfo->MapValues->mapvals->display_height_struct->Selptr;
	    kvf_get_attribute(forminfo->MapValues->mapvals->display_height_struct, KVF_INT_DEF,
	                    &(forminfo->MapValues->mapvals->display_height));
	}
	else
	    _xvf_init_editimage_warning("integer selection 'display_height' on pane 'mapvals' of subform 'MapValues'");

	forminfo->MapValues->mapvals->display_height_selected = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_MapValues(forminfo->MapValues);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_mapvals(forminfo->MapValues->mapvals);
	forminfo->MapValues->mapvals->mapval_object_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.MapValues.mapvals.mapval_object");
	if (forminfo->MapValues->mapvals->mapval_object_struct == NULL)
	    _xvf_init_editimage_warning("workspace 'mapval_object' on pane 'mapvals' of subform 'MapValues'");
	else
	{
	    kvf_get_attribute(forminfo->MapValues->mapvals->mapval_object_struct, KVF_WORKSPACE,
	                    &(forminfo->MapValues->mapvals->mapval_object));

	}
	forminfo->MapValues->mapvals->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.MapValues.mapvals.blank1");
	if (forminfo->MapValues->mapvals->blank1_struct == NULL)
	    _xvf_init_editimage_warning("blank selection 'blank1' on pane 'mapvals' of subform 'MapValues'");
	forminfo->Pseudo_struct =
	    kvf_create_struct_from_subformname(form, "editimage.Pseudo");
	if (forminfo->Pseudo_struct == NULL)
	{
	    _xvf_init_editimage_error("subform 'Pseudo' on form 'editimage'", 
			    "editimage_Pseudo");
	    return(FALSE);
	}

	/*
	 * initializing 'editimage->Pseudo' Subform Info structure
	 */

	forminfo->Pseudo = (editimage_Pseudo *)
				kcalloc(1, sizeof(editimage_Pseudo));
	subform = forminfo->Pseudo_struct->Subformptr;

	/*
	 * initializing 'editimage->Pseudo->pseudo' Pane Info structure
	 */

	forminfo->Pseudo->pseudo = (Pseudo_pseudo *)
				kcalloc(1, sizeof(Pseudo_pseudo));
	forminfo->Pseudo->pseudo_struct =
	    kvf_create_struct_from_panename(subform, "editimage.Pseudo.pseudo");
	if (forminfo->Pseudo->pseudo_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'pseudo' on subform 'Pseudo'", "Pseudo_pseudo");
	    return(FALSE);
	}
	pane = forminfo->Pseudo->pseudo_struct->Controlptr;
	forminfo->Pseudo->pseudo->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Pseudo.pseudo.help");
	if (forminfo->Pseudo->pseudo->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'pseudo' of subform 'Pseudo'");

	forminfo->Pseudo->pseudo->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Pseudo.pseudo.quit");
	if (forminfo->Pseudo->pseudo->quit_struct == NULL)
		    _xvf_init_editimage_warning("quit button 'quit' on pane 'pseudo' of subform 'Pseudo'");
	forminfo->Pseudo->pseudo->quit = FALSE;

	forminfo->Pseudo->pseudo->palette_type_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Pseudo.pseudo.palette_type");
	if (forminfo->Pseudo->pseudo->palette_type_struct != NULL)
	{
	    selection = forminfo->Pseudo->pseudo->palette_type_struct->Selptr;
	    kvf_get_attribute(forminfo->Pseudo->pseudo->palette_type_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->Pseudo->pseudo->palette_type_num));
	    forminfo->Pseudo->pseudo->palette_type_val = 2;
	}
	else
	    _xvf_init_editimage_warning("toggle selection 'palette_type' on pane 'pseudo' of subform 'Pseudo'");

	forminfo->Pseudo->pseudo->palette_type_selected = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Pseudo(forminfo->Pseudo);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_pseudo(forminfo->Pseudo->pseudo);
	forminfo->Pseudo->pseudo->pseudo_object_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Pseudo.pseudo.pseudo_object");
	if (forminfo->Pseudo->pseudo->pseudo_object_struct == NULL)
	    _xvf_init_editimage_warning("workspace 'pseudo_object' on pane 'pseudo' of subform 'Pseudo'");
	else
	{
	    kvf_get_attribute(forminfo->Pseudo->pseudo->pseudo_object_struct, KVF_WORKSPACE,
	                    &(forminfo->Pseudo->pseudo->pseudo_object));

	}
	forminfo->Thresh_struct =
	    kvf_create_struct_from_subformname(form, "editimage.Thresh");
	if (forminfo->Thresh_struct == NULL)
	{
	    _xvf_init_editimage_error("subform 'Thresh' on form 'editimage'", 
			    "editimage_Thresh");
	    return(FALSE);
	}

	/*
	 * initializing 'editimage->Thresh' Subform Info structure
	 */

	forminfo->Thresh = (editimage_Thresh *)
				kcalloc(1, sizeof(editimage_Thresh));
	subform = forminfo->Thresh_struct->Subformptr;

	/*
	 * initializing 'editimage->Thresh->thresh' Pane Info structure
	 */

	forminfo->Thresh->thresh = (Thresh_thresh *)
				kcalloc(1, sizeof(Thresh_thresh));
	forminfo->Thresh->thresh_struct =
	    kvf_create_struct_from_panename(subform, "editimage.Thresh.thresh");
	if (forminfo->Thresh->thresh_struct == NULL)
	{
	    _xvf_init_editimage_error("pane 'thresh' on subform 'Thresh'", "Thresh_thresh");
	    return(FALSE);
	}
	pane = forminfo->Thresh->thresh_struct->Controlptr;
	forminfo->Thresh->thresh->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Thresh.thresh.help");
	if (forminfo->Thresh->thresh->help_struct == NULL)
		    _xvf_init_editimage_warning("unknown selection 'help' on pane 'thresh' of subform 'Thresh'");

	forminfo->Thresh->thresh->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Thresh.thresh.quit");
	if (forminfo->Thresh->thresh->quit_struct == NULL)
		    _xvf_init_editimage_warning("quit button 'quit' on pane 'thresh' of subform 'Thresh'");
	forminfo->Thresh->thresh->quit = FALSE;

	forminfo->Thresh->thresh->thresholding_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Thresh.thresh.thresholding");
	if (forminfo->Thresh->thresh->thresholding_struct != NULL)
	{
	    selection = forminfo->Thresh->thresh->thresholding_struct->Selptr;
	    kvf_get_attribute(forminfo->Thresh->thresh->thresholding_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->Thresh->thresh->thresholding_num));
	    forminfo->Thresh->thresh->thresholding_val = 1;
	}
	else
	    _xvf_init_editimage_warning("toggle selection 'thresholding' on pane 'thresh' of subform 'Thresh'");

	forminfo->Thresh->thresh->thresholding_selected = FALSE;

	forminfo->Thresh->thresh->accept_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Thresh.thresh.accept");
	if (forminfo->Thresh->thresh->accept_struct != NULL)
	{
	    selection = forminfo->Thresh->thresh->accept_struct->Selptr;
	    kvf_get_attribute(forminfo->Thresh->thresh->accept_struct, KVF_LOGIC_DEF,
	                    &(forminfo->Thresh->thresh->accept));
	    kvf_get_attribute(forminfo->Thresh->thresh->accept_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->Thresh->thresh->accept_label));
	}
	else
	    _xvf_init_editimage_warning("logical selection 'accept' on pane 'thresh' of subform 'Thresh'");

	forminfo->Thresh->thresh->accept_selected = FALSE;

	forminfo->Thresh->thresh->invert_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Thresh.thresh.invert");
	if (forminfo->Thresh->thresh->invert_struct != NULL)
	{
	    selection = forminfo->Thresh->thresh->invert_struct->Selptr;
	    kvf_get_attribute(forminfo->Thresh->thresh->invert_struct, KVF_LOGIC_DEF,
	                    &(forminfo->Thresh->thresh->invert));
	    kvf_get_attribute(forminfo->Thresh->thresh->invert_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->Thresh->thresh->invert_label));
	}
	else
	    _xvf_init_editimage_warning("logical selection 'invert' on pane 'thresh' of subform 'Thresh'");

	forminfo->Thresh->thresh->invert_selected = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Thresh(forminfo->Thresh);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_thresh(forminfo->Thresh->thresh);
	forminfo->Thresh->thresh->thresh_object_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "editimage.Thresh.thresh.thresh_object");
	if (forminfo->Thresh->thresh->thresh_object_struct == NULL)
	    _xvf_init_editimage_warning("workspace 'thresh_object' on pane 'thresh' of subform 'Thresh'");
	else
	{
	    kvf_get_attribute(forminfo->Thresh->thresh->thresh_object_struct, KVF_WORKSPACE,
	                    &(forminfo->Thresh->thresh->thresh_object));

	}
	forminfo->editimage_struct =
	    kvf_create_struct_from_mastername(form, "editimage");
	if (forminfo->editimage_struct == NULL)
	{
	    _xvf_init_editimage_error("form 'editimage'",
			    "gui_info");
	    return(FALSE);
	}

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_editimage_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_editimage_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_editimage_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_editimage_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_editimage
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_editimage_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_editimage(
    gui_info_struct *forminfo)
{
	if (forminfo->license_struct != NULL)
	    kfree(forminfo->license_struct);
	if (forminfo->help_struct != NULL)
	    kfree(forminfo->help_struct);
	if (forminfo->quit_struct != NULL)
	    kfree(forminfo->quit_struct);
	if (forminfo->workspace_struct != NULL)
	    kfree(forminfo->workspace_struct);
	if (forminfo->b0_struct != NULL)
	    kfree(forminfo->b0_struct);
	if (forminfo->File->file->help_struct != NULL)
	    kfree(forminfo->File->file->help_struct);
	if (forminfo->File->file->quit_struct != NULL)
	    kfree(forminfo->File->file->quit_struct);
	kfree(forminfo->File->file->i);
	if (forminfo->File->file->i_struct != NULL)
	    kfree(forminfo->File->file->i_struct);
	kfree(forminfo->File->file->c);
	if (forminfo->File->file->c_struct != NULL)
	    kfree(forminfo->File->file->c_struct);
	kfree(forminfo->File->file->cmap);
	if (forminfo->File->file->cmap_struct != NULL)
	    kfree(forminfo->File->file->cmap_struct);
	if (forminfo->File->file->format_struct != NULL)
	    kfree(forminfo->File->file->format_struct);
	kfree(forminfo->File->file->format_label);
	kfree(forminfo->File->file->o);
	if (forminfo->File->file->o_struct != NULL)
	    kfree(forminfo->File->file->o_struct);
	kfree(forminfo->File->file->out_cmap);
	if (forminfo->File->file->out_cmap_struct != NULL)
	    kfree(forminfo->File->file->out_cmap_struct);
	kfree(forminfo->File->file->d);
	if (forminfo->File->file->d_struct != NULL)
	    kfree(forminfo->File->file->d_struct);
	kfree(forminfo->File->file);
	if (forminfo->File->file_struct != NULL)
	    kfree(forminfo->File->file_struct);


	if (forminfo->File_struct != NULL)
	    kfree(forminfo->File_struct);
	kfree(forminfo->File);
	if (forminfo->options->help_struct != NULL)
	    kfree(forminfo->options->help_struct);
	if (forminfo->options->quit_struct != NULL)
	    kfree(forminfo->options->quit_struct);
	if (forminfo->options->capture->help_struct != NULL)
	    kfree(forminfo->options->capture->help_struct);
	if (forminfo->options->capture->all_struct != NULL)
	    kfree(forminfo->options->capture->all_struct);
	if (forminfo->options->capture->decor_struct != NULL)
	    kfree(forminfo->options->capture->decor_struct);
	if (forminfo->options->capture->b_struct != NULL)
	    kfree(forminfo->options->capture->b_struct);
	kfree(forminfo->options->capture->o);
	if (forminfo->options->capture->o_struct != NULL)
	    kfree(forminfo->options->capture->o_struct);
	if (forminfo->options->capture->capture_struct != NULL)
	    kfree(forminfo->options->capture->capture_struct);
	if (forminfo->options->capture->screen_struct != NULL)
	    kfree(forminfo->options->capture->screen_struct);
	if (forminfo->options->capture->win_struct != NULL)
	    kfree(forminfo->options->capture->win_struct);
	if (forminfo->options->capture->blank1_struct != NULL)
	    kfree(forminfo->options->capture->blank1_struct);
	kfree(forminfo->options->capture);
	if (forminfo->options->capture_struct != NULL)
	    kfree(forminfo->options->capture_struct);

	if (forminfo->options->lists->help_struct != NULL)
	    kfree(forminfo->options->lists->help_struct);
	if (forminfo->options->lists->image_list_struct != NULL)
	    kfree(forminfo->options->lists->image_list_struct);
	kfree(forminfo->options->lists->image_list_label);
	if (forminfo->options->lists->band_list_struct != NULL)
	    kfree(forminfo->options->lists->band_list_struct);
	kfree(forminfo->options->lists->band_list_label);
	if (forminfo->options->lists->elements_struct != NULL)
	    kfree(forminfo->options->lists->elements_struct);
	if (forminfo->options->lists->depth_struct != NULL)
	    kfree(forminfo->options->lists->depth_struct);
	if (forminfo->options->lists->time_struct != NULL)
	    kfree(forminfo->options->lists->time_struct);
	if (forminfo->options->lists->image_band_label_struct != NULL)
	    kfree(forminfo->options->lists->image_band_label_struct);
	kfree(forminfo->options->lists);
	if (forminfo->options->lists_struct != NULL)
	    kfree(forminfo->options->lists_struct);

	if (forminfo->options->display->help_struct != NULL)
	    kfree(forminfo->options->display->help_struct);
	if (forminfo->options->display->norm_type_struct != NULL)
	    kfree(forminfo->options->display->norm_type_struct);
	kfree(forminfo->options->display->norm_type_label);
	if (forminfo->options->display->norm_method_struct != NULL)
	    kfree(forminfo->options->display->norm_method_struct);
	if (forminfo->options->display->red_mapcol_struct != NULL)
	    kfree(forminfo->options->display->red_mapcol_struct);
	if (forminfo->options->display->green_mapcol_struct != NULL)
	    kfree(forminfo->options->display->green_mapcol_struct);
	if (forminfo->options->display->blue_mapcol_struct != NULL)
	    kfree(forminfo->options->display->blue_mapcol_struct);
	kfree(forminfo->options->display->red_function);
	if (forminfo->options->display->red_function_struct != NULL)
	    kfree(forminfo->options->display->red_function_struct);
	kfree(forminfo->options->display->green_function);
	if (forminfo->options->display->green_function_struct != NULL)
	    kfree(forminfo->options->display->green_function_struct);
	kfree(forminfo->options->display->blue_function);
	if (forminfo->options->display->blue_function_struct != NULL)
	    kfree(forminfo->options->display->blue_function_struct);
	if (forminfo->options->display->blank1_struct != NULL)
	    kfree(forminfo->options->display->blank1_struct);
	if (forminfo->options->display->blank2_struct != NULL)
	    kfree(forminfo->options->display->blank2_struct);
	kfree(forminfo->options->display);
	if (forminfo->options->display_struct != NULL)
	    kfree(forminfo->options->display_struct);

	if (forminfo->options->comment->help_struct != NULL)
	    kfree(forminfo->options->comment->help_struct);
	kfree(forminfo->options->comment->comment_string);
	if (forminfo->options->comment->comment_string_struct != NULL)
	    kfree(forminfo->options->comment->comment_string_struct);
	if (forminfo->options->comment->change_comment_struct != NULL)
	    kfree(forminfo->options->comment->change_comment_struct);
	if (forminfo->options->comment->comment_label_struct != NULL)
	    kfree(forminfo->options->comment->comment_label_struct);
	kfree(forminfo->options->comment);
	if (forminfo->options->comment_struct != NULL)
	    kfree(forminfo->options->comment_struct);

	if (forminfo->options->colormap->help_struct != NULL)
	    kfree(forminfo->options->colormap->help_struct);
	if (forminfo->options->colormap->wksp1_struct != NULL)
	    kfree(forminfo->options->colormap->wksp1_struct);
	if (forminfo->options->colormap->wksp2_struct != NULL)
	    kfree(forminfo->options->colormap->wksp2_struct);
	if (forminfo->options->colormap->b1_struct != NULL)
	    kfree(forminfo->options->colormap->b1_struct);
	if (forminfo->options->colormap->b2_struct != NULL)
	    kfree(forminfo->options->colormap->b2_struct);
	kfree(forminfo->options->colormap);
	if (forminfo->options->colormap_struct != NULL)
	    kfree(forminfo->options->colormap_struct);

	if (forminfo->options->roi->help_struct != NULL)
	    kfree(forminfo->options->roi->help_struct);
	kfree(forminfo->options->roi->o);
	if (forminfo->options->roi->o_struct != NULL)
	    kfree(forminfo->options->roi->o_struct);
	if (forminfo->options->roi->policy_struct != NULL)
	    kfree(forminfo->options->roi->policy_struct);
	kfree(forminfo->options->roi->policy_label);
	if (forminfo->options->roi->disp_struct != NULL)
	    kfree(forminfo->options->roi->disp_struct);
	kfree(forminfo->options->roi->disp_label);
	if (forminfo->options->roi->mult_struct != NULL)
	    kfree(forminfo->options->roi->mult_struct);
	kfree(forminfo->options->roi->mult_label);
	if (forminfo->options->roi->pres_struct != NULL)
	    kfree(forminfo->options->roi->pres_struct);
	kfree(forminfo->options->roi->pres_label);
	if (forminfo->options->roi->shape_struct != NULL)
	    kfree(forminfo->options->roi->shape_struct);
	if (forminfo->options->roi->mode_struct != NULL)
	    kfree(forminfo->options->roi->mode_struct);
	if (forminfo->options->roi->line_x1_struct != NULL)
	     kfree(forminfo->options->roi->line_x1_struct);
	if (forminfo->options->roi->circle_x_struct != NULL)
	     kfree(forminfo->options->roi->circle_x_struct);
	if (forminfo->options->roi->ellipse_x_struct != NULL)
	     kfree(forminfo->options->roi->ellipse_x_struct);
	if (forminfo->options->roi->rect_x_struct != NULL)
	     kfree(forminfo->options->roi->rect_x_struct);
	if (forminfo->options->roi->line_x2_struct != NULL)
	     kfree(forminfo->options->roi->line_x2_struct);
	if (forminfo->options->roi->circle_radius_struct != NULL)
	     kfree(forminfo->options->roi->circle_radius_struct);
	if (forminfo->options->roi->ellipse_a_struct != NULL)
	     kfree(forminfo->options->roi->ellipse_a_struct);
	if (forminfo->options->roi->rect_width_struct != NULL)
	     kfree(forminfo->options->roi->rect_width_struct);
	if (forminfo->options->roi->extract_roi_struct != NULL)
	    kfree(forminfo->options->roi->extract_roi_struct);
	if (forminfo->options->roi->line_y1_struct != NULL)
	     kfree(forminfo->options->roi->line_y1_struct);
	if (forminfo->options->roi->circle_y_struct != NULL)
	     kfree(forminfo->options->roi->circle_y_struct);
	if (forminfo->options->roi->ellipse_y_struct != NULL)
	     kfree(forminfo->options->roi->ellipse_y_struct);
	if (forminfo->options->roi->rect_y_struct != NULL)
	     kfree(forminfo->options->roi->rect_y_struct);
	if (forminfo->options->roi->line_y2_struct != NULL)
	     kfree(forminfo->options->roi->line_y2_struct);
	if (forminfo->options->roi->ellipse_b_struct != NULL)
	     kfree(forminfo->options->roi->ellipse_b_struct);
	if (forminfo->options->roi->rect_height_struct != NULL)
	     kfree(forminfo->options->roi->rect_height_struct);
	kfree(forminfo->options->roi);
	if (forminfo->options->roi_struct != NULL)
	    kfree(forminfo->options->roi_struct);

	if (forminfo->options->function->create_struct != NULL)
	    kfree(forminfo->options->function->create_struct);
	if (forminfo->options->function->help_struct != NULL)
	    kfree(forminfo->options->function->help_struct);
	kfree(forminfo->options->function->expr);
	if (forminfo->options->function->expr_struct != NULL)
	    kfree(forminfo->options->function->expr_struct);
	if (forminfo->options->function->wbegin_struct != NULL)
	    kfree(forminfo->options->function->wbegin_struct);
	if (forminfo->options->function->wend_struct != NULL)
	    kfree(forminfo->options->function->wend_struct);
	if (forminfo->options->function->wsize_struct != NULL)
	     kfree(forminfo->options->function->wsize_struct);
	if (forminfo->options->function->hbegin_struct != NULL)
	    kfree(forminfo->options->function->hbegin_struct);
	if (forminfo->options->function->hend_struct != NULL)
	    kfree(forminfo->options->function->hend_struct);
	if (forminfo->options->function->hsize_struct != NULL)
	     kfree(forminfo->options->function->hsize_struct);
	if (forminfo->options->function->dbegin_struct != NULL)
	    kfree(forminfo->options->function->dbegin_struct);
	if (forminfo->options->function->dend_struct != NULL)
	    kfree(forminfo->options->function->dend_struct);
	if (forminfo->options->function->dsize_struct != NULL)
	     kfree(forminfo->options->function->dsize_struct);
	if (forminfo->options->function->tbegin_struct != NULL)
	    kfree(forminfo->options->function->tbegin_struct);
	if (forminfo->options->function->tend_struct != NULL)
	    kfree(forminfo->options->function->tend_struct);
	if (forminfo->options->function->tsize_struct != NULL)
	     kfree(forminfo->options->function->tsize_struct);
	if (forminfo->options->function->ebegin_struct != NULL)
	    kfree(forminfo->options->function->ebegin_struct);
	if (forminfo->options->function->eend_struct != NULL)
	    kfree(forminfo->options->function->eend_struct);
	if (forminfo->options->function->esize_struct != NULL)
	     kfree(forminfo->options->function->esize_struct);
	if (forminfo->options->function->type_struct != NULL)
	    kfree(forminfo->options->function->type_struct);
	kfree(forminfo->options->function->type_label);
	if (forminfo->options->function->blank1_struct != NULL)
	    kfree(forminfo->options->function->blank1_struct);
	if (forminfo->options->function->blank2_struct != NULL)
	    kfree(forminfo->options->function->blank2_struct);
	if (forminfo->options->function->blank3_struct != NULL)
	    kfree(forminfo->options->function->blank3_struct);
	if (forminfo->options->function->blank4_struct != NULL)
	    kfree(forminfo->options->function->blank4_struct);
	if (forminfo->options->function->blank5_struct != NULL)
	    kfree(forminfo->options->function->blank5_struct);
	kfree(forminfo->options->function);
	if (forminfo->options->function_struct != NULL)
	    kfree(forminfo->options->function_struct);


	if (forminfo->options_struct != NULL)
	    kfree(forminfo->options_struct);
	kfree(forminfo->options);
	if (forminfo->Zoom->zoom->help_struct != NULL)
	    kfree(forminfo->Zoom->zoom->help_struct);
	if (forminfo->Zoom->zoom->quit_struct != NULL)
	    kfree(forminfo->Zoom->zoom->quit_struct);
	if (forminfo->Zoom->zoom->zoomfactor_struct != NULL)
	    kfree(forminfo->Zoom->zoom->zoomfactor_struct);
	if (forminfo->Zoom->zoom->update_mode_struct != NULL)
	    kfree(forminfo->Zoom->zoom->update_mode_struct);
	kfree(forminfo->Zoom->zoom->update_mode_label);
	if (forminfo->Zoom->zoom->zoom_object_struct != NULL)
	    kfree(forminfo->Zoom->zoom->zoom_object_struct);
	kfree(forminfo->Zoom->zoom);
	if (forminfo->Zoom->zoom_struct != NULL)
	    kfree(forminfo->Zoom->zoom_struct);


	if (forminfo->Zoom_struct != NULL)
	    kfree(forminfo->Zoom_struct);
	kfree(forminfo->Zoom);
	if (forminfo->Pixel->pixel->help_struct != NULL)
	    kfree(forminfo->Pixel->pixel->help_struct);
	if (forminfo->Pixel->pixel->quit_struct != NULL)
	    kfree(forminfo->Pixel->pixel->quit_struct);
	if (forminfo->Pixel->pixel->update_mode_struct != NULL)
	    kfree(forminfo->Pixel->pixel->update_mode_struct);
	kfree(forminfo->Pixel->pixel->update_mode_label);
	if (forminfo->Pixel->pixel->pixel_object_struct != NULL)
	    kfree(forminfo->Pixel->pixel->pixel_object_struct);
	kfree(forminfo->Pixel->pixel);
	if (forminfo->Pixel->pixel_struct != NULL)
	    kfree(forminfo->Pixel->pixel_struct);


	if (forminfo->Pixel_struct != NULL)
	    kfree(forminfo->Pixel_struct);
	kfree(forminfo->Pixel);
	if (forminfo->MapValues->mapvals->help_struct != NULL)
	    kfree(forminfo->MapValues->mapvals->help_struct);
	if (forminfo->MapValues->mapvals->quit_struct != NULL)
	    kfree(forminfo->MapValues->mapvals->quit_struct);
	if (forminfo->MapValues->mapvals->update_mode_struct != NULL)
	    kfree(forminfo->MapValues->mapvals->update_mode_struct);
	kfree(forminfo->MapValues->mapvals->update_mode_label);
	if (forminfo->MapValues->mapvals->policy_struct != NULL)
	    kfree(forminfo->MapValues->mapvals->policy_struct);
	kfree(forminfo->MapValues->mapvals->policy_label);
	if (forminfo->MapValues->mapvals->display_width_struct != NULL)
	     kfree(forminfo->MapValues->mapvals->display_width_struct);
	if (forminfo->MapValues->mapvals->display_height_struct != NULL)
	     kfree(forminfo->MapValues->mapvals->display_height_struct);
	if (forminfo->MapValues->mapvals->mapval_object_struct != NULL)
	    kfree(forminfo->MapValues->mapvals->mapval_object_struct);
	if (forminfo->MapValues->mapvals->blank1_struct != NULL)
	    kfree(forminfo->MapValues->mapvals->blank1_struct);
	kfree(forminfo->MapValues->mapvals);
	if (forminfo->MapValues->mapvals_struct != NULL)
	    kfree(forminfo->MapValues->mapvals_struct);


	if (forminfo->MapValues_struct != NULL)
	    kfree(forminfo->MapValues_struct);
	kfree(forminfo->MapValues);
	if (forminfo->Pseudo->pseudo->help_struct != NULL)
	    kfree(forminfo->Pseudo->pseudo->help_struct);
	if (forminfo->Pseudo->pseudo->quit_struct != NULL)
	    kfree(forminfo->Pseudo->pseudo->quit_struct);
	if (forminfo->Pseudo->pseudo->palette_type_struct != NULL)
	    kfree(forminfo->Pseudo->pseudo->palette_type_struct);
	if (forminfo->Pseudo->pseudo->pseudo_object_struct != NULL)
	    kfree(forminfo->Pseudo->pseudo->pseudo_object_struct);
	kfree(forminfo->Pseudo->pseudo);
	if (forminfo->Pseudo->pseudo_struct != NULL)
	    kfree(forminfo->Pseudo->pseudo_struct);


	if (forminfo->Pseudo_struct != NULL)
	    kfree(forminfo->Pseudo_struct);
	kfree(forminfo->Pseudo);
	if (forminfo->Thresh->thresh->help_struct != NULL)
	    kfree(forminfo->Thresh->thresh->help_struct);
	if (forminfo->Thresh->thresh->quit_struct != NULL)
	    kfree(forminfo->Thresh->thresh->quit_struct);
	if (forminfo->Thresh->thresh->thresholding_struct != NULL)
	    kfree(forminfo->Thresh->thresh->thresholding_struct);
	if (forminfo->Thresh->thresh->accept_struct != NULL)
	    kfree(forminfo->Thresh->thresh->accept_struct);
	kfree(forminfo->Thresh->thresh->accept_label);
	if (forminfo->Thresh->thresh->invert_struct != NULL)
	    kfree(forminfo->Thresh->thresh->invert_struct);
	kfree(forminfo->Thresh->thresh->invert_label);
	if (forminfo->Thresh->thresh->thresh_object_struct != NULL)
	    kfree(forminfo->Thresh->thresh->thresh_object_struct);
	kfree(forminfo->Thresh->thresh);
	if (forminfo->Thresh->thresh_struct != NULL)
	    kfree(forminfo->Thresh->thresh_struct);


	if (forminfo->Thresh_struct != NULL)
	    kfree(forminfo->Thresh_struct);
	kfree(forminfo->Thresh);
	kfree(forminfo);
}
