 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane lists
   >>>> 
   >>>>  Private: 
   >>>> 	lists_image_list
   >>>> 	lists_band_list
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"

/*-----------------------------------------------------------
| 
|  Routine Name: lists_image_list
| 
|       Purpose: Do routine which is called when
|                  displaylist selection image_list is used
| 
|         Input: lists_info - ptr to PaneInfo struct for options pane
| 
|        Output: None
|    Written By: 
|          Date: Jul 03, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void lists_image_list(
     options_lists *lists_info)
{
	int indx = lists_info->image_list - 1;

	/*
	 *  sanity check to make sure that the list is not empty
	 */
	if (indx == -1) return;

	/*
	 *  Sanity check to see if we are already at the image being
	 *  displayed.  If so then just return....
	 */
	if (current_image == images[indx])
	   return;

	/*
	 *  set all editimage displays to have their objects associated
         *  with the data object associated with the file just read in,
         *  so that we are displaying, zooming, etc all on the same info.
	 */
	current_image = images[indx];
        set_current_image_object();

	edimg_update_band_list();
}


/*-----------------------------------------------------------
| 
|  Routine Name: lists_band_list
| 
|       Purpose: Do routine which is called when
|                  displaylist selection band_list is used
| 
|         Input: lists_info - ptr to PaneInfo struct for options pane
| 
|        Output: None
|    Written By: 
|          Date: Jul 03, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void lists_band_list(
     options_lists *lists_info)
{
	int indx = lists_info->band_list - 1;

	/*
	 *  set all editimage displays to have their objects associated
         *  with the correct band associated with the current data object
	 *  being display.
	 */
	xvw_set_attribute(image,   XVW_IMAGE_BANDNUM, indx);
	xvw_set_attribute(zoom,    XVW_IMAGE_BANDNUM, indx);
	xvw_set_attribute(panicon, XVW_IMAGE_BANDNUM, indx);
}
/*-----------------------------------------------------------
| 
|  Routine Name: lists_elements
| 
|       Purpose: Do routine which is called when
|                  flag selection elements is used
| 
|         Input: lists_info - ptr to PaneInfo struct for lists pane
| 
|        Output: None
|    Written By: 
|          Date: Aug 18, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void lists_elements(
     options_lists *lists_info)
{
        xvw_get_attribute(image, XVW_IMAGE_BAND_DIMENSIONS, &dimensions);
        if (lists_info->depth == FALSE)
           dimensions &= ~KIMAGE_ELEMENTS;
        else
           dimensions |= KIMAGE_ELEMENTS;
        xvw_set_attribute(image, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
        xvw_set_attribute(zoom, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
        xvw_set_attribute(panicon, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
        edimg_update_band_list();
}


/*-----------------------------------------------------------
| 
|  Routine Name: lists_depth
| 
|       Purpose: Do routine which is called when
|                  flag selection depth is used
| 
|         Input: lists_info - ptr to PaneInfo struct for lists pane
| 
|        Output: None
|    Written By: 
|          Date: Aug 18, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void lists_depth(
     options_lists *lists_info)
{
        xvw_get_attribute(image, XVW_IMAGE_BAND_DIMENSIONS, &dimensions);
        if (lists_info->depth == FALSE)
           dimensions &= ~KIMAGE_DEPTH;
        else
           dimensions |= KIMAGE_DEPTH;
        xvw_set_attribute(image, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
        xvw_set_attribute(zoom, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
        xvw_set_attribute(panicon, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
        edimg_update_band_list();
}


/*-----------------------------------------------------------
| 
|  Routine Name: lists_time
| 
|       Purpose: Do routine which is called when
|                  flag selection time is used
| 
|         Input: lists_info - ptr to PaneInfo struct for lists pane
| 
|        Output: None
|    Written By: 
|          Date: Aug 18, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void lists_time(
     options_lists *lists_info)
{
        xvw_get_attribute(image, XVW_IMAGE_BAND_DIMENSIONS, &dimensions);
        if (lists_info->depth == FALSE)
           dimensions &= ~KIMAGE_TIME;
        else
           dimensions |= KIMAGE_TIME;
        xvw_set_attribute(image, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
        xvw_set_attribute(zoom, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
        xvw_set_attribute(panicon, XVW_IMAGE_BAND_DIMENSIONS, dimensions);
        edimg_update_band_list();
}
